/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.command.query.Select;
import org.h2.command.query.SelectGroups;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFunctionType;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDouble;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WindowFunction
extends DataAnalysisOperation {
    private final WindowFunctionType type;
    private final Expression[] args;
    private boolean fromLast;
    private boolean ignoreNulls;

    public static int getMinArgumentCount(WindowFunctionType type) {
        switch (type) {
            case NTILE: 
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case RATIO_TO_REPORT: {
                return 1;
            }
            case NTH_VALUE: {
                return 2;
            }
        }
        return 0;
    }

    public static int getMaxArgumentCount(WindowFunctionType type) {
        switch (type) {
            case NTILE: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case RATIO_TO_REPORT: {
                return 1;
            }
            case LEAD: 
            case LAG: {
                return 3;
            }
            case NTH_VALUE: {
                return 2;
            }
        }
        return 0;
    }

    private static Value getNthValue(Iterator<Value[]> iterator, int number, boolean ignoreNulls) {
        Value v = ValueNull.INSTANCE;
        int cnt = 0;
        while (iterator.hasNext()) {
            Value t = iterator.next()[0];
            if (ignoreNulls && t == ValueNull.INSTANCE || cnt++ != number) continue;
            v = t;
            break;
        }
        return v;
    }

    public WindowFunction(WindowFunctionType type, Select select, Expression[] args) {
        super(select);
        this.type = type;
        this.args = args;
    }

    public WindowFunctionType getFunctionType() {
        return this.type;
    }

    public void setFromLast(boolean fromLast) {
        this.fromLast = fromLast;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    @Override
    public boolean isAggregate() {
        return false;
    }

    @Override
    protected void updateAggregate(SessionLocal session, SelectGroups groupData, int groupRowId) {
        this.updateOrderedAggregate(session, groupData, groupRowId, this.over.getOrderBy());
    }

    @Override
    protected void updateGroupAggregates(SessionLocal session, int stage) {
        super.updateGroupAggregates(session, stage);
        if (this.args != null) {
            Expression[] expressionArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expr = expressionArray[n2];
                expr.updateAggregate(session, stage);
                ++n2;
            }
        }
    }

    @Override
    protected int getNumExpressions() {
        return this.args != null ? this.args.length : 0;
    }

    @Override
    protected void rememberExpressions(SessionLocal session, Value[] array) {
        if (this.args != null) {
            int i = 0;
            int cnt = this.args.length;
            while (i < cnt) {
                array[i] = this.args[i].getValue(session);
                ++i;
            }
        }
    }

    @Override
    protected Object createAggregateData() {
        throw DbException.getUnsupportedException("Window function");
    }

    @Override
    protected void getOrderedResultLoop(SessionLocal session, HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        switch (this.type) {
            case ROW_NUMBER: {
                int i = 0;
                int size = ordered.size();
                while (i < size) {
                    result.put(ordered.get(i)[rowIdColumn].getInt(), ValueBigint.get(++i));
                }
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: {
                this.getRank(result, ordered, rowIdColumn);
                break;
            }
            case CUME_DIST: {
                this.getCumeDist(result, ordered, rowIdColumn);
                break;
            }
            case NTILE: {
                WindowFunction.getNtile(result, ordered, rowIdColumn);
                break;
            }
            case LEAD: 
            case LAG: {
                this.getLeadLag(result, ordered, rowIdColumn, session);
                break;
            }
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case NTH_VALUE: {
                this.getNth(session, result, ordered, rowIdColumn);
                break;
            }
            case RATIO_TO_REPORT: {
                WindowFunction.getRatioToReport(result, ordered, rowIdColumn);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + String.valueOf((Object)this.type));
            }
        }
    }

    private void getRank(HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        int size = ordered.size();
        int number = 0;
        int i = 0;
        while (i < size) {
            int nm;
            Value[] row = ordered.get(i);
            if (i == 0) {
                number = 1;
            } else if (this.getOverOrderBySort().compare(ordered.get(i - 1), row) != 0) {
                number = this.type == WindowFunctionType.DENSE_RANK ? ++number : i + 1;
            }
            Value v = this.type == WindowFunctionType.PERCENT_RANK ? ((nm = number - 1) == 0 ? ValueDouble.ZERO : ValueDouble.get((double)nm / (double)(size - 1))) : ValueBigint.get(number);
            result.put(row[rowIdColumn].getInt(), v);
            ++i;
        }
    }

    private void getCumeDist(HashMap<Integer, Value> result, ArrayList<Value[]> orderedData, int rowIdColumn) {
        int size = orderedData.size();
        int start = 0;
        while (start < size) {
            Value[] array = orderedData.get(start);
            int end = start + 1;
            while (end < size && this.overOrderBySort.compare(array, orderedData.get(end)) == 0) {
                ++end;
            }
            ValueDouble v = ValueDouble.get((double)end / (double)size);
            int i = start;
            while (i < end) {
                int rowId = orderedData.get(i)[rowIdColumn].getInt();
                result.put(rowId, v);
                ++i;
            }
            start = end;
        }
    }

    private static void getNtile(HashMap<Integer, Value> result, ArrayList<Value[]> orderedData, int rowIdColumn) {
        int size = orderedData.size();
        int i = 0;
        while (i < size) {
            Value[] array = orderedData.get(i);
            long buckets = array[0].getLong();
            if (buckets <= 0L) {
                throw DbException.getInvalidValueException("number of tiles", buckets);
            }
            long perTile = (long)size / buckets;
            long numLarger = (long)size - perTile * buckets;
            long largerGroup = numLarger * (perTile + 1L);
            long v = (long)i >= largerGroup ? ((long)i - largerGroup) / perTile + numLarger + 1L : (long)i / (perTile + 1L) + 1L;
            result.put(orderedData.get(i)[rowIdColumn].getInt(), ValueBigint.get(v));
            ++i;
        }
    }

    private void getLeadLag(HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn, SessionLocal session) {
        int size = ordered.size();
        int numExpressions = this.getNumExpressions();
        TypeInfo dataType = this.args[0].getType();
        int i = 0;
        while (i < size) {
            int j;
            int n;
            Value[] row = ordered.get(i);
            int rowId = row[rowIdColumn].getInt();
            if (numExpressions >= 2) {
                n = row[1].getInt();
                if (n < 0) {
                    throw DbException.getInvalidValueException("nth row", n);
                }
            } else {
                n = 1;
            }
            Value v = null;
            if (n == 0) {
                v = ordered.get(i)[0];
            } else if (this.type == WindowFunctionType.LEAD) {
                if (this.ignoreNulls) {
                    j = i + 1;
                    while (n > 0 && j < size) {
                        v = ordered.get(j)[0];
                        if (v != ValueNull.INSTANCE) {
                            --n;
                        }
                        ++j;
                    }
                    if (n > 0) {
                        v = null;
                    }
                } else if (n <= size - i - 1) {
                    v = ordered.get(i + n)[0];
                }
            } else if (this.ignoreNulls) {
                j = i - 1;
                while (n > 0 && j >= 0) {
                    v = ordered.get(j)[0];
                    if (v != ValueNull.INSTANCE) {
                        --n;
                    }
                    --j;
                }
                if (n > 0) {
                    v = null;
                }
            } else if (n <= i) {
                v = ordered.get(i - n)[0];
            }
            if (v == null) {
                v = numExpressions >= 3 ? row[2].convertTo(dataType, (CastDataProvider)session) : ValueNull.INSTANCE;
            }
            result.put(rowId, v);
            ++i;
        }
    }

    private void getNth(SessionLocal session, HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        int size = ordered.size();
        int i = 0;
        while (i < size) {
            Value v;
            Value[] row = ordered.get(i);
            int rowId = row[rowIdColumn].getInt();
            switch (this.type) {
                case FIRST_VALUE: {
                    v = WindowFunction.getNthValue(WindowFrame.iterator(this.over, session, ordered, this.getOverOrderBySort(), i, false), 0, this.ignoreNulls);
                    break;
                }
                case LAST_VALUE: {
                    v = WindowFunction.getNthValue(WindowFrame.iterator(this.over, session, ordered, this.getOverOrderBySort(), i, true), 0, this.ignoreNulls);
                    break;
                }
                case NTH_VALUE: {
                    int n = row[1].getInt();
                    if (n <= 0) {
                        throw DbException.getInvalidValueException("nth row", n);
                    }
                    Iterator<Value[]> iter = WindowFrame.iterator(this.over, session, ordered, this.getOverOrderBySort(), i, this.fromLast);
                    v = WindowFunction.getNthValue(iter, --n, this.ignoreNulls);
                    break;
                }
                default: {
                    throw DbException.getInternalError("type=" + String.valueOf((Object)this.type));
                }
            }
            result.put(rowId, v);
            ++i;
        }
    }

    private static void getRatioToReport(HashMap<Integer, Value> result, ArrayList<Value[]> ordered, int rowIdColumn) {
        int size = ordered.size();
        Value value = null;
        int i = 0;
        while (i < size) {
            Value v = ordered.get(i)[0];
            if (v != ValueNull.INSTANCE) {
                value = value == null ? v.convertToDouble() : value.add(v.convertToDouble());
            }
            ++i;
        }
        if (value != null && value.getSignum() == 0) {
            value = null;
        }
        i = 0;
        while (i < size) {
            Value v;
            Value[] row = ordered.get(i);
            if (value == null) {
                v = ValueNull.INSTANCE;
            } else {
                v = row[0];
                if (v != ValueNull.INSTANCE) {
                    v = v.convertToDouble().divide(value, TypeInfo.TYPE_DOUBLE);
                }
            }
            result.put(row[rowIdColumn].getInt(), v);
            ++i;
        }
    }

    @Override
    protected Value getAggregatedValue(SessionLocal session, Object aggregateData) {
        throw DbException.getUnsupportedException("Window function");
    }

    @Override
    public void mapColumnsAnalysis(ColumnResolver resolver, int level, int innerState) {
        if (this.args != null) {
            Expression[] expressionArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Expression arg = expressionArray[n2];
                arg.mapColumns(resolver, level, innerState);
                ++n2;
            }
        }
        super.mapColumnsAnalysis(resolver, level, innerState);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        if (this.over.getWindowFrame() != null) {
            switch (this.type) {
                case FIRST_VALUE: 
                case LAST_VALUE: 
                case NTH_VALUE: {
                    break;
                }
                default: {
                    String sql = this.getTraceSQL();
                    throw DbException.getSyntaxError(sql, sql.length() - 1);
                }
            }
        }
        if (this.over.getOrderBy() == null) {
            if (this.type.requiresWindowOrdering()) {
                String sql = this.getTraceSQL();
                throw DbException.getSyntaxError(sql, sql.length() - 1, "ORDER BY");
            }
        } else if (this.type == WindowFunctionType.RATIO_TO_REPORT) {
            String sql = this.getTraceSQL();
            throw DbException.getSyntaxError(sql, sql.length() - 1);
        }
        super.optimize(session);
        if (this.over.getOrderBy() == null) {
            switch (this.type) {
                case RANK: 
                case DENSE_RANK: {
                    return ValueExpression.get(ValueBigint.get(1L));
                }
                case PERCENT_RANK: {
                    return ValueExpression.get(ValueDouble.ZERO);
                }
                case CUME_DIST: {
                    return ValueExpression.get(ValueDouble.ONE);
                }
            }
        }
        if (this.args != null) {
            int i = 0;
            while (i < this.args.length) {
                this.args[i] = this.args[i].optimize(session);
                ++i;
            }
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.args != null) {
            Expression[] expressionArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Expression e = expressionArray[n2];
                e.setEvaluatable(tableFilter, b);
                ++n2;
            }
        }
        super.setEvaluatable(tableFilter, b);
    }

    @Override
    public TypeInfo getType() {
        switch (this.type) {
            case ROW_NUMBER: 
            case RANK: 
            case DENSE_RANK: 
            case NTILE: {
                return TypeInfo.TYPE_BIGINT;
            }
            case PERCENT_RANK: 
            case CUME_DIST: 
            case RATIO_TO_REPORT: {
                return TypeInfo.TYPE_DOUBLE;
            }
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: 
            case NTH_VALUE: {
                return this.args[0].getType();
            }
        }
        throw DbException.getInternalError("type=" + String.valueOf((Object)this.type));
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append(this.type.getSQL()).append('(');
        if (this.args != null) {
            WindowFunction.writeExpressions(builder, this.args, sqlFlags);
        }
        builder.append(')');
        if (this.fromLast && this.type == WindowFunctionType.NTH_VALUE) {
            builder.append(" FROM LAST");
        }
        if (this.ignoreNulls) {
            switch (this.type) {
                case LEAD: 
                case LAG: 
                case FIRST_VALUE: 
                case LAST_VALUE: 
                case NTH_VALUE: {
                    builder.append(" IGNORE NULLS");
                }
            }
        }
        return this.appendTailConditions(builder, sqlFlags, this.type.requiresWindowOrdering());
    }

    @Override
    public int getCost() {
        int cost = 1;
        if (this.args != null) {
            Expression[] expressionArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expr = expressionArray[n2];
                cost += expr.getCost();
                ++n2;
            }
        }
        return cost;
    }
}

