/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class BetweenPredicate
extends Condition {
    private Expression left;
    private final boolean not;
    private final boolean whenOperand;
    private boolean symmetric;
    private Expression a;
    private Expression b;

    public BetweenPredicate(Expression left, boolean not, boolean whenOperand, boolean symmetric, Expression a, Expression b) {
        this.left = left;
        this.not = not;
        this.whenOperand = whenOperand;
        this.symmetric = symmetric;
        this.a = a;
        this.b = b;
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        if (this.not) {
            builder.append(" NOT");
        }
        builder.append(" BETWEEN ");
        if (this.symmetric) {
            builder.append("SYMMETRIC ");
        }
        this.a.getSQL(builder, sqlFlags, 0).append(" AND ");
        return this.b.getSQL(builder, sqlFlags, 0);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        Value bValue;
        this.left = this.left.optimize(session);
        this.a = this.a.optimize(session);
        this.b = this.b.optimize(session);
        TypeInfo leftType = this.left.getType();
        TypeInfo.checkComparable(leftType, this.a.getType());
        TypeInfo.checkComparable(leftType, this.b.getType());
        if (this.whenOperand) {
            return this;
        }
        Value value = this.left.isConstant() ? this.left.getValue(session) : null;
        Value aValue = this.a.isConstant() ? this.a.getValue(session) : null;
        Value value2 = bValue = this.b.isConstant() ? this.b.getValue(session) : null;
        if (value != null) {
            if (value == ValueNull.INSTANCE) {
                return TypedValueExpression.UNKNOWN;
            }
            if (aValue != null && bValue != null) {
                return ValueExpression.getBoolean(this.getValue(session, value, aValue, bValue));
            }
        }
        if (this.symmetric ? aValue == ValueNull.INSTANCE || bValue == ValueNull.INSTANCE : aValue == ValueNull.INSTANCE && bValue == ValueNull.INSTANCE) {
            return TypedValueExpression.UNKNOWN;
        }
        if (aValue != null && bValue != null && session.compareWithNull(aValue, bValue, false) == 0) {
            return new Comparison(this.not ? 1 : 0, this.left, this.a, false).optimize(session);
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return this.getValue(session, value, this.a.getValue(session), this.b.getValue(session));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        if (left == ValueNull.INSTANCE) {
            return false;
        }
        return this.getValue(session, left, this.a.getValue(session), this.b.getValue(session)).isTrue();
    }

    private Value getValue(SessionLocal session, Value value, Value aValue, Value bValue) {
        int cmp1 = session.compareWithNull(aValue, value, false);
        int cmp2 = session.compareWithNull(value, bValue, false);
        if (cmp1 == Integer.MIN_VALUE) {
            return this.symmetric || cmp2 <= 0 ? ValueNull.INSTANCE : ValueBoolean.get(this.not);
        }
        if (cmp2 == Integer.MIN_VALUE) {
            return this.symmetric || cmp1 <= 0 ? ValueNull.INSTANCE : ValueBoolean.get(this.not);
        }
        return ValueBoolean.get(this.not ^ (this.symmetric ? cmp1 <= 0 && cmp2 <= 0 || cmp1 >= 0 && cmp2 >= 0 : cmp1 <= 0 && cmp2 <= 0));
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new BetweenPredicate(this.left, !this.not, false, this.symmetric, this.a, this.b);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (!(this.not || this.whenOperand || this.symmetric)) {
            Comparison.createIndexConditions(filter, this.a, this.left, 4);
            Comparison.createIndexConditions(filter, this.left, this.b, 4);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean value) {
        this.left.setEvaluatable(tableFilter, value);
        this.a.setEvaluatable(tableFilter, value);
        this.b.setEvaluatable(tableFilter, value);
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
        this.a.updateAggregate(session, stage);
        this.b.updateAggregate(session, stage);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        this.a.mapColumns(resolver, level, state);
        this.b.mapColumns(resolver, level, state);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.a.isEverything(visitor) && this.b.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.a.getCost() + this.b.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 3;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.a;
            }
            case 2: {
                return this.b;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

