/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.List;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.SimplePredicate;
import org.h2.index.IndexCondition;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class BooleanTest
extends SimplePredicate {
    private final Boolean right;

    public BooleanTest(Expression left, boolean not, boolean whenOperand, Boolean right) {
        super(left, not, whenOperand);
        this.right = right;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        return builder.append(this.not ? " IS NOT " : " IS ").append(this.right == null ? "UNKNOWN" : (this.right != false ? "TRUE" : "FALSE"));
    }

    @Override
    public Value getValue(SessionLocal session) {
        return ValueBoolean.get(this.getValue(this.left.getValue(session)));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        return this.getValue(left);
    }

    private boolean getValue(Value left) {
        return (left == ValueNull.INSTANCE ? this.right == null : this.right != null && this.right.booleanValue() == left.getBoolean()) ^ this.not;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new BooleanTest(this.left, !this.not, false, this.right);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        ExpressionColumn c;
        if (this.whenOperand || !filter.getTable().isQueryComparable()) {
            return;
        }
        if (this.left instanceof ExpressionColumn && (c = (ExpressionColumn)this.left).getType().getValueType() == 8 && filter == c.getTableFilter()) {
            if (this.not) {
                if (this.right == null && c.getColumn().isNullable()) {
                    filter.addIndexCondition(IndexCondition.getInList(c, List.of(ValueExpression.FALSE, ValueExpression.TRUE)));
                }
            } else {
                filter.addIndexCondition(IndexCondition.get(6, c, this.right == null ? TypedValueExpression.UNKNOWN : ValueExpression.getBoolean(this.right)));
            }
        }
    }
}

