/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.AbstractList;
import java.util.Arrays;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.Condition;
import org.h2.index.IndexCondition;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ConditionInArray
extends Condition {
    private Expression left;
    private final boolean whenOperand;
    private Expression right;
    private final boolean all;
    private final int compareType;

    public ConditionInArray(Expression left, boolean whenOperand, Expression right, boolean all, int compareType) {
        this.left = left;
        this.whenOperand = whenOperand;
        this.right = right;
        this.all = all;
        this.compareType = compareType;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.getValue(session, this.left.getValue(session));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        return this.getValue(session, left).isTrue();
    }

    private Value getValue(SessionLocal session, Value left) {
        Value r = this.right.getValue(session);
        if (r == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        Value[] array = r.convertToAnyArray(session).getList();
        if (array.length == 0) {
            return ValueBoolean.get(this.all);
        }
        if ((this.compareType & 0xFFFFFFFE) == 6) {
            return this.getNullSafeValueSlow(session, array, left);
        }
        if (left.containsNull()) {
            return ValueNull.INSTANCE;
        }
        return this.getValueSlow(session, array, left);
    }

    private Value getValueSlow(SessionLocal session, Value[] array, Value l) {
        boolean hasNull = false;
        ValueBoolean searched = ValueBoolean.get(!this.all);
        Value[] valueArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            Value cmp = Comparison.compare(session, l, v, this.compareType);
            if (cmp == ValueNull.INSTANCE) {
                hasNull = true;
            } else if (cmp == searched) {
                return ValueBoolean.get(!this.all);
            }
            ++n2;
        }
        if (hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(this.all);
    }

    private Value getNullSafeValueSlow(SessionLocal session, Value[] array, Value l) {
        boolean searched = this.all == (this.compareType == 7);
        Value[] valueArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Value v = valueArray[n2];
            if (session.areEqual(l, v) == searched) {
                return ValueBoolean.get(!this.all);
            }
            ++n2;
        }
        return ValueBoolean.get(this.all);
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new ConditionInArray(this.left, false, this.right, !this.all, Comparison.getNotCompareType(this.compareType));
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        this.right.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.right = this.right.optimize(session);
        this.left = this.left.optimize(session);
        if (!this.whenOperand && this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.getBoolean(this.getValue(session));
        }
        return this;
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (this.whenOperand || this.all || this.compareType != 0 || !(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        if (this.right instanceof Parameter) {
            filter.addIndexCondition(IndexCondition.getInList(l, new ParameterList((Parameter)this.right)));
        } else if (this.right.isConstant()) {
            Value r = this.right.getValue(null);
            if (r instanceof ValueArray) {
                Value[] values = ((ValueArray)r).getList();
                int count = values.length;
                if (count == 0) {
                    filter.addIndexCondition(IndexCondition.get(9, l, ValueExpression.FALSE));
                } else {
                    TypeInfo colType;
                    TypeInfo type = colType = l.getType();
                    int i = 0;
                    while (i < count) {
                        type = TypeInfo.getHigherType(type, values[i].getType());
                        ++i;
                    }
                    if (TypeInfo.haveSameOrdering(colType, type)) {
                        Expression[] valueList = new Expression[count];
                        int i2 = 0;
                        while (i2 < count) {
                            valueList[i2] = ValueExpression.get(values[i2]);
                            ++i2;
                        }
                        filter.addIndexCondition(IndexCondition.getInList(l, Arrays.asList(valueList)));
                    }
                }
            }
        } else {
            TypeInfo colType;
            TypeInfo arrayType;
            ExpressionVisitor visitor = ExpressionVisitor.getNotFromResolverVisitor(filter);
            if (this.right.isEverything(visitor) && (arrayType = this.right.getType()).getValueType() == 40 && TypeInfo.haveSameOrdering(colType = l.getType(), TypeInfo.getHigherType(colType, (TypeInfo)arrayType.getExtTypeInfo()))) {
                filter.addIndexCondition(IndexCondition.getInArray(l, this.right));
            }
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean value) {
        this.left.setEvaluatable(tableFilter, value);
        this.right.setEvaluatable(tableFilter, value);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.getWhenSQL(this.left.getSQL(builder, sqlFlags, 0), sqlFlags);
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        return this.right.getSQL(builder.append(' ').append(Comparison.COMPARE_TYPES[this.compareType]).append(this.all ? " ALL(" : " ANY("), sqlFlags).append(')');
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
        this.right.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.right.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 10;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int index) {
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value).getList()[index]);
            }
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ((ValueArray)value).getList().length;
            }
            return 1;
        }
    }
}

