/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.command.query.Query;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.PredicateWithSubquery;
import org.h2.index.IndexCondition;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ConditionInQuery
extends PredicateWithSubquery {
    private Expression left;
    private final boolean not;
    private final boolean whenOperand;
    private final boolean all;
    private final int compareType;

    public ConditionInQuery(Expression left, boolean not, boolean whenOperand, Query query, boolean all, int compareType) {
        super(query);
        this.left = left;
        this.not = not;
        this.whenOperand = whenOperand;
        query.setRandomAccessResult(true);
        query.setNeverLazy(true);
        query.setDistinctIfPossible();
        this.all = all;
        this.compareType = compareType;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.getValue(session, this.left.getValue(session));
    }

    @Override
    public boolean getWhenValue(SessionLocal session, Value left) {
        if (!this.whenOperand) {
            return super.getWhenValue(session, left);
        }
        return this.getValue(session, left).isTrue();
    }

    private Value getValue(SessionLocal session, Value left) {
        this.query.setSession(session);
        LocalResult rows = (LocalResult)this.query.query(0L);
        if (!rows.hasNext()) {
            return ValueBoolean.get(this.not ^ this.all);
        }
        if ((this.compareType & 0xFFFFFFFE) == 6) {
            return this.getNullSafeValueSlow(session, rows, left);
        }
        if (left.containsNull()) {
            return ValueNull.INSTANCE;
        }
        if (this.all || this.compareType != 0 || !session.getDatabase().getSettings().optimizeInSelect) {
            return this.getValueSlow(session, rows, left);
        }
        int columnCount = this.query.getColumnCount();
        if (columnCount != 1) {
            Value[] leftValue = left.convertToAnyRow().getList();
            if (columnCount == leftValue.length && rows.containsDistinct(leftValue)) {
                return ValueBoolean.get(!this.not);
            }
        } else {
            TypeInfo colType = rows.getColumnType(0);
            if (colType.getValueType() == 0) {
                return ValueNull.INSTANCE;
            }
            if (left.getValueType() == 41) {
                left = ((ValueRow)left).getList()[0];
            }
            if (rows.containsDistinct(new Value[]{left})) {
                return ValueBoolean.get(!this.not);
            }
        }
        if (rows.containsNull()) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(this.not);
    }

    private Value getValueSlow(SessionLocal session, ResultInterface rows, Value l) {
        boolean simple = l.getValueType() != 41 && this.query.getColumnCount() == 1;
        boolean hasNull = false;
        ValueBoolean searched = ValueBoolean.get(!this.all);
        while (rows.next()) {
            Value[] currentRow = rows.currentRow();
            Value cmp = Comparison.compare(session, l, simple ? currentRow[0] : ValueRow.get(currentRow), this.compareType);
            if (cmp == ValueNull.INSTANCE) {
                hasNull = true;
                continue;
            }
            if (cmp != searched) continue;
            return ValueBoolean.get(this.not == this.all);
        }
        if (hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(this.not ^ this.all);
    }

    private Value getNullSafeValueSlow(SessionLocal session, ResultInterface rows, Value l) {
        boolean simple = l.getValueType() != 41 && this.query.getColumnCount() == 1;
        boolean searched = this.all == (this.compareType == 7);
        while (rows.next()) {
            Value[] currentRow = rows.currentRow();
            if (session.areEqual(l, simple ? currentRow[0] : ValueRow.get(currentRow)) != searched) continue;
            return ValueBoolean.get(this.not == this.all);
        }
        return ValueBoolean.get(this.not ^ this.all);
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal session) {
        if (this.whenOperand) {
            return null;
        }
        return new ConditionInQuery(this.left, !this.not, false, this.query, this.all, this.compareType);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
        super.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        super.optimize(session);
        this.left = this.left.optimize(session);
        TypeInfo.checkComparable(this.left.getType(), this.query.getRowDataType());
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        super.setEvaluatable(tableFilter, b);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        boolean outerNot;
        boolean bl = outerNot = this.not && (this.all || this.compareType != 0);
        if (outerNot) {
            builder.append("NOT (");
        }
        this.left.getSQL(builder, sqlFlags, 0);
        this.getWhenSQL(builder, sqlFlags);
        if (outerNot) {
            builder.append(')');
        }
        return builder;
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder builder, int sqlFlags) {
        if (this.all) {
            builder.append(Comparison.COMPARE_TYPES[this.compareType]).append(" ALL");
        } else if (this.compareType == 0) {
            if (this.not) {
                builder.append(" NOT");
            }
            builder.append(" IN");
        } else {
            builder.append(' ').append(Comparison.COMPARE_TYPES[this.compareType]).append(" ANY");
        }
        return super.getUnenclosedSQL(builder, sqlFlags);
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        this.left.updateAggregate(session, stage);
        super.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && super.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + super.getCost();
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        TypeInfo queryType;
        if (this.not || this.whenOperand || this.compareType != 0 || !session.getDatabase().getSettings().optimizeInList) {
            return;
        }
        if (this.query.getColumnCount() != 1) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        TypeInfo colType = this.left.getType();
        if (!TypeInfo.haveSameOrdering(colType, TypeInfo.getHigherType(colType, queryType = this.query.getExpressions().get(0).getType()))) {
            return;
        }
        int leftType = colType.getValueType();
        if (!DataType.hasTotalOrdering(leftType) && leftType != queryType.getValueType()) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        ExpressionVisitor visitor = ExpressionVisitor.getNotFromResolverVisitor(filter);
        if (!this.query.isEverything(visitor)) {
            return;
        }
        filter.addIndexCondition(IndexCondition.getInQuery(l, this.query));
    }
}

