/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.condition.Condition;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ConditionLocalAndGlobal
extends Condition {
    private Expression local;
    private Expression global;

    public ConditionLocalAndGlobal(Expression local, Expression global) {
        if (global == null) {
            throw DbException.getInternalError();
        }
        this.local = local;
        this.global = global;
    }

    @Override
    public boolean needParentheses() {
        return this.local != null || this.global.needParentheses();
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        if (this.local == null) {
            return this.global.getUnenclosedSQL(builder, sqlFlags);
        }
        this.local.getSQL(builder, sqlFlags, 0);
        builder.append("\n    _LOCAL_AND_GLOBAL_ ");
        return this.global.getSQL(builder, sqlFlags, 0);
    }

    @Override
    public void createIndexConditions(SessionLocal session, TableFilter filter) {
        if (this.local != null) {
            this.local.createIndexConditions(session, filter);
        }
        this.global.createIndexConditions(session, filter);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value r;
        if (this.local == null) {
            return this.global.getValue(session);
        }
        Value l = this.local.getValue(session);
        if (l.isFalse() || (r = this.global.getValue(session)).isFalse()) {
            return ValueBoolean.FALSE;
        }
        if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.TRUE;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.global = this.global.optimize(session);
        if (this.local != null) {
            this.local = this.local.optimize(session);
            Expression e = ConditionAndOr.optimizeIfConstant(session, 0, this.local, this.global);
            if (e != null) {
                return e;
            }
        }
        return this;
    }

    @Override
    public void addFilterConditions(TableFilter filter) {
        if (this.local != null) {
            this.local.addFilterConditions(filter);
        }
        this.global.addFilterConditions(filter);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        if (this.local != null) {
            this.local.mapColumns(resolver, level, state);
        }
        this.global.mapColumns(resolver, level, state);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        if (this.local != null) {
            this.local.setEvaluatable(tableFilter, b);
        }
        this.global.setEvaluatable(tableFilter, b);
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        if (this.local != null) {
            this.local.updateAggregate(session, stage);
        }
        this.global.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return (this.local == null || this.local.isEverything(visitor)) && this.global.isEverything(visitor);
    }

    @Override
    public int getCost() {
        int cost = this.global.getCost();
        if (this.local != null) {
            cost += this.local.getCost();
        }
        return cost;
    }

    @Override
    public int getSubexpressionCount() {
        return this.local == null ? 1 : 2;
    }

    @Override
    public Expression getSubexpression(int index) {
        switch (index) {
            case 0: {
                return this.local != null ? this.local : this.global;
            }
            case 1: {
                if (this.local == null) break;
                return this.global;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

