/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.condition;

import java.util.Arrays;
import org.h2.command.query.Query;
import org.h2.engine.NullsDistinct;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.expression.condition.PredicateWithSubquery;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class UniquePredicate
extends PredicateWithSubquery {
    private final NullsDistinct nullsDistinct;

    public UniquePredicate(Query query, NullsDistinct nullsDistinct) {
        super(query);
        this.nullsDistinct = nullsDistinct;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        super.optimize(session);
        if (this.query.isStandardDistinct()) {
            return ValueExpression.TRUE;
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        this.query.setSession(session);
        int columnCount = this.query.getColumnCount();
        LocalResult result = new LocalResult(session, this.query.getExpressions().toArray(new Expression[0]), columnCount, columnCount);
        result.setDistinct();
        Target target = new Target(columnCount, this.nullsDistinct, result);
        this.query.query(Integer.MAX_VALUE, target);
        result.close();
        return ValueBoolean.get(!target.hasDuplicates);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append("UNIQUE");
        if (this.nullsDistinct != NullsDistinct.DISTINCT) {
            this.nullsDistinct.getSQL(builder.append(' '), 0);
        }
        return super.getUnenclosedSQL(builder, sqlFlags);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Target
    implements ResultTarget {
        private final int columnCount;
        private final NullsDistinct nullsDistinct;
        private final LocalResult result;
        boolean hasDuplicates;

        Target(int columnCount, NullsDistinct nullsDistinct, LocalResult result) {
            this.columnCount = columnCount;
            this.nullsDistinct = nullsDistinct;
            this.result = result;
        }

        @Override
        public void limitsWereApplied() {
        }

        @Override
        public long getRowCount() {
            return 0L;
        }

        @Override
        public void addRow(Value ... values) {
            if (this.hasDuplicates) {
                return;
            }
            block0 : switch (this.nullsDistinct) {
                case DISTINCT: {
                    int i = 0;
                    while (i < this.columnCount) {
                        if (values[i] == ValueNull.INSTANCE) {
                            return;
                        }
                        ++i;
                    }
                    break;
                }
                case ALL_DISTINCT: {
                    int i = 0;
                    while (i < this.columnCount) {
                        if (values[i] != ValueNull.INSTANCE) break block0;
                        ++i;
                    }
                    return;
                }
            }
            if (values.length != this.columnCount) {
                values = Arrays.copyOf(values, this.columnCount);
            }
            long expected = this.result.getRowCount() + 1L;
            this.result.addRow(values);
            if (expected != this.result.getRowCount()) {
                this.hasDuplicates = true;
                this.result.close();
            }
        }
    }
}

