/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.util.Arrays;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.mvstore.db.Store;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ArrayFunction
extends FunctionN {
    public static final int TRIM_ARRAY = 0;
    public static final int ARRAY_CONTAINS = 1;
    public static final int ARRAY_SLICE = 2;
    private static final String[] NAMES = new String[]{"TRIM_ARRAY", "ARRAY_CONTAINS", "ARRAY_SLICE"};
    private final int function;

    public ArrayFunction(Expression arg1, Expression arg2, Expression arg3, int function) {
        Expression[] expressionArray;
        if (arg3 == null) {
            Expression[] expressionArray2 = new Expression[2];
            expressionArray2[0] = arg1;
            expressionArray = expressionArray2;
            expressionArray2[1] = arg2;
        } else {
            Expression[] expressionArray3 = new Expression[3];
            expressionArray3[0] = arg1;
            expressionArray3[1] = arg2;
            expressionArray = expressionArray3;
            expressionArray3[2] = arg3;
        }
        super(expressionArray);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v1 = this.args[0].getValue(session);
        Value v2 = this.args[1].getValue(session);
        block0 : switch (this.function) {
            case 0: {
                if (v2 == ValueNull.INSTANCE) {
                    v1 = ValueNull.INSTANCE;
                    break;
                }
                int trim = v2.getInt();
                if (trim < 0) {
                    throw DbException.get(22034, Integer.toString(trim), "0..CARDINALITY(array)");
                }
                if (v1 == ValueNull.INSTANCE) break;
                ValueArray array = v1.convertToAnyArray(session);
                Value[] elements = array.getList();
                int length = elements.length;
                if (trim > length) {
                    throw DbException.get(22034, Integer.toString(trim), "0.." + length);
                }
                if (trim == 0) {
                    v1 = array;
                    break;
                }
                v1 = ValueArray.get(array.getComponentType(), Arrays.copyOf(elements, length - trim), session);
                break;
            }
            case 1: {
                int t = v1.getValueType();
                if (t == 40 || t == 41) {
                    Value[] list = ((ValueCollectionBase)v1).getList();
                    v1 = ValueBoolean.FALSE;
                    Value[] valueArray = list;
                    int n = list.length;
                    int length = 0;
                    while (length < n) {
                        Value v = valueArray[length];
                        if (session.areEqual(v, v2)) {
                            v1 = ValueBoolean.TRUE;
                            break block0;
                        }
                        ++length;
                    }
                    break;
                }
                v1 = ValueNull.INSTANCE;
                break;
            }
            case 2: {
                boolean isPG;
                Value v3;
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE || (v3 = this.args[2].getValue(session)) == ValueNull.INSTANCE) {
                    v1 = ValueNull.INSTANCE;
                    break;
                }
                ValueArray array = v1.convertToAnyArray(session);
                int index1 = v2.getInt() - 1;
                int index2 = v3.getInt();
                boolean bl = isPG = session.getMode().getEnum() == Mode.ModeEnum.PostgreSQL;
                if (index1 > index2) {
                    v1 = isPG ? ValueArray.get(array.getComponentType(), Value.EMPTY_VALUES, session) : ValueNull.INSTANCE;
                    break;
                }
                if (index1 < 0) {
                    if (isPG) {
                        index1 = 0;
                    } else {
                        v1 = ValueNull.INSTANCE;
                        break;
                    }
                }
                if (index2 > array.getList().length) {
                    if (isPG) {
                        index2 = array.getList().length;
                    } else {
                        v1 = ValueNull.INSTANCE;
                        break;
                    }
                }
                v1 = ValueArray.get(array.getComponentType(), Arrays.copyOfRange(array.getList(), index1, index2), session);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        switch (this.function) {
            case 0: 
            case 2: {
                Expression arg = this.args[0];
                this.type = arg.getType();
                int t = this.type.getValueType();
                if (t == 40 || t == 0) break;
                throw Store.getInvalidExpressionTypeException(this.getName() + " array argument", arg);
            }
            case 1: {
                this.type = TypeInfo.TYPE_BOOLEAN;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

