/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.table.Column;
import org.h2.util.DateTimeTemplate;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CastSpecification
extends Function1_2 {
    private Domain domain;

    public CastSpecification(Expression arg, Column column, Expression template) {
        super(arg, template);
        this.type = column.getType();
        this.domain = column.getDomain();
    }

    public CastSpecification(Expression arg, Column column) {
        super(arg, null);
        this.type = column.getType();
        this.domain = column.getDomain();
    }

    public CastSpecification(Expression arg, TypeInfo type) {
        super(arg, null);
        this.type = type;
    }

    @Override
    protected Value getValue(SessionLocal session, Value v1, Value v2) {
        if (v2 != null) {
            v1 = this.getValueWithTemplate(v1, v2, session);
        }
        v1 = v1.castTo(this.type, session);
        if (this.domain != null) {
            this.domain.checkConstraints(session, v1);
        }
        return v1;
    }

    private Value getValueWithTemplate(Value v, Value template, SessionLocal session) {
        if (v == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        int valueType = v.getValueType();
        if (DataType.isDateTimeType(valueType)) {
            if (DataType.isCharacterStringType(this.type.getValueType())) {
                return ValueVarchar.get(DateTimeTemplate.of(template.getString()).format(v), session);
            }
        } else if (DataType.isCharacterStringType(valueType) && DataType.isDateTimeType(this.type.getValueType())) {
            return DateTimeTemplate.of(template.getString()).parse(v.getString(), this.type, session);
        }
        throw DbException.getUnsupportedException(this.type.getSQL(v.getType().getSQL(new StringBuilder("CAST with template from "), 3).append(" to "), 0).toString());
    }

    @Override
    public Expression optimize(SessionLocal session) {
        Value v;
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant()) && ((v = this.getValue(session)) == ValueNull.INSTANCE || CastSpecification.canOptimizeCast(this.left.getType().getValueType(), this.type.getValueType()))) {
            return TypedValueExpression.get(v, this.type);
        }
        return this;
    }

    @Override
    public TypeInfo getTypeIfStaticallyKnown(SessionLocal session) {
        return this.type;
    }

    @Override
    public boolean isConstant() {
        return this.left instanceof ValueExpression && (this.right == null || this.right.isConstant()) && CastSpecification.canOptimizeCast(this.left.getType().getValueType(), this.type.getValueType());
    }

    private static boolean canOptimizeCast(int src, int dst) {
        switch (src) {
            case 18: {
                switch (dst) {
                    case 19: 
                    case 20: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 19: {
                switch (dst) {
                    case 18: 
                    case 20: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 17: {
                if (dst != 21) break;
                return false;
            }
            case 20: {
                switch (dst) {
                    case 19: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 21: {
                switch (dst) {
                    case 17: 
                    case 18: 
                    case 20: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append("CAST(");
        this.left.getUnenclosedSQL(builder, this.left instanceof ValueExpression ? sqlFlags | 4 : sqlFlags).append(" AS ");
        (this.domain != null ? this.domain : this.type).getSQL(builder, sqlFlags);
        if (this.right != null) {
            this.right.getSQL(builder.append(" FORMAT "), sqlFlags);
        }
        return builder.append(')');
    }

    @Override
    public String getName() {
        return "CAST";
    }
}

