/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CompatibilitySequenceValueFunction
extends Function1_2 {
    private final boolean current;

    public CompatibilitySequenceValueFunction(Expression left, Expression right, boolean current) {
        super(left, right);
        this.current = current;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        Sequence seq;
        String sequenceName;
        String schemaName;
        if (v2 == null) {
            Parser p = new Parser(session);
            String sql = v1.getString();
            Expression expr = p.parseExpression(sql);
            if (!(expr instanceof ExpressionColumn)) throw DbException.getSyntaxError(sql, 1);
            ExpressionColumn seq2 = (ExpressionColumn)expr;
            schemaName = seq2.getOriginalTableAliasName();
            if (schemaName == null) {
                schemaName = session.getCurrentSchemaName();
                sequenceName = sql;
            } else {
                sequenceName = seq2.getColumnName(session, -1);
            }
        } else {
            schemaName = v1.getString();
            sequenceName = v2.getString();
        }
        Database database = session.getDatabase();
        Schema s = database.findSchema(schemaName);
        if (s == null) {
            schemaName = StringUtils.toUpperEnglish(schemaName);
            s = database.getSchema(schemaName);
        }
        if ((seq = s.findSequence(sequenceName)) != null) return (this.current ? session.getCurrentValueFor(seq) : session.getNextValueFor(seq, null)).convertTo(this.type);
        sequenceName = StringUtils.toUpperEnglish(sequenceName);
        seq = s.getSequence(sequenceName);
        return (this.current ? session.getCurrentValueFor(seq) : session.getNextValueFor(seq, null)).convertTo(this.type);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        this.type = session.getMode().decimalSequences ? TypeInfo.TYPE_NUMERIC_BIGINT : TypeInfo.TYPE_BIGINT;
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 0: 
            case 2: 
            case 8: {
                return false;
            }
            case 5: {
                if (this.current) break;
                return false;
            }
        }
        return super.isEverything(visitor);
    }

    @Override
    public String getName() {
        return this.current ? "CURRVAL" : "NEXTVAL";
    }
}

