/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.NamedExpression;
import org.h2.message.DbException;
import org.h2.schema.FunctionAlias;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JavaFunction
extends Expression
implements NamedExpression {
    private final FunctionAlias functionAlias;
    private final FunctionAlias.JavaMethod javaMethod;
    private final Expression[] args;

    public JavaFunction(FunctionAlias functionAlias, Expression[] args) {
        this.functionAlias = functionAlias;
        this.javaMethod = functionAlias.findJavaMethod(args);
        if (this.javaMethod.getDataType() == null) {
            throw DbException.get(90022, this.getName());
        }
        this.args = args;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.javaMethod.getValue(session, this.args, false);
    }

    @Override
    public TypeInfo getType() {
        return this.javaMethod.getDataType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.mapColumns(resolver, level, state);
            ++n2;
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.functionAlias.isDeterministic();
        int i = 0;
        int len = this.args.length;
        while (i < len) {
            Expression e;
            this.args[i] = e = this.args[i].optimize(session);
            allConst &= e.isConstant();
            ++i;
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (e != null) {
                e.setEvaluatable(tableFilter, b);
            }
            ++n2;
        }
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return JavaFunction.writeExpressions(this.functionAlias.getSQL(builder, sqlFlags).append('('), this.args, sqlFlags).append(')');
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (e != null) {
                e.updateAggregate(session, stage);
            }
            ++n2;
        }
    }

    @Override
    public String getName() {
        return this.functionAlias.getName();
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                if (this.functionAlias.isDeterministic()) break;
                return false;
            }
            case 7: {
                visitor.addDependency(this.functionAlias);
            }
        }
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (e != null && !e.isEverything(visitor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = this.javaMethod.hasConnectionParam() ? 25 : 5;
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            cost += e.getCost();
            ++n2;
        }
        return cost;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.args[index];
    }
}

