/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.CastSpecification;
import org.h2.expression.function.DateTimeFunction;
import org.h2.expression.function.Function1_2;
import org.h2.message.DbException;
import org.h2.mvstore.db.Store;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDecfloat;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class MathFunction
extends Function1_2 {
    public static final int ABS = 0;
    public static final int MOD = 1;
    public static final int FLOOR = 2;
    public static final int CEIL = 3;
    public static final int ROUND = 4;
    public static final int ROUNDMAGIC = 5;
    public static final int SIGN = 6;
    public static final int TRUNC = 7;
    private static final String[] NAMES = new String[]{"ABS", "MOD", "FLOOR", "CEIL", "ROUND", "ROUNDMAGIC", "SIGN", "TRUNC"};
    private final int function;
    private TypeInfo commonType;

    public MathFunction(Expression arg1, Expression arg2, int function) {
        super(arg1, arg2);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        switch (this.function) {
            case 0: {
                if (v1.getSignum() >= 0) break;
                v1 = v1.negate();
                break;
            }
            case 1: {
                v1 = v1.convertTo(this.commonType, (CastDataProvider)session).modulus(v2.convertTo(this.commonType, (CastDataProvider)session)).convertTo(this.type, (CastDataProvider)session);
                break;
            }
            case 2: {
                v1 = this.round(v1, v2, RoundingMode.FLOOR);
                break;
            }
            case 3: {
                v1 = this.round(v1, v2, RoundingMode.CEILING);
                break;
            }
            case 4: {
                v1 = this.round(v1, v2, RoundingMode.HALF_UP);
                break;
            }
            case 5: {
                v1 = ValueDouble.get(MathFunction.roundMagic(v1.getDouble()));
                break;
            }
            case 6: {
                v1 = ValueInteger.get(v1.getSignum());
                break;
            }
            case 7: {
                v1 = this.round(v1, v2, RoundingMode.DOWN);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value round(Value v1, Value v2, RoundingMode roundingMode) {
        int scale = v2 != null ? v2.getInt() : 0;
        int t = this.type.getValueType();
        switch (t) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                long scaled;
                if (scale >= 0) return v1;
                long original = v1.getLong();
                if (original == (scaled = BigDecimal.valueOf(original).setScale(scale, roundingMode).longValue())) return v1;
                return ValueBigint.get(scaled).convertTo(this.type);
            }
            case 13: {
                int targetScale = this.type.getScale();
                BigDecimal bd = v1.getBigDecimal();
                if (scale >= targetScale) return ValueNumeric.get(bd.setScale(targetScale, roundingMode));
                bd = bd.setScale(scale, roundingMode);
                return ValueNumeric.get(bd.setScale(targetScale, roundingMode));
            }
            case 14: 
            case 15: {
                if (scale == 0) {
                    switch (roundingMode) {
                        case DOWN: {
                            double d = v1.getDouble();
                            d = d < 0.0 ? Math.ceil(d) : Math.floor(d);
                            return t == 14 ? ValueReal.get((float)d) : ValueDouble.get(d);
                        }
                        case CEILING: {
                            double d = Math.ceil(v1.getDouble());
                            return t == 14 ? ValueReal.get((float)d) : ValueDouble.get(d);
                        }
                        case FLOOR: {
                            double d = Math.floor(v1.getDouble());
                            return t == 14 ? ValueReal.get((float)d) : ValueDouble.get(d);
                        }
                    }
                }
                BigDecimal bd = v1.getBigDecimal().setScale(scale, roundingMode);
                return t == 14 ? ValueReal.get(bd.floatValue()) : ValueDouble.get(bd.doubleValue());
            }
            case 16: {
                return ValueDecfloat.get(v1.getBigDecimal().setScale(scale, roundingMode));
            }
        }
        return v1;
    }

    private static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuilder s = new StringBuilder();
        s.append(d);
        if (s.toString().indexOf(69) >= 0) {
            return d;
        }
        int len = s.length();
        if (len < 16) {
            return d;
        }
        if (s.toString().indexOf(46) > len - 3) {
            return d;
        }
        s.delete(len - 2, len);
        char c1 = s.charAt((len -= 2) - 2);
        char c2 = s.charAt(len - 3);
        char c3 = s.charAt(len - 4);
        if (c1 == '0' && c2 == '0' && c3 == '0') {
            s.setCharAt(len - 1, '0');
        } else if (c1 == '9' && c2 == '9' && c3 == '9') {
            s.setCharAt(len - 1, '9');
            s.append('9');
            s.append('9');
            s.append('9');
        }
        return Double.parseDouble(s.toString());
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        switch (this.function) {
            case 0: {
                this.type = this.left.getType();
                if (this.type.getValueType() != 0) break;
                this.type = TypeInfo.TYPE_NUMERIC_FLOATING_POINT;
                break;
            }
            case 2: 
            case 3: {
                Expression e = this.optimizeRound(0, true, false, true);
                if (e == null) break;
                return e;
            }
            case 1: {
                TypeInfo divisorType = this.right.getType();
                this.commonType = TypeInfo.getHigherType(this.left.getType(), divisorType);
                int valueType = this.commonType.getValueType();
                if (valueType == 0) {
                    this.commonType = TypeInfo.TYPE_BIGINT;
                } else if (!DataType.isNumericType(valueType)) {
                    throw Store.getInvalidExpressionTypeException("MOD argument", DataType.isNumericType(this.left.getType().getValueType()) ? this.right : this.left);
                }
                this.type = DataType.isNumericType(divisorType.getValueType()) ? divisorType : this.commonType;
                break;
            }
            case 4: {
                Expression e = this.optimizeRoundWithScale(session, true);
                if (e == null) break;
                return e;
            }
            case 5: {
                this.type = TypeInfo.TYPE_DOUBLE;
                break;
            }
            case 6: {
                this.type = TypeInfo.TYPE_INTEGER;
                break;
            }
            case 7: {
                switch (this.left.getType().getValueType()) {
                    case 2: {
                        this.left = new CastSpecification(this.left, TypeInfo.getTypeInfo(20, -1L, 0, null)).optimize(session);
                    }
                    case 20: 
                    case 21: {
                        if (this.right != null) {
                            throw DbException.get(7001, "TRUNC", "1");
                        }
                        return new DateTimeFunction(1, 2, this.left, null).optimize(session);
                    }
                    case 17: {
                        if (this.right != null) {
                            throw DbException.get(7001, "TRUNC", "1");
                        }
                        return new CastSpecification(this.left, TypeInfo.getTypeInfo(20, -1L, 0, null)).optimize(session);
                    }
                }
                Expression e = this.optimizeRoundWithScale(session, false);
                if (e == null) break;
                return e;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    private Expression optimizeRoundWithScale(SessionLocal session, boolean possibleRoundUp) {
        int scale;
        boolean scaleIsKnown = false;
        boolean scaleIsNull = false;
        if (this.right != null) {
            if (this.right.isConstant()) {
                Value scaleValue = this.right.getValue(session);
                scaleIsKnown = true;
                if (scaleValue != ValueNull.INSTANCE) {
                    scale = scaleValue.getInt();
                } else {
                    scale = -1;
                    scaleIsNull = true;
                }
            } else {
                scale = -1;
            }
        } else {
            scale = 0;
            scaleIsKnown = true;
        }
        return this.optimizeRound(scale, scaleIsKnown, scaleIsNull, possibleRoundUp);
    }

    private Expression optimizeRound(int scale, boolean scaleIsKnown, boolean scaleIsNull, boolean possibleRoundUp) {
        TypeInfo leftType = this.left.getType();
        switch (leftType.getValueType()) {
            case 0: {
                this.type = TypeInfo.TYPE_NUMERIC_SCALE_0;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (scaleIsKnown && scale >= 0) {
                    return this.left;
                }
                this.type = leftType;
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                this.type = leftType;
                break;
            }
            case 13: {
                long precision;
                int originalScale = leftType.getScale();
                if (scaleIsKnown) {
                    if (originalScale <= scale) {
                        return this.left;
                    }
                    if (scale < 0) {
                        scale = 0;
                    } else if (scale > 100000) {
                        scale = 100000;
                    }
                    precision = leftType.getPrecision() - (long)originalScale + (long)scale;
                    if (possibleRoundUp) {
                        ++precision;
                    }
                } else {
                    precision = leftType.getPrecision();
                    if (possibleRoundUp) {
                        ++precision;
                    }
                    scale = originalScale;
                }
                this.type = TypeInfo.getTypeInfo(13, precision, scale, null);
                break;
            }
            default: {
                throw Store.getInvalidExpressionTypeException(this.getName() + " argument", this.left);
            }
        }
        if (scaleIsNull) {
            return TypedValueExpression.get(ValueNull.INSTANCE, this.type);
        }
        return null;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

