/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.command.Command0;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.function.Function1;
import org.h2.message.DbException;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SessionControlFunction
extends Function1 {
    public static final int ABORT_SESSION = 0;
    public static final int CANCEL_SESSION = 1;
    private static final String[] NAMES = new String[]{"ABORT_SESSION", "CANCEL_SESSION"};
    private final int function;

    public SessionControlFunction(Expression arg, int function) {
        super(arg);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v = this.arg.getValue(session);
        if (v == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        int targetSessionId = v.getInt();
        session.getUser().checkAdmin();
        SessionLocal[] sessionLocalArray = session.getDatabase().getSessions(false);
        int n = sessionLocalArray.length;
        int n2 = 0;
        block4: while (n2 < n) {
            SessionLocal s = sessionLocalArray[n2];
            if (s.getId() == targetSessionId) {
                Command0 c = s.getCurrentCommand();
                switch (this.function) {
                    case 0: {
                        if (c != null) {
                            c.cancel();
                        }
                        s.close();
                        return ValueBoolean.TRUE;
                    }
                    case 1: {
                        if (c == null) break block4;
                        c.cancel();
                        return ValueBoolean.TRUE;
                    }
                    default: {
                        throw DbException.getInternalError("function=" + this.function);
                    }
                }
            }
            ++n2;
        }
        return ValueBoolean.FALSE;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        this.type = TypeInfo.TYPE_BOOLEAN;
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return false;
            }
        }
        return super.isEverything(visitor);
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

