/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class StringFunction
extends FunctionN {
    public static final int LOCATE = 0;
    public static final int INSERT = 1;
    public static final int REPLACE = 2;
    public static final int LPAD = 3;
    public static final int RPAD = 4;
    public static final int TRANSLATE = 5;
    private static final String[] NAMES = new String[]{"LOCATE", "INSERT", "REPLACE", "LPAD", "RPAD", "TRANSLATE"};
    private final int function;

    public StringFunction(Expression arg1, Expression arg2, Expression arg3, int function) {
        Expression[] expressionArray;
        if (arg3 == null) {
            Expression[] expressionArray2 = new Expression[2];
            expressionArray2[0] = arg1;
            expressionArray = expressionArray2;
            expressionArray2[1] = arg2;
        } else {
            Expression[] expressionArray3 = new Expression[3];
            expressionArray3[0] = arg1;
            expressionArray3[1] = arg2;
            expressionArray = expressionArray3;
            expressionArray3[2] = arg3;
        }
        super(expressionArray);
        this.function = function;
    }

    public StringFunction(Expression arg1, Expression arg2, Expression arg3, Expression arg4, int function) {
        super(new Expression[]{arg1, arg2, arg3, arg4});
        this.function = function;
    }

    public StringFunction(Expression[] args, int function) {
        super(args);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value v1 = this.args[0].getValue(session);
        Value v2 = this.args[1].getValue(session);
        switch (this.function) {
            case 0: {
                Value v3;
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                Value value = v3 = this.args.length >= 3 ? this.args[2].getValue(session) : null;
                if (v3 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                v1 = ValueInteger.get(StringFunction.locate(v1.getString(), v2.getString(), v3 == null ? 1 : v3.getInt()));
                break;
            }
            case 1: {
                Value v3 = this.args[2].getValue(session);
                Value v4 = this.args[3].getValue(session);
                if (v2 == ValueNull.INSTANCE || v3 == ValueNull.INSTANCE) break;
                String s = StringFunction.insert(v1.getString(), v2.getInt(), v3.getInt(), v4.getString());
                v1 = s != null ? ValueVarchar.get(s, session) : ValueNull.INSTANCE;
                break;
            }
            case 2: {
                String after;
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                if (this.args.length >= 3) {
                    Value v3 = this.args[2].getValue(session);
                    if (v3 == ValueNull.INSTANCE && session.getMode().getEnum() != Mode.ModeEnum.Oracle) {
                        return ValueNull.INSTANCE;
                    }
                    after = v3.getString();
                    if (after == null) {
                        after = "";
                    }
                } else {
                    after = "";
                }
                v1 = ValueVarchar.get(StringUtils.replaceAll(v1.getString(), v2.getString(), after), session);
                break;
            }
            case 3: 
            case 4: {
                String padding;
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                if (this.args.length >= 3) {
                    Value v3 = this.args[2].getValue(session);
                    if (v3 == ValueNull.INSTANCE) {
                        return ValueNull.INSTANCE;
                    }
                    padding = v3.getString();
                } else {
                    padding = null;
                }
                v1 = ValueVarchar.get(StringUtils.pad(v1.getString(), v2.getInt(), padding, this.function == 4), session);
                break;
            }
            case 5: {
                if (v1 == ValueNull.INSTANCE || v2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                Value v3 = this.args[2].getValue(session);
                if (v3 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                String matching = v2.getString();
                String replacement = v3.getString();
                if (session.getMode().getEnum() == Mode.ModeEnum.DB2) {
                    String t = matching;
                    matching = replacement;
                    replacement = t;
                }
                v1 = ValueVarchar.get(StringFunction.translate(v1.getString(), matching, replacement), session);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    private static int locate(String search, String s, int start) {
        if (start < 0) {
            return s.lastIndexOf(search, s.length() + start) + 1;
        }
        return s.indexOf(search, start == 0 ? 0 : start - 1) + 1;
    }

    private static String insert(String s1, int start, int length, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (--start < 0 || length <= 0 || len2 == 0 || start > len1) {
            return s1;
        }
        if (start + length > len1) {
            length = len1 - start;
        }
        return s1.substring(0, start) + s2 + s1.substring(start + length);
    }

    private static String translate(String original, String findChars, String replaceChars) {
        if (StringUtils.isNullOrEmpty(original) || StringUtils.isNullOrEmpty(findChars)) {
            return original;
        }
        StringBuilder builder = null;
        int replaceSize = replaceChars == null ? 0 : replaceChars.length();
        int i = 0;
        int size = original.length();
        while (i < size) {
            char ch = original.charAt(i);
            int index = findChars.indexOf(ch);
            if (index >= 0) {
                if (builder == null) {
                    builder = new StringBuilder(size);
                    if (i > 0) {
                        builder.append(original, 0, i);
                    }
                }
                if (index < replaceSize) {
                    ch = replaceChars.charAt(index);
                }
            }
            if (builder != null) {
                builder.append(ch);
            }
            ++i;
        }
        return builder == null ? original : builder.toString();
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        switch (this.function) {
            case 0: {
                this.type = TypeInfo.TYPE_INTEGER;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.type = TypeInfo.TYPE_VARCHAR;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

