/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Currency;
import java.util.Locale;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.DateTimeFunction;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ToCharFunction
extends FunctionN {
    public static final int JULIAN_EPOCH = -2440588;
    private static final int[] ROMAN_VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] ROMAN_NUMERALS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    public static final int MONTHS = 0;
    public static final int SHORT_MONTHS = 1;
    public static final int WEEKDAYS = 2;
    public static final int SHORT_WEEKDAYS = 3;
    static final int AM_PM = 4;
    private static volatile String[][] NAMES;

    /*
     * Unable to fully structure code
     */
    public static String toChar(BigDecimal number, String format, String nlsParam) {
        block50: {
            v0 = formatUp = format != null ? StringUtils.toUpperEnglish((String)format) : null;
            if (formatUp == null || formatUp.equals("TM") || formatUp.equals("TM9")) {
                s = number.toPlainString();
                return s.startsWith("0.") != false ? s.substring(1) : s;
            }
            if (formatUp.equals("TME")) {
                pow = number.precision() - number.scale() - 1;
                number = number.movePointLeft(pow);
                return number.toPlainString() + "E" + (pow < 0 ? '-' : '+') + (Math.abs(pow) < 10 ? "0" : "") + Math.abs(pow);
            }
            if (formatUp.equals("RN")) {
                lowercase = format.startsWith("r");
                rn = StringUtils.pad(ToCharFunction.toRomanNumeral(number.intValue()), 15, " ", false);
                return lowercase != false ? rn.toLowerCase() : rn;
            }
            if (formatUp.equals("FMRN")) {
                lowercase = format.charAt(2) == 'r';
                rn = ToCharFunction.toRomanNumeral(number.intValue());
                return lowercase != false ? rn.toLowerCase() : rn;
            }
            if (formatUp.endsWith("X")) {
                return ToCharFunction.toHex(number, (String)format);
            }
            originalFormat = format;
            symbols = DecimalFormatSymbols.getInstance();
            localGrouping = symbols.getGroupingSeparator();
            localDecimal = symbols.getDecimalSeparator();
            leadingSign = formatUp.startsWith("S");
            if (leadingSign) {
                format = format.substring(1);
            }
            if (trailingSign = formatUp.endsWith("S")) {
                format = format.substring(0, format.length() - 1);
            }
            if (trailingMinus = formatUp.endsWith("MI")) {
                format = format.substring(0, format.length() - 2);
            }
            if (angleBrackets = formatUp.endsWith("PR")) {
                format = format.substring(0, format.length() - 2);
            }
            if ((v = formatUp.indexOf(86)) >= 0) {
                digits = 0;
                i = v + 1;
                while (i < format.length()) {
                    c = format.charAt(i);
                    if (c == '0' || c == '9') {
                        ++digits;
                    }
                    ++i;
                }
                number = number.movePointRight(digits);
                format = format.substring(0, v) + format.substring(v + 1);
            }
            if (format.endsWith("EEEE")) {
                power = number.precision() - number.scale() - 1;
                number = number.movePointLeft(power);
                format = format.substring(0, format.length() - 4);
            } else {
                power = null;
            }
            maxLength = 1;
            v1 = fillMode = formatUp.startsWith("FM") == false;
            if (!fillMode) {
                format = format.substring(2);
            }
            if ((formatScale = ToCharFunction.calculateScale((String)(format = format.replaceAll("[Bb]", "")), separator = ToCharFunction.findDecimalSeparator((String)format))) < (numberScale = number.scale())) {
                number = number.setScale(formatScale, RoundingMode.HALF_UP);
            } else if (numberScale < 0) {
                number = number.setScale(0);
            }
            i = format.indexOf(48);
            while (i >= 0 && i < separator) {
                if (format.charAt(i) == '9') {
                    format = format.substring(0, i) + "0" + format.substring(i + 1);
                }
                ++i;
            }
            output = new StringBuilder();
            unscaled = (number.abs().compareTo(BigDecimal.ONE) < 0 ? ToCharFunction.zeroesAfterDecimalSeparator(number) : "") + number.unscaledValue().abs().toString();
            i = separator - 1;
            j = unscaled.length() - number.scale() - 1;
            while (i >= 0) {
                c = format.charAt(i);
                ++maxLength;
                if (c == '9' || c == '0') {
                    if (j >= 0) {
                        digit = unscaled.charAt(j);
                        output.insert(0, digit);
                        --j;
                    } else if (c == '0' && power == null) {
                        output.insert(0, '0');
                    }
                } else if (c == ',') {
                    if (j >= 0 || i > 0 && format.charAt(i - 1) == '0') {
                        output.insert(0, c);
                    }
                } else if (c == 'G' || c == 'g') {
                    if (j >= 0 || i > 0 && format.charAt(i - 1) == '0') {
                        output.insert(0, localGrouping);
                    }
                } else if (c == 'C' || c == 'c') {
                    currency = ToCharFunction.getCurrency();
                    output.insert(0, currency.getCurrencyCode());
                    maxLength += 6;
                } else if (c == 'L' || c == 'l' || c == 'U' || c == 'u') {
                    currency = ToCharFunction.getCurrency();
                    output.insert(0, currency.getSymbol());
                    maxLength += 9;
                } else if (c == '$') {
                    currency = ToCharFunction.getCurrency();
                    cs = currency.getSymbol();
                    output.insert(0, cs);
                } else {
                    throw DbException.get(90010, originalFormat);
                }
                --i;
            }
            if (j >= 0) {
                return StringUtils.pad("", format.length() + 1, "#", true);
            }
            if (separator < format.length()) {
                ++maxLength;
                pt = format.charAt(separator);
                if (pt == 'd' || pt == 'D') {
                    output.append(localDecimal);
                } else {
                    output.append(pt);
                }
                i = separator + 1;
                j = unscaled.length() - number.scale();
                while (i < format.length()) {
                    c = format.charAt(i);
                    ++maxLength;
                    if (c == '9' || c == '0') {
                        if (j < unscaled.length()) {
                            digit = unscaled.charAt(j);
                            output.append(digit);
                            ++j;
                        } else if (c == '0' || fillMode) {
                            output.append('0');
                        }
                    } else {
                        throw DbException.get(90010, originalFormat);
                    }
                    ++i;
                }
            }
            ToCharFunction.addSign(output, number.signum(), leadingSign, trailingSign, trailingMinus, angleBrackets, fillMode);
            if (power != null) {
                output.append('E');
                output.append(power < 0 ? '-' : '+');
                output.append(Math.abs(power) < 10 ? "0" : "");
                output.append(Math.abs(power));
            }
            if (!fillMode) break block50;
            if (power == null) ** GOTO lbl160
            output.insert(0, ' ');
            break block50;
lbl-1000:
            // 1 sources

            {
                output.insert(0, ' ');
lbl160:
                // 2 sources

                ** while (output.length() < maxLength)
            }
        }
        return output.toString();
    }

    private static Currency getCurrency() {
        Locale locale = Locale.getDefault();
        return Currency.getInstance(locale.getCountry().length() == 2 ? locale : Locale.US);
    }

    private static String zeroesAfterDecimalSeparator(BigDecimal number) {
        String numberStr = number.toPlainString();
        int idx = numberStr.indexOf(46);
        if (idx < 0) {
            return "";
        }
        int i = idx + 1;
        boolean allZeroes = true;
        int length = numberStr.length();
        while (i < length) {
            if (numberStr.charAt(i) != '0') {
                allZeroes = false;
                break;
            }
            ++i;
        }
        char[] zeroes = new char[allZeroes ? length - idx - 1 : i - 1 - idx];
        Arrays.fill(zeroes, '0');
        return String.valueOf(zeroes);
    }

    private static void addSign(StringBuilder output, int signum, boolean leadingSign, boolean trailingSign, boolean trailingMinus, boolean angleBrackets, boolean fillMode) {
        if (angleBrackets) {
            if (signum < 0) {
                output.insert(0, '<');
                output.append('>');
            } else if (fillMode) {
                output.insert(0, ' ');
                output.append(' ');
            }
        } else {
            String sign = signum == 0 ? "" : (signum < 0 ? "-" : (leadingSign || trailingSign ? "+" : (fillMode ? " " : "")));
            if (trailingMinus || trailingSign) {
                output.append(sign);
            } else {
                output.insert(0, sign);
            }
        }
    }

    private static int findDecimalSeparator(String format) {
        int index = format.indexOf(46);
        if (index == -1 && (index = format.indexOf(68)) == -1 && (index = format.indexOf(100)) == -1) {
            index = format.length();
        }
        return index;
    }

    private static int calculateScale(String format, int separator) {
        int scale = 0;
        int i = separator;
        while (i < format.length()) {
            char c = format.charAt(i);
            if (c == '0' || c == '9') {
                ++scale;
            }
            ++i;
        }
        return scale;
    }

    private static String toRomanNumeral(int number) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < ROMAN_VALUES.length) {
            int value = ROMAN_VALUES[i];
            String numeral = ROMAN_NUMERALS[i];
            while (number >= value) {
                result.append(numeral);
                number -= value;
            }
            ++i;
        }
        return result.toString();
    }

    private static String toHex(BigDecimal number, String format) {
        boolean fillMode = !StringUtils.toUpperEnglish(format).startsWith("FM");
        boolean uppercase = !format.contains("x");
        boolean zeroPadded = format.startsWith("0");
        int digits = 0;
        int i = 0;
        while (i < format.length()) {
            char c = format.charAt(i);
            if (c == '0' || c == 'X' || c == 'x') {
                ++digits;
            }
            ++i;
        }
        i = number.setScale(0, RoundingMode.HALF_UP).intValue();
        String hex = Integer.toHexString(i);
        if (digits < hex.length()) {
            hex = StringUtils.pad("", digits + 1, "#", true);
        } else {
            if (uppercase) {
                hex = StringUtils.toUpperEnglish(hex);
            }
            if (zeroPadded) {
                hex = StringUtils.pad(hex, digits, "0", false);
            }
            if (fillMode) {
                hex = StringUtils.pad(hex, format.length() + 1, " ", false);
            }
        }
        return hex;
    }

    public static String[] getDateNames(int names) {
        String[][] result = NAMES;
        if (result == null) {
            result = new String[5][];
            DateFormatSymbols dfs = DateFormatSymbols.getInstance();
            result[0] = dfs.getMonths();
            String[] months = dfs.getShortMonths();
            int i = 0;
            while (i < 12) {
                String month = months[i];
                if (month.endsWith(".")) {
                    months[i] = month.substring(0, month.length() - 1);
                }
                ++i;
            }
            result[1] = months;
            result[2] = dfs.getWeekdays();
            result[3] = dfs.getShortWeekdays();
            result[4] = dfs.getAmPmStrings();
            NAMES = result;
        }
        return result[names];
    }

    public static void clearNames() {
        NAMES = null;
    }

    private static String getTimeZone(SessionLocal session, Value value, boolean tzd) {
        if (value instanceof ValueTimestampTimeZone) {
            return DateTimeUtils.timeZoneNameFromOffsetSeconds(((ValueTimestampTimeZone)value).getTimeZoneOffsetSeconds());
        }
        if (value instanceof ValueTimeTimeZone) {
            return DateTimeUtils.timeZoneNameFromOffsetSeconds(((ValueTimeTimeZone)value).getTimeZoneOffsetSeconds());
        }
        TimeZoneProvider tz = session.currentTimeZone();
        if (tzd) {
            ValueTimestamp v = (ValueTimestamp)value.convertTo(TypeInfo.TYPE_TIMESTAMP, (CastDataProvider)session);
            return tz.getShortId(tz.getEpochSecondsFromLocal(v.getDateValue(), v.getTimeNanos()));
        }
        return tz.getId();
    }

    public static String toCharDateTime(SessionLocal session, Value value, String format, String nlsParam) {
        boolean isAM;
        long[] a = DateTimeUtils.dateAndTimeFromValue(value, session);
        long dateValue = a[0];
        long timeNanos = a[1];
        int year = DateTimeUtils.yearFromDateValue(dateValue);
        int monthOfYear = DateTimeUtils.monthFromDateValue(dateValue);
        int dayOfMonth = DateTimeUtils.dayFromDateValue(dateValue);
        int posYear = Math.abs(year);
        int second = (int)(timeNanos / 1000000000L);
        int nanos = (int)(timeNanos - (long)(second * 1000000000));
        int minute = second / 60;
        second -= minute * 60;
        int hour = minute / 60;
        minute -= hour * 60;
        int h12 = (hour + 11) % 12 + 1;
        boolean bl = isAM = hour < 12;
        if (format == null) {
            format = "DD-MON-YY HH.MI.SS.FF PM";
        }
        StringBuilder output = new StringBuilder();
        boolean fillMode = true;
        int i = 0;
        int length = format.length();
        block0: while (i < length) {
            Capitalization cap = ToCharFunction.containsAt(format, i, "A.D.", "B.C.");
            if (cap != null) {
                String era = year > 0 ? "A.D." : "B.C.";
                output.append(cap.apply(era));
                i += 4;
                continue;
            }
            cap = ToCharFunction.containsAt(format, i, "AD", "BC");
            if (cap != null) {
                String era = year > 0 ? "AD" : "BC";
                output.append(cap.apply(era));
                i += 2;
                continue;
            }
            cap = ToCharFunction.containsAt(format, i, "A.M.", "P.M.");
            if (cap != null) {
                String am = isAM ? "A.M." : "P.M.";
                output.append(cap.apply(am));
                i += 4;
                continue;
            }
            cap = ToCharFunction.containsAt(format, i, "AM", "PM");
            if (cap != null) {
                String am = isAM ? "AM" : "PM";
                output.append(cap.apply(am));
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "DL") != null) {
                String day = ToCharFunction.getDateNames(2)[DateTimeUtils.getSundayDayOfWeek(dateValue)];
                String month = ToCharFunction.getDateNames(0)[monthOfYear - 1];
                output.append(day).append(", ").append(month).append(' ').append(dayOfMonth).append(", ");
                StringUtils.appendZeroPadded(output, 4, posYear);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "DS") != null) {
                StringUtils.appendTwoDigits(output, monthOfYear).append('/');
                StringUtils.appendTwoDigits(output, dayOfMonth).append('/');
                StringUtils.appendZeroPadded(output, 4, posYear);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "TS") != null) {
                output.append(h12).append(':');
                StringUtils.appendTwoDigits(output, minute).append(':');
                StringUtils.appendTwoDigits(output, second).append(' ').append(ToCharFunction.getDateNames(4)[isAM ? 0 : 1]);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "DDD") != null) {
                output.append(DateTimeUtils.getDayOfYear(dateValue));
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "DD") != null) {
                StringUtils.appendTwoDigits(output, dayOfMonth);
                i += 2;
                continue;
            }
            cap = ToCharFunction.containsAt(format, i, "DY");
            if (cap != null) {
                String day = ToCharFunction.getDateNames(3)[DateTimeUtils.getSundayDayOfWeek(dateValue)];
                output.append(cap.apply(day));
                i += 2;
                continue;
            }
            cap = ToCharFunction.containsAt(format, i, "DAY");
            if (cap != null) {
                String day = ToCharFunction.getDateNames(2)[DateTimeUtils.getSundayDayOfWeek(dateValue)];
                if (fillMode) {
                    day = StringUtils.pad(day, "Wednesday".length(), " ", true);
                }
                output.append(cap.apply(day));
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "D") != null) {
                output.append(DateTimeUtils.getSundayDayOfWeek(dateValue));
                ++i;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "J") != null) {
                output.append(DateTimeUtils.absoluteDayFromDateValue(dateValue) - -2440588L);
                ++i;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "HH24") != null) {
                StringUtils.appendTwoDigits(output, hour);
                i += 4;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "HH12") != null) {
                StringUtils.appendTwoDigits(output, h12);
                i += 4;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "HH") != null) {
                StringUtils.appendTwoDigits(output, h12);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "MI") != null) {
                StringUtils.appendTwoDigits(output, minute);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "SSSSS") != null) {
                int seconds = (int)(timeNanos / 1000000000L);
                output.append(seconds);
                i += 5;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "SS") != null) {
                StringUtils.appendTwoDigits(output, second);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "FF1", "FF2", "FF3", "FF4", "FF5", "FF6", "FF7", "FF8", "FF9") != null) {
                int x = format.charAt(i + 2) - 48;
                int ff = (int)((double)nanos * Math.pow(10.0, x - 9));
                StringUtils.appendZeroPadded(output, x, ff);
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "FF") != null) {
                StringUtils.appendZeroPadded(output, 9, nanos);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "TZR") != null) {
                output.append(ToCharFunction.getTimeZone(session, value, false));
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "TZD") != null) {
                output.append(ToCharFunction.getTimeZone(session, value, true));
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "TZH") != null) {
                int hours = DateTimeFunction.extractDateTime(session, value, 6);
                output.append(hours < 0 ? (char)'-' : '+');
                StringUtils.appendTwoDigits(output, Math.abs(hours));
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "TZM") != null) {
                StringUtils.appendTwoDigits(output, Math.abs(DateTimeFunction.extractDateTime(session, value, 7)));
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "WW") != null) {
                StringUtils.appendTwoDigits(output, (DateTimeUtils.getDayOfYear(dateValue) - 1) / 7 + 1);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "IW") != null) {
                StringUtils.appendTwoDigits(output, DateTimeUtils.getIsoWeekOfYear(dateValue));
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "W") != null) {
                output.append((dayOfMonth - 1) / 7 + 1);
                ++i;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "Y,YYY") != null) {
                output.append(new DecimalFormat("#,###").format(posYear));
                i += 5;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "SYYYY") != null) {
                if (year < 0) {
                    output.append('-');
                }
                StringUtils.appendZeroPadded(output, 4, posYear);
                i += 5;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "YYYY", "RRRR") != null) {
                StringUtils.appendZeroPadded(output, 4, posYear);
                i += 4;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "IYYY") != null) {
                StringUtils.appendZeroPadded(output, 4, Math.abs(DateTimeUtils.getIsoWeekYear(dateValue)));
                i += 4;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "YYY") != null) {
                StringUtils.appendZeroPadded(output, 3, posYear % 1000);
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "IYY") != null) {
                StringUtils.appendZeroPadded(output, 3, Math.abs(DateTimeUtils.getIsoWeekYear(dateValue)) % 1000);
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "YY", "RR") != null) {
                StringUtils.appendTwoDigits(output, posYear % 100);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "IY") != null) {
                StringUtils.appendTwoDigits(output, Math.abs(DateTimeUtils.getIsoWeekYear(dateValue)) % 100);
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "Y") != null) {
                output.append(posYear % 10);
                ++i;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "I") != null) {
                output.append(Math.abs(DateTimeUtils.getIsoWeekYear(dateValue)) % 10);
                ++i;
                continue;
            }
            cap = ToCharFunction.containsAt(format, i, "MONTH");
            if (cap != null) {
                String month = ToCharFunction.getDateNames(0)[monthOfYear - 1];
                if (fillMode) {
                    month = StringUtils.pad(month, "September".length(), " ", true);
                }
                output.append(cap.apply(month));
                i += 5;
                continue;
            }
            cap = ToCharFunction.containsAt(format, i, "MON");
            if (cap != null) {
                String month = ToCharFunction.getDateNames(1)[monthOfYear - 1];
                output.append(cap.apply(month));
                i += 3;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "MM") != null) {
                StringUtils.appendTwoDigits(output, monthOfYear);
                i += 2;
                continue;
            }
            cap = ToCharFunction.containsAt(format, i, "RM");
            if (cap != null) {
                output.append(cap.apply(ToCharFunction.toRomanNumeral(monthOfYear)));
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "Q") != null) {
                int q = 1 + (monthOfYear - 1) / 3;
                output.append(q);
                ++i;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "X") != null) {
                char c = DecimalFormatSymbols.getInstance().getDecimalSeparator();
                output.append(c);
                ++i;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "FM") != null) {
                fillMode = !fillMode;
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "FX") != null) {
                i += 2;
                continue;
            }
            if (ToCharFunction.containsAt(format, i, "\"") != null) {
                ++i;
                while (i < format.length()) {
                    char c = format.charAt(i);
                    if (c == '\"') {
                        ++i;
                        continue block0;
                    }
                    output.append(c);
                    ++i;
                }
                continue;
            }
            if (format.charAt(i) == '-' || format.charAt(i) == '/' || format.charAt(i) == ',' || format.charAt(i) == '.' || format.charAt(i) == ';' || format.charAt(i) == ':' || format.charAt(i) == ' ') {
                output.append(format.charAt(i));
                ++i;
                continue;
            }
            throw DbException.get(90010, format);
        }
        return output.toString();
    }

    private static Capitalization containsAt(String s, int index, String ... substrings) {
        String[] stringArray = substrings;
        int n = substrings.length;
        int n2 = 0;
        while (n2 < n) {
            String substring = stringArray[n2];
            if (index + substring.length() <= s.length()) {
                boolean found = true;
                Boolean up1 = null;
                Boolean up2 = null;
                int i = 0;
                while (i < substring.length()) {
                    char c2;
                    char c1 = s.charAt(index + i);
                    if (c1 != (c2 = substring.charAt(i)) && Character.toUpperCase(c1) != Character.toUpperCase(c2)) {
                        found = false;
                        break;
                    }
                    if (Character.isLetter(c1)) {
                        if (up1 == null) {
                            up1 = Character.isUpperCase(c1);
                        } else if (up2 == null) {
                            up2 = Character.isUpperCase(c1);
                        }
                    }
                    ++i;
                }
                if (found) {
                    return Capitalization.toCapitalization(up1, up2);
                }
            }
            ++n2;
        }
        return null;
    }

    public ToCharFunction(Expression arg1, Expression arg2, Expression arg3) {
        Expression[] expressionArray;
        if (arg2 == null) {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = arg1;
        } else if (arg3 == null) {
            Expression[] expressionArray3 = new Expression[2];
            expressionArray3[0] = arg1;
            expressionArray = expressionArray3;
            expressionArray3[1] = arg2;
        } else {
            Expression[] expressionArray4 = new Expression[3];
            expressionArray4[0] = arg1;
            expressionArray4[1] = arg2;
            expressionArray = expressionArray4;
            expressionArray4[2] = arg3;
        }
        super(expressionArray);
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        switch (v1.getValueType()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                v1 = ValueVarchar.get(ToCharFunction.toCharDateTime(session, v1, v2 == null ? null : v2.getString(), v3 == null ? null : v3.getString()), session);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                v1 = ValueVarchar.get(ToCharFunction.toChar(v1.getBigDecimal(), v2 == null ? null : v2.getString(), v3 == null ? null : v3.getString()), session);
                break;
            }
            default: {
                v1 = ValueVarchar.get(v1.getString(), session);
            }
        }
        return v1;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session, true);
        this.type = TypeInfo.TYPE_VARCHAR;
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return "TO_CHAR";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Capitalization {
        UPPERCASE,
        LOWERCASE,
        CAPITALIZE;


        static Capitalization toCapitalization(Boolean up1, Boolean up2) {
            if (up1 == null) {
                return CAPITALIZE;
            }
            if (up2 == null) {
                return up1 != false ? UPPERCASE : LOWERCASE;
            }
            if (up1.booleanValue()) {
                return up2 != false ? UPPERCASE : CAPITALIZE;
            }
            return LOWERCASE;
        }

        public String apply(String s) {
            if (s == null || s.isEmpty()) {
                return s;
            }
            switch (this) {
                case UPPERCASE: {
                    return StringUtils.toUpperEnglish(s);
                }
                case LOWERCASE: {
                    return StringUtils.toLowerEnglish(s);
                }
                case CAPITALIZE: {
                    return Character.toUpperCase(s.charAt(0)) + (s.length() > 1 ? StringUtils.toLowerEnglish(s).substring(1) : "");
                }
            }
            throw new IllegalArgumentException("Unknown capitalization strategy: " + String.valueOf((Object)this));
        }
    }
}

