/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.Function1_2;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TrimFunction
extends Function1_2 {
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int MULTI_CHARACTER = 4;
    private int flags;

    public TrimFunction(Expression from, Expression space, int flags) {
        super(from, space);
        this.flags = flags;
    }

    @Override
    public Value getValue(SessionLocal session, Value v1, Value v2) {
        return ValueVarchar.get(StringUtils.trim(v1.getString(), (this.flags & 1) != 0, (this.flags & 2) != 0, v2 != null ? v2.getString() : " "), session);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        this.type = TypeInfo.getTypeInfo(2, this.left.getType().getPrecision(), 0, null);
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append(this.getName()).append('(');
        if ((this.flags & 4) != 0) {
            this.left.getUnenclosedSQL(builder, sqlFlags);
            if (this.right != null) {
                this.right.getUnenclosedSQL(builder.append(", "), sqlFlags);
            }
        } else {
            boolean needFrom = false;
            switch (this.flags) {
                case 1: {
                    builder.append("LEADING ");
                    needFrom = true;
                    break;
                }
                case 2: {
                    builder.append("TRAILING ");
                    needFrom = true;
                }
            }
            if (this.right != null) {
                this.right.getUnenclosedSQL(builder, sqlFlags);
                needFrom = true;
            }
            if (needFrom) {
                builder.append(" FROM ");
            }
            this.left.getUnenclosedSQL(builder, sqlFlags);
        }
        return builder.append(')');
    }

    @Override
    public String getName() {
        switch (this.flags) {
            case 5: {
                return "LTRIM";
            }
            case 6: {
                return "RTRIM";
            }
            case 7: {
                return "BTRIM";
            }
        }
        return "TRIM";
    }
}

