/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.function.FunctionN;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class XMLFunction
extends FunctionN {
    public static final int XMLATTR = 0;
    public static final int XMLCDATA = 1;
    public static final int XMLCOMMENT = 2;
    public static final int XMLNODE = 3;
    public static final int XMLSTARTDOC = 4;
    public static final int XMLTEXT = 5;
    private static final String[] NAMES = new String[]{"XMLATTR", "XMLCDATA", "XMLCOMMENT", "XMLNODE", "XMLSTARTDOC", "XMLTEXT"};
    private final int function;

    public XMLFunction(int function) {
        super(new Expression[4]);
        this.function = function;
    }

    @Override
    public Value getValue(SessionLocal session) {
        switch (this.function) {
            case 3: {
                return this.xmlNode(session);
            }
            case 4: {
                return ValueVarchar.get(StringUtils.xmlStartDoc(), session);
            }
        }
        return super.getValue(session);
    }

    private Value xmlNode(SessionLocal session) {
        boolean indent;
        String content;
        Value v1 = this.args[0].getValue(session);
        if (v1 == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        int length = this.args.length;
        String attr = length >= 2 ? this.args[1].getValue(session).getString() : null;
        String string = content = length >= 3 ? this.args[2].getValue(session).getString() : null;
        if (length >= 4) {
            Value v4 = this.args[3].getValue(session);
            if (v4 == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            indent = v4.getBoolean();
        } else {
            indent = true;
        }
        return ValueVarchar.get(StringUtils.xmlNode(v1.getString(), attr, content, indent), session);
    }

    @Override
    protected Value getValue(SessionLocal session, Value v1, Value v2, Value v3) {
        switch (this.function) {
            case 0: {
                v1 = ValueVarchar.get(StringUtils.xmlAttr(v1.getString(), v2.getString()), session);
                break;
            }
            case 1: {
                v1 = ValueVarchar.get(StringUtils.xmlCData(v1.getString()), session);
                break;
            }
            case 2: {
                v1 = ValueVarchar.get(StringUtils.xmlComment(v1.getString()), session);
                break;
            }
            case 5: {
                v1 = ValueVarchar.get(StringUtils.xmlText(v1.getString(), v2 != null && v2.getBoolean()), session);
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        return v1;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        int max;
        int min;
        boolean allConst = this.optimizeArguments(session, true);
        switch (this.function) {
            case 0: {
                min = 2;
                max = 2;
                break;
            }
            case 3: {
                min = 1;
                max = 4;
                break;
            }
            case 1: 
            case 2: {
                min = 1;
                max = 1;
                break;
            }
            case 4: {
                min = 0;
                max = 0;
                break;
            }
            case 5: {
                min = 1;
                max = 2;
                break;
            }
            default: {
                throw DbException.getInternalError("function=" + this.function);
            }
        }
        int len = this.args.length;
        if (len < min || len > max) {
            throw DbException.get(7001, this.getName(), min + ".." + max);
        }
        this.type = TypeInfo.TYPE_VARCHAR;
        if (allConst) {
            return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

