/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function.table;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.function.CSVWriteFunction;
import org.h2.expression.function.table.TableFunction;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.FunctionAlias;
import org.h2.tools.Csv;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CSVReadFunction
extends TableFunction {
    public CSVReadFunction() {
        super(new Expression[4]);
    }

    @Override
    public ResultInterface getValue(SessionLocal session) {
        session.getUser().checkAdmin();
        String fileName = this.getValue(session, 0);
        String columnList = this.getValue(session, 1);
        Csv csv = new Csv();
        String options = this.getValue(session, 2);
        String charset = null;
        if (options != null && options.indexOf(61) >= 0) {
            charset = csv.setOptions(options);
        } else {
            charset = options;
            String fieldSeparatorRead = this.getValue(session, 3);
            String fieldDelimiter = this.getValue(session, 4);
            String escapeCharacter = this.getValue(session, 5);
            String nullString = this.getValue(session, 6);
            CSVWriteFunction.setCsvDelimiterEscape(csv, fieldSeparatorRead, fieldDelimiter, escapeCharacter);
            csv.setNullString(nullString);
        }
        char fieldSeparator = csv.getFieldSeparatorRead();
        String[] columns = StringUtils.arraySplit(columnList, fieldSeparator, true);
        try {
            return FunctionAlias.JavaMethod.resultSetToResult(session, csv.read(fileName, columns, charset), Integer.MAX_VALUE);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    private String getValue(SessionLocal session, int index) {
        return CSVReadFunction.getValue(session, this.args, index);
    }

    @Override
    public void optimize(SessionLocal session) {
        super.optimize(session);
        int len = this.args.length;
        if (len < 1 || len > 7) {
            throw DbException.get(7001, this.getName(), "1..7");
        }
    }

    @Override
    public ResultInterface getValueTemplate(SessionLocal session) {
        ResultInterface result;
        session.getUser().checkAdmin();
        String fileName = CSVReadFunction.getValue(session, this.args, 0);
        if (fileName == null) {
            throw DbException.get(90012, "fileName");
        }
        String columnList = CSVReadFunction.getValue(session, this.args, 1);
        Csv csv = new Csv();
        String options = CSVReadFunction.getValue(session, this.args, 2);
        String charset = null;
        if (options != null && options.indexOf(61) >= 0) {
            charset = csv.setOptions(options);
        } else {
            charset = options;
            String fieldSeparatorRead = CSVReadFunction.getValue(session, this.args, 3);
            String fieldDelimiter = CSVReadFunction.getValue(session, this.args, 4);
            String escapeCharacter = CSVReadFunction.getValue(session, this.args, 5);
            CSVWriteFunction.setCsvDelimiterEscape(csv, fieldSeparatorRead, fieldDelimiter, escapeCharacter);
        }
        char fieldSeparator = csv.getFieldSeparatorRead();
        String[] columns = StringUtils.arraySplit(columnList, fieldSeparator, true);
        try {
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                try (ResultSet rs = csv.read(fileName, columns, charset);){
                    result = FunctionAlias.JavaMethod.resultSetToResult(session, rs, 0);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw DbException.convert(e);
            }
        }
        finally {
            csv.close();
        }
        return result;
    }

    private static String getValue(SessionLocal session, Expression[] args, int index) {
        return index < args.length ? args[index].getValue(session).getString() : null;
    }

    @Override
    public String getName() {
        return "CSVREAD";
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }
}

