/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function.table;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.function.table.TableFunction;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.schema.FunctionAlias;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JavaTableFunction
extends TableFunction {
    private final FunctionAlias functionAlias;
    private final FunctionAlias.JavaMethod javaMethod;

    public JavaTableFunction(FunctionAlias functionAlias, Expression[] args) {
        super(args);
        this.functionAlias = functionAlias;
        this.javaMethod = functionAlias.findJavaMethod(args);
        if (this.javaMethod.getDataType() != null) {
            throw DbException.get(90000, this.getName());
        }
    }

    @Override
    public ResultInterface getValue(SessionLocal session) {
        return this.javaMethod.getTableValue(session, this.args, false);
    }

    @Override
    public ResultInterface getValueTemplate(SessionLocal session) {
        return this.javaMethod.getTableValue(session, this.args, true);
    }

    @Override
    public void optimize(SessionLocal session) {
        super.optimize(session);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return Expression.writeExpressions(this.functionAlias.getSQL(builder, sqlFlags).append('('), this.args, sqlFlags).append(')');
    }

    @Override
    public String getName() {
        return this.functionAlias.getName();
    }

    @Override
    public boolean isDeterministic() {
        return this.functionAlias.isDeterministic();
    }
}

