/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function.table;

import java.util.Arrays;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionWithVariableParameters;
import org.h2.expression.function.NamedExpression;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.HasSQL;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TableFunction
implements HasSQL,
NamedExpression,
ExpressionWithVariableParameters {
    protected Expression[] args;
    private int argsCount;

    protected TableFunction(Expression[] args) {
        this.args = args;
    }

    @Override
    public void addParameter(Expression param) {
        int capacity = this.args.length;
        if (this.argsCount >= capacity) {
            this.args = Arrays.copyOf(this.args, capacity * 2);
        }
        this.args[this.argsCount++] = param;
    }

    @Override
    public void doneWithParameters() throws DbException {
        if (this.args.length != this.argsCount) {
            this.args = Arrays.copyOf(this.args, this.argsCount);
        }
    }

    public abstract ResultInterface getValue(SessionLocal var1);

    public abstract ResultInterface getValueTemplate(SessionLocal var1);

    public void optimize(SessionLocal session) {
        int i = 0;
        int l = this.args.length;
        while (i < l) {
            this.args[i] = this.args[i].optimize(session);
            ++i;
        }
    }

    public abstract boolean isDeterministic();

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        return Expression.writeExpressions(builder.append(this.getName()).append('('), this.args, sqlFlags).append(')');
    }
}

