/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionColumn;
import org.h2.fulltext.FullText;
import org.h2.jdbc.JdbcConnection;
import org.h2.store.fs.FileUtils;
import org.h2.tools.SimpleResultSet;
import org.h2.util.StringUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FullTextLucene
extends FullText {
    protected static final boolean STORE_DOCUMENT_TEXT_IN_INDEX = Utils.getProperty("h2.storeDocumentTextInIndex", false);
    private static final HashMap<String, IndexAccess> INDEX_ACCESS = new HashMap();
    private static final String TRIGGER_PREFIX = "FTL_";
    private static final String SCHEMA = "FTL";
    private static final String LUCENE_FIELD_DATA = "_DATA";
    private static final String LUCENE_FIELD_QUERY = "_QUERY";
    private static final String LUCENE_FIELD_MODIFIED = "_modified";
    private static final String LUCENE_FIELD_COLUMN_PREFIX = "_";
    private static final String IN_MEMORY_PREFIX = "mem:";

    public static void init(Connection conn) throws SQLException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Statement stat = conn.createStatement();){
            stat.execute("CREATE SCHEMA IF NOT EXISTS FTL");
            stat.execute("CREATE TABLE IF NOT EXISTS FTL.INDEXES(SCHEMA VARCHAR, `TABLE` VARCHAR, COLUMNS VARCHAR, PRIMARY KEY(SCHEMA, `TABLE`))");
            String className = FullTextLucene.class.getName();
            stat.execute("CREATE ALIAS IF NOT EXISTS FTL_CREATE_INDEX FOR '" + className + ".createIndex'");
            stat.execute("CREATE ALIAS IF NOT EXISTS FTL_DROP_INDEX FOR '" + className + ".dropIndex'");
            stat.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH FOR '" + className + ".search'");
            stat.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH_DATA FOR '" + className + ".searchData'");
            stat.execute("CREATE ALIAS IF NOT EXISTS FTL_REINDEX FOR '" + className + ".reindex'");
            stat.execute("CREATE ALIAS IF NOT EXISTS FTL_DROP_ALL FOR '" + className + ".dropAll'");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void createIndex(Connection conn, String schema, String table, String columnList) throws SQLException {
        FullTextLucene.init(conn);
        PreparedStatement prep = conn.prepareStatement("INSERT INTO FTL.INDEXES(SCHEMA, `TABLE`, COLUMNS) VALUES(?, ?, ?)");
        prep.setString(1, schema);
        prep.setString(2, table);
        prep.setString(3, columnList);
        prep.execute();
        FullTextLucene.createTrigger(conn, schema, table);
        FullTextLucene.indexExistingRows(conn, schema, table);
    }

    public static void dropIndex(Connection conn, String schema, String table) throws SQLException {
        FullTextLucene.init(conn);
        PreparedStatement prep = conn.prepareStatement("DELETE FROM FTL.INDEXES WHERE SCHEMA=? AND `TABLE`=?");
        prep.setString(1, schema);
        prep.setString(2, table);
        int rowCount = prep.executeUpdate();
        if (rowCount != 0) {
            FullTextLucene.reindex(conn);
        }
    }

    public static void reindex(Connection conn) throws SQLException {
        FullTextLucene.init(conn);
        FullTextLucene.removeAllTriggers(conn, TRIGGER_PREFIX);
        FullTextLucene.removeIndexFiles(conn);
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM FTL.INDEXES");
        while (rs.next()) {
            String schema = rs.getString("SCHEMA");
            String table = rs.getString("TABLE");
            FullTextLucene.createTrigger(conn, schema, table);
            FullTextLucene.indexExistingRows(conn, schema, table);
        }
    }

    public static void dropAll(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        stat.execute("DROP SCHEMA IF EXISTS FTL CASCADE");
        FullTextLucene.removeAllTriggers(conn, TRIGGER_PREFIX);
        FullTextLucene.removeIndexFiles(conn);
    }

    public static ResultSet search(Connection conn, String text, int limit, int offset) throws SQLException {
        return FullTextLucene.search(conn, text, limit, offset, false);
    }

    public static ResultSet searchData(Connection conn, String text, int limit, int offset) throws SQLException {
        return FullTextLucene.search(conn, text, limit, offset, true);
    }

    protected static SQLException convertException(Exception e) {
        return new SQLException("Error while indexing document", "FULLTEXT", e);
    }

    private static void createTrigger(Connection conn, String schema, String table) throws SQLException {
        FullTextLucene.createOrDropTrigger(conn, schema, table, true);
    }

    private static void createOrDropTrigger(Connection conn, String schema, String table, boolean create) throws SQLException {
        Statement stat = conn.createStatement();
        String trigger = StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + table);
        stat.execute("DROP TRIGGER IF EXISTS " + trigger);
        if (create) {
            StringBuilder builder = new StringBuilder("CREATE TRIGGER IF NOT EXISTS ");
            builder.append(trigger).append(" AFTER INSERT, UPDATE, DELETE, ROLLBACK ON ");
            StringUtils.quoteIdentifier(builder, schema).append('.');
            StringUtils.quoteIdentifier(builder, table).append(" FOR EACH ROW CALL \"").append(FullTextTrigger.class.getName()).append('\"');
            stat.execute(builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IndexAccess getIndexAccess(Connection conn) throws SQLException {
        String path = FullTextLucene.getIndexPath(conn);
        HashMap<String, IndexAccess> hashMap = INDEX_ACCESS;
        synchronized (hashMap) {
            IndexAccess access = INDEX_ACCESS.get(path);
            while (access == null) {
                try {
                    ByteBuffersDirectory indexDir = path.startsWith(IN_MEMORY_PREFIX) ? new ByteBuffersDirectory() : FSDirectory.open((Path)Paths.get(path, new String[0]));
                    StandardAnalyzer analyzer = new StandardAnalyzer();
                    IndexWriterConfig conf = new IndexWriterConfig((Analyzer)analyzer);
                    conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                    IndexWriter writer = new IndexWriter((Directory)indexDir, conf);
                    access = new IndexAccess(writer);
                }
                catch (IndexFormatTooOldException e) {
                    FullTextLucene.reindex(conn);
                    continue;
                }
                catch (IOException e) {
                    throw FullTextLucene.convertException(e);
                }
                INDEX_ACCESS.put(path, access);
                break;
            }
            return access;
        }
    }

    protected static String getIndexPath(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("CALL DATABASE_PATH()");
        rs.next();
        String path = rs.getString(1);
        if (path == null) {
            return IN_MEMORY_PREFIX + conn.getCatalog();
        }
        int index = path.lastIndexOf(58);
        if (index > 1) {
            path = path.substring(index + 1);
        }
        rs.close();
        return path;
    }

    private static void indexExistingRows(Connection conn, String schema, String table) throws SQLException {
        FullTextTrigger existing = new FullTextTrigger();
        existing.init(conn, schema, null, table, false, 1);
        String sql = "SELECT * FROM " + StringUtils.quoteIdentifier(schema) + "." + StringUtils.quoteIdentifier(table);
        ResultSet rs = conn.createStatement().executeQuery(sql);
        int columnCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            int i = 0;
            while (i < columnCount) {
                row[i] = rs.getObject(i + 1);
                ++i;
            }
            existing.insert(row, false);
        }
        existing.commitIndex();
    }

    private static void removeIndexFiles(Connection conn) throws SQLException {
        String path = FullTextLucene.getIndexPath(conn);
        FullTextLucene.removeIndexAccess(path);
        if (!path.startsWith(IN_MEMORY_PREFIX)) {
            FileUtils.deleteRecursive(path, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeIndexAccess(String indexPath) throws SQLException {
        HashMap<String, IndexAccess> hashMap = INDEX_ACCESS;
        synchronized (hashMap) {
            try {
                IndexAccess access = INDEX_ACCESS.remove(indexPath);
                if (access != null) {
                    access.close();
                }
            }
            catch (Exception e) {
                throw FullTextLucene.convertException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static ResultSet search(Connection conn, String text, int limit, int offset, boolean data) throws SQLException {
        SimpleResultSet result = FullTextLucene.createResultSet(data);
        if (conn.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return result;
        }
        if (text == null) return result;
        if (StringUtils.isWhitespaceOrEmpty(text)) {
            return result;
        }
        try {
            IndexAccess access = FullTextLucene.getIndexAccess(conn);
            IndexSearcher searcher = access.getSearcher();
            try {
                Analyzer analyzer = access.writer.getAnalyzer();
                StandardQueryParser parser = new StandardQueryParser(analyzer);
                Query query = parser.parse(text, LUCENE_FIELD_DATA);
                int maxResults = (limit == 0 ? 100 : limit) + offset;
                TopDocs docs = searcher.search(query, maxResults);
                long totalHits = docs.totalHits.value;
                if (limit == 0) {
                    limit = (int)totalHits;
                }
                int i = 0;
                int len = docs.scoreDocs.length;
                while (i < limit) {
                    if ((long)(i + offset) >= totalHits) return result;
                    if (i + offset >= len) {
                        return result;
                    }
                    ScoreDoc sd = docs.scoreDocs[i + offset];
                    Document doc = searcher.getIndexReader().storedFields().document(sd.doc);
                    float score = sd.score;
                    String q = doc.get(LUCENE_FIELD_QUERY);
                    if (data) {
                        int idx = q.indexOf(" WHERE ");
                        JdbcConnection c = (JdbcConnection)conn;
                        SessionLocal session = (SessionLocal)c.getSession();
                        Parser p = new Parser(session);
                        String tab = q.substring(0, idx);
                        ExpressionColumn expr = (ExpressionColumn)p.parseExpression(tab);
                        String schemaName = expr.getOriginalTableAliasName();
                        String tableName = expr.getColumnName(session, -1);
                        q = q.substring(idx + " WHERE ".length());
                        String[][] columnData = FullTextLucene.parseKey(conn, q);
                        result.addRow(schemaName, tableName, columnData[0], columnData[1], Float.valueOf(score));
                    } else {
                        result.addRow(q, Float.valueOf(score));
                    }
                    ++i;
                }
                return result;
            }
            finally {
                access.returnSearcher(searcher);
            }
        }
        catch (Exception e) {
            throw FullTextLucene.convertException(e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class FullTextTrigger
    implements Trigger {
        private String schema;
        private String table;
        private int[] keys;
        private int[] indexColumns;
        private String[] columns;
        private int[] columnTypes;
        private String indexPath;
        private IndexAccess indexAccess;
        private final FieldType DOC_ID_FIELD_TYPE = new FieldType((IndexableFieldType)TextField.TYPE_STORED);

        public FullTextTrigger() {
            this.DOC_ID_FIELD_TYPE.setTokenized(false);
            this.DOC_ID_FIELD_TYPE.freeze();
        }

        @Override
        public void init(Connection conn, String schemaName, String triggerName, String tableName, boolean before, int type) throws SQLException {
            String cols;
            this.schema = schemaName;
            this.table = tableName;
            this.indexPath = FullTextLucene.getIndexPath(conn);
            this.indexAccess = FullTextLucene.getIndexAccess(conn);
            ArrayList<String> keyList = Utils.newSmallArrayList();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getColumns(null, StringUtils.escapeMetaDataPattern(schemaName), StringUtils.escapeMetaDataPattern(tableName), null);
            ArrayList<String> columnList = Utils.newSmallArrayList();
            while (rs.next()) {
                columnList.add(rs.getString("COLUMN_NAME"));
            }
            this.columnTypes = new int[columnList.size()];
            this.columns = columnList.toArray(new String[0]);
            rs = meta.getColumns(null, StringUtils.escapeMetaDataPattern(schemaName), StringUtils.escapeMetaDataPattern(tableName), null);
            int i = 0;
            while (rs.next()) {
                this.columnTypes[i] = rs.getInt("DATA_TYPE");
                ++i;
            }
            if (keyList.isEmpty()) {
                rs = meta.getPrimaryKeys(null, StringUtils.escapeMetaDataPattern(schemaName), tableName);
                while (rs.next()) {
                    keyList.add(rs.getString("COLUMN_NAME"));
                }
            }
            if (keyList.isEmpty()) {
                throw FullTextLucene.throwException("No primary key for table " + tableName);
            }
            ArrayList<String> indexList = Utils.newSmallArrayList();
            PreparedStatement prep = conn.prepareStatement("SELECT COLUMNS FROM FTL.INDEXES WHERE SCHEMA=? AND `TABLE`=?");
            prep.setString(1, schemaName);
            prep.setString(2, tableName);
            rs = prep.executeQuery();
            if (rs.next() && (cols = rs.getString(1)) != null) {
                Collections.addAll(indexList, StringUtils.arraySplit(cols, ',', true));
            }
            if (indexList.isEmpty()) {
                indexList.addAll(columnList);
            }
            this.keys = new int[keyList.size()];
            FullTextLucene.setColumns(this.keys, keyList, columnList);
            this.indexColumns = new int[indexList.size()];
            FullTextLucene.setColumns(this.indexColumns, indexList, columnList);
        }

        @Override
        public void fire(Connection conn, Object[] oldRow, Object[] newRow) throws SQLException {
            if (oldRow != null) {
                if (newRow != null) {
                    if (FullTextLucene.hasChanged(oldRow, newRow, this.indexColumns)) {
                        this.delete(oldRow, false);
                        this.insert(newRow, true);
                    }
                } else {
                    this.delete(oldRow, true);
                }
            } else if (newRow != null) {
                this.insert(newRow, true);
            }
        }

        @Override
        public void close() throws SQLException {
            FullTextLucene.removeIndexAccess(this.indexPath);
        }

        void commitIndex() throws SQLException {
            try {
                this.indexAccess.commit();
            }
            catch (IOException e) {
                throw FullTextLucene.convertException(e);
            }
        }

        void insert(Object[] row, boolean commitIndex) throws SQLException {
            String query = this.getQuery(row);
            Document doc = new Document();
            doc.add((IndexableField)new Field(FullTextLucene.LUCENE_FIELD_QUERY, (CharSequence)query, (IndexableFieldType)this.DOC_ID_FIELD_TYPE));
            long time = System.currentTimeMillis();
            doc.add((IndexableField)new Field(FullTextLucene.LUCENE_FIELD_MODIFIED, (CharSequence)DateTools.timeToString((long)time, (DateTools.Resolution)DateTools.Resolution.SECOND), (IndexableFieldType)TextField.TYPE_STORED));
            StringBuilder builder = new StringBuilder();
            int i = 0;
            int length = this.indexColumns.length;
            while (i < length) {
                int index = this.indexColumns[i];
                Object columnName = this.columns[index];
                String data = FullTextLucene.asString(row[index], this.columnTypes[index]);
                if (((String)columnName).startsWith(FullTextLucene.LUCENE_FIELD_COLUMN_PREFIX)) {
                    columnName = FullTextLucene.LUCENE_FIELD_COLUMN_PREFIX + (String)columnName;
                }
                doc.add((IndexableField)new Field((String)columnName, (CharSequence)data, (IndexableFieldType)TextField.TYPE_NOT_STORED));
                if (i > 0) {
                    builder.append(' ');
                }
                builder.append(data);
                ++i;
            }
            FieldType dataFieldType = STORE_DOCUMENT_TEXT_IN_INDEX ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED;
            doc.add((IndexableField)new Field(FullTextLucene.LUCENE_FIELD_DATA, (CharSequence)builder.toString(), (IndexableFieldType)dataFieldType));
            try {
                this.indexAccess.writer.addDocument((Iterable)doc);
                if (commitIndex) {
                    this.commitIndex();
                }
            }
            catch (IOException e) {
                throw FullTextLucene.convertException(e);
            }
        }

        private void delete(Object[] row, boolean commitIndex) throws SQLException {
            String query = this.getQuery(row);
            try {
                Term term = new Term(FullTextLucene.LUCENE_FIELD_QUERY, query);
                this.indexAccess.writer.deleteDocuments(new Term[]{term});
                if (commitIndex) {
                    this.commitIndex();
                }
            }
            catch (IOException e) {
                throw FullTextLucene.convertException(e);
            }
        }

        private String getQuery(Object[] row) throws SQLException {
            StringBuilder builder = new StringBuilder();
            if (this.schema != null) {
                StringUtils.quoteIdentifier(builder, this.schema).append('.');
            }
            StringUtils.quoteIdentifier(builder, this.table).append(" WHERE ");
            int i = 0;
            int length = this.keys.length;
            while (i < length) {
                if (i > 0) {
                    builder.append(" AND ");
                }
                int columnIndex = this.keys[i];
                StringUtils.quoteIdentifier(builder, this.columns[columnIndex]);
                Object o = row[columnIndex];
                if (o == null) {
                    builder.append(" IS NULL");
                } else {
                    builder.append('=').append(FullText.quoteSQL(o, this.columnTypes[columnIndex]));
                }
                ++i;
            }
            return builder.toString();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class IndexAccess {
        final IndexWriter writer;
        private IndexSearcher searcher;

        IndexAccess(IndexWriter writer) throws IOException {
            this.writer = writer;
            this.initializeSearcher();
        }

        synchronized IndexSearcher getSearcher() throws IOException {
            if (!this.searcher.getIndexReader().tryIncRef()) {
                this.initializeSearcher();
            }
            return this.searcher;
        }

        private void initializeSearcher() throws IOException {
            DirectoryReader reader = DirectoryReader.open((IndexWriter)this.writer);
            this.searcher = new IndexSearcher((IndexReader)reader);
        }

        synchronized void returnSearcher(IndexSearcher searcher) throws IOException {
            searcher.getIndexReader().decRef();
        }

        public synchronized void commit() throws IOException {
            this.writer.commit();
            this.returnSearcher(this.searcher);
            this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)this.writer));
        }

        public synchronized void close() throws IOException {
            this.searcher = null;
            this.writer.close();
        }
    }
}

