/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.h2.fulltext.FullText;
import org.h2.fulltext.IndexInfo;
import org.h2.util.SoftValuesHashMap;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class FullTextSettings {
    private static final HashMap<String, FullTextSettings> SETTINGS = new HashMap();
    private boolean initialized;
    private final HashSet<String> ignoreList = new HashSet();
    private final HashMap<String, Integer> words = new HashMap();
    private final ConcurrentHashMap<Integer, IndexInfo> indexes = new ConcurrentHashMap();
    private final WeakHashMap<Connection, SoftValuesHashMap<String, PreparedStatement>> cache = new WeakHashMap();
    private String whitespaceChars = " \t\n\r\f+\"*%&/()=?'!,.;:-_#@|^~`{}[]<>\\";

    private FullTextSettings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearIgnored() {
        HashSet<String> hashSet = this.ignoreList;
        synchronized (hashSet) {
            this.ignoreList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnored(Iterable<String> words) {
        HashSet<String> hashSet = this.ignoreList;
        synchronized (hashSet) {
            for (String word : words) {
                word = FullTextSettings.normalizeWord(word);
                this.ignoreList.add(word);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWordList() {
        HashMap<String, Integer> hashMap = this.words;
        synchronized (hashMap) {
            this.words.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getWordId(String word) {
        HashMap<String, Integer> hashMap = this.words;
        synchronized (hashMap) {
            return this.words.get(word);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWord(String word, Integer id) {
        HashMap<String, Integer> hashMap = this.words;
        synchronized (hashMap) {
            this.words.putIfAbsent(word, id);
        }
    }

    IndexInfo getIndexInfo(int indexId) {
        return this.indexes.get(indexId);
    }

    void addIndexInfo(IndexInfo index) {
        this.indexes.put(index.id, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String convertWord(String word) {
        word = FullTextSettings.normalizeWord(word);
        HashSet<String> hashSet = this.ignoreList;
        synchronized (hashSet) {
            block4: {
                if (!this.ignoreList.contains(word)) break block4;
                return null;
            }
        }
        return word;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FullTextSettings getInstance(Connection conn) throws SQLException {
        FullTextSettings setting;
        String path = FullTextSettings.getIndexPath(conn);
        HashMap<String, FullTextSettings> hashMap = SETTINGS;
        synchronized (hashMap) {
            setting = SETTINGS.get(path);
            if (setting == null) {
                setting = new FullTextSettings();
                SETTINGS.put(path, setting);
            }
        }
        return setting;
    }

    private static String getIndexPath(Connection conn) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("CALL COALESCE(DATABASE_PATH(), 'MEM:' || DATABASE())");
        rs.next();
        String path = rs.getString(1);
        if ("MEM:UNNAMED".equals(path)) {
            throw FullText.throwException("Fulltext search for private (unnamed) in-memory databases is not supported.");
        }
        rs.close();
        return path;
    }

    synchronized PreparedStatement prepare(Connection conn, String sql) throws SQLException {
        PreparedStatement prep;
        SoftValuesHashMap<String, PreparedStatement> c = this.cache.get(conn);
        if (c == null) {
            c = new SoftValuesHashMap();
            this.cache.put(conn, c);
        }
        if ((prep = c.get(sql)) != null && prep.getConnection().isClosed()) {
            prep = null;
        }
        if (prep == null) {
            prep = conn.prepareStatement(sql);
            c.put(sql, prep);
        }
        return prep;
    }

    void removeAllIndexes() {
        this.indexes.clear();
    }

    void removeIndexInfo(IndexInfo index) {
        this.indexes.remove(index.id);
    }

    void setInitialized(boolean b) {
        this.initialized = b;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeAll() {
        HashMap<String, FullTextSettings> hashMap = SETTINGS;
        synchronized (hashMap) {
            SETTINGS.clear();
        }
    }

    void setWhitespaceChars(String whitespaceChars) {
        this.whitespaceChars = whitespaceChars;
    }

    String getWhitespaceChars() {
        return this.whitespaceChars;
    }

    private static String normalizeWord(String word) {
        return word.toUpperCase();
    }
}

