/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.index.Cursor;
import org.h2.index.QueryExpressionIndex;
import org.h2.index.RecursiveIndex;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Table;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class QueryExpressionCursor
implements Cursor {
    private final Table table;
    private final QueryExpressionIndex index;
    private final ResultInterface result;
    private final SearchRow first;
    private final SearchRow last;
    private Row current;

    public QueryExpressionCursor(QueryExpressionIndex index, ResultInterface result, SearchRow first, SearchRow last) {
        this.table = index.getTable();
        this.index = index;
        this.result = result;
        this.first = first;
        this.last = last;
    }

    @Override
    public Row get() {
        return this.current;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.current;
    }

    @Override
    public boolean next() {
        int comp;
        do {
            boolean res;
            if (!(res = this.result.next())) {
                if (this.index.getClass() == RecursiveIndex.class) {
                    this.result.reset();
                } else {
                    this.result.close();
                }
                this.current = null;
                return false;
            }
            this.current = this.table.getTemplateRow();
            Value[] values = this.result.currentRow();
            int i = 0;
            int len = this.current.getColumnCount();
            while (i < len) {
                ValueNull v = i < values.length ? values[i] : ValueNull.INSTANCE;
                this.current.setValue(i, v);
                ++i;
            }
        } while (this.first != null && (comp = this.index.compareRows(this.current, this.first)) < 0 || this.last != null && (comp = this.index.compareRows(this.current, this.last)) > 0);
        return true;
    }

    @Override
    public boolean previous() {
        throw DbException.getInternalError(this.toString());
    }
}

