/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.mvstore.DataUtils;
import org.h2.util.IOUtils;
import org.h2.util.Task;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class JdbcLob
extends TraceObject {
    final JdbcConnection conn;
    Value value;
    State state;

    JdbcLob(JdbcConnection conn, Value value, State state, int type, int id) {
        this.setTrace(conn.getSession().getTrace(), type, id);
        this.conn = conn;
        this.value = value;
        this.state = state;
    }

    void checkClosed() {
        this.conn.checkClosed();
        if (this.state == State.CLOSED) {
            throw DbException.get(90007);
        }
    }

    void checkEditable() {
        this.checkClosed();
        if (this.state != State.NEW) {
            throw DbException.getUnsupportedException("Allocate a new object to set its value.");
        }
    }

    void checkReadable() throws SQLException, IOException {
        this.checkClosed();
        if (this.state == State.SET_CALLED) {
            throw DbException.getUnsupportedException("Stream setter is not yet closed.");
        }
    }

    void completeWrite(Value blob) {
        this.checkClosed();
        this.state = State.WITH_VALUE;
        this.value = blob;
    }

    public void free() {
        this.debugCodeCall("free");
        this.state = State.CLOSED;
        this.value = null;
    }

    InputStream getBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("getBinaryStream");
            this.checkReadable();
            return this.value.getInputStream();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    Reader getCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("getCharacterStream");
            this.checkReadable();
            return this.value.getReader();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    Writer setCharacterStreamImpl() throws IOException {
        return IOUtils.getBufferedWriter(this.setClobOutputStreamImpl());
    }

    LobPipedOutputStream setClobOutputStreamImpl() throws IOException {
        final PipedInputStream in = new PipedInputStream();
        Task task = new Task(){

            @Override
            public void call() {
                JdbcLob.this.completeWrite(JdbcLob.this.conn.createClob(IOUtils.getReader(in), -1L));
            }
        };
        LobPipedOutputStream out = new LobPipedOutputStream(in, task);
        task.execute();
        return out;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.getTraceObjectName()).append(": ");
        if (this.state == State.SET_CALLED) {
            builder.append("<setter_in_progress>");
        } else if (this.state == State.CLOSED) {
            builder.append("<closed>");
        } else {
            builder.append(this.value.getTraceSQL());
        }
        return builder.toString();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class LobPipedOutputStream
    extends PipedOutputStream {
        private final Task task;

        LobPipedOutputStream(PipedInputStream snk, Task task) throws IOException {
            super(snk);
            this.task = task;
        }

        @Override
        public void close() throws IOException {
            super.close();
            try {
                this.task.get();
            }
            catch (Exception e) {
                throw DataUtils.convertToIOException(e);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum State {
        NEW,
        SET_CALLED,
        WITH_VALUE,
        CLOSED;

    }
}

