/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.h2.command.CommandInterface;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Session;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcParameterMetaData;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.result.BatchResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.util.IOUtils;
import org.h2.util.LegacyDateTimeUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueNumeric;
import org.h2.value.ValueReal;
import org.h2.value.ValueSmallint;
import org.h2.value.ValueTinyint;
import org.h2.value.ValueToObjectConverter;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement {
    protected CommandInterface command;
    private ArrayList<Value[]> batchParameters;
    private HashMap<String, Integer> cachedColumnLabelMap;
    private final Object generatedKeysRequest;

    JdbcPreparedStatement(JdbcConnection conn, String sql, int id, int resultSetType, int resultSetConcurrency, Object generatedKeysRequest) {
        super(conn, id, resultSetType, resultSetConcurrency);
        this.generatedKeysRequest = generatedKeysRequest;
        this.setTrace(this.session.getTrace(), 3, id);
        this.command = conn.prepareCommand(sql, this.fetchSize);
    }

    void setCachedColumnLabelMap(HashMap<String, Integer> cachedColumnLabelMap) {
        this.cachedColumnLabelMap = cachedColumnLabelMap;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            int id = JdbcPreparedStatement.getNextId(4);
            this.debugCodeAssign("ResultSet", 4, id, "executeQuery()");
            Session session = this.session;
            session.lock();
            try {
                ResultInterface result;
                this.checkClosed();
                this.closeOldResultSet();
                boolean lazy = false;
                boolean scrollable = this.resultSetType != 1003;
                boolean updatable = this.resultSetConcurrency == 1008;
                try {
                    this.setExecutingStatement(this.command);
                    result = this.command.executeQuery(this.maxRows, scrollable);
                    lazy = result.isLazy();
                }
                finally {
                    if (!lazy) {
                        this.setExecutingStatement(null);
                    }
                }
                this.resultSet = new JdbcResultSet(this.conn, this, this.command, result, id, scrollable, updatable, this.cachedColumnLabelMap);
            }
            finally {
                session.unlock();
            }
            return this.resultSet;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.debugCodeCall("executeUpdate");
            this.checkClosed();
            long updateCount = this.executeUpdateInternal();
            return updateCount <= Integer.MAX_VALUE ? (int)updateCount : -2;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        try {
            this.debugCodeCall("executeLargeUpdate");
            this.checkClosed();
            return this.executeUpdateInternal();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private long executeUpdateInternal() {
        this.closeOldResultSet();
        Session session = this.session;
        session.lock();
        try {
            try {
                this.setExecutingStatement(this.command);
                ResultWithGeneratedKeys result = this.command.executeUpdate(this.generatedKeysRequest);
                this.updateCount = result.getUpdateCount();
                ResultInterface gk = result.getGeneratedKeys();
                if (gk != null) {
                    int id = JdbcPreparedStatement.getNextId(4);
                    this.generatedKeys = new JdbcResultSet(this.conn, (JdbcStatement)this, this.command, gk, id, true, false, false);
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        finally {
            session.unlock();
        }
        return this.updateCount;
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            boolean returnsResultSet;
            int id = JdbcPreparedStatement.getNextId(4);
            this.debugCodeCall("execute");
            this.checkClosed();
            Session session = this.session;
            session.lock();
            try {
                this.closeOldResultSet();
                boolean lazy = false;
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        returnsResultSet = true;
                        boolean scrollable = this.resultSetType != 1003;
                        boolean updatable = this.resultSetConcurrency == 1008;
                        ResultInterface result = this.command.executeQuery(this.maxRows, scrollable);
                        lazy = result.isLazy();
                        this.resultSet = new JdbcResultSet(this.conn, this, this.command, result, id, scrollable, updatable, this.cachedColumnLabelMap);
                    } else {
                        returnsResultSet = false;
                        ResultWithGeneratedKeys result = this.command.executeUpdate(this.generatedKeysRequest);
                        this.updateCount = result.getUpdateCount();
                        ResultInterface gk = result.getGeneratedKeys();
                        if (gk != null) {
                            this.generatedKeys = new JdbcResultSet(this.conn, (JdbcStatement)this, this.command, gk, id, true, false, false);
                        }
                    }
                }
                finally {
                    if (!lazy) {
                        this.setExecutingStatement(null);
                    }
                }
            }
            finally {
                session.unlock();
            }
            return returnsResultSet;
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ArrayList<? extends ParameterInterface> parameters = this.command.getParameters();
            for (ParameterInterface parameterInterface : parameters) {
                parameterInterface.setValue(null, this.batchParameters == null);
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", sql);
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.debugCodeCall("addBatch", sql);
            throw DbException.get(90130);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + parameterIndex + ", " + sqlType + ")");
            }
            this.setParameter(parameterIndex, ValueNull.INSTANCE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setInt(" + parameterIndex + ", " + x + ")");
            }
            this.setParameter(parameterIndex, ValueInteger.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + parameterIndex + ", " + JdbcPreparedStatement.quote(x) + ")");
            }
            this.setParameter(parameterIndex, x == null ? ValueNull.INSTANCE : ValueVarchar.get(x, this.conn));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBigDecimal(" + parameterIndex + ", " + JdbcPreparedStatement.quoteBigDecimal(x) + ")");
            }
            this.setParameter(parameterIndex, x == null ? ValueNull.INSTANCE : ValueNumeric.getAnyScale(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + parameterIndex + ", " + JdbcPreparedStatement.quoteDate(x) + ")");
            }
            this.setParameter(parameterIndex, x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromDate(this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + parameterIndex + ", " + JdbcPreparedStatement.quoteTime(x) + ")");
            }
            this.setParameter(parameterIndex, x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTime(this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + parameterIndex + ", " + JdbcPreparedStatement.quoteTimestamp(x) + ")");
            }
            this.setParameter(parameterIndex, x == null ? ValueNull.INSTANCE : LegacyDateTimeUtils.fromTimestamp((CastDataProvider)this.conn, null, x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + parameterIndex + ", x)");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, ValueToObjectConverter.objectToValue(this.session, x, -1));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + parameterIndex + ", x, " + targetSqlType + ")");
            }
            this.setObjectWithType(parameterIndex, x, DataType.convertSQLTypeToValueType(targetSqlType));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + parameterIndex + ", x, " + targetSqlType + ", " + scale + ")");
            }
            this.setObjectWithType(parameterIndex, x, DataType.convertSQLTypeToValueType(targetSqlType));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + parameterIndex + ", x, " + DataType.sqlTypeToString(targetSqlType) + ")");
            }
            this.setObjectWithType(parameterIndex, x, DataType.convertSQLTypeToValueType(targetSqlType));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + parameterIndex + ", x, " + DataType.sqlTypeToString(targetSqlType) + ", " + scaleOrLength + ")");
            }
            this.setObjectWithType(parameterIndex, x, DataType.convertSQLTypeToValueType(targetSqlType));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void setObjectWithType(int parameterIndex, Object x, int type) {
        if (x == null) {
            this.setParameter(parameterIndex, ValueNull.INSTANCE);
        } else {
            Value v = ValueToObjectConverter.objectToValue(this.conn.getSession(), x, type);
            if (type != -1) {
                v = v.convertTo(type, (CastDataProvider)this.conn);
            }
            this.setParameter(parameterIndex, v);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBoolean(" + parameterIndex + ", " + x + ")");
            }
            this.setParameter(parameterIndex, ValueBoolean.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setByte(" + parameterIndex + ", " + x + ")");
            }
            this.setParameter(parameterIndex, ValueTinyint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setShort(" + parameterIndex + ", (short) " + x + ")");
            }
            this.setParameter(parameterIndex, ValueSmallint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setLong(" + parameterIndex + ", " + x + "L)");
            }
            this.setParameter(parameterIndex, ValueBigint.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setFloat(" + parameterIndex + ", " + x + "f)");
            }
            this.setParameter(parameterIndex, ValueReal.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDouble(" + parameterIndex + ", " + x + "d)");
            }
            this.setParameter(parameterIndex, ValueDouble.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + parameterIndex + ", " + JdbcPreparedStatement.quoteDate(x) + ", calendar)");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, LegacyDateTimeUtils.fromDate(this.conn, calendar != null ? calendar.getTimeZone() : null, x));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + parameterIndex + ", " + JdbcPreparedStatement.quoteTime(x) + ", calendar)");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, LegacyDateTimeUtils.fromTime(this.conn, calendar != null ? calendar.getTimeZone() : null, x));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + parameterIndex + ", " + JdbcPreparedStatement.quoteTimestamp(x) + ", calendar)");
            }
            if (x == null) {
                this.setParameter(parameterIndex, ValueNull.INSTANCE);
            } else {
                this.setParameter(parameterIndex, LegacyDateTimeUtils.fromTimestamp((CastDataProvider)this.conn, calendar != null ? calendar.getTimeZone() : null, x));
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + parameterIndex + ", " + sqlType + ", " + JdbcPreparedStatement.quote(typeName) + ")");
            }
            this.setNull(parameterIndex, sqlType);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + parameterIndex + ", x)");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createBlob(x.getBinaryStream(), -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + parameterIndex + ", x)");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + parameterIndex + ", x)");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + parameterIndex + ", x)");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x, -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setArray(" + parameterIndex + ", x)");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : ValueToObjectConverter.objectToValue(this.session, x.getArray(), 40);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + parameterIndex + ", " + JdbcPreparedStatement.quoteBytes(x) + ")");
            }
            this.setParameter(parameterIndex, x == null ? ValueNull.INSTANCE : ValueVarbinary.get(x));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + parameterIndex + ", x, " + length + "L)");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAsciiStream(" + parameterIndex + ", x, " + length + "L)");
            }
            this.checkClosed();
            Value v = this.conn.createClob(IOUtils.getAsciiReader(x), length);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setCharacterStream(parameterIndex, x, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setCharacterStream(" + parameterIndex + ", x, " + length + "L)");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultInterface result;
        block3: {
            try {
                this.debugCodeCall("getMetaData");
                this.checkClosed();
                result = this.command.getMetaData();
                if (result != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw this.logAndConvert(e);
            }
        }
        int id = JdbcPreparedStatement.getNextId(5);
        this.debugCodeAssign("ResultSetMetaData", 5, id, "getMetaData()");
        String catalog = this.conn.getCatalog();
        return new JdbcResultSetMetaData(null, this, result, catalog, this.session.getTrace(), id);
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
            this.batchParameters = null;
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeBatch");
            this.checkClosed();
            this.closeOldResultSet();
            if (this.batchParameters == null) {
                return new int[0];
            }
            BatchResult batchResult = this.executeBatchInternal();
            long[] longResult = batchResult.getUpdateCounts();
            int size = longResult.length;
            int[] intResult = new int[size];
            int i = 0;
            while (i < size) {
                long updateCount = longResult[i];
                intResult[i] = updateCount <= Integer.MAX_VALUE ? (int)updateCount : -2;
                ++i;
            }
            List<SQLException> exceptions = batchResult.getExceptions();
            if (!exceptions.isEmpty()) {
                throw new JdbcBatchUpdateException(this.createBatchException(exceptions), intResult);
            }
            return intResult;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeLargeBatch");
            this.checkClosed();
            this.closeOldResultSet();
            if (this.batchParameters == null) {
                return new long[0];
            }
            BatchResult batchResult = this.executeBatchInternal();
            long[] result = batchResult.getUpdateCounts();
            List<SQLException> exceptions = batchResult.getExceptions();
            if (!exceptions.isEmpty()) {
                throw new JdbcBatchUpdateException(this.createBatchException(exceptions), result);
            }
            return result;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private BatchResult executeBatchInternal() {
        Session session = this.session;
        session.lock();
        try {
            BatchResult batchResult;
            try {
                this.setExecutingStatement(this.command);
                BatchResult result = this.command.executeBatchUpdate(this.batchParameters, this.generatedKeysRequest);
                ResultInterface gk = result.getGeneratedKeys();
                if (gk != null) {
                    int id = JdbcPreparedStatement.getNextId(4);
                    this.generatedKeys = new JdbcResultSet(this.conn, (JdbcStatement)this, this.command, gk, id, true, false, false);
                }
                this.batchParameters = null;
                batchResult = result;
            }
            catch (Throwable throwable) {
                this.setExecutingStatement(null);
                throw throwable;
            }
            this.setExecutingStatement(null);
            return batchResult;
        }
        finally {
            session.unlock();
        }
    }

    private SQLException createBatchException(List<SQLException> exceptions) {
        SQLException exception;
        Iterator<SQLException> i = exceptions.iterator();
        SQLException last = exception = this.logAndConvert(i.next());
        while (i.hasNext()) {
            SQLException next = i.next();
            last.setNextException(next);
            last = next;
        }
        return exception;
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosed();
            ArrayList<? extends ParameterInterface> parameters = this.command.getParameters();
            int size = parameters.size();
            Value[] set = new Value[size];
            int i = 0;
            while (i < size) {
                Value value;
                ParameterInterface param = parameters.get(i);
                param.checkSet();
                set[i] = value = param.getParamValue();
                ++i;
            }
            if (this.batchParameters == null) {
                this.batchParameters = Utils.newSmallArrayList();
            }
            this.batchParameters.add(set);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int id = JdbcPreparedStatement.getNextId(11);
            this.debugCodeAssign("ParameterMetaData", 11, id, "getParameterMetaData()");
            this.checkClosed();
            return new JdbcParameterMetaData(this.session.getTrace(), this, this.command, id);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    private void setParameter(int parameterIndex, Value value) {
        this.checkClosed();
        ArrayList<? extends ParameterInterface> parameters = this.command.getParameters();
        if (--parameterIndex < 0 || parameterIndex >= parameters.size()) {
            throw DbException.getInvalidValueException("parameterIndex", parameterIndex + 1);
        }
        ParameterInterface param = parameters.get(parameterIndex);
        param.setValue(value, this.batchParameters == null);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(int parameterIndex, String x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNString(" + parameterIndex + ", " + JdbcPreparedStatement.quote(x) + ")");
            }
            this.setParameter(parameterIndex, x == null ? ValueNull.INSTANCE : ValueVarchar.get(x, this.conn));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNCharacterStream(" + parameterIndex + ", x, " + length + "L)");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.setNCharacterStream(parameterIndex, x, -1L);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + parameterIndex + ", x)");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + parameterIndex + ", x)");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + parameterIndex + ", x, " + length + "L)");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + parameterIndex + ", x, " + length + "L)");
            }
            this.checkClosed();
            Value v = this.conn.createBlob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + parameterIndex + ", x, " + length + "L)");
            }
            this.checkClosed();
            Value v = this.conn.createClob(x, length);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setSQLXML(" + parameterIndex + ", x)");
            }
            this.checkClosed();
            Value v = x == null ? ValueNull.INSTANCE : this.conn.createClob(x.getCharacterStream(), -1L);
            this.setParameter(parameterIndex, v);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String toString() {
        return this.getTraceObjectName() + ": " + String.valueOf(this.command);
    }
}

