/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import org.h2.jdbc.JdbcException;
import org.h2.message.DbException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JdbcSQLTransientException
extends SQLTransientException
implements JdbcException {
    private static final long serialVersionUID = 1L;
    private final String originalMessage;
    private final String stackTrace;
    private String message;
    private String sql;

    public JdbcSQLTransientException(String message, String sql, String state, int errorCode, Throwable cause, String stackTrace) {
        super(message, state, errorCode);
        this.originalMessage = message;
        this.stackTrace = stackTrace;
        this.setSQL(sql);
        this.initCause(cause);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getOriginalMessage() {
        return this.originalMessage;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        DbException.printNextExceptions((SQLException)this, s);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        DbException.printNextExceptions((SQLException)this, s);
    }

    @Override
    public String getSQL() {
        return this.sql;
    }

    @Override
    public void setSQL(String sql) {
        this.sql = sql;
        this.message = DbException.buildMessageForException(this);
    }

    @Override
    public String toString() {
        if (this.stackTrace == null) {
            return super.toString();
        }
        return this.stackTrace;
    }
}

