/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc.meta;

import java.util.ArrayList;
import org.h2.engine.SessionRemote;
import org.h2.jdbc.meta.DatabaseMeta;
import org.h2.mode.DefaultNullOrdering;
import org.h2.result.ResultInterface;
import org.h2.value.Transfer;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DatabaseMetaRemote
extends DatabaseMeta {
    static final int DEFAULT_NULL_ORDERING = 0;
    static final int GET_DATABASE_PRODUCT_VERSION = 1;
    static final int GET_SQL_KEYWORDS = 2;
    static final int GET_NUMERIC_FUNCTIONS = 3;
    static final int GET_STRING_FUNCTIONS = 4;
    static final int GET_SYSTEM_FUNCTIONS = 5;
    static final int GET_TIME_DATE_FUNCTIONS = 6;
    static final int GET_SEARCH_STRING_ESCAPE = 7;
    static final int GET_PROCEDURES_3 = 8;
    static final int GET_PROCEDURE_COLUMNS_4 = 9;
    static final int GET_TABLES_4 = 10;
    static final int GET_SCHEMAS = 11;
    static final int GET_CATALOGS = 12;
    static final int GET_TABLE_TYPES = 13;
    static final int GET_COLUMNS_4 = 14;
    static final int GET_COLUMN_PRIVILEGES_4 = 15;
    static final int GET_TABLE_PRIVILEGES_3 = 16;
    static final int GET_BEST_ROW_IDENTIFIER_5 = 17;
    static final int GET_VERSION_COLUMNS_3 = 18;
    static final int GET_PRIMARY_KEYS_3 = 19;
    static final int GET_IMPORTED_KEYS_3 = 20;
    static final int GET_EXPORTED_KEYS_3 = 21;
    static final int GET_CROSS_REFERENCE_6 = 22;
    static final int GET_TYPE_INFO = 23;
    static final int GET_INDEX_INFO_5 = 24;
    static final int GET_UDTS_4 = 25;
    static final int GET_SUPER_TYPES_3 = 26;
    static final int GET_SUPER_TABLES_3 = 27;
    static final int GET_ATTRIBUTES_4 = 28;
    static final int GET_DATABASE_MAJOR_VERSION = 29;
    static final int GET_DATABASE_MINOR_VERSION = 30;
    static final int GET_SCHEMAS_2 = 31;
    static final int GET_FUNCTIONS_3 = 32;
    static final int GET_FUNCTION_COLUMNS_4 = 33;
    static final int GET_PSEUDO_COLUMNS_4 = 34;
    private final SessionRemote session;
    private final ArrayList<Transfer> transferList;

    public DatabaseMetaRemote(SessionRemote session, ArrayList<Transfer> transferList) {
        this.session = session;
        this.transferList = transferList;
    }

    @Override
    public DefaultNullOrdering defaultNullOrdering() {
        ResultInterface result = this.executeQuery(0, new Value[0]);
        result.next();
        return DefaultNullOrdering.valueOf(result.currentRow()[0].getInt());
    }

    @Override
    public String getDatabaseProductVersion() {
        ResultInterface result = this.executeQuery(1, new Value[0]);
        result.next();
        return result.currentRow()[0].getString();
    }

    @Override
    public String getSQLKeywords() {
        ResultInterface result = this.executeQuery(2, new Value[0]);
        result.next();
        return result.currentRow()[0].getString();
    }

    @Override
    public String getNumericFunctions() {
        ResultInterface result = this.executeQuery(3, new Value[0]);
        result.next();
        return result.currentRow()[0].getString();
    }

    @Override
    public String getStringFunctions() {
        ResultInterface result = this.executeQuery(4, new Value[0]);
        result.next();
        return result.currentRow()[0].getString();
    }

    @Override
    public String getSystemFunctions() {
        ResultInterface result = this.executeQuery(5, new Value[0]);
        result.next();
        return result.currentRow()[0].getString();
    }

    @Override
    public String getTimeDateFunctions() {
        ResultInterface result = this.executeQuery(6, new Value[0]);
        result.next();
        return result.currentRow()[0].getString();
    }

    @Override
    public String getSearchStringEscape() {
        ResultInterface result = this.executeQuery(7, new Value[0]);
        result.next();
        return result.currentRow()[0].getString();
    }

    @Override
    public ResultInterface getProcedures(String catalog, String schemaPattern, String procedureNamePattern) {
        return this.executeQuery(8, this.getString(catalog), this.getString(schemaPattern), this.getString(procedureNamePattern));
    }

    @Override
    public ResultInterface getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) {
        return this.executeQuery(9, this.getString(catalog), this.getString(schemaPattern), this.getString(procedureNamePattern), this.getString(columnNamePattern));
    }

    @Override
    public ResultInterface getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        return this.executeQuery(10, this.getString(catalog), this.getString(schemaPattern), this.getString(tableNamePattern), this.getStringArray(types));
    }

    @Override
    public ResultInterface getSchemas() {
        return this.executeQuery(11, new Value[0]);
    }

    @Override
    public ResultInterface getCatalogs() {
        return this.executeQuery(12, new Value[0]);
    }

    @Override
    public ResultInterface getTableTypes() {
        return this.executeQuery(13, new Value[0]);
    }

    @Override
    public ResultInterface getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        return this.executeQuery(14, this.getString(catalog), this.getString(schemaPattern), this.getString(tableNamePattern), this.getString(columnNamePattern));
    }

    @Override
    public ResultInterface getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) {
        return this.executeQuery(15, this.getString(catalog), this.getString(schema), this.getString(table), this.getString(columnNamePattern));
    }

    @Override
    public ResultInterface getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) {
        return this.executeQuery(16, this.getString(catalog), this.getString(schemaPattern), this.getString(tableNamePattern));
    }

    @Override
    public ResultInterface getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return this.executeQuery(17, this.getString(catalog), this.getString(schema), this.getString(table), ValueInteger.get(scope), ValueBoolean.get(nullable));
    }

    @Override
    public ResultInterface getVersionColumns(String catalog, String schema, String table) {
        return this.executeQuery(18, this.getString(catalog), this.getString(schema), this.getString(table));
    }

    @Override
    public ResultInterface getPrimaryKeys(String catalog, String schema, String table) {
        return this.executeQuery(19, this.getString(catalog), this.getString(schema), this.getString(table));
    }

    @Override
    public ResultInterface getImportedKeys(String catalog, String schema, String table) {
        return this.executeQuery(20, this.getString(catalog), this.getString(schema), this.getString(table));
    }

    @Override
    public ResultInterface getExportedKeys(String catalog, String schema, String table) {
        return this.executeQuery(21, this.getString(catalog), this.getString(schema), this.getString(table));
    }

    @Override
    public ResultInterface getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return this.executeQuery(22, this.getString(primaryCatalog), this.getString(primarySchema), this.getString(primaryTable), this.getString(foreignCatalog), this.getString(foreignSchema), this.getString(foreignTable));
    }

    @Override
    public ResultInterface getTypeInfo() {
        return this.executeQuery(23, new Value[0]);
    }

    @Override
    public ResultInterface getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        return this.executeQuery(24, this.getString(catalog), this.getString(schema), this.getString(table), ValueBoolean.get(unique), ValueBoolean.get(approximate));
    }

    @Override
    public ResultInterface getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) {
        return this.executeQuery(25, this.getString(catalog), this.getString(schemaPattern), this.getString(typeNamePattern), this.getIntArray(types));
    }

    @Override
    public ResultInterface getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) {
        return this.executeQuery(26, this.getString(catalog), this.getString(schemaPattern), this.getString(typeNamePattern));
    }

    @Override
    public ResultInterface getSuperTables(String catalog, String schemaPattern, String tableNamePattern) {
        return this.executeQuery(27, this.getString(catalog), this.getString(schemaPattern), this.getString(tableNamePattern));
    }

    @Override
    public ResultInterface getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) {
        return this.executeQuery(28, this.getString(catalog), this.getString(schemaPattern), this.getString(typeNamePattern), this.getString(attributeNamePattern));
    }

    @Override
    public int getDatabaseMajorVersion() {
        ResultInterface result = this.executeQuery(29, new Value[0]);
        result.next();
        return result.currentRow()[0].getInt();
    }

    @Override
    public int getDatabaseMinorVersion() {
        ResultInterface result = this.executeQuery(30, new Value[0]);
        result.next();
        return result.currentRow()[0].getInt();
    }

    @Override
    public ResultInterface getSchemas(String catalog, String schemaPattern) {
        return this.executeQuery(31, this.getString(catalog), this.getString(schemaPattern));
    }

    @Override
    public ResultInterface getFunctions(String catalog, String schemaPattern, String functionNamePattern) {
        return this.executeQuery(32, this.getString(catalog), this.getString(schemaPattern), this.getString(functionNamePattern));
    }

    @Override
    public ResultInterface getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) {
        return this.executeQuery(33, this.getString(catalog), this.getString(schemaPattern), this.getString(functionNamePattern), this.getString(columnNamePattern));
    }

    @Override
    public ResultInterface getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        return this.executeQuery(34, this.getString(catalog), this.getString(schemaPattern), this.getString(tableNamePattern), this.getString(columnNamePattern));
    }

    /*
     * Exception decompiling
     */
    private ResultInterface executeQuery(int code, Value ... args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP], 3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Value getIntArray(int[] array) {
        if (array == null) {
            return ValueNull.INSTANCE;
        }
        int cardinality = array.length;
        Value[] values = new Value[cardinality];
        int i = 0;
        while (i < cardinality) {
            values[i] = ValueInteger.get(array[i]);
            ++i;
        }
        return ValueArray.get(TypeInfo.TYPE_INTEGER, values, this.session);
    }

    private Value getStringArray(String[] array) {
        if (array == null) {
            return ValueNull.INSTANCE;
        }
        int cardinality = array.length;
        Value[] values = new Value[cardinality];
        int i = 0;
        while (i < cardinality) {
            values[i] = this.getString(array[i]);
            ++i;
        }
        return ValueArray.get(TypeInfo.TYPE_VARCHAR, values, this.session);
    }

    private Value getString(String string) {
        return string != null ? ValueVarchar.get(string, this.session) : ValueNull.INSTANCE;
    }
}

