/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc.meta;

import org.h2.engine.SessionLocal;
import org.h2.jdbc.meta.DatabaseMeta;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.SimpleResult;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DatabaseMetaServer {
    public static ResultInterface process(SessionLocal session, int code, Value[] args) {
        DatabaseMeta meta = session.getDatabaseMeta();
        switch (code) {
            case 0: {
                return DatabaseMetaServer.result(meta.defaultNullOrdering().ordinal());
            }
            case 1: {
                return DatabaseMetaServer.result(session, meta.getDatabaseProductVersion());
            }
            case 2: {
                return DatabaseMetaServer.result(session, meta.getSQLKeywords());
            }
            case 3: {
                return DatabaseMetaServer.result(session, meta.getNumericFunctions());
            }
            case 4: {
                return DatabaseMetaServer.result(session, meta.getStringFunctions());
            }
            case 5: {
                return DatabaseMetaServer.result(session, meta.getSystemFunctions());
            }
            case 6: {
                return DatabaseMetaServer.result(session, meta.getTimeDateFunctions());
            }
            case 7: {
                return DatabaseMetaServer.result(session, meta.getSearchStringEscape());
            }
            case 8: {
                return meta.getProcedures(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 9: {
                return meta.getProcedureColumns(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getString());
            }
            case 10: {
                return meta.getTables(args[0].getString(), args[1].getString(), args[2].getString(), DatabaseMetaServer.toStringArray(args[3]));
            }
            case 11: {
                return meta.getSchemas();
            }
            case 12: {
                return meta.getCatalogs();
            }
            case 13: {
                return meta.getTableTypes();
            }
            case 14: {
                return meta.getColumns(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getString());
            }
            case 15: {
                return meta.getColumnPrivileges(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getString());
            }
            case 16: {
                return meta.getTablePrivileges(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 17: {
                return meta.getBestRowIdentifier(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getInt(), args[4].getBoolean());
            }
            case 18: {
                return meta.getVersionColumns(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 19: {
                return meta.getPrimaryKeys(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 20: {
                return meta.getImportedKeys(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 21: {
                return meta.getExportedKeys(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 22: {
                return meta.getCrossReference(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getString(), args[4].getString(), args[5].getString());
            }
            case 23: {
                return meta.getTypeInfo();
            }
            case 24: {
                return meta.getIndexInfo(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getBoolean(), args[4].getBoolean());
            }
            case 25: {
                return meta.getUDTs(args[0].getString(), args[1].getString(), args[2].getString(), DatabaseMetaServer.toIntArray(args[3]));
            }
            case 26: {
                return meta.getSuperTypes(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 27: {
                return meta.getSuperTables(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 28: {
                return meta.getAttributes(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getString());
            }
            case 29: {
                return DatabaseMetaServer.result(meta.getDatabaseMajorVersion());
            }
            case 30: {
                return DatabaseMetaServer.result(meta.getDatabaseMinorVersion());
            }
            case 31: {
                return meta.getSchemas(args[0].getString(), args[1].getString());
            }
            case 32: {
                return meta.getFunctions(args[0].getString(), args[1].getString(), args[2].getString());
            }
            case 33: {
                return meta.getFunctionColumns(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getString());
            }
            case 34: {
                return meta.getPseudoColumns(args[0].getString(), args[1].getString(), args[2].getString(), args[3].getString());
            }
        }
        throw DbException.getUnsupportedException("META " + code);
    }

    private static String[] toStringArray(Value value) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        Value[] list = ((ValueArray)value).getList();
        int l = list.length;
        String[] result = new String[l];
        int i = 0;
        while (i < l) {
            result[i] = list[i].getString();
            ++i;
        }
        return result;
    }

    private static int[] toIntArray(Value value) {
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        Value[] list = ((ValueArray)value).getList();
        int l = list.length;
        int[] result = new int[l];
        int i = 0;
        while (i < l) {
            result[i] = list[i].getInt();
            ++i;
        }
        return result;
    }

    private static ResultInterface result(int value) {
        return DatabaseMetaServer.result(ValueInteger.get(value));
    }

    private static ResultInterface result(SessionLocal session, String value) {
        return DatabaseMetaServer.result(ValueVarchar.get(value, session));
    }

    private static ResultInterface result(Value v) {
        SimpleResult result = new SimpleResult();
        result.addColumn("RESULT", v.getType());
        result.addRow(v);
        return result;
    }

    private DatabaseMetaServer() {
    }
}

