/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbcx.JdbcDataSourceFactory;
import org.h2.jdbcx.JdbcXid;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JdbcXAConnection
extends TraceObject
implements XAConnection,
XAResource {
    private final JdbcDataSourceFactory factory;
    private JdbcConnection physicalConn;
    private volatile Connection handleConn;
    private final ArrayList<ConnectionEventListener> listeners = Utils.newSmallArrayList();
    private Xid currentTransaction;
    private boolean prepared;

    JdbcXAConnection(JdbcDataSourceFactory factory, int id, JdbcConnection physicalConn) {
        this.factory = factory;
        this.setTrace(factory.getTrace(), 13, id);
        this.physicalConn = physicalConn;
    }

    @Override
    public XAResource getXAResource() {
        this.debugCodeCall("getXAResource");
        return this;
    }

    @Override
    public void close() throws SQLException {
        this.debugCodeCall("close");
        Connection lastHandle = this.handleConn;
        if (lastHandle != null) {
            this.listeners.clear();
            lastHandle.close();
        }
        if (this.physicalConn != null) {
            try {
                this.physicalConn.close();
            }
            finally {
                this.physicalConn = null;
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.debugCodeCall("getConnection");
        Connection lastHandle = this.handleConn;
        if (lastHandle != null) {
            lastHandle.close();
        }
        this.physicalConn.rollback();
        this.handleConn = new PooledJdbcConnection(this.physicalConn);
        return this.handleConn;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.debugCode("addConnectionEventListener(listener)");
        this.listeners.add(listener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.debugCode("removeConnectionEventListener(listener)");
        this.listeners.remove(listener);
    }

    void closedHandle() {
        this.debugCodeCall("closedHandle");
        ConnectionEvent event = new ConnectionEvent(this);
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            ConnectionEventListener listener = this.listeners.get(i);
            listener.connectionClosed(event);
            --i;
        }
        this.handleConn = null;
    }

    @Override
    public int getTransactionTimeout() {
        this.debugCodeCall("getTransactionTimeout");
        return 0;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) {
        this.debugCodeCall("setTransactionTimeout", seconds);
        return false;
    }

    @Override
    public boolean isSameRM(XAResource xares) {
        this.debugCode("isSameRM(xares)");
        return xares == this;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        this.debugCodeCall("recover", JdbcXAConnection.quoteFlags(flag));
        this.checkOpen();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement stat = this.physicalConn.createStatement();){
                ResultSet rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.IN_DOUBT ORDER BY TRANSACTION_NAME");
                ArrayList<Xid> list = Utils.newSmallArrayList();
                while (rs.next()) {
                    String tid = rs.getString("TRANSACTION_NAME");
                    int id = JdbcXAConnection.getNextId(15);
                    JdbcXid xid = new JdbcXid(this.factory, id, tid);
                    list.add(xid);
                }
                rs.close();
                Xid[] result = list.toArray(new Xid[0]);
                if (!list.isEmpty()) {
                    this.prepared = true;
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            XAException xa = new XAException(-3);
            xa.initCause(e);
            throw xa;
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("prepare(" + JdbcXAConnection.quoteXid(xid) + ")");
        }
        this.checkOpen();
        if (!this.currentTransaction.equals(xid)) {
            throw new XAException(-5);
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Statement stat = this.physicalConn.createStatement();){
                stat.execute(JdbcXid.toString(new StringBuilder("PREPARE COMMIT \""), xid).append('\"').toString());
                this.prepared = true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw JdbcXAConnection.convertException(e);
        }
        return 0;
    }

    @Override
    public void forget(Xid xid) {
        if (this.isDebugEnabled()) {
            this.debugCode("forget(" + JdbcXAConnection.quoteXid(xid) + ")");
        }
        this.prepared = false;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("rollback(" + JdbcXAConnection.quoteXid(xid) + ")");
        }
        try {
            if (this.prepared) {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Statement stat = this.physicalConn.createStatement();){
                    stat.execute(JdbcXid.toString(new StringBuilder("ROLLBACK TRANSACTION \""), xid).append('\"').toString());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                this.prepared = false;
            } else {
                this.physicalConn.rollback();
            }
            this.physicalConn.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw JdbcXAConnection.convertException(e);
        }
        this.currentTransaction = null;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("end(" + JdbcXAConnection.quoteXid(xid) + ", " + JdbcXAConnection.quoteFlags(flags) + ")");
        }
        if (flags == 0x2000000) {
            return;
        }
        if (!this.currentTransaction.equals(xid)) {
            throw new XAException(-9);
        }
        this.prepared = false;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("start(" + JdbcXAConnection.quoteXid(xid) + ", " + JdbcXAConnection.quoteFlags(flags) + ")");
        }
        if (flags == 0x8000000) {
            return;
        }
        if (flags == 0x200000) {
            if (this.currentTransaction != null && !this.currentTransaction.equals(xid)) {
                throw new XAException(-3);
            }
        } else if (this.currentTransaction != null) {
            throw new XAException(-4);
        }
        try {
            this.physicalConn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw JdbcXAConnection.convertException(e);
        }
        this.currentTransaction = xid;
        this.prepared = false;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.isDebugEnabled()) {
            this.debugCode("commit(" + JdbcXAConnection.quoteXid(xid) + ", " + onePhase + ")");
        }
        try {
            if (onePhase) {
                this.physicalConn.commit();
            } else {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Statement stat = this.physicalConn.createStatement();){
                    stat.execute(JdbcXid.toString(new StringBuilder("COMMIT TRANSACTION \""), xid).append('\"').toString());
                    this.prepared = false;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.physicalConn.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw JdbcXAConnection.convertException(e);
        }
        this.currentTransaction = null;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getTraceObjectName() + ": " + String.valueOf(this.physicalConn);
    }

    private static XAException convertException(SQLException e) {
        XAException xa = new XAException(e.getMessage());
        xa.initCause(e);
        return xa;
    }

    private static String quoteXid(Xid xid) {
        return JdbcXid.toString(new StringBuilder(), xid).toString().replace('-', '$');
    }

    private static String quoteFlags(int flags) {
        StringBuilder buff = new StringBuilder();
        if ((flags & 0x800000) != 0) {
            buff.append("|XAResource.TMENDRSCAN");
        }
        if ((flags & 0x20000000) != 0) {
            buff.append("|XAResource.TMFAIL");
        }
        if ((flags & 0x200000) != 0) {
            buff.append("|XAResource.TMJOIN");
        }
        if ((flags & 0x40000000) != 0) {
            buff.append("|XAResource.TMONEPHASE");
        }
        if ((flags & 0x8000000) != 0) {
            buff.append("|XAResource.TMRESUME");
        }
        if ((flags & 0x1000000) != 0) {
            buff.append("|XAResource.TMSTARTRSCAN");
        }
        if ((flags & 0x4000000) != 0) {
            buff.append("|XAResource.TMSUCCESS");
        }
        if ((flags & 0x2000000) != 0) {
            buff.append("|XAResource.TMSUSPEND");
        }
        if ((flags & 3) != 0) {
            buff.append("|XAResource.XA_RDONLY");
        }
        if (buff.length() == 0) {
            buff.append("|XAResource.TMNOFLAGS");
        }
        return buff.substring(1);
    }

    private void checkOpen() throws XAException {
        if (this.physicalConn == null) {
            throw new XAException(-3);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    final class PooledJdbcConnection
    extends JdbcConnection {
        private boolean isClosed;

        public PooledJdbcConnection(JdbcConnection conn) {
            super(conn);
        }

        @Override
        public void close() throws SQLException {
            block5: {
                this.lock();
                try {
                    if (this.isClosed) break block5;
                    try {
                        this.rollback();
                        this.setAutoCommit(true);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    JdbcXAConnection.this.closedHandle();
                    this.isClosed = true;
                }
                finally {
                    this.unlock();
                }
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            this.lock();
            try {
                boolean bl = this.isClosed || super.isClosed();
                return bl;
            }
            finally {
                this.unlock();
            }
        }

        @Override
        protected void checkClosed() {
            this.lock();
            try {
                if (this.isClosed) {
                    throw DbException.get(90007);
                }
                super.checkClosed();
            }
            finally {
                this.unlock();
            }
        }
    }
}

