/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jmx;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.h2.command.Command0;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.jmx.DatabaseInfoMBean;
import org.h2.jmx.DocumentedMBean;
import org.h2.table.Table;
import org.h2.util.NetworkConnectionInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DatabaseInfo
implements DatabaseInfoMBean {
    private static final Map<String, ObjectName> MBEANS = new HashMap<String, ObjectName>();
    private final Database database;

    private DatabaseInfo(Database database) {
        if (database == null) {
            throw new IllegalArgumentException("Argument 'database' must not be null");
        }
        this.database = database;
    }

    private static ObjectName getObjectName(String name, String path) throws JMException {
        name = name.replace(':', '_');
        path = path.replace(':', '_');
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("name", name);
        map.put("path", path);
        return new ObjectName("org.h2", map);
    }

    public static void registerMBean(ConnectionInfo connectionInfo, Database database) throws JMException {
        String path = connectionInfo.getName();
        if (!MBEANS.containsKey(path)) {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            String name = database.getShortName();
            ObjectName mbeanObjectName = DatabaseInfo.getObjectName(name, path);
            MBEANS.put(path, mbeanObjectName);
            DatabaseInfo info = new DatabaseInfo(database);
            DocumentedMBean mbean = new DocumentedMBean(info, DatabaseInfoMBean.class);
            mbeanServer.registerMBean(mbean, mbeanObjectName);
        }
    }

    public static void unregisterMBean(String name) throws Exception {
        ObjectName mbeanObjectName = MBEANS.remove(name);
        if (mbeanObjectName != null) {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            mbeanServer.unregisterMBean(mbeanObjectName);
        }
    }

    @Override
    public boolean isExclusive() {
        return this.database.getExclusiveSession() != null;
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public String getMode() {
        return this.database.getMode().getName();
    }

    @Override
    public int getTraceLevel() {
        return this.database.getTraceSystem().getLevelFile();
    }

    @Override
    public void setTraceLevel(int level) {
        this.database.getTraceSystem().setLevelFile(level);
    }

    @Override
    public long getFileWriteCount() {
        if (this.database.isPersistent()) {
            return this.database.getStore().getMvStore().getFileStore().getWriteCount();
        }
        return 0L;
    }

    @Override
    public long getFileReadCount() {
        if (this.database.isPersistent()) {
            return this.database.getStore().getMvStore().getFileStore().getReadCount();
        }
        return 0L;
    }

    @Override
    public long getFileSize() {
        long size = 0L;
        if (this.database.isPersistent()) {
            size = this.database.getStore().getMvStore().getFileStore().size();
        }
        return size / 1024L;
    }

    @Override
    public int getCacheSizeMax() {
        if (this.database.isPersistent()) {
            return this.database.getStore().getMvStore().getCacheSize() * 1024;
        }
        return 0;
    }

    @Override
    public void setCacheSizeMax(int kb) {
        if (this.database.isPersistent()) {
            this.database.setCacheSize(kb);
        }
    }

    @Override
    public int getCacheSize() {
        if (this.database.isPersistent()) {
            return this.database.getStore().getMvStore().getCacheSizeUsed() * 1024;
        }
        return 0;
    }

    @Override
    public String getVersion() {
        return Constants.FULL_VERSION;
    }

    @Override
    public String listSettings() {
        StringBuilder builder = new StringBuilder();
        Map.Entry<String, String>[] entryArray = this.database.getSettings().getSortedSettings();
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<String, String> e = entryArray[n2];
            builder.append(e.getKey()).append(" = ").append(e.getValue()).append('\n');
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public String listSessions() {
        StringBuilder buff = new StringBuilder();
        SessionLocal[] sessionLocalArray = this.database.getSessions(false);
        int n = sessionLocalArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionLocal session = sessionLocalArray[n2];
            buff.append("session id: ").append(session.getId());
            buff.append(" user: ").append(session.getUser().getName()).append('\n');
            NetworkConnectionInfo networkConnectionInfo = session.getNetworkConnectionInfo();
            if (networkConnectionInfo != null) {
                buff.append("server: ").append(networkConnectionInfo.getServer()).append('\n').append("clientAddr: ").append(networkConnectionInfo.getClient()).append('\n');
                String clientInfo = networkConnectionInfo.getClientInfo();
                if (clientInfo != null) {
                    buff.append("clientInfo: ").append(clientInfo).append('\n');
                }
            }
            buff.append("connected: ").append(session.getSessionStart().getString()).append('\n');
            Command0 command = session.getCurrentCommand();
            if (command != null) {
                buff.append("statement: ").append(command).append('\n').append("started: ").append(session.getCommandStartOrEnd().getString()).append('\n');
            }
            for (Table table : session.getLocks()) {
                if (table.isLockedExclusivelyBy(session)) {
                    buff.append("write lock on ");
                } else {
                    buff.append("read lock on ");
                }
                buff.append(table.getSchema().getName()).append('.').append(table.getName()).append('\n');
            }
            buff.append('\n');
            ++n2;
        }
        return buff.toString();
    }
}

