/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jmx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DocumentedMBean
extends StandardMBean {
    private final String interfaceName;
    private Properties resources;

    public <T> DocumentedMBean(T impl, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(impl, mbeanInterface);
        this.interfaceName = impl.getClass().getName() + "MBean";
    }

    private Properties getResources() {
        if (this.resources == null) {
            this.resources = new Properties();
            String resourceName = "/org/h2/res/javadoc.properties";
            try {
                byte[] buff = Utils.getResource(resourceName);
                if (buff != null) {
                    this.resources.load(new ByteArrayInputStream(buff));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.resources;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        String s = this.getResources().getProperty(this.interfaceName);
        return s == null ? super.getDescription(info) : s;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op) {
        String s = this.getResources().getProperty(this.interfaceName + "." + op.getName());
        return s == null ? super.getDescription(op) : s;
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String prefix = info.isIs() ? "is" : "get";
        String s = this.getResources().getProperty(this.interfaceName + "." + prefix + info.getName());
        return s == null ? super.getDescription(info) : s;
    }

    @Override
    protected int getImpact(MBeanOperationInfo info) {
        if (info.getName().startsWith("list")) {
            return 0;
        }
        return 1;
    }
}

