/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import org.h2.engine.SessionLocal;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Operation0;
import org.h2.expression.function.NamedExpression;
import org.h2.util.DateTimeUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class CompatibilityDateTimeValueFunction
extends Operation0
implements NamedExpression {
    static final int SYSDATE = 0;
    static final int SYSTIMESTAMP = 1;
    private static final String[] NAMES = new String[]{"SYSDATE", "SYSTIMESTAMP"};
    private final int function;
    private final int scale;
    private final TypeInfo type;

    CompatibilityDateTimeValueFunction(int function, int scale) {
        this.function = function;
        this.scale = scale;
        this.type = function == 0 ? TypeInfo.getTypeInfo(20, 0L, 0, null) : TypeInfo.getTypeInfo(21, 0L, scale, null);
    }

    @Override
    public Value getValue(SessionLocal session) {
        int newOffset;
        ValueTimestampTimeZone v = session.currentTimestamp();
        long dateValue = v.getDateValue();
        long timeNanos = v.getTimeNanos();
        int offsetSeconds = v.getTimeZoneOffsetSeconds();
        if (offsetSeconds != (newOffset = TimeZoneProvider.getDefault().getTimeZoneOffsetUTC(DateTimeUtils.getEpochSeconds(dateValue, timeNanos, offsetSeconds)))) {
            v = DateTimeUtils.timestampTimeZoneAtOffset(dateValue, timeNanos, offsetSeconds, newOffset);
        }
        if (this.function == 0) {
            return ValueTimestamp.fromDateValueAndNanos(v.getDateValue(), v.getTimeNanos() / 1000000000L * 1000000000L);
        }
        return v.castTo(this.type, session);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        builder.append(this.getName());
        if (this.scale >= 0) {
            builder.append('(').append(this.scale).append(')');
        }
        return builder;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                return false;
            }
        }
        return true;
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public int getCost() {
        return 1;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }
}

