/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.mode.FunctionInfo;
import org.h2.mode.ModeFunction;
import org.h2.util.DateTimeUtils;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FunctionsMySQL
extends ModeFunction {
    private static final int UNIX_TIMESTAMP = 1001;
    private static final int FROM_UNIXTIME = 1002;
    private static final int DATE = 1003;
    private static final int LAST_INSERT_ID = 1004;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap();
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] FORMAT_REPLACE;

    static {
        FUNCTIONS.put("UNIX_TIMESTAMP", new FunctionInfo("UNIX_TIMESTAMP", 1001, -1, 11, true, false));
        FUNCTIONS.put("FROM_UNIXTIME", new FunctionInfo("FROM_UNIXTIME", 1002, -1, 2, true, true));
        FUNCTIONS.put("DATE", new FunctionInfo("DATE", 1003, 1, 17, true, true));
        FUNCTIONS.put("LAST_INSERT_ID", new FunctionInfo("LAST_INSERT_ID", 1004, -1, 12, false, false));
        FORMAT_REPLACE = new String[]{"%a", "EEE", "%b", "MMM", "%c", "MM", "%d", "dd", "%e", "d", "%H", "HH", "%h", "hh", "%I", "hh", "%i", "mm", "%j", "DDD", "%k", "H", "%l", "h", "%M", "MMMM", "%m", "MM", "%p", "a", "%r", "hh:mm:ss a", "%S", "ss", "%s", "ss", "%T", "HH:mm:ss", "%W", "EEEE", "%w", "F", "%Y", "yyyy", "%y", "yy", "%%", "%"};
    }

    public static int unixTimestamp(SessionLocal session, Value value) {
        long seconds;
        if (value instanceof ValueTimestampTimeZone) {
            ValueTimestampTimeZone t = (ValueTimestampTimeZone)value;
            long timeNanos = t.getTimeNanos();
            seconds = DateTimeUtils.absoluteDayFromDateValue(t.getDateValue()) * 86400L + timeNanos / 1000000000L - (long)t.getTimeZoneOffsetSeconds();
        } else {
            ValueTimestamp t = (ValueTimestamp)value.convertTo(TypeInfo.TYPE_TIMESTAMP, (CastDataProvider)session);
            long timeNanos = t.getTimeNanos();
            seconds = session.currentTimeZone().getEpochSecondsFromLocal(t.getDateValue(), timeNanos);
        }
        return (int)seconds;
    }

    public static String fromUnixTime(int seconds) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.ENGLISH);
        return formatter.format(new Date((long)seconds * 1000L));
    }

    public static String fromUnixTime(int seconds, String format) {
        format = FunctionsMySQL.convertToSimpleDateFormat(format);
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ENGLISH);
        return formatter.format(new Date((long)seconds * 1000L));
    }

    private static String convertToSimpleDateFormat(String format) {
        String[] replace = FORMAT_REPLACE;
        int i = 0;
        while (i < replace.length) {
            format = StringUtils.replaceAll(format, replace[i], replace[i + 1]);
            i += 2;
        }
        return format;
    }

    public static FunctionsMySQL getFunction(String upperName) {
        FunctionInfo info = FUNCTIONS.get(upperName);
        return info != null ? new FunctionsMySQL(info) : null;
    }

    FunctionsMySQL(FunctionInfo info) {
        super(info);
    }

    @Override
    protected void checkParameterCount(int len) {
        int max;
        int min;
        switch (this.info.type) {
            case 1001: {
                min = 0;
                max = 1;
                break;
            }
            case 1002: {
                min = 1;
                max = 2;
                break;
            }
            case 1003: {
                min = 1;
                max = 1;
                break;
            }
            case 1004: {
                min = 0;
                max = 1;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.info.type);
            }
        }
        if (len < min || len > max) {
            throw DbException.get(7001, this.info.name, min + ".." + max);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = this.optimizeArguments(session);
        this.type = TypeInfo.getTypeInfo(this.info.returnDataType);
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value result;
        Value[] values = this.getArgumentsValues(session, this.args);
        if (values == null) {
            return ValueNull.INSTANCE;
        }
        Value v0 = FunctionsMySQL.getNullOrValue(session, this.args, values, 0);
        Value v1 = FunctionsMySQL.getNullOrValue(session, this.args, values, 1);
        block1 : switch (this.info.type) {
            case 1001: {
                result = ValueInteger.get(FunctionsMySQL.unixTimestamp(session, v0 == null ? session.currentTimestamp() : v0));
                break;
            }
            case 1002: {
                result = ValueVarchar.get(v1 == null ? FunctionsMySQL.fromUnixTime(v0.getInt()) : FunctionsMySQL.fromUnixTime(v0.getInt(), v1.getString()));
                break;
            }
            case 1003: {
                switch (v0.getValueType()) {
                    case 17: {
                        result = v0;
                        break block1;
                    }
                    default: {
                        try {
                            v0 = v0.convertTo(TypeInfo.TYPE_TIMESTAMP, (CastDataProvider)session);
                            break;
                        }
                        catch (DbException ex) {
                            result = ValueNull.INSTANCE;
                            break block1;
                        }
                    }
                    case 20: 
                    case 21: 
                }
                result = v0.convertToDate(session);
                break;
            }
            case 1004: {
                if (this.args.length == 0) {
                    result = session.getLastIdentity();
                    if (result == ValueNull.INSTANCE) {
                        result = ValueBigint.get(0L);
                        break;
                    }
                    result = result.convertToBigint(null);
                    break;
                }
                result = v0;
                if (result == ValueNull.INSTANCE) {
                    session.setLastIdentity(ValueNull.INSTANCE);
                    break;
                }
                result = result.convertToBigint(null);
                session.setLastIdentity(result);
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.info.type);
            }
        }
        return result;
    }
}

