/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import java.util.HashMap;
import java.util.StringJoiner;
import org.h2.command.Parser;
import org.h2.engine.Constants;
import org.h2.engine.RightOwner;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.CurrentGeneralValueSpecification;
import org.h2.expression.function.RandFunction;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mode.FunctionInfo;
import org.h2.mode.ModeFunction;
import org.h2.mode.ToDateParser;
import org.h2.schema.Schema;
import org.h2.server.pg.PgServer;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.StringUtils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FunctionsPostgreSQL
extends ModeFunction {
    private static final int CURRENT_DATABASE = 3001;
    private static final int CURRTID2 = 3002;
    private static final int FORMAT_TYPE = 3003;
    private static final int HAS_DATABASE_PRIVILEGE = 3004;
    private static final int HAS_SCHEMA_PRIVILEGE = 3005;
    private static final int HAS_TABLE_PRIVILEGE = 3006;
    private static final int LASTVAL = 3007;
    private static final int VERSION = 3008;
    private static final int OBJ_DESCRIPTION = 3009;
    private static final int PG_ENCODING_TO_CHAR = 3010;
    private static final int PG_GET_EXPR = 3011;
    private static final int PG_GET_INDEXDEF = 3012;
    private static final int PG_GET_USERBYID = 3013;
    private static final int PG_POSTMASTER_START_TIME = 3014;
    private static final int PG_RELATION_SIZE = 3015;
    private static final int PG_TOTAL_RELATION_SIZE = 3016;
    private static final int PG_TABLE_IS_VISIBLE = 3017;
    private static final int SET_CONFIG = 3018;
    private static final int ARRAY_TO_STRING = 3019;
    private static final int PG_STAT_GET_NUMSCANS = 3020;
    private static final int TO_DATE = 3021;
    private static final int TO_TIMESTAMP = 3022;
    private static final int GEN_RANDOM_UUID = 3023;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap(32);

    static {
        FUNCTIONS.put("CURRENT_DATABASE", new FunctionInfo("CURRENT_DATABASE", 3001, 0, 2, true, false));
        FUNCTIONS.put("CURRTID2", new FunctionInfo("CURRTID2", 3002, 2, 11, true, false));
        FUNCTIONS.put("FORMAT_TYPE", new FunctionInfo("FORMAT_TYPE", 3003, 2, 2, false, true));
        FUNCTIONS.put("HAS_DATABASE_PRIVILEGE", new FunctionInfo("HAS_DATABASE_PRIVILEGE", 3004, -1, 8, true, false));
        FUNCTIONS.put("HAS_SCHEMA_PRIVILEGE", new FunctionInfo("HAS_SCHEMA_PRIVILEGE", 3005, -1, 8, true, false));
        FUNCTIONS.put("HAS_TABLE_PRIVILEGE", new FunctionInfo("HAS_TABLE_PRIVILEGE", 3006, -1, 8, true, false));
        FUNCTIONS.put("LASTVAL", new FunctionInfo("LASTVAL", 3007, 0, 12, true, false));
        FUNCTIONS.put("VERSION", new FunctionInfo("VERSION", 3008, 0, 2, true, false));
        FUNCTIONS.put("OBJ_DESCRIPTION", new FunctionInfo("OBJ_DESCRIPTION", 3009, -1, 2, true, false));
        FUNCTIONS.put("PG_ENCODING_TO_CHAR", new FunctionInfo("PG_ENCODING_TO_CHAR", 3010, 1, 2, true, true));
        FUNCTIONS.put("PG_GET_EXPR", new FunctionInfo("PG_GET_EXPR", 3011, -1, 2, true, true));
        FUNCTIONS.put("PG_GET_INDEXDEF", new FunctionInfo("PG_GET_INDEXDEF", 3012, -1, 2, true, false));
        FUNCTIONS.put("PG_GET_USERBYID", new FunctionInfo("PG_GET_USERBYID", 3013, 1, 2, true, false));
        FUNCTIONS.put("PG_POSTMASTER_START_TIME", new FunctionInfo("PG_POSTMASTER_START_TIME", 3014, 0, 21, true, false));
        FUNCTIONS.put("PG_RELATION_SIZE", new FunctionInfo("PG_RELATION_SIZE", 3015, -1, 12, true, false));
        FUNCTIONS.put("PG_TOTAL_RELATION_SIZE", new FunctionInfo("PG_TOTAL_RELATION_SIZE", 3016, -1, 12, true, false));
        FUNCTIONS.put("PG_TABLE_IS_VISIBLE", new FunctionInfo("PG_TABLE_IS_VISIBLE", 3017, 1, 8, true, false));
        FUNCTIONS.put("SET_CONFIG", new FunctionInfo("SET_CONFIG", 3018, 3, 2, true, false));
        FUNCTIONS.put("ARRAY_TO_STRING", new FunctionInfo("ARRAY_TO_STRING", 3019, -1, 2, false, true));
        FUNCTIONS.put("PG_STAT_GET_NUMSCANS", new FunctionInfo("PG_STAT_GET_NUMSCANS", 3020, 1, 11, true, true));
        FUNCTIONS.put("TO_DATE", new FunctionInfo("TO_DATE", 3021, 2, 17, true, true));
        FUNCTIONS.put("TO_TIMESTAMP", new FunctionInfo("TO_TIMESTAMP", 3022, 2, 21, true, true));
        FUNCTIONS.put("GEN_RANDOM_UUID", new FunctionInfo("GEN_RANDOM_UUID", 3023, 0, 39, true, false));
    }

    public static FunctionsPostgreSQL getFunction(String upperName) {
        FunctionInfo info = FUNCTIONS.get(upperName);
        if (info != null) {
            return new FunctionsPostgreSQL(info);
        }
        return null;
    }

    private FunctionsPostgreSQL(FunctionInfo info) {
        super(info);
    }

    @Override
    protected void checkParameterCount(int len) {
        int max;
        int min;
        switch (this.info.type) {
            case 3004: 
            case 3005: 
            case 3006: {
                min = 2;
                max = 3;
                break;
            }
            case 3009: 
            case 3015: 
            case 3016: {
                min = 1;
                max = 2;
                break;
            }
            case 3012: {
                if (len != 1 && len != 3) {
                    throw DbException.get(7001, this.info.name, "1, 3");
                }
                return;
            }
            case 3011: 
            case 3019: {
                min = 2;
                max = 3;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.info.type);
            }
        }
        if (len < min || len > max) {
            throw DbException.get(7001, this.info.name, min + ".." + max);
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        switch (this.info.type) {
            case 3001: {
                return new CurrentGeneralValueSpecification(0).optimize(session);
            }
            case 3023: {
                return new RandFunction(null, 2).optimize(session);
            }
        }
        boolean allConst = this.optimizeArguments(session);
        this.type = TypeInfo.getTypeInfo(this.info.returnDataType);
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value result;
        Value[] values = this.getArgumentsValues(session, this.args);
        if (values == null) {
            return ValueNull.INSTANCE;
        }
        Value v0 = FunctionsPostgreSQL.getNullOrValue(session, this.args, values, 0);
        Value v1 = FunctionsPostgreSQL.getNullOrValue(session, this.args, values, 1);
        Value v2 = FunctionsPostgreSQL.getNullOrValue(session, this.args, values, 2);
        switch (this.info.type) {
            case 3002: {
                result = ValueInteger.get(1);
                break;
            }
            case 3003: {
                result = v0 != ValueNull.INSTANCE ? ValueVarchar.get(PgServer.formatType(v0.getInt())) : ValueNull.INSTANCE;
                break;
            }
            case 3004: 
            case 3005: 
            case 3006: 
            case 3017: {
                result = ValueBoolean.TRUE;
                break;
            }
            case 3007: {
                result = session.getLastIdentity();
                if (result == ValueNull.INSTANCE) {
                    throw DbException.get(90148, "lastval()");
                }
                result = result.convertToBigint(null);
                break;
            }
            case 3008: {
                result = ValueVarchar.get("PostgreSQL 8.2.23 server protocol using H2 " + Constants.FULL_VERSION);
                break;
            }
            case 3009: {
                result = ValueNull.INSTANCE;
                break;
            }
            case 3010: {
                result = ValueVarchar.get(FunctionsPostgreSQL.encodingToChar(v0.getInt()));
                break;
            }
            case 3011: {
                result = ValueNull.INSTANCE;
                break;
            }
            case 3012: {
                result = FunctionsPostgreSQL.getIndexdef(session, v0.getInt(), v1, v2);
                break;
            }
            case 3013: {
                result = ValueVarchar.get(FunctionsPostgreSQL.getUserbyid(session, v0.getInt()));
                break;
            }
            case 3014: {
                result = session.getDatabase().getSystemSession().getSessionStart();
                break;
            }
            case 3015: {
                result = FunctionsPostgreSQL.relationSize(session, v0, false);
                break;
            }
            case 3016: {
                result = FunctionsPostgreSQL.relationSize(session, v0, true);
                break;
            }
            case 3018: {
                result = v1.convertTo(2);
                break;
            }
            case 3019: {
                if (v0 == ValueNull.INSTANCE || v1 == ValueNull.INSTANCE) {
                    result = ValueNull.INSTANCE;
                    break;
                }
                StringJoiner joiner = new StringJoiner(v1.getString());
                if (v0.getValueType() != 40) {
                    throw DbException.getInvalidValueException("ARRAY_TO_STRING array", v0);
                }
                String nullString = null;
                if (v2 != null) {
                    nullString = v2.getString();
                }
                Value[] valueArray = ((ValueArray)v0).getList();
                int n = valueArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Value v = valueArray[n2];
                    if (v != ValueNull.INSTANCE) {
                        joiner.add(v.getString());
                    } else if (nullString != null) {
                        joiner.add(nullString);
                    }
                    ++n2;
                }
                result = ValueVarchar.get(joiner.toString());
                break;
            }
            case 3020: {
                result = ValueInteger.get(0);
                break;
            }
            case 3021: {
                result = ToDateParser.toDate(session, v0.getString(), v1.getString()).convertToDate(session);
                break;
            }
            case 3022: {
                result = ToDateParser.toTimestampTz(session, v0.getString(), v1.getString());
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.info.type);
            }
        }
        return result;
    }

    private static String encodingToChar(int code) {
        switch (code) {
            case 0: {
                return "SQL_ASCII";
            }
            case 6: {
                return "UTF8";
            }
            case 8: {
                return "LATIN1";
            }
        }
        return code < 40 ? "UTF8" : "";
    }

    private static Value getIndexdef(SessionLocal session, int indexId, Value ordinalPosition, Value pretty) {
        block0: for (Schema schema : session.getDatabase().getAllSchemasNoMeta()) {
            for (Index index : schema.getAllIndexes()) {
                Column[] columns;
                int ordinal;
                if (index.getId() != indexId) continue;
                if (ordinalPosition == null || (ordinal = ordinalPosition.getInt()) == 0) {
                    return ValueVarchar.get(index.getCreateSQL());
                }
                if (ordinal < 1 || ordinal > (columns = index.getColumns()).length) continue block0;
                return ValueVarchar.get(columns[ordinal - 1].getName());
            }
        }
        return ValueNull.INSTANCE;
    }

    private static String getUserbyid(SessionLocal session, int uid) {
        String name;
        User u = session.getUser();
        if (u.getId() == uid) {
            name = u.getName();
        } else if (u.isAdmin()) {
            for (RightOwner rightOwner : session.getDatabase().getAllUsersAndRoles()) {
                if (rightOwner.getId() != uid) continue;
                name = rightOwner.getName();
                break;
            }
        } else {
            return "unknown (OID=" + uid + ")";
        }
        if (session.getDatabase().getSettings().databaseToLower) {
            name = StringUtils.toLowerEnglish(name);
        }
        return name;
    }

    private static Value relationSize(SessionLocal session, Value tableOidOrName, boolean total) {
        Table t;
        block3: {
            if (tableOidOrName.getValueType() == 11) {
                int tid = tableOidOrName.getInt();
                for (Schema schema : session.getDatabase().getAllSchemasNoMeta()) {
                    for (Table table : schema.getAllTablesAndViews(session)) {
                        if (tid != table.getId()) continue;
                        t = table;
                        break block3;
                    }
                }
                return ValueNull.INSTANCE;
            }
            t = new Parser(session).parseTableName(tableOidOrName.getString());
        }
        return ValueBigint.get(t.getDiskSpaceUsed(total));
    }
}

