/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mode;

import java.util.ArrayList;
import java.util.HashSet;
import org.h2.constraint.Constraint;
import org.h2.engine.RightOwner;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.TriggerObject;
import org.h2.server.pg.PgServer;
import org.h2.table.Column;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueDouble;
import org.h2.value.ValueInteger;
import org.h2.value.ValueSmallint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class PgCatalogTable
extends MetaTable {
    private static final int PG_AM = 0;
    private static final int PG_ATTRDEF = 1;
    private static final int PG_ATTRIBUTE = 2;
    private static final int PG_AUTHID = 3;
    private static final int PG_CLASS = 4;
    private static final int PG_CONSTRAINT = 5;
    private static final int PG_DATABASE = 6;
    private static final int PG_DESCRIPTION = 7;
    private static final int PG_GROUP = 8;
    private static final int PG_INDEX = 9;
    private static final int PG_INHERITS = 10;
    private static final int PG_NAMESPACE = 11;
    private static final int PG_PROC = 12;
    private static final int PG_ROLES = 13;
    private static final int PG_SETTINGS = 14;
    private static final int PG_TABLESPACE = 15;
    private static final int PG_TRIGGER = 16;
    private static final int PG_TYPE = 17;
    private static final int PG_USER = 18;
    public static final int META_TABLE_TYPE_COUNT = 19;
    private static final Object[][] PG_EXTRA_TYPES = new Object[][]{{18, "char", 1, 0}, {19, "name", 64, 18}, {22, "int2vector", -1, 21}, {24, "regproc", 4, 0}, {1005, "_int2", -1, 21}, {1007, "_int4", -1, 23}, {1015, "_varchar", -1, 1043}, {2205, "regclass", 4, 0}};

    public PgCatalogTable(Schema schema, int id, int type) {
        super(schema, id, type);
        Column[] cols;
        switch (type) {
            case 0: {
                this.setMetaTableName("PG_AM");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("AMNAME", TypeInfo.TYPE_VARCHAR)};
                break;
            }
            case 1: {
                this.setMetaTableName("PG_ATTRDEF");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("ADSRC", TypeInfo.TYPE_INTEGER), this.column("ADRELID", TypeInfo.TYPE_INTEGER), this.column("ADNUM", TypeInfo.TYPE_INTEGER), this.column("ADBIN", TypeInfo.TYPE_VARCHAR)};
                break;
            }
            case 2: {
                this.setMetaTableName("PG_ATTRIBUTE");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("ATTRELID", TypeInfo.TYPE_INTEGER), this.column("ATTNAME", TypeInfo.TYPE_VARCHAR), this.column("ATTTYPID", TypeInfo.TYPE_INTEGER), this.column("ATTLEN", TypeInfo.TYPE_INTEGER), this.column("ATTNUM", TypeInfo.TYPE_INTEGER), this.column("ATTTYPMOD", TypeInfo.TYPE_INTEGER), this.column("ATTNOTNULL", TypeInfo.TYPE_BOOLEAN), this.column("ATTISDROPPED", TypeInfo.TYPE_BOOLEAN), this.column("ATTHASDEF", TypeInfo.TYPE_BOOLEAN)};
                break;
            }
            case 3: {
                this.setMetaTableName("PG_AUTHID");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("ROLNAME", TypeInfo.TYPE_VARCHAR), this.column("ROLSUPER", TypeInfo.TYPE_BOOLEAN), this.column("ROLINHERIT", TypeInfo.TYPE_BOOLEAN), this.column("ROLCREATEROLE", TypeInfo.TYPE_BOOLEAN), this.column("ROLCREATEDB", TypeInfo.TYPE_BOOLEAN), this.column("ROLCATUPDATE", TypeInfo.TYPE_BOOLEAN), this.column("ROLCANLOGIN", TypeInfo.TYPE_BOOLEAN), this.column("ROLCONNLIMIT", TypeInfo.TYPE_BOOLEAN), this.column("ROLPASSWORD", TypeInfo.TYPE_BOOLEAN), this.column("ROLVALIDUNTIL", TypeInfo.TYPE_TIMESTAMP_TZ), this.column("ROLCONFIG", TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.TYPE_VARCHAR))};
                break;
            }
            case 4: {
                this.setMetaTableName("PG_CLASS");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("RELNAME", TypeInfo.TYPE_VARCHAR), this.column("RELNAMESPACE", TypeInfo.TYPE_INTEGER), this.column("RELKIND", TypeInfo.TYPE_CHAR), this.column("RELAM", TypeInfo.TYPE_INTEGER), this.column("RELTUPLES", TypeInfo.TYPE_DOUBLE), this.column("RELTABLESPACE", TypeInfo.TYPE_INTEGER), this.column("RELPAGES", TypeInfo.TYPE_INTEGER), this.column("RELHASINDEX", TypeInfo.TYPE_BOOLEAN), this.column("RELHASRULES", TypeInfo.TYPE_BOOLEAN), this.column("RELHASOIDS", TypeInfo.TYPE_BOOLEAN), this.column("RELCHECKS", TypeInfo.TYPE_SMALLINT), this.column("RELTRIGGERS", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 5: {
                this.setMetaTableName("PG_CONSTRAINT");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("CONNAME", TypeInfo.TYPE_VARCHAR), this.column("CONTYPE", TypeInfo.TYPE_VARCHAR), this.column("CONRELID", TypeInfo.TYPE_INTEGER), this.column("CONFRELID", TypeInfo.TYPE_INTEGER), this.column("CONKEY", TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.TYPE_SMALLINT))};
                break;
            }
            case 6: {
                this.setMetaTableName("PG_DATABASE");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("DATNAME", TypeInfo.TYPE_VARCHAR), this.column("ENCODING", TypeInfo.TYPE_INTEGER), this.column("DATLASTSYSOID", TypeInfo.TYPE_INTEGER), this.column("DATALLOWCONN", TypeInfo.TYPE_BOOLEAN), this.column("DATCONFIG", TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.TYPE_VARCHAR)), this.column("DATACL", TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.TYPE_VARCHAR)), this.column("DATDBA", TypeInfo.TYPE_INTEGER), this.column("DATTABLESPACE", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 7: {
                this.setMetaTableName("PG_DESCRIPTION");
                cols = new Column[]{this.column("OBJOID", TypeInfo.TYPE_INTEGER), this.column("OBJSUBID", TypeInfo.TYPE_INTEGER), this.column("CLASSOID", TypeInfo.TYPE_INTEGER), this.column("DESCRIPTION", TypeInfo.TYPE_VARCHAR)};
                break;
            }
            case 8: {
                this.setMetaTableName("PG_GROUP");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("GRONAME", TypeInfo.TYPE_VARCHAR)};
                break;
            }
            case 9: {
                this.setMetaTableName("PG_INDEX");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("INDEXRELID", TypeInfo.TYPE_INTEGER), this.column("INDRELID", TypeInfo.TYPE_INTEGER), this.column("INDISCLUSTERED", TypeInfo.TYPE_BOOLEAN), this.column("INDISUNIQUE", TypeInfo.TYPE_BOOLEAN), this.column("INDISPRIMARY", TypeInfo.TYPE_BOOLEAN), this.column("INDEXPRS", TypeInfo.TYPE_VARCHAR), this.column("INDKEY", TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.TYPE_INTEGER)), this.column("INDPRED", TypeInfo.TYPE_VARCHAR)};
                break;
            }
            case 10: {
                this.setMetaTableName("PG_INHERITS");
                cols = new Column[]{this.column("INHRELID", TypeInfo.TYPE_INTEGER), this.column("INHPARENT", TypeInfo.TYPE_INTEGER), this.column("INHSEQNO", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 11: {
                this.setMetaTableName("PG_NAMESPACE");
                cols = new Column[]{this.column("ID", TypeInfo.TYPE_INTEGER), this.column("NSPNAME", TypeInfo.TYPE_VARCHAR)};
                break;
            }
            case 12: {
                this.setMetaTableName("PG_PROC");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("PRONAME", TypeInfo.TYPE_VARCHAR), this.column("PRORETTYPE", TypeInfo.TYPE_INTEGER), this.column("PROARGTYPES", TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.TYPE_INTEGER)), this.column("PRONAMESPACE", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 13: {
                this.setMetaTableName("PG_ROLES");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("ROLNAME", TypeInfo.TYPE_VARCHAR), this.column("ROLSUPER", TypeInfo.TYPE_CHAR), this.column("ROLCREATEROLE", TypeInfo.TYPE_CHAR), this.column("ROLCREATEDB", TypeInfo.TYPE_CHAR)};
                break;
            }
            case 14: {
                this.setMetaTableName("PG_SETTINGS");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("NAME", TypeInfo.TYPE_VARCHAR), this.column("SETTING", TypeInfo.TYPE_VARCHAR)};
                break;
            }
            case 15: {
                this.setMetaTableName("PG_TABLESPACE");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("SPCNAME", TypeInfo.TYPE_VARCHAR), this.column("SPCLOCATION", TypeInfo.TYPE_VARCHAR), this.column("SPCOWNER", TypeInfo.TYPE_INTEGER), this.column("SPCACL", TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.TYPE_VARCHAR))};
                break;
            }
            case 16: {
                this.setMetaTableName("PG_TRIGGER");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("TGCONSTRRELID", TypeInfo.TYPE_INTEGER), this.column("TGFOID", TypeInfo.TYPE_INTEGER), this.column("TGARGS", TypeInfo.TYPE_INTEGER), this.column("TGNARGS", TypeInfo.TYPE_INTEGER), this.column("TGDEFERRABLE", TypeInfo.TYPE_BOOLEAN), this.column("TGINITDEFERRED", TypeInfo.TYPE_BOOLEAN), this.column("TGCONSTRNAME", TypeInfo.TYPE_VARCHAR), this.column("TGRELID", TypeInfo.TYPE_INTEGER)};
                break;
            }
            case 17: {
                this.setMetaTableName("PG_TYPE");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("TYPNAME", TypeInfo.TYPE_VARCHAR), this.column("TYPNAMESPACE", TypeInfo.TYPE_INTEGER), this.column("TYPLEN", TypeInfo.TYPE_INTEGER), this.column("TYPTYPE", TypeInfo.TYPE_VARCHAR), this.column("TYPDELIM", TypeInfo.TYPE_VARCHAR), this.column("TYPRELID", TypeInfo.TYPE_INTEGER), this.column("TYPELEM", TypeInfo.TYPE_INTEGER), this.column("TYPBASETYPE", TypeInfo.TYPE_INTEGER), this.column("TYPTYPMOD", TypeInfo.TYPE_INTEGER), this.column("TYPNOTNULL", TypeInfo.TYPE_BOOLEAN), this.column("TYPINPUT", TypeInfo.TYPE_VARCHAR)};
                break;
            }
            case 18: {
                this.setMetaTableName("PG_USER");
                cols = new Column[]{this.column("OID", TypeInfo.TYPE_INTEGER), this.column("USENAME", TypeInfo.TYPE_VARCHAR), this.column("USECREATEDB", TypeInfo.TYPE_BOOLEAN), this.column("USESUPER", TypeInfo.TYPE_BOOLEAN)};
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + type);
            }
        }
        this.setColumns(cols);
        this.indexColumn = -1;
        this.metaIndex = null;
    }

    @Override
    public ArrayList<Row> generateRows(SessionLocal session, SearchRow first, SearchRow last) {
        ArrayList<Row> rows = Utils.newSmallArrayList();
        String catalog = this.database.getShortName();
        boolean admin = session.getUser().isAdmin();
        switch (this.type) {
            case 0: {
                String[] am = new String[]{"btree", "hash"};
                int i = 0;
                int l = am.length;
                while (i < l) {
                    this.add(session, rows, ValueInteger.get(i), am[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.getAllTables(session, null, null).forEach(table -> this.pgAttribute(session, rows, (Table)table));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.getAllTables(session, null, null).forEach(table -> this.pgClass(session, rows, (Table)table));
                break;
            }
            case 5: {
                this.pgConstraint(session, rows);
                break;
            }
            case 6: {
                int uid = Integer.MAX_VALUE;
                for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
                    int id;
                    if (!(rightOwner instanceof User) || !((User)rightOwner).isAdmin() || (id = rightOwner.getId()) >= uid) continue;
                    uid = id;
                }
                this.add(session, rows, ValueInteger.get(100001), catalog, ValueInteger.get(6), ValueInteger.get(100000), ValueBoolean.TRUE, null, null, ValueInteger.get(uid), ValueInteger.get(0));
                break;
            }
            case 7: {
                this.add(session, rows, ValueInteger.get(0), ValueInteger.get(0), ValueInteger.get(-1), catalog);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                for (Schema schema : this.database.getAllSchemas()) {
                    this.add(session, rows, ValueInteger.get(schema.getId()), schema.getName());
                }
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
                    if (!admin && session.getUser() != rightOwner) continue;
                    String r = rightOwner instanceof User && ((User)rightOwner).isAdmin() ? "t" : "f";
                    this.add(session, rows, ValueInteger.get(rightOwner.getId()), this.identifier(rightOwner.getName()), r, r, r);
                }
                break;
            }
            case 14: {
                String[][] settings = new String[][]{{"autovacuum", "on"}, {"stats_start_collector", "on"}, {"stats_row_level", "on"}};
                int i = 0;
                int l = settings.length;
                while (i < l) {
                    String[] setting = settings[i];
                    this.add(session, rows, ValueInteger.get(i), setting[0], setting[1]);
                    ++i;
                }
                break;
            }
            case 15: {
                this.add(session, rows, ValueInteger.get(0), "main", "?", ValueInteger.get(0), null);
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                HashSet<Integer> types = new HashSet<Integer>();
                int i = 1;
                int l = 42;
                while (i < l) {
                    int pgType;
                    DataType t = DataType.getDataType(i);
                    if (t.type != 40 && (pgType = PgServer.convertType(TypeInfo.getTypeInfo(t.type))) != 705 && types.add(pgType)) {
                        this.add(session, rows, ValueInteger.get(pgType), Value.getTypeName(t.type), ValueInteger.get(-1000), ValueInteger.get(-1), "b", ",", ValueInteger.get(0), ValueInteger.get(0), ValueInteger.get(0), ValueInteger.get(-1), ValueBoolean.FALSE, null);
                    }
                    ++i;
                }
                Object[][] objectArray = PG_EXTRA_TYPES;
                int t = PG_EXTRA_TYPES.length;
                l = 0;
                while (l < t) {
                    Object[] pgType = objectArray[l];
                    this.add(session, rows, ValueInteger.get((Integer)pgType[0]), pgType[1], ValueInteger.get(-1000), ValueInteger.get((Integer)pgType[2]), "b", ",", ValueInteger.get(0), ValueInteger.get((Integer)pgType[3]), ValueInteger.get(0), ValueInteger.get(-1), ValueBoolean.FALSE, null);
                    ++l;
                }
                break;
            }
            case 18: {
                for (RightOwner rightOwner : this.database.getAllUsersAndRoles()) {
                    if (!(rightOwner instanceof User)) continue;
                    User u = (User)rightOwner;
                    if (!admin && session.getUser() != u) continue;
                    ValueBoolean r = ValueBoolean.get(u.isAdmin());
                    this.add(session, rows, ValueInteger.get(u.getId()), this.identifier(u.getName()), r, r);
                }
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        return rows;
    }

    private void pgAttribute(SessionLocal session, ArrayList<Row> rows, Table table) {
        Column[] cols = table.getColumns();
        int tableId = table.getId();
        int i = 0;
        while (i < cols.length) {
            Column column = cols[i++];
            this.addAttribute(session, rows, tableId * 10000 + i, tableId, column, i);
        }
        for (Index index : table.getIndexes()) {
            if (index.getCreateSQL() == null) continue;
            cols = index.getColumns();
            int i2 = 0;
            while (i2 < cols.length) {
                Column column = cols[i2++];
                int indexId = index.getId();
                this.addAttribute(session, rows, 1000000 * indexId + tableId * 10000 + i2, indexId, column, i2);
            }
        }
    }

    private void pgClass(SessionLocal session, ArrayList<Row> rows, Table table) {
        ArrayList<TriggerObject> triggers = table.getTriggers();
        this.addClass(session, rows, table.getId(), table.getName(), table.getSchema().getId(), table.isView() ? "v" : "r", false, triggers != null ? triggers.size() : 0);
        ArrayList<Index> indexes = table.getIndexes();
        if (indexes != null) {
            for (Index index : indexes) {
                if (index.getCreateSQL() == null) continue;
                this.addClass(session, rows, index.getId(), index.getName(), index.getSchema().getId(), "i", true, 0);
            }
        }
    }

    private void pgConstraint(SessionLocal session, ArrayList<Row> rows) {
        this.getAllConstraints(session).filter(constraint -> constraint.getConstraintType() != Constraint.Type.DOMAIN).forEach(constraint -> {
            Constraint.Type constraintType = constraint.getConstraintType();
            Table table = constraint.getTable();
            ArrayList<ValueSmallint> conkey = new ArrayList<ValueSmallint>();
            for (Column column : constraint.getReferencedColumns(table)) {
                conkey.add(ValueSmallint.get((short)(column.getColumnId() + 1)));
            }
            Table refTable = constraint.getRefTable();
            this.add(session, rows, ValueInteger.get(constraint.getId()), constraint.getName(), StringUtils.toLowerEnglish(constraintType.getSqlName().substring(0, 1)), ValueInteger.get(table.getId()), ValueInteger.get(refTable != null && refTable != table ? table.getId() : 0), ValueArray.get(TypeInfo.TYPE_SMALLINT, conkey.toArray(Value.EMPTY_VALUES), null));
        });
    }

    private void addAttribute(SessionLocal session, ArrayList<Row> rows, int id, int relId, Column column, int ordinal) {
        long precision = column.getType().getPrecision();
        this.add(session, rows, ValueInteger.get(id), ValueInteger.get(relId), column.getName(), ValueInteger.get(PgServer.convertType(column.getType())), ValueInteger.get(precision > 255L ? -1 : (int)precision), ValueInteger.get(ordinal), ValueInteger.get(-1), ValueBoolean.get(!column.isNullable()), ValueBoolean.FALSE, ValueBoolean.FALSE);
    }

    private void addClass(SessionLocal session, ArrayList<Row> rows, int id, String name, int schema, String kind, boolean index, int triggers) {
        this.add(session, rows, ValueInteger.get(id), name, ValueInteger.get(schema), kind, ValueInteger.get(0), ValueDouble.get(0.0), ValueInteger.get(0), ValueInteger.get(0), ValueBoolean.get(index), ValueBoolean.FALSE, ValueBoolean.FALSE, ValueSmallint.get((short)0), ValueInteger.get(triggers));
    }

    @Override
    public long getMaxDataModificationId() {
        return this.database.getModificationDataId();
    }
}

