/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;
import org.h2.mvstore.RootReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Cursor<K, V>
implements Iterator<K> {
    private final boolean reverse;
    private final K to;
    private CursorPos<K, V> cursorPos;
    private CursorPos<K, V> keeper;
    private K current;
    private K last;
    private V lastValue;
    private Page<K, V> lastPage;

    public Cursor(RootReference<K, V> rootReference, K from, K to) {
        this(rootReference, from, to, false);
    }

    public Cursor(RootReference<K, V> rootReference, K from, K to, boolean reverse) {
        this.lastPage = rootReference.root;
        this.cursorPos = Cursor.traverseDown(this.lastPage, from, reverse);
        this.to = to;
        this.reverse = reverse;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean hasNext() {
        block6: {
            if (this.cursorPos == null) break block6;
            increment = this.reverse != false ? -1 : 1;
            while (this.current == null) {
                block7: {
                    page = this.cursorPos.page;
                    index = this.cursorPos.index;
                    if (!(this.reverse != false ? index < 0 : index >= Cursor.upperBound(page))) ** GOTO lbl25
                    tmp = this.cursorPos;
                    this.cursorPos = this.cursorPos.parent;
                    if (this.cursorPos == null) {
                        return false;
                    }
                    tmp.parent = this.keeper;
                    this.keeper = tmp;
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        page = page.getChildPage(index);
                        v0 = index = this.reverse != false ? Cursor.upperBound(page) - 1 : 0;
                        if (this.keeper == null) {
                            this.cursorPos = new CursorPos<K, V>(page, index, this.cursorPos);
                            continue;
                        }
                        tmp = this.keeper;
                        this.keeper = this.keeper.parent;
                        tmp.parent = this.cursorPos;
                        tmp.page = page;
                        tmp.index = index;
                        this.cursorPos = tmp;
lbl25:
                        // 3 sources

                        ** while (!page.isLeaf())
                    }
lbl26:
                    // 1 sources

                    if (this.reverse != false ? index >= 0 : index < page.getKeyCount()) {
                        key = page.getKey(index);
                        if (this.to != null && Integer.signum(page.map.getKeyType().compare(key, this.to)) == increment) {
                            return false;
                        }
                        this.last = key;
                        this.current = this.last;
                        this.lastValue = page.getValue(index);
                        this.lastPage = page;
                    }
                }
                this.cursorPos.index += increment;
            }
        }
        return this.current != null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = null;
        return this.last;
    }

    public K getKey() {
        return this.last;
    }

    public V getValue() {
        return this.lastValue;
    }

    Page<K, V> getPage() {
        return this.lastPage;
    }

    public void skip(long n) {
        if (n < 10L) {
            while (n-- > 0L && this.hasNext()) {
                this.next();
            }
        } else if (this.hasNext()) {
            CursorPos parent;
            assert (this.cursorPos != null);
            CursorPos<K, V> cp = this.cursorPos;
            while ((parent = cp.parent) != null) {
                cp = parent;
            }
            Page root = cp.page;
            MVMap map = root.map;
            long index = map.getKeyIndex(this.next());
            this.last = map.getKey(index + (this.reverse ? -n : n));
            this.cursorPos = Cursor.traverseDown(root, this.last, this.reverse);
        }
    }

    static <K, V> CursorPos<K, V> traverseDown(Page<K, V> page, K key, boolean reverse) {
        CursorPos<K, V> cursorPos = key != null ? CursorPos.traverseDown(page, key) : (reverse ? page.getAppendCursorPos(null) : page.getPrependCursorPos(null));
        int index = cursorPos.index;
        if (index < 0) {
            index ^= 0xFFFFFFFF;
            if (reverse) {
                --index;
            }
            cursorPos.index = index;
        }
        return cursorPos;
    }

    private static <K, V> int upperBound(Page<K, V> page) {
        return page.isLeaf() ? page.getKeyCount() : page.map.getChildPageCount(page);
    }
}

