/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import org.h2.mvstore.Page;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class CursorPos<K, V> {
    public Page<K, V> page;
    public int index;
    public CursorPos<K, V> parent;

    public CursorPos(Page<K, V> page, int index, CursorPos<K, V> parent) {
        this.page = page;
        this.index = index;
        this.parent = parent;
    }

    static <K, V> CursorPos<K, V> traverseDown(Page<K, V> page, K key) {
        CursorPos<K, V> cursorPos = null;
        while (!page.isLeaf()) {
            int index = page.binarySearch(key) + 1;
            if (index < 0) {
                index = -index;
            }
            cursorPos = new CursorPos<K, V>(page, index, cursorPos);
            page = page.getChildPage(index);
        }
        return new CursorPos<K, V>(page, page.binarySearch(key), cursorPos);
    }

    int processRemovalInfo(long version) {
        int unsavedMemory = 0;
        CursorPos<K, V> head = this;
        while (head != null) {
            unsavedMemory += head.page.removePage(version);
            head = head.parent;
        }
        return unsavedMemory;
    }

    public String toString() {
        return "CursorPos{page=" + String.valueOf(this.page) + ", index=" + this.index + ", parent=" + String.valueOf(this.parent) + "}";
    }
}

