/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.IntSupplier;
import java.util.zip.ZipOutputStream;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.Page;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.MathUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class FileStore<C extends Chunk<C>> {
    static final String HDR_H = "H";
    static final String HDR_BLOCK_SIZE = "blockSize";
    static final String HDR_FORMAT = "format";
    static final String HDR_CREATED = "created";
    static final String HDR_FORMAT_READ = "formatRead";
    static final String HDR_CHUNK = "chunk";
    static final String HDR_BLOCK = "block";
    static final String HDR_VERSION = "version";
    static final String HDR_CLEAN = "clean";
    static final String HDR_FLETCHER = "fletcher";
    public static final String META_ID_KEY = "meta.id";
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE_MIN = 3;
    private static final int FORMAT_WRITE_MAX = 3;
    private static final int FORMAT_READ_MIN = 3;
    private static final int FORMAT_READ_MAX = 3;
    MVStore mvStore;
    private boolean closed;
    protected final AtomicLong readCount = new AtomicLong();
    protected final AtomicLong readBytes = new AtomicLong();
    protected final AtomicLong writeCount = new AtomicLong();
    protected final AtomicLong writeBytes = new AtomicLong();
    private String fileName;
    private int retentionTime = this.getDefaultRetentionTime();
    private final int maxPageSize;
    private long size;
    private boolean readOnly;
    private final ReentrantLock serializationLock = new ReentrantLock(true);
    private ThreadPoolExecutor serializationExecutor;
    private ThreadPoolExecutor bufferSaveExecutor;
    private final CacheLongKeyLIRS<Page<?, ?>> cache;
    private final CacheLongKeyLIRS<long[]> chunksToC;
    private final Queue<RemovedPageInfo> removedPages = new PriorityBlockingQueue<RemovedPageInfo>();
    protected volatile C lastChunk;
    private int lastChunkId;
    protected final ReentrantLock saveChunkLock = new ReentrantLock(true);
    final ConcurrentHashMap<Integer, C> chunks = new ConcurrentHashMap();
    protected final HashMap<String, Object> storeHeader = new HashMap();
    private long creationTime;
    private final Queue<WriteBuffer> writeBufferPool = new ArrayBlockingQueue<WriteBuffer>(4);
    private MVMap<String, String> layout;
    private final Deque<C> deadChunks = new ConcurrentLinkedDeque<C>();
    private final AtomicReference<BackgroundWriterThread> backgroundWriterThread = new AtomicReference();
    private final int autoCompactFillRate;
    private int autoCommitDelay;
    private long autoCompactLastFileOpCount;
    private long lastCommitTime;
    protected final boolean recoveryMode;
    public static final int PIPE_LENGTH = 3;
    private int serializationExecutorHWM;
    private int bufferSaveExecutorHWM;

    protected FileStore(Map<String, Object> config) {
        int maxCacheableSize;
        this.recoveryMode = config.containsKey("recoveryMode");
        this.autoCompactFillRate = DataUtils.getConfigParam(config, "autoCompactFillRate", 90);
        CacheLongKeyLIRS.Config cc = null;
        int mb = DataUtils.getConfigParam(config, "cacheSize", 16);
        if (mb > 0) {
            cc = new CacheLongKeyLIRS.Config();
            cc.maxMemory = (long)mb * 1024L * 1024L;
            Object o = config.get("cacheConcurrency");
            if (o != null) {
                cc.segmentCount = (Integer)o;
            }
        }
        this.cache = cc == null ? null : new CacheLongKeyLIRS(cc);
        CacheLongKeyLIRS.Config cc2 = new CacheLongKeyLIRS.Config();
        cc2.maxMemory = 0x100000L;
        this.chunksToC = new CacheLongKeyLIRS(cc2);
        int maxPageSize = Integer.MAX_VALUE;
        if (this.cache != null && (maxPageSize = 16384) > (maxCacheableSize = (int)(this.cache.getMaxItemSize() >> 4))) {
            maxPageSize = maxCacheableSize;
        }
        this.maxPageSize = maxPageSize;
    }

    public abstract void open(String var1, boolean var2, char[] var3);

    public abstract FileStore<C> open(String var1, boolean var2);

    protected final void init(String fileName, boolean readOnly) {
        this.fileName = fileName;
        this.readOnly = readOnly;
    }

    public final void bind(MVStore mvStore) {
        if (this.mvStore != mvStore) {
            long pos = this.layout == null ? 0L : this.layout.getRootPage().getPos();
            this.layout = new MVMap<String, String>(mvStore, 0, StringDataType.INSTANCE, StringDataType.INSTANCE);
            this.layout.setRootPos(pos, mvStore.getCurrentVersion());
            this.mvStore = mvStore;
            mvStore.resetLastMapId(this.lastChunk == null ? 0 : ((Chunk)this.lastChunk).mapId);
            mvStore.setCurrentVersion(this.lastChunkVersion());
        }
    }

    public final void stop(long allowedCompactionTime) {
        if (allowedCompactionTime > 0L) {
            this.compactStore(allowedCompactionTime);
        }
        this.writeCleanShutdown();
        this.clearCaches();
    }

    public void close() {
        this.layout.close();
        this.closed = true;
        this.chunks.clear();
    }

    public final int getMetaMapId(IntSupplier nextIdSupplier) {
        int metaId;
        String metaIdStr = this.layout.get(META_ID_KEY);
        if (metaIdStr == null) {
            metaId = nextIdSupplier.getAsInt();
            this.layout.put(META_ID_KEY, Integer.toHexString(metaId));
        } else {
            metaId = DataUtils.parseHexInt(metaIdStr);
        }
        return metaId;
    }

    public final Map<String, String> getLayoutMap() {
        return new TreeMap<String, String>(this.layout);
    }

    public final boolean isRegularMap(MVMap<?, ?> map) {
        return map != this.layout;
    }

    public final long getRootPos(int mapId) {
        String root = this.layout.get(MVMap.getMapRootKey(mapId));
        return root == null ? 0L : DataUtils.parseHexLong(root);
    }

    public final boolean deregisterMapRoot(int mapId) {
        return this.layout.remove(MVMap.getMapRootKey(mapId)) != null;
    }

    public final boolean hasChangesSince(long lastStoredVersion) {
        return this.layout.hasChangesSince(lastStoredVersion) && lastStoredVersion > -1L;
    }

    public final long lastChunkVersion() {
        C chunk = this.lastChunk;
        return chunk == null ? 0L : ((Chunk)chunk).version;
    }

    public final long getMaxPageSize() {
        return this.maxPageSize;
    }

    public final int getRetentionTime() {
        return this.retentionTime;
    }

    public final void setRetentionTime(int ms) {
        this.retentionTime = ms;
    }

    public abstract boolean shouldSaveNow(int var1, int var2);

    public final int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public final void setAutoCommitDelay(int millis) {
        if (this.autoCommitDelay != millis) {
            this.autoCommitDelay = millis;
            if (!this.isReadOnly()) {
                int sleep;
                BackgroundWriterThread t;
                this.stopBackgroundThread(millis >= 0);
                if (millis > 0 && this.mvStore.isOpen() && this.backgroundWriterThread.compareAndSet(null, t = new BackgroundWriterThread(this, sleep = Math.max(10, millis / 3), this.toString()))) {
                    t.start();
                    this.serializationExecutor = Utils.createSingleThreadExecutor("H2-serialization");
                    this.bufferSaveExecutor = Utils.createSingleThreadExecutor("H2-save");
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isKnownVersion(long version) {
        if (this.chunks.isEmpty()) {
            return true;
        }
        C c = this.getChunkForVersion(version);
        if (c == null) {
            return false;
        }
        try {
            Chunk chunk;
            String chunkKey;
            MVMap<String, String> oldLayoutMap = this.getLayoutMap(version);
            Iterator<C> iterator = this.getChunksFromLayoutMap(oldLayoutMap).iterator();
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                chunk = (Chunk)iterator.next();
            } while (this.layout.containsKey(chunkKey = Chunk.getMetaKey(chunk.id)) || this.isValidChunk(chunk));
            return false;
        }
        catch (MVStoreException e) {
            return false;
        }
    }

    public final void rollbackTo(long version) {
        block9: {
            if (version == 0L) {
                String metaId = this.layout.get(META_ID_KEY);
                this.layout.setInitialRoot(this.layout.createEmptyLeaf(), -1L);
                this.layout.put(META_ID_KEY, metaId);
            } else if (!this.layout.rollbackRoot(version)) {
                MVMap<String, String> layoutMap = this.getLayoutMap(version);
                this.layout.setInitialRoot(layoutMap.getRootPage(), version);
            }
            this.serializationLock.lock();
            try {
                C keep = this.getChunkForVersion(version);
                if (keep == null) break block9;
                this.saveChunkLock.lock();
                try {
                    this.deadChunks.clear();
                    this.setLastChunk(keep);
                    this.adjustStoreToLastChunk();
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            }
            finally {
                this.serializationLock.unlock();
            }
        }
        this.removedPages.clear();
        this.clearCaches();
    }

    protected final void initializeCommonHeaderAttributes(long time) {
        this.setLastChunk(null);
        this.creationTime = time;
        this.storeHeader.put(HDR_H, 2);
        this.storeHeader.put(HDR_BLOCK_SIZE, 4096);
        this.storeHeader.put(HDR_FORMAT, 3);
        this.storeHeader.put(HDR_CREATED, this.creationTime);
    }

    protected final void processCommonHeaderAttributes() {
        this.creationTime = DataUtils.readHexLong(this.storeHeader, HDR_CREATED, 0L);
        long now = System.currentTimeMillis();
        int year = 1970 + (int)(now / 31557600000L);
        if (year < 2014) {
            this.creationTime = now - (long)this.getRetentionTime();
        } else if (now < this.creationTime) {
            this.creationTime = now;
            this.storeHeader.put(HDR_CREATED, this.creationTime);
        }
        int blockSize = DataUtils.readHexInt(this.storeHeader, HDR_BLOCK_SIZE, 4096);
        if (blockSize != 4096) {
            throw DataUtils.newMVStoreException(5, "Block size {0} is currently not supported", blockSize);
        }
        long format = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT, 1L);
        if (!this.isReadOnly()) {
            if (format > 3L) {
                throw this.getUnsupportedWriteFormatException(format, 3, "The write format {0} is larger than the supported format {1}");
            }
            if (format < 3L) {
                throw this.getUnsupportedWriteFormatException(format, 3, "The write format {0} is smaller than the supported format {1}");
            }
        }
        if ((format = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT_READ, format)) > 3L) {
            throw DataUtils.newMVStoreException(5, "The read format {0} is larger than the supported format {1}", format, 3);
        }
        if (format < 3L) {
            throw DataUtils.newMVStoreException(5, "The read format {0} is smaller than the supported format {1}", format, 3);
        }
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.mvStore.getTimeAbsolute() - this.getCreationTime());
    }

    private MVMap<String, String> getLayoutMap(long version) {
        C chunk = this.getChunkForVersion(version);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", version);
        return this.layout.openReadOnly(((Chunk)chunk).layoutRootPos, version);
    }

    private C getChunkForVersion(long version) {
        Chunk newest = null;
        for (Chunk c : this.chunks.values()) {
            if (c.version > version || newest != null && c.id <= newest.id) continue;
            newest = c;
        }
        return (C)newest;
    }

    private void scrubLayoutMap(MVMap<String, String> meta) {
        HashSet<String> keysToRemove = new HashSet<String>();
        String[] stringArray = new String[]{"name.", "map."};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            Iterator<String> it = this.layout.keyIterator(prefix);
            while (it.hasNext()) {
                String key = it.next();
                if (!key.startsWith(prefix)) break;
                meta.putIfAbsent(key, this.layout.get(key));
                this.mvStore.markMetaChanged();
                keysToRemove.add(key);
            }
            ++n2;
        }
        Iterator<String> it = this.layout.keyIterator("root.");
        while (it.hasNext()) {
            String key = it.next();
            if (!key.startsWith("root.")) break;
            String mapIdStr = key.substring(key.lastIndexOf(46) + 1);
            if (meta.containsKey("map." + mapIdStr) || DataUtils.parseHexInt(mapIdStr) == meta.getId()) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.layout.remove(key);
        }
    }

    protected final boolean hasPersistentData() {
        return this.lastChunk != null;
    }

    protected final boolean isIdle() {
        return this.autoCompactLastFileOpCount >= this.getWriteCount() + this.getReadCount();
    }

    protected final void setLastChunk(C last) {
        this.lastChunk = last;
        this.chunks.clear();
        this.lastChunkId = 0;
        long layoutRootPos = 0L;
        if (last != null) {
            this.lastChunkId = ((Chunk)last).id;
            layoutRootPos = ((Chunk)last).layoutRootPos;
            this.chunks.put(((Chunk)last).id, last);
        }
        this.layout.setRootPos(layoutRootPos, this.lastChunkVersion());
    }

    protected final void registerDeadChunk(C chunk) {
        this.deadChunks.offer(chunk);
    }

    public final void dropUnusedChunks() {
        if (!this.deadChunks.isEmpty()) {
            Chunk chunk;
            long oldestVersionToKeep = this.mvStore.getOldestVersionToKeep();
            long time = this.getTimeSinceCreation();
            ArrayList<Chunk> toBeFreed = new ArrayList<Chunk>();
            while ((chunk = (Chunk)this.deadChunks.poll()) != null && (this.isSeasonedChunk(chunk, time) && FileStore.canOverwriteChunk(chunk, oldestVersionToKeep) || !this.deadChunks.offerFirst(chunk))) {
                if (this.chunks.remove(chunk.id) == null) continue;
                long[] toc = this.cleanToCCache(chunk);
                if (toc != null && this.cache != null) {
                    long[] lArray = toc;
                    int n = toc.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long tocElement = lArray[n2];
                        long pagePos = DataUtils.composePagePos(chunk.id, tocElement);
                        this.cache.remove(pagePos);
                        ++n2;
                    }
                }
                if (this.layout.remove(Chunk.getMetaKey(chunk.id)) != null) {
                    this.mvStore.markMetaChanged();
                }
                if (!chunk.isAllocated()) continue;
                toBeFreed.add(chunk);
            }
            if (!toBeFreed.isEmpty()) {
                this.saveChunkLock.lock();
                try {
                    this.freeChunkSpace(toBeFreed);
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            }
        }
    }

    private static <C extends Chunk<C>> boolean canOverwriteChunk(C c, long oldestVersionToKeep) {
        return !c.isLive() && c.unusedAtVersion < oldestVersionToKeep;
    }

    private boolean isSeasonedChunk(C chunk, long time) {
        int retentionTime = this.getRetentionTime();
        return retentionTime < 0 || ((Chunk)chunk).time + (long)retentionTime <= time;
    }

    private boolean isRewritable(C chunk, long time) {
        return ((Chunk)chunk).isRewritable() && this.isSeasonedChunk(chunk, time);
    }

    protected abstract void writeFully(C var1, long var2, ByteBuffer var4);

    public abstract ByteBuffer readFully(C var1, long var2, int var4);

    protected final ByteBuffer readFully(FileChannel file, long pos, int len) {
        ByteBuffer dst = ByteBuffer.allocate(len);
        DataUtils.readFully(file, pos, dst);
        this.readCount.incrementAndGet();
        this.readBytes.addAndGet(len);
        return dst;
    }

    protected abstract void allocateChunkSpace(C var1, WriteBuffer var2);

    protected abstract void writeChunk(C var1, WriteBuffer var2);

    protected abstract void writeCleanShutdownMark();

    protected abstract void adjustStoreToLastChunk();

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private C createChunk(long time, long version) {
        int newChunkId = this.findNewChunkId();
        C c = this.createChunk(newChunkId);
        ((Chunk)c).time = time;
        ((Chunk)c).version = version;
        ((Chunk)c).occupancy = new BitSet();
        return c;
    }

    protected abstract C createChunk(int var1);

    public abstract C createChunk(String var1);

    protected abstract C createChunk(Map<String, String> var1);

    private int findNewChunkId() {
        Chunk old;
        int newChunkId;
        while ((newChunkId = ++this.lastChunkId & 0x3FFFFFF) != this.lastChunkId && (old = (Chunk)this.chunks.get(newChunkId)) != null) {
            if (old.isSaved()) continue;
            throw DataUtils.newMVStoreException(3, "Last block {0} not stored, possibly due to out-of-memory", old);
        }
        return newChunkId;
    }

    protected void writeCleanShutdown() {
        if (!this.isReadOnly()) {
            this.saveChunkLock.lock();
            try {
                this.writeCleanShutdownMark();
                this.sync();
                assert (this.validateFileLength("on close"));
            }
            finally {
                this.saveChunkLock.unlock();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void saveChunkMetadataChanges(C chunk) {
        if (FileStore.$assertionsDisabled || this.serializationLock.isHeldByCurrentThread()) ** GOTO lbl13
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            this.saveChunkLock.lock();
            try {
                if (chunk.isAllocated()) {
                    break;
                }
            }
            finally {
                this.saveChunkLock.unlock();
            }
            Thread.yield();
lbl13:
            // 2 sources

            ** while (!chunk.isAllocated())
        }
lbl14:
        // 2 sources

        this.layout.put(Chunk.getMetaKey(chunk.id), chunk.asString());
    }

    protected abstract void freeChunkSpace(Iterable<C> var1);

    protected abstract boolean validateFileLength(String var1);

    public boolean compact(int targetFillRate, int write) {
        if (this.hasPersistentData() && targetFillRate > 0 && this.getChunksFillRate() < targetFillRate) {
            try {
                Boolean result = this.mvStore.tryExecuteUnderStoreLock(() -> this.rewriteChunks(write, 100));
                return result != null && result != false;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public void compactStore(long maxCompactTime) {
        this.compactStore(this.autoCompactFillRate, maxCompactTime, 0x1000000, this.mvStore);
    }

    protected abstract void compactStore(int var1, long var2, int var4, MVStore var5);

    protected abstract void doHousekeeping(MVStore var1) throws InterruptedException;

    public MVMap<String, String> start() {
        if (this.size() == 0L) {
            this.initializeCommonHeaderAttributes(this.mvStore.getTimeAbsolute());
            this.initializeStoreHeader(this.mvStore.getTimeAbsolute());
        } else {
            this.saveChunkLock.lock();
            try {
                this.readStoreHeader(this.recoveryMode);
            }
            finally {
                this.saveChunkLock.unlock();
            }
        }
        this.lastCommitTime = this.getTimeSinceCreation();
        this.mvStore.resetLastMapId(this.lastMapId());
        this.mvStore.setCurrentVersion(this.lastChunkVersion());
        MVMap<String, String> metaMap = this.mvStore.openMetaMap();
        this.scrubLayoutMap(metaMap);
        return metaMap;
    }

    protected abstract void initializeStoreHeader(long var1);

    protected abstract void readStoreHeader(boolean var1);

    private int lastMapId() {
        C chunk = this.lastChunk;
        return chunk == null ? 0 : ((Chunk)chunk).mapId;
    }

    private MVStoreException getUnsupportedWriteFormatException(long format, int expectedFormat, String s) {
        if ((format = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT_READ, format)) >= 3L && format <= 3L) {
            s = (String)s + ", and the file was not opened in read-only mode";
        }
        return DataUtils.newMVStoreException(5, (String)s, format, expectedFormat);
    }

    protected final C discoverChunk(long block) {
        long candidateLocation = Long.MAX_VALUE;
        C candidate = null;
        while (block != candidateLocation) {
            if (block == 2L) {
                return null;
            }
            C test = this.readChunkFooter(block);
            if (test != null) {
                candidateLocation = Long.MAX_VALUE;
                test = this.readChunkHeaderOptionally(((Chunk)test).block, ((Chunk)test).id);
                if (test != null) {
                    candidate = test;
                    candidateLocation = ((Chunk)test).block;
                }
            }
            if (--block <= candidateLocation || this.readChunkHeaderOptionally(block) == null) continue;
            candidateLocation = Long.MAX_VALUE;
        }
        return candidate;
    }

    protected final boolean findLastChunkWithCompleteValidChunkSet(Comparator<C> chunkComparator, Map<Long, C> validChunksByLocation, boolean afterFullScan) {
        Chunk chunk;
        Chunk[] array = this.createChunksArray(validChunksByLocation.size());
        Chunk[] lastChunkCandidates = validChunksByLocation.values().toArray(array);
        Arrays.sort(lastChunkCandidates, chunkComparator);
        HashMap<Integer, Chunk> validChunksById = new HashMap<Integer, Chunk>();
        Chunk[] chunkArray = lastChunkCandidates;
        int n = lastChunkCandidates.length;
        int n2 = 0;
        while (n2 < n) {
            chunk = chunkArray[n2];
            validChunksById.put(chunk.id, chunk);
            ++n2;
        }
        chunkArray = lastChunkCandidates;
        n = lastChunkCandidates.length;
        n2 = 0;
        while (n2 < n) {
            chunk = chunkArray[n2];
            boolean verified = true;
            try {
                this.setLastChunk(chunk);
                for (Chunk c : this.getChunksFromLayoutMap()) {
                    Chunk test = (Chunk)validChunksByLocation.get(c.block);
                    if (test == null || test.id != c.id) {
                        test = (Chunk)validChunksById.get(c.id);
                        if (test != null) {
                            c.block = test.block;
                        } else if (c.isLive() && (afterFullScan || this.readChunkHeaderAndFooter(c.block, c.id) == null)) {
                            verified = false;
                            break;
                        }
                    }
                    if (c.isLive()) continue;
                    c.block = 0L;
                    c.len = 0;
                    if (c.unused == 0L) {
                        c.unused = this.getCreationTime();
                    }
                    if (c.unusedAtVersion != 0L) continue;
                    c.unusedAtVersion = -1L;
                }
            }
            catch (Exception ignored) {
                verified = false;
            }
            if (verified) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private C[] createChunksArray(int sz) {
        return new Chunk[sz];
    }

    private C readChunkHeader(long block) {
        long p = block * 4096L;
        ByteBuffer buff = this.readFully((C)null, p, 1024);
        Throwable exception = null;
        try {
            C chunk = this.createChunk(Chunk.readChunkHeader(buff));
            if (((Chunk)chunk).block == 0L) {
                ((Chunk)chunk).block = block;
            }
            if (((Chunk)chunk).block == block) {
                return chunk;
            }
        }
        catch (MVStoreException e) {
            exception = e.getCause();
        }
        catch (Throwable e) {
            exception = e;
        }
        throw DataUtils.newMVStoreException(6, "File corrupt reading chunk at position {0}", p, exception);
    }

    protected Iterable<C> getChunksFromLayoutMap() {
        return this.getChunksFromLayoutMap(this.layout);
    }

    private Iterable<C> getChunksFromLayoutMap(MVMap<String, String> layoutMap) {
        return () -> new Iterator<C>(layoutMap){
            private final Cursor<String, String> cursor;
            private C nextChunk;
            {
                this.cursor = mVMap.cursor("chunk.");
            }

            @Override
            public boolean hasNext() {
                if (this.nextChunk == null && this.cursor.hasNext() && this.cursor.next().startsWith("chunk.")) {
                    this.nextChunk = FileStore.this.createChunk(this.cursor.getValue());
                    Chunk existingChunk = (Chunk)FileStore.this.chunks.putIfAbsent(((Chunk)this.nextChunk).id, this.nextChunk);
                    if (existingChunk != null) {
                        this.nextChunk = existingChunk;
                    }
                }
                return this.nextChunk != null;
            }

            @Override
            public C next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object chunk = this.nextChunk;
                this.nextChunk = null;
                return chunk;
            }
        };
    }

    private boolean isValidChunk(C chunk) {
        return this.readChunkHeaderAndFooter(((Chunk)chunk).block, ((Chunk)chunk).id) != null;
    }

    protected final C readChunkHeaderAndFooter(long block, int expectedId) {
        C footer;
        C header = this.readChunkHeaderOptionally(block, expectedId);
        if (header != null && ((footer = this.readChunkFooter(block + (long)((Chunk)header).len)) == null || ((Chunk)footer).id != expectedId || ((Chunk)footer).block != ((Chunk)header).block)) {
            return null;
        }
        return header;
    }

    protected final C readChunkHeaderOptionally(long block, int expectedId) {
        C chunk = this.readChunkHeaderOptionally(block);
        return chunk == null || ((Chunk)chunk).id != expectedId ? null : (C)chunk;
    }

    protected final C readChunkHeaderOptionally(long block) {
        try {
            C chunk = this.readChunkHeader(block);
            return ((Chunk)chunk).block != block ? null : (C)chunk;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    protected final C readChunkFooter(long block) {
        long pos;
        block5: {
            pos = block * 4096L - 128L;
            if (pos >= 0L) break block5;
            return null;
        }
        try {
            ByteBuffer lastBlock = this.readFully((C)null, pos, 128);
            byte[] buff = new byte[128];
            lastBlock.get(buff);
            HashMap<String, String> m = DataUtils.parseChecksummedMap(buff);
            if (m != null) {
                C chunk = this.createChunk(m);
                if (((Chunk)chunk).block == 0L) {
                    ((Chunk)chunk).block = block - (long)((Chunk)chunk).len;
                }
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public WriteBuffer getWriteBuffer() {
        WriteBuffer buff = this.writeBufferPool.poll();
        if (buff != null) {
            buff.clear();
        } else {
            buff = new WriteBuffer();
        }
        return buff;
    }

    public void releaseWriteBuffer(WriteBuffer buff) {
        if (buff.capacity() <= 0x400000) {
            this.writeBufferPool.offer(buff);
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    protected final int getAutoCompactFillRate() {
        return this.autoCompactFillRate;
    }

    public void sync() {
    }

    public abstract int getFillRate();

    protected abstract void shrinkStoreIfPossible(int var1);

    public long size() {
        return this.size;
    }

    protected final void setSize(long size) {
        this.size = size;
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    private long getWriteBytes() {
        return this.writeBytes.get();
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getDefaultRetentionTime() {
        return 45000;
    }

    public void clear() {
        this.saveChunkLock.lock();
        try {
            this.deadChunks.clear();
            this.lastChunk = null;
            this.readCount.set(0L);
            this.readBytes.set(0L);
            this.writeCount.set(0L);
            this.writeBytes.set(0L);
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    protected final MVStore getMvStore() {
        return this.mvStore;
    }

    protected abstract void markUsed(long var1, int var3);

    public abstract void backup(ZipOutputStream var1) throws IOException;

    protected final ConcurrentMap<Integer, C> getChunks() {
        return this.chunks;
    }

    protected Collection<C> getRewriteCandidates() {
        return null;
    }

    public boolean isSpaceReused() {
        return true;
    }

    public void setReuseSpace(boolean reuseSpace) {
    }

    protected final void store() {
        this.serializationLock.unlock();
        try {
            this.mvStore.storeNow();
        }
        finally {
            this.serializationLock.lock();
        }
    }

    final void storeIt(ArrayList<Page<?, ?>> changed, long version, boolean syncWrite) throws ExecutionException {
        this.lastCommitTime = this.getTimeSinceCreation();
        this.serializationExecutorHWM = FileStore.submitOrRun(this.serializationExecutor, () -> this.serializeAndStore(syncWrite, changed, this.lastCommitTime, version), syncWrite, 3, this.serializationExecutorHWM);
    }

    private static int submitOrRun(ThreadPoolExecutor executor, Runnable action, boolean syncRun, int threshold, int hwm) throws ExecutionException {
        if (executor != null) {
            try {
                Future<?> future = executor.submit(action);
                int size = executor.getQueue().size();
                if (size > hwm) {
                    hwm = size;
                }
                if (syncRun || size > threshold) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return hwm;
            }
            catch (RejectedExecutionException ex) {
                assert (executor.isShutdown());
                Utils.shutdownExecutor(executor);
            }
        }
        action.run();
        return hwm;
    }

    private void serializeAndStore(boolean syncRun, ArrayList<Page<?, ?>> changed, long time, long version) {
        this.serializationLock.lock();
        try {
            try {
                WriteBuffer buff;
                C c;
                Chunk lastChunk = null;
                int chunkId = this.lastChunkId;
                if (chunkId != 0) {
                    lastChunk = (Chunk)this.chunks.get(chunkId &= 0x3FFFFFF);
                    assert (lastChunk != null) : this.lastChunkId + " (" + chunkId + ") " + String.valueOf(this.chunks);
                    time = Math.max(lastChunk.time, time);
                }
                try {
                    c = this.createChunk(time, version);
                    buff = this.getWriteBuffer();
                    this.serializeToBuffer(buff, changed, c, lastChunk);
                    this.chunks.put(((Chunk)c).id, c);
                }
                catch (Throwable t) {
                    this.lastChunkId = chunkId;
                    throw t;
                }
                this.bufferSaveExecutorHWM = FileStore.submitOrRun(this.bufferSaveExecutor, () -> this.storeBuffer(c, buff), syncRun, 5, this.bufferSaveExecutorHWM);
                for (Page<?, ?> p : changed) {
                    p.releaseSavedPages();
                }
            }
            catch (MVStoreException e) {
                this.mvStore.panic(e);
                this.serializationLock.unlock();
            }
            catch (Throwable e) {
                this.mvStore.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
                this.serializationLock.unlock();
            }
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    private void serializeToBuffer(WriteBuffer buff, ArrayList<Page<?, ?>> changed, C c, C previousChunk) {
        int headerLength = ((Chunk)c).estimateHeaderSize();
        buff.position(headerLength);
        ((Chunk)c).next = headerLength;
        long version = ((Chunk)c).version;
        PageSerializationManager pageSerializationManager = new PageSerializationManager(this, c, buff);
        for (Page<?, ?> p : changed) {
            String key = MVMap.getMapRootKey(p.getMapId());
            if (p.getTotalCount() == 0L) {
                this.layout.remove(key);
                continue;
            }
            p.writeUnsavedRecursive(pageSerializationManager);
            long root = p.getPos();
            this.layout.put(key, Long.toHexString(root));
        }
        this.acceptChunkOccupancyChanges(((Chunk)c).time, version);
        if (previousChunk != null && !this.layout.containsKey(Chunk.getMetaKey(((Chunk)previousChunk).id))) {
            this.saveChunkMetadataChanges(previousChunk);
        }
        RootReference<String, String> layoutRootReference = this.layout.setWriteVersion(version);
        assert (layoutRootReference != null);
        assert (layoutRootReference.version == version) : layoutRootReference.version + " != " + version;
        this.acceptChunkOccupancyChanges(((Chunk)c).time, version);
        this.mvStore.onVersionChange(version);
        Page layoutRoot = layoutRootReference.root;
        layoutRoot.writeUnsavedRecursive(pageSerializationManager);
        ((Chunk)c).layoutRootPos = layoutRoot.getPos();
        changed.add(layoutRoot);
        ((Chunk)c).mapId = this.mvStore.getLastMapId();
        ((Chunk)c).tocPos = buff.position();
        pageSerializationManager.serializeToC();
        int chunkLength = buff.position();
        int length = MathUtils.roundUpInt(chunkLength + 128, 4096);
        buff.limit(length);
        ((Chunk)c).len = buff.limit() / 4096;
        ((Chunk)c).buffer = buff.getBuffer();
    }

    private void storeBuffer(C c, WriteBuffer buff) {
        this.saveChunkLock.lock();
        try {
            try {
                if (this.closed) {
                    throw DataUtils.newMVStoreException(2, "This fileStore is closed", new Object[0]);
                }
                int headerLength = (int)((Chunk)c).next;
                this.allocateChunkSpace(c, buff);
                buff.position(0);
                ((Chunk)c).writeChunkHeader(buff, headerLength);
                buff.position(buff.limit() - 128);
                buff.put(((Chunk)c).getFooterBytes());
                buff.position(0);
                this.writeChunk(c, buff);
                this.lastChunk = c;
            }
            catch (MVStoreException e) {
                this.mvStore.panic(e);
                this.saveChunkLock.unlock();
                ((Chunk)c).buffer = null;
                this.releaseWriteBuffer(buff);
            }
            catch (Throwable e) {
                this.mvStore.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
                this.saveChunkLock.unlock();
                ((Chunk)c).buffer = null;
                this.releaseWriteBuffer(buff);
            }
        }
        finally {
            this.saveChunkLock.unlock();
            ((Chunk)c).buffer = null;
            this.releaseWriteBuffer(buff);
        }
    }

    private void acceptChunkOccupancyChanges(long time, long version) {
        assert (this.serializationLock.isHeldByCurrentThread());
        if (this.hasPersistentData()) {
            HashSet<Chunk> modifiedChunks = new HashSet<Chunk>();
            while (true) {
                RemovedPageInfo rpi;
                if ((rpi = this.removedPages.peek()) != null && rpi.version < version) {
                    rpi = this.removedPages.poll();
                    assert (rpi != null);
                    assert (rpi.version < version) : String.valueOf(rpi) + " < " + version;
                    int chunkId = rpi.getPageChunkId();
                    Chunk chunk = (Chunk)this.chunks.get(chunkId);
                    assert (!this.mvStore.isOpen() || chunk != null) : chunkId;
                    if (chunk == null) continue;
                    modifiedChunks.add(chunk);
                    if (!chunk.accountForRemovedPage(rpi.getPageNo(), rpi.getPageLength(), rpi.isPinned(), time, rpi.version)) continue;
                    this.registerDeadChunk(chunk);
                    continue;
                }
                if (modifiedChunks.isEmpty()) {
                    return;
                }
                for (Chunk chunk : modifiedChunks) {
                    this.saveChunkMetadataChanges(chunk);
                }
                modifiedChunks.clear();
            }
        }
    }

    public int getChunksFillRate() {
        return this.getChunksFillRate(true);
    }

    int getRewritableChunksFillRate() {
        return this.getChunksFillRate(false);
    }

    private int getChunksFillRate(boolean all) {
        long maxLengthSum = 1L;
        long maxLengthLiveSum = 1L;
        long time = this.getTimeSinceCreation();
        for (Chunk c : this.chunks.values()) {
            if (!all && !this.isRewritable(c, time)) continue;
            assert (c.maxLen >= 0L);
            maxLengthSum += c.maxLen;
            maxLengthLiveSum += c.maxLenLive;
        }
        int fillRate = (int)(100L * maxLengthLiveSum / maxLengthSum);
        return fillRate;
    }

    private int getChunkCount() {
        return this.chunks.size();
    }

    private int getPageCount() {
        int count = 0;
        for (Chunk chunk : this.chunks.values()) {
            count += chunk.pageCount;
        }
        return count;
    }

    private int getLivePageCount() {
        int count = 0;
        for (Chunk chunk : this.chunks.values()) {
            count += chunk.pageCountLive;
        }
        return count;
    }

    void cachePage(Page<?, ?> page) {
        if (this.cache != null) {
            this.cache.put(page.getPos(), page, page.getMemory());
        }
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() >> 20);
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() >> 20);
    }

    public void setCacheSize(int mb) {
        long bytes = (long)mb * 1024L * 1024L;
        if (this.cache != null) {
            this.cache.setMaxMemory(bytes);
            this.cache.clear();
        }
    }

    void cacheToC(C chunk, long[] toc) {
        this.chunksToC.put(((Chunk)chunk).id, toc, (long)toc.length * 8L + 24L);
    }

    private long[] cleanToCCache(C chunk) {
        return this.chunksToC.remove(((Chunk)chunk).id);
    }

    public void populateInfo(BiConsumer<String, String> consumer) {
        consumer.accept("info.FILE_WRITE", Long.toString(this.getWriteCount()));
        consumer.accept("info.FILE_WRITE_BYTES", Long.toString(this.getWriteBytes()));
        consumer.accept("info.FILE_READ", Long.toString(this.getReadCount()));
        consumer.accept("info.FILE_READ_BYTES", Long.toString(this.getReadBytes()));
        consumer.accept("info.FILL_RATE", Integer.toString(this.getFillRate()));
        consumer.accept("info.CHUNKS_FILL_RATE", Integer.toString(this.getChunksFillRate()));
        consumer.accept("info.CHUNKS_FILL_RATE_RW", Integer.toString(this.getRewritableChunksFillRate()));
        consumer.accept("info.FILE_SIZE", Long.toString(this.size()));
        consumer.accept("info.CHUNK_COUNT", Long.toString(this.getChunkCount()));
        consumer.accept("info.PAGE_COUNT", Long.toString(this.getPageCount()));
        consumer.accept("info.PAGE_COUNT_LIVE", Long.toString(this.getLivePageCount()));
        consumer.accept("info.PAGE_SIZE", Long.toString(this.getMaxPageSize()));
        consumer.accept("info.CACHE_MAX_SIZE", Integer.toString(this.getCacheSize()));
        consumer.accept("info.CACHE_SIZE", Integer.toString(this.getCacheSizeUsed()));
        consumer.accept("info.CACHE_HIT_RATIO", Integer.toString(this.getCacheHitRatio()));
        consumer.accept("info.TOC_CACHE_HIT_RATIO", Integer.toString(this.getTocCacheHitRatio()));
    }

    public int getCacheHitRatio() {
        return FileStore.getCacheHitRatio(this.cache);
    }

    public int getTocCacheHitRatio() {
        return FileStore.getCacheHitRatio(this.chunksToC);
    }

    private static int getCacheHitRatio(CacheLongKeyLIRS<?> cache) {
        if (cache == null) {
            return 0;
        }
        long hits = cache.getHits();
        return (int)(100L * hits / (hits + cache.getMisses() + 1L));
    }

    boolean isBackgroundThread() {
        return Thread.currentThread() == this.backgroundWriterThread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread(boolean waitForIt) {
        BackgroundWriterThread t;
        while ((t = this.backgroundWriterThread.get()) != null) {
            if (!this.backgroundWriterThread.compareAndSet(t, null)) continue;
            if (t != Thread.currentThread()) {
                Object object = t.sync;
                synchronized (object) {
                    t.sync.notifyAll();
                }
                if (waitForIt) {
                    try {
                        t.join();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.shutdownExecutors();
            break;
        }
    }

    private void shutdownExecutors() {
        Utils.shutdownExecutor(this.serializationExecutor);
        this.serializationExecutor = null;
        Utils.shutdownExecutor(this.bufferSaveExecutor);
        this.bufferSaveExecutor = null;
    }

    private Iterable<C> findOldChunks(int writeLimit, int targetFillRate) {
        assert (this.hasPersistentData());
        long time = this.getTimeSinceCreation();
        PriorityQueue<Chunk> queue = new PriorityQueue<Chunk>(this.chunks.size() / 4 + 1, (o1, o2) -> {
            int comp = Integer.compare(o2.collectPriority, o1.collectPriority);
            if (comp == 0) {
                comp = Long.compare(o2.maxLenLive, o1.maxLenLive);
            }
            return comp;
        });
        long totalSize = 0L;
        long latestVersion = this.lastChunkVersion() + 1L;
        Collection<C> candidates = this.getRewriteCandidates();
        if (candidates == null) {
            candidates = this.chunks.values();
        }
        block0: for (Chunk chunk : candidates) {
            int fillRate = chunk.getFillRate();
            if (!this.isRewritable(chunk, time) || fillRate > targetFillRate) continue;
            long age = Math.max(1L, latestVersion - chunk.version);
            chunk.collectPriority = (int)((long)(fillRate * 1000) / age);
            totalSize += chunk.maxLenLive;
            queue.offer(chunk);
            while (totalSize > (long)writeLimit) {
                Chunk removed = (Chunk)queue.poll();
                if (removed == null) continue block0;
                totalSize -= removed.maxLenLive;
            }
        }
        return queue.isEmpty() ? null : queue;
    }

    void writeInBackground() {
        block5: {
            try {
                if (this.mvStore.isOpen() && !this.isReadOnly()) {
                    long time = this.getTimeSinceCreation();
                    if (time > this.lastCommitTime + (long)this.autoCommitDelay) {
                        this.mvStore.tryCommit();
                    }
                    this.doHousekeeping(this.mvStore);
                    this.autoCompactLastFileOpCount = this.getWriteCount() + this.getReadCount() + 10L;
                }
            }
            catch (InterruptedException time) {
            }
            catch (Throwable e) {
                if (this.mvStore.handleException(e)) break block5;
                throw e;
            }
        }
    }

    protected boolean rewriteChunks(int writeLimit, int targetFillRate) {
        this.serializationLock.lock();
        try {
            MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
            try {
                this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.mvStore.getCurrentVersion());
                Iterable<C> old = this.findOldChunks(writeLimit, targetFillRate);
                if (old != null) {
                    HashSet<Integer> idSet = FileStore.createIdSet(old);
                    boolean bl = !idSet.isEmpty() && this.compactRewrite(idSet) > 0;
                    return bl;
                }
            }
            finally {
                this.mvStore.deregisterVersionUsage(txCounter);
            }
            {
            }
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    private static <C extends Chunk<C>> HashSet<Integer> createIdSet(Iterable<C> toCompact) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Chunk c : toCompact) {
            set.add(c.id);
        }
        return set;
    }

    public void executeFileStoreOperation(Runnable operation) {
        Utils.flushExecutor(this.serializationExecutor);
        this.serializationLock.lock();
        try {
            Utils.flushExecutor(this.bufferSaveExecutor);
            operation.run();
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    private int compactRewrite(Set<Integer> set) {
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.mvStore.getCurrentVersion());
        int rewrittenPageCount = this.rewriteChunks(set, false);
        this.acceptChunkOccupancyChanges(this.getTimeSinceCreation(), this.mvStore.getCurrentVersion());
        return rewrittenPageCount += this.rewriteChunks(set, true);
    }

    private int rewriteChunks(Set<Integer> set, boolean secondPass) {
        int rewrittenPageCount = 0;
        for (int chunkId : set) {
            long[] toc;
            Chunk chunk = (Chunk)this.chunks.get(chunkId);
            if (chunk == null || (toc = this.getToC(chunk)) == null) continue;
            int pageNo = 0;
            while ((pageNo = chunk.occupancy.nextClearBit(pageNo)) < chunk.pageCount) {
                MVMap<String, String> map;
                long tocElement = toc[pageNo];
                int mapId = DataUtils.getPageMapId(tocElement);
                MVMap<String, String> metaMap = this.mvStore.getMetaMap();
                MVMap<String, String> mVMap = mapId == this.layout.getId() ? this.layout : (map = mapId == metaMap.getId() ? metaMap : this.mvStore.getMap(mapId));
                if (map != null && !map.isClosed()) {
                    assert (!map.isSingleWriter());
                    if (secondPass || DataUtils.isLeafPosition(tocElement)) {
                        long pagePos = DataUtils.composePagePos(chunkId, tocElement);
                        this.serializationLock.unlock();
                        try {
                            if (map.rewritePage(pagePos)) {
                                ++rewrittenPageCount;
                                if (mapId == metaMap.getId()) {
                                    this.mvStore.markMetaChanged();
                                }
                            }
                        }
                        finally {
                            this.serializationLock.lock();
                        }
                    }
                }
                ++pageNo;
            }
        }
        return rewrittenPageCount;
    }

    <K, V> Page<K, V> readPage(MVMap<K, V> map, long pos) {
        try {
            if (!DataUtils.isPageSaved(pos)) {
                throw DataUtils.newMVStoreException(6, "Position 0", new Object[0]);
            }
            Page<K, V> page = this.readPageFromCache(pos);
            if (page == null) {
                MVStoreException exception;
                boolean alreadySaved;
                C chunk = this.getChunk(pos);
                int pageOffset = DataUtils.getPageOffset(pos);
                do {
                    exception = null;
                    ByteBuffer buff = ((Chunk)chunk).buffer;
                    boolean bl = alreadySaved = buff == null;
                    if (alreadySaved) {
                        buff = ((Chunk)chunk).readBufferForPage(this, pageOffset, pos);
                    } else {
                        buff = buff.duplicate();
                        buff.position(pageOffset);
                        buff = buff.slice();
                    }
                    try {
                        page = Page.read(buff, pos, map);
                    }
                    catch (MVStoreException e) {
                        exception = e;
                    }
                    catch (Exception e) {
                        exception = DataUtils.newMVStoreException(6, "Unable to read the page at position 0x{0}, chunk {1}, offset 0x{3}", Long.toHexString(pos), chunk, Long.toHexString(pageOffset), e);
                    }
                } while (!alreadySaved);
                if (exception != null) {
                    throw exception;
                }
                this.cachePage(page);
            }
            return page;
        }
        catch (MVStoreException e) {
            if (this.recoveryMode) {
                return map.createEmptyLeaf();
            }
            throw e;
        }
    }

    private C getChunk(long pos) {
        int chunkId = DataUtils.getPageChunkId(pos);
        Chunk c = (Chunk)this.chunks.get(chunkId);
        if (c == null) {
            String s = this.layout.get(Chunk.getMetaKey(chunkId));
            if (s == null) {
                throw DataUtils.newMVStoreException(9, "Chunk {0} not found", chunkId);
            }
            c = this.createChunk(s);
            if (!c.isSaved()) {
                throw DataUtils.newMVStoreException(6, "Chunk {0} is invalid", chunkId);
            }
            this.chunks.put(c.id, c);
        }
        return (C)c;
    }

    private int calculatePageNo(long pos) {
        int pageNo = -1;
        C chunk = this.getChunk(pos);
        long[] toC = this.getToC(chunk);
        if (toC != null) {
            int offset = DataUtils.getPageOffset(pos);
            int low = 0;
            int high = toC.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                long midVal = DataUtils.getPageOffset(toC[mid]);
                if (midVal < (long)offset) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > (long)offset) {
                    high = mid - 1;
                    continue;
                }
                pageNo = mid;
                break;
            }
        }
        return pageNo;
    }

    private void clearCaches() {
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.chunksToC != null) {
            this.chunksToC.clear();
        }
        this.removedPages.clear();
    }

    private long[] getToC(C chunk) {
        if (((Chunk)chunk).tocPos == 0) {
            return null;
        }
        long[] toc = this.chunksToC.get(((Chunk)chunk).id);
        if (toc == null) {
            toc = ((Chunk)chunk).readToC(this);
            this.cacheToC(chunk, toc);
        }
        assert (toc.length == ((Chunk)chunk).pageCount) : toc.length + " != " + ((Chunk)chunk).pageCount;
        return toc;
    }

    private <K, V> Page<K, V> readPageFromCache(long pos) {
        return this.cache == null ? null : this.cache.get(pos);
    }

    public void accountForRemovedPage(long pos, long version, boolean pinned, int pageNo) {
        assert (DataUtils.isPageSaved(pos));
        if (pageNo < 0) {
            pageNo = this.calculatePageNo(pos);
        }
        RemovedPageInfo rpi = new RemovedPageInfo(pos, pinned, version, pageNo);
        this.removedPages.add(rpi);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final FileStore<?> store;
        private final int sleep;

        BackgroundWriterThread(FileStore<?> store, int sleep, String fileStoreName) {
            super("MVStore background writer " + fileStoreName);
            this.store = store;
            this.sleep = sleep;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.store.isBackgroundThread()) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.store.isBackgroundThread()) break;
                this.store.writeInBackground();
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class PageSerializationManager {
        private final C chunk;
        private final WriteBuffer buff;
        private final List<Long> toc = new ArrayList<Long>();
        final /* synthetic */ FileStore this$0;

        PageSerializationManager(C chunk, WriteBuffer buff) {
            this.this$0 = var1_1;
            this.chunk = chunk;
            this.buff = buff;
        }

        public WriteBuffer getBuffer() {
            return this.buff;
        }

        private int getChunkId() {
            return ((Chunk)this.chunk).id;
        }

        public int getPageNo() {
            return this.toc.size();
        }

        public long getPagePosition(int mapId, int offset, int pageLength, int type) {
            long tocElement = DataUtils.composeTocElement(mapId, offset, pageLength, type);
            this.toc.add(tocElement);
            long pagePos = DataUtils.composePagePos(((Chunk)this.chunk).id, tocElement);
            int chunkId = this.getChunkId();
            int check = DataUtils.getCheckValue(chunkId) ^ DataUtils.getCheckValue(offset) ^ DataUtils.getCheckValue(pageLength);
            this.buff.putInt(offset, pageLength).putShort(offset + 4, (short)check);
            return pagePos;
        }

        public void onPageSerialized(Page<?, ?> page, boolean isDeleted, int diskSpaceUsed, boolean isPinned) {
            this.this$0.cachePage(page);
            if (!page.isLeaf()) {
                this.this$0.cachePage(page);
            }
            ((Chunk)this.chunk).accountForWrittenPage(diskSpaceUsed, isPinned);
            if (isDeleted) {
                this.this$0.accountForRemovedPage(page.getPos(), ((Chunk)this.chunk).version + 1L, isPinned, page.pageNo);
            }
        }

        public void serializeToC() {
            long[] tocArray = new long[this.toc.size()];
            int index = 0;
            for (long tocElement : this.toc) {
                tocArray[index++] = tocElement;
                this.buff.putLong(tocElement);
                this.this$0.mvStore.countNewPage(DataUtils.isLeafPosition(tocElement));
            }
            this.this$0.cacheToC(this.chunk, tocArray);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class RemovedPageInfo
    implements Comparable<RemovedPageInfo> {
        final long version;
        final long removedPageInfo;

        RemovedPageInfo(long pagePos, boolean pinned, long version, int pageNo) {
            this.removedPageInfo = RemovedPageInfo.createRemovedPageInfo(pagePos, pinned, pageNo);
            this.version = version;
        }

        @Override
        public int compareTo(RemovedPageInfo other) {
            return Long.compare(this.version, other.version);
        }

        int getPageChunkId() {
            return DataUtils.getPageChunkId(this.removedPageInfo);
        }

        int getPageNo() {
            return DataUtils.getPageOffset(this.removedPageInfo);
        }

        int getPageLength() {
            return DataUtils.getPageMaxLength(this.removedPageInfo);
        }

        boolean isPinned() {
            return (this.removedPageInfo & 1L) == 1L;
        }

        private static long createRemovedPageInfo(long pagePos, boolean isPinned, int pageNo) {
            assert (pageNo >= 0);
            assert (pageNo >> 26 == 0);
            long result = pagePos & 0xFFFFFFC00000003EL | (long)pageNo << 6;
            if (isPinned) {
                result |= 1L;
            }
            return result;
        }

        public String toString() {
            return "RemovedPageInfo{version=" + this.version + ", chunk=" + this.getPageChunkId() + ", pageNo=" + this.getPageNo() + ", len=" + this.getPageLength() + (this.isPinned() ? ", pinned" : "") + "}";
        }
    }
}

