/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.Map;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class MFChunk
extends Chunk<MFChunk> {
    private static final String ATTR_VOLUME = "vol";
    public volatile int volumeId;

    MFChunk(int id) {
        super(id);
    }

    MFChunk(String line) {
        super(line);
    }

    MFChunk(Map<String, String> map) {
        super(map, false);
        this.volumeId = DataUtils.readHexInt(map, ATTR_VOLUME, 0);
    }

    @Override
    protected ByteBuffer readFully(FileStore<MFChunk> fileStore, long filePos, int length) {
        return fileStore.readFully(this, filePos, length);
    }

    @Override
    protected void dump(StringBuilder buff) {
        super.dump(buff);
        if (this.volumeId != 0) {
            DataUtils.appendMap(buff, ATTR_VOLUME, this.volumeId);
        }
    }
}

