/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import org.h2.compress.CompressDeflate;
import org.h2.compress.CompressLZF;
import org.h2.compress.Compressor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.MVStoreTool;
import org.h2.mvstore.Page;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.SingleFileStore;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FileUtils;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class MVStore
implements AutoCloseable {
    private static final int STATE_OPEN = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_CLOSED = 2;
    static final long INITIAL_VERSION = -1L;
    private final ReentrantLock storeLock = new ReentrantLock(true);
    private final AtomicBoolean storeOperationInProgress = new AtomicBoolean();
    private volatile int state;
    private final FileStore<?> fileStore;
    private final boolean fileStoreShallBeClosed;
    private final int keysPerPage;
    private long updateCounter = 0L;
    private long updateAttemptCounter = 0L;
    private final MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private final AtomicInteger lastMapId = new AtomicInteger();
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    public final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private volatile long currentVersion;
    private final AtomicLong oldestVersionToKeep = new AtomicLong();
    private final Deque<TxCounter> versions = new LinkedList<TxCounter>();
    private volatile TxCounter currentTxCounter = new TxCounter(this.currentVersion);
    private int unsavedMemory;
    private final int autoCommitMemory;
    private volatile boolean saveNeeded;
    private volatile boolean metaChanged;
    private volatile MVStoreException panicException;
    private long lastTimeAbsolute;
    private long leafCount;
    private long nonLeafCount;
    private volatile LongConsumer oldestVersionTracker;

    MVStore(Map<String, Object> config) {
        this.compressionLevel = DataUtils.getConfigParam(config, "compress", 0);
        String fileName = (String)config.get("fileName");
        FileStore fileStore = (FileStore)config.get("fileStore");
        boolean fileStoreShallBeOpen = false;
        if (fileStore == null) {
            if (fileName != null) {
                fileStore = new SingleFileStore(config);
                fileStoreShallBeOpen = true;
            }
            this.fileStoreShallBeClosed = true;
        } else {
            if (fileName != null) {
                throw new IllegalArgumentException("fileName && fileStore");
            }
            Boolean fileStoreIsAdopted = (Boolean)config.get("fileStoreIsAdopted");
            this.fileStoreShallBeClosed = fileStoreIsAdopted != null && fileStoreIsAdopted != false;
        }
        this.fileStore = fileStore;
        this.keysPerPage = DataUtils.getConfigParam(config, "keysPerPage", 48);
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)config.get("backgroundExceptionHandler");
        if (fileStore != null) {
            MVMap<String, String> metaMap;
            block15: {
                int kb = Math.max(1, Math.min(19, Utils.scaleForAvailableMemory(64))) * 1024;
                kb = DataUtils.getConfigParam(config, "autoCommitBufferSize", kb);
                this.autoCommitMemory = kb * 1024;
                char[] encryptionKey = (char[])config.remove("encryptionKey");
                metaMap = null;
                this.storeLock.lock();
                try {
                    try {
                        if (fileStoreShallBeOpen) {
                            boolean readOnly = config.containsKey("readOnly");
                            fileStore.open(fileName, readOnly, encryptionKey);
                        }
                        fileStore.bind(this);
                        metaMap = fileStore.start();
                    }
                    catch (MVStoreException e) {
                        this.panic(e);
                        if (encryptionKey != null) {
                            Arrays.fill(encryptionKey, '\u0000');
                        }
                        this.unlockAndCheckPanicCondition();
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (encryptionKey != null) {
                        Arrays.fill(encryptionKey, '\u0000');
                    }
                    this.unlockAndCheckPanicCondition();
                    throw throwable;
                }
                if (encryptionKey != null) {
                    Arrays.fill(encryptionKey, '\u0000');
                }
                this.unlockAndCheckPanicCondition();
            }
            this.meta = metaMap;
            this.scrubMetaMap();
            int delay = DataUtils.getConfigParam(config, "autoCommitDelay", 1000);
            this.setAutoCommitDelay(delay);
        } else {
            this.autoCommitMemory = 0;
            this.meta = this.openMetaMap();
        }
        this.onVersionChange(this.currentVersion);
    }

    public MVMap<String, String> openMetaMap() {
        int metaId = this.fileStore != null ? this.fileStore.getMetaMapId(this::getNextMapId) : 1;
        MVMap<String, String> map = new MVMap<String, String>(this, metaId, StringDataType.INSTANCE, StringDataType.INSTANCE);
        map.setRootPos(this.getRootPos(map.getId()), this.currentVersion);
        return map;
    }

    private void scrubMetaMap() {
        String mapName;
        Object key;
        HashSet<Object> keysToRemove = new HashSet<Object>();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext()) {
            int mapId;
            String realMapName;
            key = iterator.next();
            if (!((String)key).startsWith("name.")) break;
            mapName = ((String)key).substring("name.".length());
            if (mapName.equals(realMapName = this.getMapName(mapId = DataUtils.parseHexInt(this.meta.get(key))))) continue;
            keysToRemove.add(key);
        }
        for (String string : keysToRemove) {
            this.meta.remove(string);
            this.markMetaChanged();
        }
        Iterator<String> iterator2 = this.meta.keyIterator("map.");
        while (iterator2.hasNext()) {
            key = iterator2.next();
            if (!((String)key).startsWith("map.")) break;
            mapName = DataUtils.getMapName(this.meta.get(key));
            String mapIdStr = ((String)key).substring("map.".length());
            this.adjustLastMapId(DataUtils.parseHexInt(mapIdStr));
            if (mapIdStr.equals(this.meta.get("name." + mapName))) continue;
            this.meta.put("name." + mapName, mapIdStr);
            this.markMetaChanged();
        }
    }

    private void unlockAndCheckPanicCondition() {
        this.storeLock.unlock();
        MVStoreException exception = this.getPanicException();
        if (exception != null) {
            this.closeImmediately();
            throw exception;
        }
    }

    public void panic(MVStoreException e) {
        if (this.isOpen()) {
            this.handleException(e);
            this.panicException = e;
        }
        throw e;
    }

    public MVStoreException getPanicException() {
        return this.panicException;
    }

    public static MVStore open(String fileName) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("fileName", fileName);
        return new MVStore(config);
    }

    public <K, V> MVMap<K, V> openMap(String name) {
        return this.openMap(name, new MVMap.Builder());
    }

    public <M extends MVMap<K, V>, K, V> M openMap(String name, MVMap.MapBuilder<M, K, V> builder) {
        int id = this.getMapId(name);
        if (id >= 0) {
            MVMap<K, V> map = this.getMap(id);
            if (map == null) {
                map = this.openMap(id, builder);
            }
            assert (builder.getKeyType() == null || map.getKeyType().getClass().equals(builder.getKeyType().getClass()));
            assert (builder.getValueType() == null || map.getValueType().getClass().equals(builder.getValueType().getClass()));
            return (M)map;
        }
        HashMap<String, Object> c = new HashMap<String, Object>();
        id = this.getNextMapId();
        assert (this.getMap(id) == null);
        c.put("id", id);
        long curVersion = this.currentVersion;
        c.put("createVersion", curVersion);
        Object map = builder.create(this, c);
        String x = Integer.toHexString(id);
        this.meta.put(MVMap.getMapKey(id), ((MVMap)map).asString(name));
        String existing = this.meta.putIfAbsent("name." + name, x);
        if (existing != null) {
            this.meta.remove(MVMap.getMapKey(id));
            return this.openMap(name, builder);
        }
        ((MVMap)map).setRootPos(0L, curVersion);
        this.markMetaChanged();
        MVMap<?, ?> existingMap = this.maps.putIfAbsent(id, (MVMap<?, ?>)map);
        if (existingMap != null) {
            map = existingMap;
        }
        return map;
    }

    public <M extends MVMap<K, V>, K, V> M openMap(int id, MVMap.MapBuilder<M, K, V> builder) {
        MVMap<K, V> map;
        while ((map = this.getMap(id)) == null) {
            String configAsString = this.meta.get(MVMap.getMapKey(id));
            DataUtils.checkArgument(configAsString != null, "Missing map with id {0}", id);
            HashMap<String, Object> config = new HashMap<String, Object>(DataUtils.parseMap(configAsString));
            config.put("id", (String)((Object)Integer.valueOf(id)));
            map = builder.create(this, config);
            long root = this.getRootPos(id);
            map.setRootPos(root, this.currentVersion);
            if (this.maps.putIfAbsent(id, map) == null) break;
        }
        return (M)map;
    }

    public <K, V> MVMap<K, V> getMap(int id) {
        this.checkNotClosed();
        MVMap<?, ?> map = this.maps.get(id);
        return map;
    }

    public Set<String> getMapNames() {
        HashSet<String> set = new HashSet<String>();
        this.checkNotClosed();
        Iterator<String> it = this.meta.keyIterator("name.");
        while (it.hasNext()) {
            String x = it.next();
            if (!x.startsWith("name.")) break;
            String mapName = x.substring("name.".length());
            set.add(mapName);
        }
        return set;
    }

    public Map<String, String> getLayoutMap() {
        return this.fileStore == null ? null : this.fileStore.getLayoutMap();
    }

    private boolean isRegularMap(MVMap<?, ?> map) {
        return map != this.meta && (this.fileStore == null || this.fileStore.isRegularMap(map));
    }

    public MVMap<String, String> getMetaMap() {
        this.checkNotClosed();
        return this.meta;
    }

    public boolean hasMap(String name) {
        return this.meta.containsKey("name." + name);
    }

    public boolean hasData(String name) {
        return this.hasMap(name) && this.getRootPos(this.getMapId(name)) != 0L;
    }

    void markMetaChanged() {
        this.metaChanged = true;
    }

    int getLastMapId() {
        return this.lastMapId.get();
    }

    private int getNextMapId() {
        return this.lastMapId.incrementAndGet();
    }

    void adjustLastMapId(int mapId) {
        if (mapId > this.lastMapId.get()) {
            this.lastMapId.set(mapId);
        }
    }

    void resetLastMapId(int mapId) {
        this.lastMapId.set(mapId);
    }

    @Override
    public void close() {
        this.closeStore(true, 0);
    }

    public void close(int allowedCompactionTime) {
        if (!this.isClosed()) {
            if (this.fileStore != null) {
                boolean compactFully;
                boolean bl = compactFully = allowedCompactionTime == -1;
                if (this.fileStore.isReadOnly()) {
                    compactFully = false;
                } else {
                    this.commit();
                }
                if (compactFully) {
                    allowedCompactionTime = 0;
                }
                this.closeStore(true, allowedCompactionTime);
                String fileName = this.fileStore.getFileName();
                if (compactFully && FileUtils.exists(fileName)) {
                    MVStoreTool.compact(fileName, true);
                }
            } else {
                this.close();
            }
        }
    }

    public void closeImmediately() {
        try {
            this.closeStore(false, 0);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    private void closeStore(boolean normalShutdown, int allowedCompactionTime) {
        while (!this.isClosed()) {
            this.setAutoCommitDelay(-1);
            this.setOldestVersionTracker(null);
            this.storeLock.lock();
            try {
                if (this.state != 0) continue;
                this.state = 1;
                try {
                    try {
                        if (normalShutdown && this.fileStore != null && !this.fileStore.isReadOnly()) {
                            for (MVMap<?, ?> map : this.maps.values()) {
                                if (!map.isClosed()) continue;
                                this.fileStore.deregisterMapRoot(map.getId());
                            }
                            this.setRetentionTime(0);
                            this.commit();
                            assert (this.oldestVersionToKeep.get() == this.currentVersion) : this.oldestVersionToKeep.get() + " != " + this.currentVersion;
                            this.fileStore.stop(allowedCompactionTime);
                        }
                        if (this.meta != null) {
                            this.meta.close();
                        }
                        for (MVMap<?, ?> m : new ArrayList(this.maps.values())) {
                            m.close();
                        }
                        this.maps.clear();
                    }
                    finally {
                        if (this.fileStore != null && this.fileStoreShallBeClosed) {
                            this.fileStore.close();
                        }
                    }
                }
                finally {
                    this.state = 2;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    public boolean isPersistent() {
        return this.fileStore != null;
    }

    public long tryCommit() {
        return this.tryCommit(x -> true);
    }

    private long tryCommit(Predicate<MVStore> check) {
        if (this.canStartStoreOperation() && this.storeLock.tryLock()) {
            try {
                if (check.test(this)) {
                    long l = this.store(false);
                    return l;
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
        return -1L;
    }

    public long commit() {
        return this.commit(x -> true);
    }

    private long commit(Predicate<MVStore> check) {
        if (this.canStartStoreOperation()) {
            this.storeLock.lock();
            try {
                if (check.test(this)) {
                    long l = this.store(true);
                    return l;
                }
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
        return -1L;
    }

    private boolean canStartStoreOperation() {
        return !this.storeLock.isHeldByCurrentThread() || !this.storeOperationInProgress.get();
    }

    private long store(boolean syncWrite) {
        assert (this.storeLock.isHeldByCurrentThread());
        if (this.isOpenOrStopping() && this.hasUnsavedChanges() && this.storeOperationInProgress.compareAndSet(false, true)) {
            try {
                long result = ++this.currentVersion;
                if (this.fileStore == null) {
                    this.setWriteVersion(this.currentVersion);
                } else {
                    if (this.fileStore.isReadOnly()) {
                        throw DataUtils.newMVStoreException(2, "This store is read-only", new Object[0]);
                    }
                    this.fileStore.dropUnusedChunks();
                    this.storeNow(syncWrite);
                }
                long l = result;
                return l;
            }
            finally {
                this.storeOperationInProgress.set(false);
            }
        }
        return -1L;
    }

    private void setWriteVersion(long version) {
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map = iter.next();
            assert (this.isRegularMap(map));
            if (map.setWriteVersion(version) != null) continue;
            iter.remove();
        }
        this.meta.setWriteVersion(version);
        this.onVersionChange(version);
    }

    void storeNow() {
        ++this.currentVersion;
        this.storeNow(true);
    }

    private void storeNow(boolean syncWrite) {
        try {
            int currentUnsavedMemory = this.unsavedMemory;
            long version = this.currentVersion;
            assert (this.storeLock.isHeldByCurrentThread());
            this.fileStore.storeIt(this.collectChangedMapRoots(version), version, syncWrite);
            this.saveNeeded = false;
            this.unsavedMemory = Math.max(0, this.unsavedMemory - currentUnsavedMemory);
        }
        catch (MVStoreException e) {
            this.panic(e);
        }
        catch (Throwable e) {
            this.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
        }
    }

    private ArrayList<Page<?, ?>> collectChangedMapRoots(long version) {
        long lastStoredVersion = version - 2L;
        ArrayList changed = new ArrayList();
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map = iter.next();
            RootReference<?, ?> rootReference = map.setWriteVersion(version);
            if (rootReference == null) {
                iter.remove();
                continue;
            }
            if (map.getCreateVersion() >= version || map.isVolatile() || !map.hasChangesSince(lastStoredVersion)) continue;
            assert (rootReference.version <= version) : rootReference.version + " > " + version;
            changed.add(rootReference.root);
        }
        RootReference<String, String> rootReference = this.meta.setWriteVersion(version);
        if (this.meta.hasChangesSince(lastStoredVersion) || this.metaChanged) {
            assert (rootReference != null && rootReference.version <= version) : rootReference == null ? "null" : rootReference.version + " > " + version;
            changed.add(rootReference.root);
        }
        return changed;
    }

    public long getTimeAbsolute() {
        long now = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && now < this.lastTimeAbsolute) {
            now = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = now;
        }
        return now;
    }

    public boolean hasUnsavedChanges() {
        if (this.metaChanged) {
            return true;
        }
        long lastStoredVersion = this.currentVersion - 1L;
        for (MVMap<?, ?> m : this.maps.values()) {
            if (m.isClosed() || !m.hasChangesSince(lastStoredVersion)) continue;
            return true;
        }
        return this.fileStore != null && this.fileStore.hasChangesSince(lastStoredVersion);
    }

    public void executeFilestoreOperation(Runnable operation) {
        this.storeLock.lock();
        try {
            try {
                this.checkNotClosed();
                this.fileStore.executeFileStoreOperation(operation);
            }
            catch (MVStoreException e) {
                this.panic(e);
                this.unlockAndCheckPanicCondition();
            }
            catch (Throwable e) {
                this.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
                this.unlockAndCheckPanicCondition();
            }
        }
        finally {
            this.unlockAndCheckPanicCondition();
        }
    }

    <R> R tryExecuteUnderStoreLock(Callable<R> operation) throws InterruptedException {
        R result;
        block8: {
            result = null;
            if (this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                try {
                    result = operation.call();
                }
                catch (MVStoreException e) {
                    this.panic(e);
                    this.unlockAndCheckPanicCondition();
                    break block8;
                }
                catch (Throwable e) {
                    try {
                        this.panic(DataUtils.newMVStoreException(3, "{0}", e.toString(), e));
                        break block8;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.unlockAndCheckPanicCondition();
                    }
                }
                this.unlockAndCheckPanicCondition();
            }
        }
        return result;
    }

    public void sync() {
        this.checkOpen();
        FileStore<?> f = this.fileStore;
        if (f != null) {
            f.sync();
        }
    }

    public void compactFile(int maxCompactTime) {
        if (this.fileStore != null) {
            this.setRetentionTime(0);
            this.storeLock.lock();
            try {
                this.fileStore.compactStore(maxCompactTime);
            }
            finally {
                this.unlockAndCheckPanicCondition();
            }
        }
    }

    public boolean compact(int targetFillRate, int write) {
        this.checkOpen();
        return this.fileStore != null && this.fileStore.compact(targetFillRate, write);
    }

    public int getFillRate() {
        return this.fileStore.getFillRate();
    }

    <K, V> Page<K, V> readPage(MVMap<K, V> map, long pos) {
        this.checkNotClosed();
        return this.fileStore.readPage(map, pos);
    }

    void accountForRemovedPage(long pos, long version, boolean pinned, int pageNo) {
        this.fileStore.accountForRemovedPage(pos, version, pinned, pageNo);
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getKeysPerPage() {
        return this.keysPerPage;
    }

    public long getMaxPageSize() {
        return this.fileStore == null ? Long.MAX_VALUE : this.fileStore.getMaxPageSize();
    }

    public int getCacheSize() {
        return this.fileStore == null ? 0 : this.fileStore.getCacheSize();
    }

    public int getCacheSizeUsed() {
        return this.fileStore == null ? 0 : this.fileStore.getCacheSizeUsed();
    }

    public void setCacheSize(int kb) {
        if (this.fileStore != null) {
            this.fileStore.setCacheSize(Math.max(1, kb / 1024));
        }
    }

    public boolean isSpaceReused() {
        return this.fileStore.isSpaceReused();
    }

    public void setReuseSpace(boolean reuseSpace) {
        this.fileStore.setReuseSpace(reuseSpace);
    }

    public int getRetentionTime() {
        return this.fileStore == null ? 0 : this.fileStore.getRetentionTime();
    }

    public void setRetentionTime(int ms) {
        if (this.fileStore != null) {
            this.fileStore.setRetentionTime(ms);
        }
    }

    public boolean isVersioningRequired() {
        return this.fileStore != null && !this.fileStore.isReadOnly() || this.versionsToKeep > 0;
    }

    public void setVersionsToKeep(int count) {
        this.versionsToKeep = count;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        return Math.min(this.oldestVersionToKeep.get(), Math.max(this.currentVersion - (long)this.versionsToKeep, -1L));
    }

    private void setOldestVersionToKeep(long version) {
        long current;
        boolean success;
        while (!(success = version <= (current = this.oldestVersionToKeep.get()) || this.oldestVersionToKeep.compareAndSet(current, version))) {
        }
        assert (version <= this.currentVersion) : version + " <= " + this.currentVersion;
        if (this.oldestVersionTracker != null) {
            this.oldestVersionTracker.accept(version);
        }
    }

    public void setOldestVersionTracker(LongConsumer callback) {
        this.oldestVersionTracker = callback;
    }

    private boolean isKnownVersion(long version) {
        long curVersion = this.getCurrentVersion();
        if (version > curVersion || version < 0L) {
            return false;
        }
        if (version == curVersion) {
            return true;
        }
        return this.fileStore == null || this.fileStore.isKnownVersion(version);
    }

    public void registerUnsavedMemory(int memory) {
        assert (this.fileStore != null);
        this.unsavedMemory += memory;
        if (this.needStore()) {
            this.saveNeeded = true;
        }
    }

    void registerUnsavedMemoryAndCommitIfNeeded(int memory) {
        this.registerUnsavedMemory(memory);
        if (this.saveNeeded) {
            this.commit();
        }
    }

    void beforeWrite(MVMap<?, ?> map) {
        if (this.saveNeeded && this.isOpenOrStopping() && (this.storeLock.isHeldByCurrentThread() || !map.getRoot().isLockedByCurrentThread()) && this.fileStore.isRegularMap(map)) {
            this.saveNeeded = false;
            if (this.needStore()) {
                if (this.requireStore() && !map.isSingleWriter()) {
                    this.commit(MVStore::requireStore);
                } else {
                    this.tryCommit(MVStore::needStore);
                }
            }
        }
    }

    private boolean requireStore() {
        return 3 * this.unsavedMemory > 4 * this.autoCommitMemory;
    }

    private boolean needStore() {
        return this.autoCommitMemory > 0 && this.fileStore.shouldSaveNow(this.unsavedMemory, this.autoCommitMemory);
    }

    public int getStoreVersion() {
        this.checkOpen();
        String x = this.meta.get("setting.storeVersion");
        return x == null ? 0 : DataUtils.parseHexInt(x);
    }

    public void setStoreVersion(int version) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            this.markMetaChanged();
            this.meta.put("setting.storeVersion", Integer.toHexString(version));
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    public void rollbackTo(long version) {
        this.storeLock.lock();
        try {
            TxCounter txCounter;
            this.currentVersion = version;
            this.checkOpen();
            DataUtils.checkArgument(this.isKnownVersion(version), "Unknown version {0}", version);
            while ((txCounter = this.versions.peekLast()) != null && txCounter.version >= version) {
                this.versions.removeLast();
            }
            this.currentTxCounter = new TxCounter(version);
            if (this.oldestVersionToKeep.get() > version) {
                this.oldestVersionToKeep.set(version);
            }
            if (this.fileStore != null) {
                this.fileStore.rollbackTo(version);
            }
            if (!this.meta.rollbackRoot(version)) {
                this.meta.setRootPos(this.getRootPos(this.meta.getId()), version - 1L);
            }
            this.metaChanged = false;
            for (MVMap<?, ?> m : new ArrayList(this.maps.values())) {
                int id = m.getId();
                if (m.getCreateVersion() >= version) {
                    m.close();
                    this.maps.remove(id);
                    continue;
                }
                if (m.rollbackRoot(version)) continue;
                m.setRootPos(this.getRootPos(id), version);
            }
            this.onVersionChange(this.currentVersion);
            assert (!this.hasUnsavedChanges());
        }
        finally {
            this.unlockAndCheckPanicCondition();
        }
    }

    private long getRootPos(int mapId) {
        return this.fileStore == null ? 0L : this.fileStore.getRootPos(mapId);
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    void setCurrentVersion(long curVersion) {
        this.currentVersion = curVersion;
    }

    public FileStore<?> getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.fileStore.getStoreHeader();
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw DataUtils.newMVStoreException(4, "This store is closed", this.panicException);
        }
    }

    private void checkNotClosed() {
        if (!this.isOpenOrStopping()) {
            throw DataUtils.newMVStoreException(4, "This store is closed", this.panicException);
        }
    }

    public void renameMap(MVMap<?, ?> map, String newName) {
        this.checkOpen();
        DataUtils.checkArgument(this.isRegularMap(map), "Renaming the meta map is not allowed", new Object[0]);
        int id = map.getId();
        String oldName = this.getMapName(id);
        if (oldName != null && !oldName.equals(newName)) {
            String idHexStr = Integer.toHexString(id);
            String existingIdHexStr = this.meta.putIfAbsent("name." + newName, idHexStr);
            DataUtils.checkArgument(existingIdHexStr == null || existingIdHexStr.equals(idHexStr), "A map named {0} already exists", newName);
            this.meta.put(MVMap.getMapKey(id), map.asString(newName));
            this.meta.remove("name." + oldName);
            this.markMetaChanged();
        }
    }

    public void removeMap(MVMap<?, ?> map) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            DataUtils.checkArgument(this.isRegularMap(map), "Removing the meta map is not allowed", new Object[0]);
            RootReference<?, ?> rootReference = map.clearIt();
            map.close();
            this.updateCounter += rootReference.updateCounter;
            this.updateAttemptCounter += rootReference.updateAttemptCounter;
            int id = map.getId();
            String name = this.getMapName(id);
            if (this.meta.remove(MVMap.getMapKey(id)) != null) {
                this.markMetaChanged();
            }
            if (this.meta.remove("name." + name) != null) {
                this.markMetaChanged();
            }
            if (!this.isVersioningRequired()) {
                this.maps.remove(id);
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    void deregisterMapRoot(int mapId) {
        if (this.fileStore != null && this.fileStore.deregisterMapRoot(mapId)) {
            this.markMetaChanged();
        }
    }

    public void removeMap(String name) {
        int id = this.getMapId(name);
        if (id > 0) {
            MVMap map = this.getMap(id);
            if (map == null) {
                map = this.openMap(name, MVStoreTool.getGenericMapBuilder());
            }
            this.removeMap(map);
        }
    }

    public String getMapName(int id) {
        String m = this.meta.get(MVMap.getMapKey(id));
        return m == null ? null : DataUtils.getMapName(m);
    }

    private int getMapId(String name) {
        String m = this.meta.get("name." + name);
        return m == null ? -1 : DataUtils.parseHexInt(m);
    }

    public void populateInfo(BiConsumer<String, String> consumer) {
        consumer.accept("info.UPDATE_FAILURE_PERCENT", String.format(Locale.ENGLISH, "%.2f%%", 100.0 * this.getUpdateFailureRatio()));
        consumer.accept("info.LEAF_RATIO", Integer.toString(this.getLeafRatio()));
        if (this.fileStore != null) {
            this.fileStore.populateInfo(consumer);
        }
    }

    boolean handleException(Throwable ex) {
        if (this.backgroundExceptionHandler != null) {
            block3: {
                try {
                    this.backgroundExceptionHandler.uncaughtException(Thread.currentThread(), ex);
                }
                catch (Throwable e) {
                    if (ex == e) break block3;
                    ex.addSuppressed(e);
                }
            }
            return true;
        }
        return false;
    }

    boolean isOpen() {
        return this.state == 0;
    }

    public boolean isClosed() {
        if (this.isOpen()) {
            return false;
        }
        this.storeLock.lock();
        try {
            boolean bl = this.state == 2;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private boolean isOpenOrStopping() {
        return this.state <= 1;
    }

    public void setAutoCommitDelay(int millis) {
        if (this.fileStore != null) {
            this.fileStore.setAutoCommitDelay(millis);
        }
    }

    public int getAutoCommitDelay() {
        return this.fileStore == null ? 0 : this.fileStore.getAutoCommitDelay();
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    public boolean isReadOnly() {
        return this.fileStore != null && this.fileStore.isReadOnly();
    }

    private int getLeafRatio() {
        return (int)(this.leafCount * 100L / Math.max(1L, this.leafCount + this.nonLeafCount));
    }

    private double getUpdateFailureRatio() {
        long updateCounter = this.updateCounter;
        long updateAttemptCounter = this.updateAttemptCounter;
        RootReference<String, String> rootReference = this.meta.getRoot();
        updateCounter += rootReference.updateCounter;
        updateAttemptCounter += rootReference.updateAttemptCounter;
        for (MVMap<?, ?> map : this.maps.values()) {
            RootReference<?, ?> root = map.getRoot();
            updateCounter += root.updateCounter;
            updateAttemptCounter += root.updateAttemptCounter;
        }
        return updateAttemptCounter == 0L ? 0.0 : 1.0 - (double)updateCounter / (double)updateAttemptCounter;
    }

    public TxCounter registerVersionUsage() {
        TxCounter txCounter;
        while ((txCounter = this.currentTxCounter).incrementAndGet() <= 0) {
            assert (txCounter != this.currentTxCounter) : txCounter;
            txCounter.decrementAndGet();
        }
        return txCounter;
    }

    public void deregisterVersionUsage(TxCounter txCounter) {
        if (this.decrementVersionUsageCounter(txCounter)) {
            if (this.storeLock.isHeldByCurrentThread()) {
                this.dropUnusedVersions();
            } else if (this.storeLock.tryLock()) {
                try {
                    this.dropUnusedVersions();
                }
                finally {
                    this.storeLock.unlock();
                }
            }
        }
    }

    public boolean decrementVersionUsageCounter(TxCounter txCounter) {
        return txCounter != null && txCounter.decrementAndGet() <= 0;
    }

    void onVersionChange(long version) {
        this.metaChanged = false;
        TxCounter txCounter = this.currentTxCounter;
        assert (txCounter.get() >= 0);
        this.versions.add(txCounter);
        this.currentTxCounter = new TxCounter(version);
        txCounter.decrementAndGet();
        this.dropUnusedVersions();
    }

    private void dropUnusedVersions() {
        TxCounter txCounter;
        while ((txCounter = this.versions.peek()) != null && txCounter.get() < 0) {
            this.versions.poll();
        }
        long oldestVersionToKeep = (txCounter != null ? txCounter : this.currentTxCounter).version;
        this.setOldestVersionToKeep(oldestVersionToKeep);
    }

    public void countNewPage(boolean leaf) {
        if (leaf) {
            ++this.leafCount;
        } else {
            ++this.nonLeafCount;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Builder {
        private final HashMap<String, Object> config;

        private Builder(HashMap<String, Object> config) {
            this.config = config;
        }

        public Builder() {
            this.config = new HashMap();
        }

        private Builder set(String key, Object value) {
            this.config.put(key, value);
            return this;
        }

        public Builder autoCommitDisabled() {
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int kb) {
            return this.set("autoCommitBufferSize", kb);
        }

        public Builder autoCompactFillRate(int percent) {
            return this.set("autoCompactFillRate", percent);
        }

        public Builder fileName(String fileName) {
            return this.set("fileName", fileName);
        }

        public Builder encryptionKey(char[] password) {
            return this.set("encryptionKey", password);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder keysPerPage(int keyCount) {
            return this.set("keysPerPage", keyCount);
        }

        public Builder recoveryMode() {
            return this.set("recoveryMode", 1);
        }

        public Builder cacheSize(int mb) {
            return this.set("cacheSize", mb);
        }

        public Builder cacheConcurrency(int concurrency) {
            return this.set("cacheConcurrency", concurrency);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int pageSplitSize) {
            return this.set("pageSplitSize", pageSplitSize);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            return this.set("backgroundExceptionHandler", exceptionHandler);
        }

        public Builder fileStore(FileStore<?> store) {
            return this.set("fileStore", store);
        }

        public Builder adoptFileStore(FileStore store) {
            this.set("fileStoreIsAdopted", true);
            return this.set("fileStore", store);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String s) {
            return new Builder(DataUtils.parseMap(s));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class TxCounter {
        public final long version;
        private volatile int counter;
        private static final AtomicIntegerFieldUpdater<TxCounter> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(TxCounter.class, "counter");

        TxCounter(long version) {
            this.version = version;
        }

        int get() {
            return this.counter;
        }

        int incrementAndGet() {
            return counterUpdater.incrementAndGet(this);
        }

        int decrementAndGet() {
            return counterUpdater.decrementAndGet(this);
        }

        public String toString() {
            return "v=" + this.version + " / cnt=" + this.counter;
        }
    }
}

