/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.h2.compress.Compressor;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Page<K, V>
implements Cloneable {
    public final MVMap<K, V> map;
    private volatile long pos;
    public int pageNo = -1;
    private int cachedCompare;
    private int memory;
    private int diskSpaceUsed;
    private K[] keys;
    private static final AtomicLongFieldUpdater<Page> posUpdater = AtomicLongFieldUpdater.newUpdater(Page.class, "pos");
    static final int PAGE_MEMORY_CHILD = 24;
    private static final int PAGE_MEMORY = 81;
    static final int PAGE_NODE_MEMORY = 121;
    static final int PAGE_LEAF_MEMORY = 113;
    private static final int IN_MEMORY = Integer.MIN_VALUE;
    private static final PageReference[] SINGLE_EMPTY = new PageReference[]{PageReference.EMPTY};

    Page(MVMap<K, V> map) {
        this.map = map;
    }

    Page(MVMap<K, V> map, Page<K, V> source) {
        this(map, source.keys);
        this.memory = source.memory;
    }

    Page(MVMap<K, V> map, K[] keys) {
        this.map = map;
        this.keys = keys;
    }

    static <K, V> Page<K, V> createEmptyLeaf(MVMap<K, V> map) {
        return Page.createLeaf(map, map.getKeyType().createStorage(0), map.getValueType().createStorage(0), 113);
    }

    static <K, V> Page<K, V> createEmptyNode(MVMap<K, V> map) {
        return Page.createNode(map, map.getKeyType().createStorage(0), SINGLE_EMPTY, 0L, 153);
    }

    public static <K, V> Page<K, V> createNode(MVMap<K, V> map, K[] keys, PageReference<K, V>[] children, long totalCount, int memory) {
        assert (keys != null);
        NonLeaf<K, V> page = new NonLeaf<K, V>(map, keys, children, totalCount);
        page.initMemoryAccount(memory);
        return page;
    }

    static <K, V> Page<K, V> createLeaf(MVMap<K, V> map, K[] keys, V[] values, int memory) {
        assert (keys != null);
        Leaf<K, V> page = new Leaf<K, V>(map, keys, values);
        page.initMemoryAccount(memory);
        return page;
    }

    private void initMemoryAccount(int memoryCount) {
        if (!this.map.isPersistent()) {
            this.memory = Integer.MIN_VALUE;
        } else if (memoryCount == 0) {
            this.recalculateMemory();
        } else {
            this.addMemory(memoryCount);
            assert (memoryCount == this.getMemory());
        }
    }

    static <K, V> V get(Page<K, V> p, K key) {
        while (true) {
            int index = p.binarySearch(key);
            if (p.isLeaf()) {
                return index >= 0 ? (V)p.getValue(index) : null;
            }
            if (index++ < 0) {
                index = -index;
            }
            p = p.getChildPage(index);
        }
    }

    static <K, V> Page<K, V> read(ByteBuffer buff, long pos, MVMap<K, V> map) {
        boolean leaf = (DataUtils.getPageType(pos) & 1) == 0;
        Page p = leaf ? new Leaf<K, V>(map) : new NonLeaf<K, V>(map);
        p.pos = pos;
        p.read(buff);
        return p;
    }

    public final int getMapId() {
        return this.map.getId();
    }

    abstract Page<K, V> copy(MVMap<K, V> var1, boolean var2);

    public K getKey(int index) {
        return this.keys[index];
    }

    public abstract Page<K, V> getChildPage(int var1);

    public abstract long getChildPagePos(int var1);

    public abstract V getValue(int var1);

    public final int getKeyCount() {
        return this.keys.length;
    }

    public final boolean isLeaf() {
        return this.getNodeType() == 0;
    }

    public abstract int getNodeType();

    public final long getPos() {
        return this.pos;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        this.dump(buff);
        return buff.toString();
    }

    protected void dump(StringBuilder buff) {
        buff.append("id: ").append(System.identityHashCode(this)).append('\n');
        buff.append("pos: ").append(Long.toHexString(this.pos)).append('\n');
        if (this.isSaved()) {
            int chunkId = DataUtils.getPageChunkId(this.pos);
            buff.append("chunk:").append(Long.toHexString(chunkId));
            if (this.pageNo >= 0) {
                buff.append(",no:").append(Long.toHexString(this.pageNo));
            }
            buff.append('\n');
        }
    }

    public final Page<K, V> copy() {
        Object newPage = this.clone();
        ((Page)newPage).pos = 0L;
        ((Page)newPage).pageNo = -1;
        return newPage;
    }

    protected final Page<K, V> clone() {
        Page clone;
        try {
            clone = (Page)super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            throw new RuntimeException(impossible);
        }
        return clone;
    }

    int binarySearch(K key) {
        int res = this.map.getKeyType().binarySearch(key, this.keys, this.getKeyCount(), this.cachedCompare);
        this.cachedCompare = res < 0 ? ~res : res + 1;
        return res;
    }

    abstract Page<K, V> split(int var1);

    final K[] splitKeys(int aCount, int bCount) {
        assert (aCount + bCount <= this.getKeyCount());
        K[] aKeys = this.createKeyStorage(aCount);
        K[] bKeys = this.createKeyStorage(bCount);
        System.arraycopy(this.keys, 0, aKeys, 0, aCount);
        System.arraycopy(this.keys, this.getKeyCount() - bCount, bKeys, 0, bCount);
        this.keys = aKeys;
        return bKeys;
    }

    abstract void expand(int var1, K[] var2, V[] var3);

    final void expandKeys(int extraKeyCount, K[] extraKeys) {
        int keyCount = this.getKeyCount();
        K[] newKeys = this.createKeyStorage(keyCount + extraKeyCount);
        System.arraycopy(this.keys, 0, newKeys, 0, keyCount);
        System.arraycopy(extraKeys, 0, newKeys, keyCount, extraKeyCount);
        this.keys = newKeys;
    }

    public abstract long getTotalCount();

    abstract long getCounts(int var1);

    public abstract void setChild(int var1, Page<K, V> var2);

    public final void setKey(int index, K key) {
        this.keys = (Object[])this.keys.clone();
        if (this.isPersistent()) {
            K old = this.keys[index];
            if (!this.map.isMemoryEstimationAllowed() || old == null) {
                int mem = this.map.evaluateMemoryForKey(key);
                if (old != null) {
                    mem -= this.map.evaluateMemoryForKey(old);
                }
                this.addMemory(mem);
            }
        }
        this.keys[index] = key;
    }

    public abstract V setValue(int var1, V var2);

    public abstract void insertLeaf(int var1, K var2, V var3);

    public abstract void insertNode(int var1, K var2, Page<K, V> var3);

    final void insertKey(int index, K key) {
        int keyCount = this.getKeyCount();
        assert (index <= keyCount) : index + " > " + keyCount;
        K[] newKeys = this.createKeyStorage(keyCount + 1);
        DataUtils.copyWithGap(this.keys, newKeys, keyCount, index);
        this.keys = newKeys;
        this.keys[index] = key;
        if (this.isPersistent()) {
            this.addMemory(8 + this.map.evaluateMemoryForKey(key));
        }
    }

    public void remove(int index) {
        int keyCount = this.getKeyCount();
        if (index == keyCount) {
            --index;
        }
        if (this.isPersistent() && !this.map.isMemoryEstimationAllowed()) {
            K old = this.getKey(index);
            this.addMemory(-8 - this.map.evaluateMemoryForKey(old));
        }
        K[] newKeys = this.createKeyStorage(keyCount - 1);
        DataUtils.copyExcept(this.keys, newKeys, keyCount, index);
        this.keys = newKeys;
    }

    private void read(ByteBuffer buff) {
        boolean compressed;
        int checkTest;
        int remaining;
        int chunkId = DataUtils.getPageChunkId(this.pos);
        int offset = DataUtils.getPageOffset(this.pos);
        int start = buff.position();
        int pageLength = buff.getInt();
        if (pageLength > (remaining = buff.remaining() + 4) || pageLength < 4) {
            throw DataUtils.newMVStoreException(6, "File corrupted in chunk {0}, expected page length 4..{1}, got {2}", chunkId, remaining, pageLength);
        }
        short check = buff.getShort();
        if (check != (short)(checkTest = DataUtils.getCheckValue(chunkId) ^ DataUtils.getCheckValue(offset) ^ DataUtils.getCheckValue(pageLength))) {
            throw DataUtils.newMVStoreException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", chunkId, checkTest, check);
        }
        this.pageNo = DataUtils.readVarInt(buff);
        if (this.pageNo < 0) {
            throw DataUtils.newMVStoreException(6, "File corrupted in chunk {0}, got negative page No {1}", chunkId, this.pageNo);
        }
        int mapId = DataUtils.readVarInt(buff);
        if (mapId != this.map.getId()) {
            throw DataUtils.newMVStoreException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", chunkId, this.map.getId(), mapId);
        }
        int keyCount = DataUtils.readVarInt(buff);
        this.keys = this.createKeyStorage(keyCount);
        byte type = buff.get();
        if (this.isLeaf() != ((type & 1) == 0)) {
            throw DataUtils.newMVStoreException(6, "File corrupted in chunk {0}, expected node type {1}, got {2}", chunkId, this.isLeaf() ? "0" : "1", type);
        }
        buff.limit(start + pageLength);
        if (!this.isLeaf()) {
            this.readPayLoad(buff);
        }
        boolean bl = compressed = (type & 2) != 0;
        if (compressed) {
            byte[] comp;
            Compressor compressor = (type & 6) == 6 ? this.map.getStore().getCompressorHigh() : this.map.getStore().getCompressorFast();
            int lenAdd = DataUtils.readVarInt(buff);
            int compLen = buff.remaining();
            int pos = 0;
            if (buff.hasArray()) {
                comp = buff.array();
                pos = buff.arrayOffset() + buff.position();
            } else {
                comp = Utils.newBytes(compLen);
                buff.get(comp);
            }
            int l = compLen + lenAdd;
            buff = ByteBuffer.allocate(l);
            compressor.expand(comp, pos, compLen, buff.array(), buff.arrayOffset(), l);
        }
        this.map.getKeyType().read(buff, this.keys, keyCount);
        if (this.isLeaf()) {
            this.readPayLoad(buff);
        }
        this.diskSpaceUsed = pageLength;
        this.recalculateMemory();
    }

    protected abstract void readPayLoad(ByteBuffer var1);

    public final boolean isSaved() {
        return DataUtils.isPageSaved(this.pos);
    }

    public final boolean isRemoved() {
        return DataUtils.isPageRemoved(this.pos);
    }

    private boolean markAsRemoved() {
        assert (this.getTotalCount() > 0L) : this;
        do {
            long pagePos;
            if (DataUtils.isPageSaved(pagePos = this.pos)) {
                return false;
            }
            assert (!DataUtils.isPageRemoved(pagePos));
        } while (!posUpdater.compareAndSet(this, 0L, 1L));
        return true;
    }

    protected final int write(FileStore.PageSerializationManager pageSerializationManager) {
        int compressionLevel;
        this.pageNo = pageSerializationManager.getPageNo();
        int keyCount = this.getKeyCount();
        WriteBuffer buff = pageSerializationManager.getBuffer();
        int start = buff.position();
        buff.putInt(0).putShort((short)0).putVarInt(this.pageNo).putVarInt(this.map.getId()).putVarInt(keyCount);
        int typePos = buff.position();
        int type = this.isLeaf() ? 0 : 1;
        buff.put((byte)type);
        int childrenPos = buff.position();
        this.writeChildren(buff, true);
        int compressStart = buff.position();
        this.map.getKeyType().write(buff, this.keys, keyCount);
        this.writeValues(buff);
        MVStore store = this.map.getStore();
        int expLen = buff.position() - compressStart;
        if (expLen > 16 && (compressionLevel = store.getCompressionLevel()) > 0) {
            byte[] exp;
            int compressType;
            Compressor compressor;
            if (compressionLevel == 1) {
                compressor = store.getCompressorFast();
                compressType = 2;
            } else {
                compressor = store.getCompressorHigh();
                compressType = 6;
            }
            byte[] comp = new byte[expLen * 2];
            ByteBuffer byteBuffer = buff.getBuffer();
            int pos = 0;
            if (byteBuffer.hasArray()) {
                exp = byteBuffer.array();
                pos = byteBuffer.arrayOffset() + compressStart;
            } else {
                exp = Utils.newBytes(expLen);
                buff.position(compressStart).get(exp);
            }
            int compLen = compressor.compress(exp, pos, expLen, comp, 0);
            int plus = DataUtils.getVarIntLen(expLen - compLen);
            if (compLen + plus < expLen) {
                buff.position(typePos).put((byte)(type | compressType));
                buff.position(compressStart).putVarInt(expLen - compLen).put(comp, 0, compLen);
            }
        }
        int pageLength = buff.position() - start;
        long pagePos = pageSerializationManager.getPagePosition(this.getMapId(), start, pageLength, type);
        if (this.isSaved()) {
            throw DataUtils.newMVStoreException(3, "Page already stored", new Object[0]);
        }
        boolean isDeleted = this.isRemoved();
        while (!posUpdater.compareAndSet(this, isDeleted ? 1L : 0L, pagePos)) {
            isDeleted = this.isRemoved();
        }
        int pageLengthDecoded = DataUtils.getPageMaxLength(pagePos);
        this.diskSpaceUsed = pageLengthDecoded != 0x200000 ? pageLengthDecoded : pageLength;
        boolean singleWriter = this.map.isSingleWriter();
        pageSerializationManager.onPageSerialized(this, isDeleted, pageLengthDecoded, singleWriter);
        return childrenPos;
    }

    protected abstract void writeValues(WriteBuffer var1);

    protected abstract void writeChildren(WriteBuffer var1, boolean var2);

    abstract void writeUnsavedRecursive(FileStore.PageSerializationManager var1);

    abstract void releaseSavedPages();

    public abstract int getRawChildPageCount();

    protected final boolean isPersistent() {
        return this.memory != Integer.MIN_VALUE;
    }

    public final int getMemory() {
        if (this.isPersistent()) {
            return this.memory;
        }
        return 0;
    }

    public long getDiskSpaceUsed() {
        long r = 0L;
        if (this.isPersistent()) {
            r += (long)this.diskSpaceUsed;
            if (!this.isLeaf()) {
                int i = 0;
                while (i < this.getRawChildPageCount()) {
                    long pos = this.getChildPagePos(i);
                    if (pos != 0L) {
                        r += this.getChildPage(i).getDiskSpaceUsed();
                    }
                    ++i;
                }
            }
        }
        return r;
    }

    final void addMemory(int mem) {
        this.memory += mem;
        assert (this.memory >= 0);
    }

    final void recalculateMemory() {
        assert (this.isPersistent());
        this.memory = this.calculateMemory();
    }

    protected int calculateMemory() {
        return this.map.evaluateMemoryForKeys(this.keys, this.getKeyCount());
    }

    public boolean isComplete() {
        return true;
    }

    public void setComplete() {
    }

    public final int removePage(long version) {
        if (this.isPersistent() && this.getTotalCount() > 0L) {
            MVStore store = this.map.store;
            if (!this.markAsRemoved()) {
                long pagePos = this.pos;
                store.accountForRemovedPage(pagePos, version, this.map.isSingleWriter(), this.pageNo);
            } else {
                return -this.memory;
            }
        }
        return 0;
    }

    public abstract CursorPos<K, V> getPrependCursorPos(CursorPos<K, V> var1);

    public abstract CursorPos<K, V> getAppendCursorPos(CursorPos<K, V> var1);

    public abstract int removeAllRecursive(long var1);

    public final K[] createKeyStorage(int size) {
        return this.map.getKeyType().createStorage(size);
    }

    final V[] createValueStorage(int size) {
        return this.map.getValueType().createStorage(size);
    }

    public static <K, V> PageReference<K, V>[] createRefStorage(int size) {
        return new PageReference[size];
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class IncompleteNonLeaf<K, V>
    extends NonLeaf<K, V> {
        private boolean complete;

        IncompleteNonLeaf(MVMap<K, V> map, NonLeaf<K, V> source) {
            super(map, source, IncompleteNonLeaf.constructEmptyPageRefs(source.getRawChildPageCount()), source.getTotalCount());
        }

        private static <K, V> PageReference<K, V>[] constructEmptyPageRefs(int size) {
            Object[] children = IncompleteNonLeaf.createRefStorage(size);
            Arrays.fill(children, PageReference.empty());
            return children;
        }

        @Override
        void writeUnsavedRecursive(FileStore.PageSerializationManager pageSerializationManager) {
            if (this.complete) {
                super.writeUnsavedRecursive(pageSerializationManager);
            } else if (!this.isSaved()) {
                this.writeChildrenRecursive(pageSerializationManager);
            }
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public void setComplete() {
            this.recalculateTotalCount();
            this.complete = true;
        }

        @Override
        public void dump(StringBuilder buff) {
            super.dump(buff);
            buff.append(", complete:").append(this.complete);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Leaf<K, V>
    extends Page<K, V> {
        private V[] values;

        Leaf(MVMap<K, V> map) {
            super(map);
        }

        private Leaf(MVMap<K, V> map, Leaf<K, V> source) {
            super(map, source);
            this.values = source.values;
        }

        Leaf(MVMap<K, V> map, K[] keys, V[] values) {
            super(map, keys);
            this.values = values;
        }

        @Override
        public int getNodeType() {
            return 0;
        }

        @Override
        public Page<K, V> copy(MVMap<K, V> map, boolean eraseChildrenRefs) {
            return new Leaf<K, V>(map, this);
        }

        @Override
        public Page<K, V> getChildPage(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getChildPagePos(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V getValue(int index) {
            return this.values == null ? null : (V)this.values[index];
        }

        @Override
        public Page<K, V> split(int at) {
            assert (!this.isSaved());
            int b = this.getKeyCount() - at;
            K[] bKeys = this.splitKeys(at, b);
            V[] bValues = this.createValueStorage(b);
            if (this.values != null) {
                V[] aValues = this.createValueStorage(at);
                System.arraycopy(this.values, 0, aValues, 0, at);
                System.arraycopy(this.values, at, bValues, 0, b);
                this.values = aValues;
            }
            Page newPage = Leaf.createLeaf(this.map, bKeys, bValues, 0);
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
            return newPage;
        }

        @Override
        public void expand(int extraKeyCount, K[] extraKeys, V[] extraValues) {
            int keyCount = this.getKeyCount();
            this.expandKeys(extraKeyCount, extraKeys);
            if (this.values != null) {
                V[] newValues = this.createValueStorage(keyCount + extraKeyCount);
                System.arraycopy(this.values, 0, newValues, 0, keyCount);
                System.arraycopy(extraValues, 0, newValues, keyCount, extraKeyCount);
                this.values = newValues;
            }
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
        }

        @Override
        public long getTotalCount() {
            return this.getKeyCount();
        }

        @Override
        long getCounts(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setChild(int index, Page<K, V> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V setValue(int index, V value) {
            this.values = (Object[])this.values.clone();
            V old = this.setValueInternal(index, value);
            if (this.isPersistent() && !this.map.isMemoryEstimationAllowed()) {
                this.addMemory(this.map.evaluateMemoryForValue(value) - this.map.evaluateMemoryForValue(old));
            }
            return old;
        }

        private V setValueInternal(int index, V value) {
            V old = this.values[index];
            this.values[index] = value;
            return old;
        }

        @Override
        public void insertLeaf(int index, K key, V value) {
            int keyCount = this.getKeyCount();
            this.insertKey(index, key);
            if (this.values != null) {
                V[] newValues = this.createValueStorage(keyCount + 1);
                DataUtils.copyWithGap(this.values, newValues, keyCount, index);
                this.values = newValues;
                this.setValueInternal(index, value);
                if (this.isPersistent()) {
                    this.addMemory(8 + this.map.evaluateMemoryForValue(value));
                }
            }
        }

        @Override
        public void insertNode(int index, K key, Page<K, V> childPage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int index) {
            int keyCount = this.getKeyCount();
            super.remove(index);
            if (this.values != null) {
                if (this.isPersistent()) {
                    if (this.map.isMemoryEstimationAllowed()) {
                        this.addMemory(-this.getMemory() / keyCount);
                    } else {
                        V old = this.getValue(index);
                        this.addMemory(-8 - this.map.evaluateMemoryForValue(old));
                    }
                }
                V[] newValues = this.createValueStorage(keyCount - 1);
                DataUtils.copyExcept(this.values, newValues, keyCount, index);
                this.values = newValues;
            }
        }

        @Override
        public int removeAllRecursive(long version) {
            return this.removePage(version);
        }

        @Override
        public CursorPos<K, V> getPrependCursorPos(CursorPos<K, V> cursorPos) {
            return new CursorPos<K, V>(this, -1, cursorPos);
        }

        @Override
        public CursorPos<K, V> getAppendCursorPos(CursorPos<K, V> cursorPos) {
            int keyCount = this.getKeyCount();
            return new CursorPos<K, V>(this, ~keyCount, cursorPos);
        }

        @Override
        protected void readPayLoad(ByteBuffer buff) {
            int keyCount = this.getKeyCount();
            this.values = this.createValueStorage(keyCount);
            this.map.getValueType().read(buff, this.values, this.getKeyCount());
        }

        @Override
        protected void writeValues(WriteBuffer buff) {
            this.map.getValueType().write(buff, this.values, this.getKeyCount());
        }

        @Override
        protected void writeChildren(WriteBuffer buff, boolean withCounts) {
        }

        @Override
        void writeUnsavedRecursive(FileStore.PageSerializationManager pageSerializationManager) {
            if (!this.isSaved()) {
                this.write(pageSerializationManager);
            }
        }

        @Override
        void releaseSavedPages() {
        }

        @Override
        public int getRawChildPageCount() {
            return 0;
        }

        @Override
        protected int calculateMemory() {
            return super.calculateMemory() + 113 + (this.values == null ? 0 : this.map.evaluateMemoryForValues(this.values, this.getKeyCount()));
        }

        @Override
        public void dump(StringBuilder buff) {
            super.dump(buff);
            int keyCount = this.getKeyCount();
            int i = 0;
            while (i < keyCount) {
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(this.getKey(i));
                if (this.values != null) {
                    buff.append(':');
                    buff.append(this.getValue(i));
                }
                ++i;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class NonLeaf<K, V>
    extends Page<K, V> {
        private PageReference<K, V>[] children;
        private long totalCount;

        NonLeaf(MVMap<K, V> map) {
            super(map);
        }

        NonLeaf(MVMap<K, V> map, NonLeaf<K, V> source, PageReference<K, V>[] children, long totalCount) {
            super(map, source);
            this.children = children;
            this.totalCount = totalCount;
        }

        NonLeaf(MVMap<K, V> map, K[] keys, PageReference<K, V>[] children, long totalCount) {
            super(map, keys);
            this.children = children;
            this.totalCount = totalCount;
        }

        @Override
        public int getNodeType() {
            return 1;
        }

        @Override
        public Page<K, V> copy(MVMap<K, V> map, boolean eraseChildrenRefs) {
            return eraseChildrenRefs ? new IncompleteNonLeaf<K, V>(map, this) : new NonLeaf<K, V>(map, this, this.children, this.totalCount);
        }

        @Override
        public Page<K, V> getChildPage(int index) {
            PageReference<K, V> ref = this.children[index];
            Page<K, V> page = ref.getPage();
            if (page == null) {
                page = this.map.readPage(ref.getPos());
                assert (ref.getPos() == page.getPos());
                assert (ref.count == page.getTotalCount());
            }
            return page;
        }

        @Override
        public long getChildPagePos(int index) {
            return this.children[index].getPos();
        }

        @Override
        public V getValue(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Page<K, V> split(int at) {
            PageReference x;
            assert (!this.isSaved());
            int b = this.getKeyCount() - at;
            K[] bKeys = this.splitKeys(at, b - 1);
            PageReference<K, V>[] aChildren = NonLeaf.createRefStorage(at + 1);
            PageReference<K, V>[] bChildren = NonLeaf.createRefStorage(b);
            System.arraycopy(this.children, 0, aChildren, 0, at + 1);
            System.arraycopy(this.children, at + 1, bChildren, 0, b);
            this.children = aChildren;
            long t = 0L;
            PageReference<K, V>[] pageReferenceArray = aChildren;
            int n = aChildren.length;
            int n2 = 0;
            while (n2 < n) {
                x = pageReferenceArray[n2];
                t += x.count;
                ++n2;
            }
            this.totalCount = t;
            t = 0L;
            pageReferenceArray = bChildren;
            n = bChildren.length;
            n2 = 0;
            while (n2 < n) {
                x = pageReferenceArray[n2];
                t += x.count;
                ++n2;
            }
            Page newPage = NonLeaf.createNode(this.map, bKeys, bChildren, t, 0);
            if (this.isPersistent()) {
                this.recalculateMemory();
            }
            return newPage;
        }

        @Override
        public void expand(int keyCount, Object[] extraKeys, Object[] extraValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTotalCount() {
            assert (!this.isComplete() || this.totalCount == this.calculateTotalCount()) : "Total count: " + this.totalCount + " != " + this.calculateTotalCount();
            return this.totalCount;
        }

        private long calculateTotalCount() {
            long check = 0L;
            int keyCount = this.getKeyCount();
            int i = 0;
            while (i <= keyCount) {
                check += this.children[i].count;
                ++i;
            }
            return check;
        }

        void recalculateTotalCount() {
            this.totalCount = this.calculateTotalCount();
        }

        @Override
        long getCounts(int index) {
            return this.children[index].count;
        }

        @Override
        public void setChild(int index, Page<K, V> c) {
            assert (c != null);
            PageReference<K, V> child = this.children[index];
            if (c != child.getPage() || c.getPos() != child.getPos()) {
                this.totalCount += c.getTotalCount() - child.count;
                this.children = (PageReference[])this.children.clone();
                this.children[index] = new PageReference<K, V>(c);
            }
        }

        @Override
        public V setValue(int index, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertLeaf(int index, K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void insertNode(int index, K key, Page<K, V> childPage) {
            int childCount = this.getRawChildPageCount();
            this.insertKey(index, key);
            PageReference<K, V>[] newChildren = NonLeaf.createRefStorage(childCount + 1);
            DataUtils.copyWithGap(this.children, newChildren, childCount, index);
            this.children = newChildren;
            this.children[index] = new PageReference<K, V>(childPage);
            this.totalCount += childPage.getTotalCount();
            if (this.isPersistent()) {
                this.addMemory(32);
            }
        }

        @Override
        public void remove(int index) {
            int childCount = this.getRawChildPageCount();
            super.remove(index);
            if (this.isPersistent()) {
                if (this.map.isMemoryEstimationAllowed()) {
                    this.addMemory(-this.getMemory() / childCount);
                } else {
                    this.addMemory(-32);
                }
            }
            this.totalCount -= this.children[index].count;
            PageReference<K, V>[] newChildren = NonLeaf.createRefStorage(childCount - 1);
            DataUtils.copyExcept(this.children, newChildren, childCount, index);
            this.children = newChildren;
        }

        @Override
        public int removeAllRecursive(long version) {
            int unsavedMemory = this.removePage(version);
            if (this.isPersistent()) {
                int i = 0;
                int size = this.map.getChildPageCount(this);
                while (i < size) {
                    PageReference<K, V> ref = this.children[i];
                    Page<K, V> page = ref.getPage();
                    if (page != null) {
                        unsavedMemory += page.removeAllRecursive(version);
                    } else {
                        long pagePos = ref.getPos();
                        assert (DataUtils.isPageSaved(pagePos));
                        if (DataUtils.isLeafPosition(pagePos)) {
                            this.map.store.accountForRemovedPage(pagePos, version, this.map.isSingleWriter(), -1);
                        } else {
                            unsavedMemory += this.map.readPage(pagePos).removeAllRecursive(version);
                        }
                    }
                    ++i;
                }
            }
            return unsavedMemory;
        }

        @Override
        public CursorPos<K, V> getPrependCursorPos(CursorPos<K, V> cursorPos) {
            Page<K, V> childPage = this.getChildPage(0);
            return childPage.getPrependCursorPos(new CursorPos<K, V>(this, 0, cursorPos));
        }

        @Override
        public CursorPos<K, V> getAppendCursorPos(CursorPos<K, V> cursorPos) {
            int keyCount = this.getKeyCount();
            Page<K, V> childPage = this.getChildPage(keyCount);
            return childPage.getAppendCursorPos(new CursorPos<K, V>(this, keyCount, cursorPos));
        }

        @Override
        protected void readPayLoad(ByteBuffer buff) {
            int keyCount = this.getKeyCount();
            this.children = NonLeaf.createRefStorage(keyCount + 1);
            long[] p = new long[keyCount + 1];
            int i = 0;
            while (i <= keyCount) {
                p[i] = buff.getLong();
                ++i;
            }
            long total = 0L;
            int i2 = 0;
            while (i2 <= keyCount) {
                long s = DataUtils.readVarLong(buff);
                long position = p[i2];
                assert (!(position == 0L ? s != 0L : s < 0L));
                total += s;
                this.children[i2] = position == 0L ? PageReference.empty() : new PageReference(position, s);
                ++i2;
            }
            this.totalCount = total;
        }

        @Override
        protected void writeValues(WriteBuffer buff) {
        }

        @Override
        protected void writeChildren(WriteBuffer buff, boolean withCounts) {
            int keyCount = this.getKeyCount();
            int i = 0;
            while (i <= keyCount) {
                buff.putLong(this.children[i].getPos());
                ++i;
            }
            if (withCounts) {
                i = 0;
                while (i <= keyCount) {
                    buff.putVarLong(this.children[i].count);
                    ++i;
                }
            }
        }

        @Override
        void writeUnsavedRecursive(FileStore.PageSerializationManager pageSerializationManager) {
            if (!this.isSaved()) {
                int patch = this.write(pageSerializationManager);
                this.writeChildrenRecursive(pageSerializationManager);
                WriteBuffer buff = pageSerializationManager.getBuffer();
                int old = buff.position();
                buff.position(patch);
                this.writeChildren(buff, false);
                buff.position(old);
            }
        }

        void writeChildrenRecursive(FileStore.PageSerializationManager pageSerializationManager) {
            int len = this.getRawChildPageCount();
            int i = 0;
            while (i < len) {
                PageReference<K, V> ref = this.children[i];
                Page<K, V> p = ref.getPage();
                if (p != null) {
                    p.writeUnsavedRecursive(pageSerializationManager);
                    ref.resetPos();
                }
                ++i;
            }
        }

        @Override
        void releaseSavedPages() {
            int len = this.getRawChildPageCount();
            int i = 0;
            while (i < len) {
                this.children[i].clearPageReference();
                ++i;
            }
        }

        @Override
        public int getRawChildPageCount() {
            return this.getKeyCount() + 1;
        }

        @Override
        protected int calculateMemory() {
            return super.calculateMemory() + 121 + this.getRawChildPageCount() * 32;
        }

        @Override
        public void dump(StringBuilder buff) {
            super.dump(buff);
            int keyCount = this.getKeyCount();
            int i = 0;
            while (i <= keyCount) {
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append("[").append(Long.toHexString(this.children[i].getPos())).append("]");
                if (i < keyCount) {
                    buff.append(" ").append(this.getKey(i));
                }
                ++i;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class PageReference<K, V> {
        static final PageReference EMPTY = new PageReference(null, 0L, 0L);
        private long pos;
        private Page<K, V> page;
        final long count;

        public static <X, Y> PageReference<X, Y> empty() {
            return EMPTY;
        }

        public PageReference(Page<K, V> page) {
            this(page, page.getPos(), page.getTotalCount());
        }

        PageReference(long pos, long count) {
            this(null, pos, count);
            assert (DataUtils.isPageSaved(pos));
        }

        private PageReference(Page<K, V> page, long pos, long count) {
            this.page = page;
            this.pos = pos;
            this.count = count;
        }

        public Page<K, V> getPage() {
            return this.page;
        }

        void clearPageReference() {
            if (this.page != null) {
                this.page.releaseSavedPages();
                assert (this.page.isSaved() || !this.page.isComplete());
                if (this.page.isSaved()) {
                    assert (this.pos == this.page.getPos());
                    assert (this.count == this.page.getTotalCount()) : this.count + " != " + this.page.getTotalCount();
                    this.page = null;
                }
            }
        }

        long getPos() {
            return this.pos;
        }

        void resetPos() {
            Page<K, V> p = this.page;
            if (p != null && p.isSaved()) {
                this.pos = p.getPos();
                assert (this.count == p.getTotalCount());
            }
        }

        public String toString() {
            return "Cnt:" + this.count + ", pos:" + (String)(this.pos == 0L ? "0" : DataUtils.getPageChunkId(this.pos) + (String)(this.page == null ? "" : "/" + this.page.pageNo) + "-" + DataUtils.getPageOffset(this.pos) + ":" + DataUtils.getPageMaxLength(this.pos)) + ((this.page == null ? DataUtils.getPageType(this.pos) == 0 : this.page.isLeaf()) ? " leaf" : " node") + ", page:{" + String.valueOf(this.page) + "}";
        }
    }
}

