/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.FreeSpaceBitSet;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.SFChunk;
import org.h2.mvstore.WriteBuffer;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class RandomAccessStore
extends FileStore<SFChunk> {
    protected final FreeSpaceBitSet freeSpace = new FreeSpaceBitSet(2, 4096);
    private volatile boolean reuseSpace = true;
    private long reservedLow;
    private long reservedHigh;
    private boolean stopIdleHousekeeping;

    public RandomAccessStore(Map<String, Object> config) {
        super(config);
    }

    @Override
    protected final SFChunk createChunk(int newChunkId) {
        return new SFChunk(newChunkId);
    }

    @Override
    public SFChunk createChunk(String s) {
        return new SFChunk(s);
    }

    @Override
    protected SFChunk createChunk(Map<String, String> map) {
        return new SFChunk(map);
    }

    @Override
    public void markUsed(long pos, int length) {
        this.freeSpace.markUsed(pos, length);
    }

    private long allocate(int length, long reservedLow, long reservedHigh) {
        return this.freeSpace.allocate(length, reservedLow, reservedHigh);
    }

    private long predictAllocation(int blocks, long reservedLow, long reservedHigh) {
        return this.freeSpace.predictAllocation(blocks, reservedLow, reservedHigh);
    }

    @Override
    public boolean shouldSaveNow(int unsavedMemory, int autoCommitMemory) {
        return unsavedMemory > autoCommitMemory;
    }

    private boolean isFragmented() {
        return this.freeSpace.isFragmented();
    }

    @Override
    public boolean isSpaceReused() {
        return this.reuseSpace;
    }

    @Override
    public void setReuseSpace(boolean reuseSpace) {
        this.reuseSpace = reuseSpace;
    }

    @Override
    protected void freeChunkSpace(Iterable<SFChunk> chunks) {
        for (SFChunk chunk : chunks) {
            this.freeChunkSpace(chunk);
        }
        assert (this.validateFileLength(String.valueOf(chunks)));
    }

    private void freeChunkSpace(SFChunk chunk) {
        long start = chunk.block * 4096L;
        int length = chunk.len * 4096;
        this.free(start, length);
    }

    protected void free(long pos, int length) {
        this.freeSpace.free(pos, length);
    }

    @Override
    public int getFillRate() {
        this.saveChunkLock.lock();
        try {
            int n = this.freeSpace.getFillRate();
            return n;
        }
        finally {
            this.saveChunkLock.unlock();
        }
    }

    @Override
    protected final boolean validateFileLength(String msg) {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        assert (this.getFileLengthInUse() == this.measureFileLengthInUse()) : this.getFileLengthInUse() + " != " + this.measureFileLengthInUse() + " " + msg;
        return true;
    }

    private long measureFileLengthInUse() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        long size = 2L;
        for (SFChunk c : this.getChunks().values()) {
            if (!c.isAllocated()) continue;
            size = Math.max(size, c.block + (long)c.len);
        }
        return size * 4096L;
    }

    long getFirstFree() {
        return this.freeSpace.getFirstFree();
    }

    long getFileLengthInUse() {
        return this.freeSpace.getLastFree();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void readStoreHeader(boolean recoveryMode) {
        block25: {
            block26: {
                newest = null;
                assumeCleanShutdown = true;
                validStoreHeader = false;
                fileHeaderBlocks = this.readFully(null, 0L, 8192);
                buff = new byte[4096];
                i = 0;
                while (i <= 4096) {
                    fileHeaderBlocks.get(buff);
                    try {
                        m = DataUtils.parseChecksummedMap(buff);
                        if (m == null) {
                            assumeCleanShutdown = false;
                        } else {
                            version = DataUtils.readHexLong(m, "version", 0L);
                            v0 = assumeCleanShutdown = assumeCleanShutdown != false && (newest == null || version == newest.version);
                            if (newest == null || version > newest.version) {
                                validStoreHeader = true;
                                this.storeHeader.putAll(m);
                                chunkId = DataUtils.readHexInt(m, "chunk", 0);
                                block = DataUtils.readHexLong(m, "block", 2L);
                                test = (SFChunk)this.readChunkHeaderAndFooter(block, chunkId);
                                if (test != null) {
                                    newest = test;
                                }
                            }
                        }
                    }
                    catch (Exception ignore) {
                        assumeCleanShutdown = false;
                    }
                    i += 4096;
                }
                if (!validStoreHeader) {
                    throw DataUtils.newMVStoreException(6, "Store header is corrupt: {0}", new Object[]{this});
                }
                this.processCommonHeaderAttributes();
                v1 = assumeCleanShutdown = assumeCleanShutdown != false && newest != null && recoveryMode == false;
                if (assumeCleanShutdown) {
                    assumeCleanShutdown = DataUtils.readHexInt(this.storeHeader, "clean", 0) != 0;
                }
                fileSize = this.size();
                blocksInStore = fileSize / 4096L;
                chunkComparator = (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$0(org.h2.mvstore.SFChunk org.h2.mvstore.SFChunk ), (Lorg/h2/mvstore/SFChunk;Lorg/h2/mvstore/SFChunk;)I)();
                validChunksByLocation = new HashMap<Long, SFChunk>();
                if (!assumeCleanShutdown) break block26;
                chunksToVerify = new PriorityQueue<T>(20, Collections.reverseOrder(chunkComparator));
                try {
                    block27: {
                        this.setLastChunk(newest);
                        for (SFChunk c : this.getChunksFromLayoutMap()) {
                            chunksToVerify.offer(c);
                            if (chunksToVerify.size() != 20) continue;
                            chunksToVerify.poll();
                        }
                        break block27;
                        while (true) {
                            test = (SFChunk)this.readChunkHeaderAndFooter(c.block, c.id);
                            v2 = assumeCleanShutdown = test != null;
                            if (!assumeCleanShutdown) break;
                            validChunksByLocation.put(test.block, test);
                            break;
                        }
                    }
                    if (assumeCleanShutdown) {
                        if ((c = (SFChunk)chunksToVerify.poll()) != null) ** continue;
                    }
                    break block25;
                }
                catch (IllegalStateException ignored) {
                    assumeCleanShutdown = false;
                }
                break block25;
            }
            tailChunk = (SFChunk)this.discoverChunk(blocksInStore);
            if (tailChunk != null) {
                blocksInStore = tailChunk.block;
                validChunksByLocation.put(blocksInStore, tailChunk);
                if (newest == null || tailChunk.version > newest.version) {
                    newest = tailChunk;
                }
            }
            if (newest != null) {
                while (true) {
                    validChunksByLocation.put(newest.block, newest);
                    if (newest.next == 0L || newest.next >= blocksInStore || (test = (SFChunk)this.readChunkHeaderAndFooter(newest.next, newest.id + 1 & 0x3FFFFFF)) == null || test.version <= newest.version) break;
                    newest = test;
                }
            }
        }
        if (!assumeCleanShutdown) {
            v3 = quickRecovery = recoveryMode == false && this.findLastChunkWithCompleteValidChunkSet(chunkComparator, validChunksByLocation, false) != false;
            if (!quickRecovery) {
                block = blocksInStore;
                while ((tailChunk = (SFChunk)this.discoverChunk(block)) != null) {
                    block = tailChunk.block;
                    validChunksByLocation.put(block, tailChunk);
                }
                if (!this.findLastChunkWithCompleteValidChunkSet(chunkComparator, validChunksByLocation, true) && this.hasPersistentData()) {
                    throw DataUtils.newMVStoreException(6, "File is corrupted - unable to recover a valid set of chunks", new Object[0]);
                }
            }
        }
        this.clear();
        for (SFChunk c : this.getChunks().values()) {
            if (c.isAllocated()) {
                start = c.block * 4096L;
                length = c.len * 4096;
                this.markUsed(start, length);
            }
            if (c.isLive()) continue;
            this.registerDeadChunk(c);
        }
        if (!RandomAccessStore.$assertionsDisabled && !this.validateFileLength("on open")) {
            throw new AssertionError();
        }
    }

    @Override
    protected void initializeStoreHeader(long time) {
        this.initializeCommonHeaderAttributes(time);
        this.writeStoreHeader();
    }

    @Override
    protected final void allocateChunkSpace(SFChunk chunk, WriteBuffer buff) {
        long reservedLow = this.reservedLow;
        long reservedHigh = this.reservedHigh > 0L ? this.reservedHigh : (this.isSpaceReused() ? 0L : this.getAfterLastBlock());
        long filePos = this.allocate(buff.limit(), reservedLow, reservedHigh);
        chunk.next = reservedLow > 0L || reservedHigh == reservedLow ? this.predictAllocation(chunk.len, 0L, 0L) : 0L;
        chunk.block = filePos / 4096L;
    }

    @Override
    protected final void writeChunk(SFChunk chunk, WriteBuffer buffer) {
        long filePos = chunk.block * 4096L;
        this.writeFully(chunk, filePos, buffer.getBuffer());
        boolean storeAtEndOfFile = filePos + (long)buffer.limit() >= this.size();
        boolean shouldWriteStoreHeader = this.shouldWriteStoreHeader(chunk, storeAtEndOfFile);
        this.lastChunk = chunk;
        if (shouldWriteStoreHeader) {
            this.writeStoreHeader();
        }
        if (!storeAtEndOfFile) {
            this.shrinkStoreIfPossible(1);
        }
    }

    private boolean shouldWriteStoreHeader(SFChunk c, boolean storeAtEndOfFile) {
        boolean writeStoreHeader = false;
        if (!storeAtEndOfFile) {
            SFChunk chunk = (SFChunk)this.lastChunk;
            if (chunk == null) {
                writeStoreHeader = true;
            } else if (chunk.next != c.block) {
                writeStoreHeader = true;
            } else {
                long headerVersion = DataUtils.readHexLong(this.storeHeader, "version", 0L);
                if (chunk.version - headerVersion > 20L) {
                    writeStoreHeader = true;
                } else {
                    int chunkId = DataUtils.readHexInt(this.storeHeader, "chunk", 0);
                    while (!writeStoreHeader && chunkId <= chunk.id) {
                        writeStoreHeader = !this.getChunks().containsKey(chunkId);
                        ++chunkId;
                    }
                }
            }
        }
        if (this.storeHeader.remove("clean") != null) {
            writeStoreHeader = true;
        }
        return writeStoreHeader;
    }

    @Override
    protected final void writeCleanShutdownMark() {
        this.shrinkStoreIfPossible(0);
        this.storeHeader.put("clean", 1);
        this.writeStoreHeader();
    }

    @Override
    protected final void adjustStoreToLastChunk() {
        this.storeHeader.put("clean", 1);
        this.writeStoreHeader();
        this.readStoreHeader(false);
    }

    @Override
    protected void compactStore(int thresholdFillRate, long maxCompactTime, int maxWriteSize, MVStore mvStore) {
        this.setRetentionTime(0);
        long stopAt = System.nanoTime() + maxCompactTime * 1000000L;
        while (this.compact(thresholdFillRate, maxWriteSize)) {
            this.sync();
            this.compactMoveChunks(thresholdFillRate, maxWriteSize, mvStore);
            if (System.nanoTime() - stopAt > 0L) break;
        }
    }

    public void compactMoveChunks(int targetFillRate, long moveSize, MVStore mvStore) {
        if (this.isSpaceReused()) {
            mvStore.executeFilestoreOperation(() -> {
                this.dropUnusedChunks();
                this.saveChunkLock.lock();
                try {
                    if (this.hasPersistentData() && this.getFillRate() <= targetFillRate) {
                        this.compactMoveChunks(moveSize);
                    }
                }
                finally {
                    this.saveChunkLock.unlock();
                }
            });
        }
    }

    private void compactMoveChunks(long moveSize) {
        long start = this.getFirstFree() / 4096L;
        Iterable<SFChunk> chunksToMove = this.findChunksToMove(start, moveSize);
        if (chunksToMove != null) {
            this.compactMoveChunks(chunksToMove);
        }
    }

    private Iterable<SFChunk> findChunksToMove(long startBlock, long moveSize) {
        long maxBlocksToMove = moveSize / 4096L;
        ArrayList result = null;
        if (maxBlocksToMove > 0L) {
            PriorityQueue<SFChunk> queue = new PriorityQueue<SFChunk>(this.getChunks().size() / 2 + 1, (o1, o2) -> {
                int res = Integer.compare(o2.collectPriority, o1.collectPriority);
                if (res != 0) {
                    return res;
                }
                return Long.signum(o2.block - o1.block);
            });
            long size = 0L;
            block0: for (SFChunk chunk : this.getChunks().values()) {
                if (!chunk.isAllocated() || chunk.block <= startBlock) continue;
                chunk.collectPriority = this.getMovePriority(chunk);
                queue.offer(chunk);
                size += (long)chunk.len;
                while (size > maxBlocksToMove) {
                    Chunk removed = (Chunk)queue.poll();
                    if (removed == null) continue block0;
                    size -= (long)removed.len;
                }
            }
            if (!queue.isEmpty()) {
                ArrayList list = new ArrayList(queue);
                list.sort(Chunk.PositionComparator.instance());
                result = list;
            }
        }
        return result;
    }

    private int getMovePriority(SFChunk chunk) {
        return this.getMovePriority((int)chunk.block);
    }

    private void compactMoveChunks(Iterable<SFChunk> move) {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        if (move != null) {
            this.writeStoreHeader();
            this.sync();
            Iterator<SFChunk> iterator = move.iterator();
            assert (iterator.hasNext());
            long leftmostBlock = iterator.next().block;
            long originalBlockCount = this.getAfterLastBlock();
            for (SFChunk chunk : move) {
                this.moveChunk(chunk, leftmostBlock, originalBlockCount);
            }
            this.store(leftmostBlock, originalBlockCount);
            this.sync();
            SFChunk chunkToMove = (SFChunk)this.lastChunk;
            assert (chunkToMove != null);
            long postEvacuationBlockCount = this.getAfterLastBlock();
            boolean chunkToMoveIsAlreadyInside = chunkToMove.block < leftmostBlock;
            boolean movedToEOF = !chunkToMoveIsAlreadyInside;
            for (SFChunk c : move) {
                if (c.block < originalBlockCount || !this.moveChunk(c, originalBlockCount, postEvacuationBlockCount)) continue;
                assert (c.block < originalBlockCount);
                movedToEOF = true;
            }
            assert (postEvacuationBlockCount >= this.getAfterLastBlock());
            if (movedToEOF) {
                boolean moved = this.moveChunkInside(chunkToMove, originalBlockCount);
                this.store(originalBlockCount, postEvacuationBlockCount);
                this.sync();
                long lastBoundary = moved || chunkToMoveIsAlreadyInside ? postEvacuationBlockCount : chunkToMove.block;
                boolean bl = moved = !moved && this.moveChunkInside(chunkToMove, lastBoundary);
                if (this.moveChunkInside((SFChunk)this.lastChunk, lastBoundary) || moved) {
                    this.store(lastBoundary, -1L);
                }
            }
            this.shrinkStoreIfPossible(0);
            this.sync();
        }
    }

    private void writeStoreHeader() {
        StringBuilder buff = new StringBuilder(112);
        if (this.hasPersistentData()) {
            this.storeHeader.put("block", ((SFChunk)this.lastChunk).block);
            this.storeHeader.put("chunk", ((SFChunk)this.lastChunk).id);
            this.storeHeader.put("version", ((SFChunk)this.lastChunk).version);
        }
        DataUtils.appendMap(buff, this.storeHeader);
        byte[] bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        int checksum = DataUtils.getFletcher32(bytes, 0, bytes.length);
        DataUtils.appendMap(buff, "fletcher", checksum);
        buff.append('\n');
        bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        ByteBuffer header = ByteBuffer.allocate(8192);
        header.put(bytes);
        header.position(4096);
        header.put(bytes);
        header.rewind();
        this.writeFully(null, 0L, header);
    }

    private void store(long reservedLow, long reservedHigh) {
        this.reservedLow = reservedLow;
        this.reservedHigh = reservedHigh;
        this.saveChunkLock.unlock();
        try {
            this.store();
        }
        finally {
            this.saveChunkLock.lock();
            this.reservedLow = 0L;
            this.reservedHigh = 0L;
        }
    }

    private boolean moveChunkInside(SFChunk chunkToMove, long boundary) {
        boolean res;
        boolean bl = res = chunkToMove.block >= boundary && this.predictAllocation(chunkToMove.len, boundary, -1L) < boundary && this.moveChunk(chunkToMove, boundary, -1L);
        assert (!res || chunkToMove.block + (long)chunkToMove.len <= boundary);
        return res;
    }

    private boolean moveChunk(SFChunk chunk, long reservedAreaLow, long reservedAreaHigh) {
        if (!this.getChunks().containsKey(chunk.id)) {
            return false;
        }
        long start = chunk.block * 4096L;
        int length = chunk.len * 4096;
        long pos = this.allocate(length, reservedAreaLow, reservedAreaHigh);
        long block = pos / 4096L;
        assert (reservedAreaHigh > 0L || block <= chunk.block) : block + " " + String.valueOf(chunk);
        ByteBuffer readBuff = this.readFully(chunk, start, length);
        this.writeFully(null, pos, readBuff);
        this.free(start, length);
        chunk.block = block;
        chunk.next = 0L;
        this.saveChunkMetadataChanges(chunk);
        return true;
    }

    @Override
    protected void shrinkStoreIfPossible(int minPercent) {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        long result = this.getFileLengthInUse();
        assert (result == this.measureFileLengthInUse()) : result + " != " + this.measureFileLengthInUse();
        this.shrinkIfPossible(minPercent);
    }

    private void shrinkIfPossible(int minPercent) {
        long fileSize;
        if (this.isReadOnly()) {
            return;
        }
        long end = this.getFileLengthInUse();
        if (end >= (fileSize = this.size())) {
            return;
        }
        if (minPercent > 0 && fileSize - end < 4096L) {
            return;
        }
        int savedPercent = (int)(100L - end * 100L / fileSize);
        if (savedPercent < minPercent) {
            return;
        }
        this.sync();
        this.truncate(end);
    }

    @Override
    protected void doHousekeeping(MVStore mvStore) throws InterruptedException {
        int fillRateToCompare;
        boolean idle = this.isIdle();
        int rewritableChunksFillRate = this.getRewritableChunksFillRate();
        if (idle && this.stopIdleHousekeeping) {
            return;
        }
        int autoCommitMemory = mvStore.getAutoCommitMemory();
        int fileFillRate = this.getFillRate();
        long chunksTotalSize = this.size() * (long)fileFillRate / 100L;
        if (this.isFragmented() && fileFillRate < this.getAutoCompactFillRate()) {
            mvStore.tryExecuteUnderStoreLock(() -> {
                int moveSize = 2 * autoCommitMemory;
                if (idle) {
                    moveSize *= 4;
                }
                this.compactMoveChunks(101, moveSize, mvStore);
                return true;
            });
        }
        int chunksFillRate = this.getChunksFillRate();
        int adjustedUpFillRate = 50 + rewritableChunksFillRate / 2;
        int n = fillRateToCompare = idle ? rewritableChunksFillRate : adjustedUpFillRate;
        if (fillRateToCompare < this.getTargetFillRate(idle)) {
            int targetFillRate = idle ? adjustedUpFillRate : rewritableChunksFillRate;
            mvStore.tryExecuteUnderStoreLock(() -> {
                int writeLimit = autoCommitMemory;
                if (!idle) {
                    writeLimit /= 4;
                }
                if (this.rewriteChunks(writeLimit, targetFillRate)) {
                    this.dropUnusedChunks();
                }
                return true;
            });
        }
        this.stopIdleHousekeeping = false;
        if (idle) {
            int currentChunksFillRate = this.getChunksFillRate();
            long currentTotalChunksSize = this.size() * (long)this.getFillRate() / 100L;
            this.stopIdleHousekeeping = currentTotalChunksSize > chunksTotalSize || currentTotalChunksSize == chunksTotalSize && currentChunksFillRate <= chunksFillRate;
        }
    }

    private int getTargetFillRate(boolean idle) {
        int targetRate = this.getAutoCompactFillRate();
        if (!idle) {
            targetRate = targetRate * targetRate / 100;
        }
        return targetRate;
    }

    protected abstract void truncate(long var1);

    @Override
    public void clear() {
        this.freeSpace.clear();
    }

    public int getMovePriority(int block) {
        return this.freeSpace.getMovePriority(block);
    }

    private long getAfterLastBlock() {
        assert (this.saveChunkLock.isHeldByCurrentThread());
        return this.getAfterLastBlock_();
    }

    protected long getAfterLastBlock_() {
        return this.freeSpace.getAfterLastBlock();
    }

    @Override
    public Collection<SFChunk> getRewriteCandidates() {
        return this.isSpaceReused() ? null : Collections.emptyList();
    }

    private static /* synthetic */ int lambda$0(SFChunk one, SFChunk two) {
        int result = Long.compare(two.version, one.version);
        if (result == 0) {
            result = Long.compare(one.block, two.block);
        }
        return result;
    }
}

