/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.RandomAccessStore;
import org.h2.mvstore.SFChunk;
import org.h2.mvstore.cache.FilePathCache;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.encrypt.FileEncrypt;
import org.h2.store.fs.encrypt.FilePathEncrypt;
import org.h2.util.IOUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SingleFileStore
extends RandomAccessStore {
    private FileChannel fileChannel;
    private FileChannel originalFileChannel;
    private FileLock fileLock;
    private final Map<String, Object> config;

    public SingleFileStore(Map<String, Object> config) {
        super(config);
        this.config = config;
    }

    public String toString() {
        return this.getFileName();
    }

    @Override
    public ByteBuffer readFully(SFChunk chunk, long pos, int len) {
        return this.readFully(this.fileChannel, pos, len);
    }

    @Override
    protected void writeFully(SFChunk chunk, long pos, ByteBuffer src) {
        int len = src.remaining();
        this.setSize(Math.max(super.size(), pos + (long)len));
        DataUtils.writeFully(this.fileChannel, pos, src);
        this.writeCount.incrementAndGet();
        this.writeBytes.addAndGet(len);
    }

    @Override
    public void open(String fileName, boolean readOnly, char[] encryptionKey) {
        this.open(fileName, readOnly, encryptionKey == null ? null : fileChannel -> new FileEncrypt(fileName, FilePathEncrypt.getPasswordBytes(encryptionKey), (FileChannel)fileChannel));
    }

    public SingleFileStore open(String fileName, boolean readOnly) {
        SingleFileStore result = new SingleFileStore(this.config);
        result.open(fileName, readOnly, this.originalFileChannel == null ? null : fileChannel -> new FileEncrypt(fileName, (FileEncrypt)this.fileChannel, (FileChannel)fileChannel));
        return result;
    }

    private void open(String fileName, boolean readOnly, Function<FileChannel, FileChannel> encryptionTransformer) {
        if (this.fileChannel != null && this.fileChannel.isOpen()) {
            return;
        }
        FilePathCache.INSTANCE.getScheme();
        FilePath f = FilePath.get(fileName);
        FilePath parent = f.getParent();
        if (parent != null && !parent.exists()) {
            throw DataUtils.newIllegalArgumentException("Directory does not exist: {0}", parent);
        }
        if (f.exists() && !f.canWrite()) {
            readOnly = true;
        }
        this.init(fileName, readOnly);
        try {
            this.fileChannel = f.open(readOnly ? "r" : "rw");
            if (encryptionTransformer != null) {
                this.originalFileChannel = this.fileChannel;
                this.fileChannel = encryptionTransformer.apply(this.fileChannel);
            }
            this.fileLock = this.lockFileChannel(this.fileChannel, readOnly, fileName);
            this.saveChunkLock.lock();
            try {
                this.setSize(this.fileChannel.size());
            }
            finally {
                this.saveChunkLock.unlock();
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw DataUtils.newMVStoreException(1, "Could not open file {0}", fileName, e);
        }
    }

    private FileLock lockFileChannel(FileChannel fileChannel, boolean readOnly, String fileName) throws IOException {
        FileLock fileLock;
        try {
            fileLock = fileChannel.tryLock(0L, Long.MAX_VALUE, readOnly);
        }
        catch (OverlappingFileLockException e) {
            throw DataUtils.newMVStoreException(7, "The file is locked: {0}", fileName, e);
        }
        if (fileLock == null) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw DataUtils.newMVStoreException(7, "The file is locked: {0}", fileName);
        }
        return fileLock;
    }

    @Override
    public void close() {
        try {
            try {
                if (this.fileChannel.isOpen()) {
                    if (this.fileLock != null) {
                        this.fileLock.release();
                    }
                    this.fileChannel.close();
                }
            }
            catch (Exception e) {
                throw DataUtils.newMVStoreException(2, "Closing failed for file {0}", this.getFileName(), e);
            }
        }
        finally {
            this.fileLock = null;
            super.close();
        }
    }

    @Override
    public void sync() {
        if (this.fileChannel.isOpen()) {
            try {
                this.fileChannel.force(true);
            }
            catch (IOException e) {
                throw DataUtils.newMVStoreException(2, "Could not sync file {0}", this.getFileName(), e);
            }
        }
    }

    @Override
    public void truncate(long size) {
        int attemptCount = 0;
        while (true) {
            try {
                this.writeCount.incrementAndGet();
                this.fileChannel.truncate(size);
                this.setSize(Math.min(super.size(), size));
                return;
            }
            catch (IOException e) {
                if (++attemptCount == 10) {
                    throw DataUtils.newMVStoreException(2, "Could not truncate file {0} to size {1}", this.getFileName(), size, e);
                }
                System.gc();
                Thread.yield();
                continue;
            }
            break;
        }
    }

    @Override
    public int getMovePriority(int block) {
        return this.freeSpace.getMovePriority(block);
    }

    @Override
    protected long getAfterLastBlock_() {
        return this.freeSpace.getAfterLastBlock();
    }

    @Override
    public void backup(ZipOutputStream out) throws IOException {
        boolean before = this.isSpaceReused();
        this.setReuseSpace(false);
        try {
            SingleFileStore.backupFile(out, this.getFileName(), this.originalFileChannel != null ? this.originalFileChannel : this.fileChannel);
        }
        finally {
            this.setReuseSpace(before);
        }
    }

    private static void backupFile(ZipOutputStream out, String fileName, FileChannel in) throws IOException {
        String f = FilePath.get(fileName).toRealPath().getName();
        f = SingleFileStore.correctFileName(f);
        out.putNextEntry(new ZipEntry(f));
        IOUtils.copy(in, (OutputStream)out);
        out.closeEntry();
    }

    public static String correctFileName(String f) {
        if ((f = f.replace('\\', '/')).startsWith("/")) {
            f = f.substring(1);
        }
        return f;
    }
}

