/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.cache;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.h2.mvstore.DataUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CacheLongKeyLIRS<V> {
    private long maxMemory;
    private final Segment<V>[] segments;
    private final int segmentCount;
    private final int segmentShift;
    private final int segmentMask;
    private final int stackMoveDistance;
    private final int nonResidentQueueSize;
    private final int nonResidentQueueSizeHigh;

    public CacheLongKeyLIRS(Config config) {
        this.setMaxMemory(config.maxMemory);
        this.nonResidentQueueSize = config.nonResidentQueueSize;
        this.nonResidentQueueSizeHigh = config.nonResidentQueueSizeHigh;
        DataUtils.checkArgument(Integer.bitCount(config.segmentCount) == 1, "The segment count must be a power of 2, is {0}", config.segmentCount);
        this.segmentCount = config.segmentCount;
        this.segmentMask = this.segmentCount - 1;
        this.stackMoveDistance = config.stackMoveDistance;
        this.segments = new Segment[this.segmentCount];
        this.clear();
        this.segmentShift = 32 - Integer.bitCount(this.segmentMask);
    }

    public void clear() {
        long max = this.getMaxItemSize();
        int i = 0;
        while (i < this.segmentCount) {
            this.segments[i] = new Segment(max, this.stackMoveDistance, 8, this.nonResidentQueueSize, this.nonResidentQueueSizeHigh);
            ++i;
        }
    }

    public long getMaxItemSize() {
        return Math.max(1L, this.maxMemory / (long)this.segmentCount);
    }

    private Entry<V> find(long key) {
        int hash = CacheLongKeyLIRS.getHash(key);
        return this.getSegment(hash).find(key, hash);
    }

    public boolean containsKey(long key) {
        Entry<V> e = this.find(key);
        return e != null && e.value != null;
    }

    public V peek(long key) {
        Entry<V> e = this.find(key);
        return e == null ? null : (V)e.getValue();
    }

    public V put(long key, V value) {
        return this.put(key, value, this.sizeOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(long key, V value, long memory) {
        Segment<V> s;
        if (value == null) {
            throw DataUtils.newIllegalArgumentException("The value may not be null", new Object[0]);
        }
        int hash = CacheLongKeyLIRS.getHash(key);
        int segmentIndex = this.getSegmentIndex(hash);
        Segment<V> segment = s = this.segments[segmentIndex];
        synchronized (segment) {
            s = this.resizeIfNeeded(s, segmentIndex);
            return s.put(key, hash, value, memory);
        }
    }

    private Segment<V> resizeIfNeeded(Segment<V> s, int segmentIndex) {
        int newLen = s.getNewMapLen();
        if (newLen == 0) {
            return s;
        }
        Segment<V> s2 = this.segments[segmentIndex];
        if (s == s2) {
            s = new Segment<V>(s, newLen);
            this.segments[segmentIndex] = s;
        }
        return s;
    }

    protected long sizeOf(V value) {
        return 16L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long key) {
        Segment<V> s;
        int hash = CacheLongKeyLIRS.getHash(key);
        int segmentIndex = this.getSegmentIndex(hash);
        Segment<V> segment = s = this.segments[segmentIndex];
        synchronized (segment) {
            s = this.resizeIfNeeded(s, segmentIndex);
            return s.remove(key, hash);
        }
    }

    public long getMemory(long key) {
        Entry<V> e = this.find(key);
        return e == null ? 0L : e.getMemory();
    }

    public static int getMemoryOverhead() {
        return 112;
    }

    public V get(long key) {
        int hash = CacheLongKeyLIRS.getHash(key);
        Segment<V> s = this.getSegment(hash);
        Entry<V> e = s.find(key, hash);
        return s.get(e);
    }

    private Segment<V> getSegment(int hash) {
        return this.segments[this.getSegmentIndex(hash)];
    }

    private int getSegmentIndex(int hash) {
        return hash >>> this.segmentShift & this.segmentMask;
    }

    static int getHash(long key) {
        int hash = (int)(key >>> 32 ^ key);
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = hash >>> 16 ^ hash;
        return hash;
    }

    public long getUsedMemory() {
        long x = 0L;
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            x += s.usedMemory;
            ++n2;
        }
        return x;
    }

    public void setMaxMemory(long maxMemory) {
        DataUtils.checkArgument(maxMemory > 0L, "Max memory must be larger than 0, is {0}", maxMemory);
        this.maxMemory = maxMemory;
        if (this.segments != null) {
            long max = 1L + maxMemory / (long)this.segments.length;
            Segment<V>[] segmentArray = this.segments;
            int n = this.segments.length;
            int n2 = 0;
            while (n2 < n) {
                Segment<V> s = segmentArray[n2];
                s.setMaxMemory(max);
                ++n2;
            }
        }
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public synchronized Set<Map.Entry<Long, V>> entrySet() {
        return this.getMap().entrySet();
    }

    public Set<Long> keySet() {
        HashSet<Long> set = new HashSet<Long>();
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            set.addAll(s.keySet());
            ++n2;
        }
        return set;
    }

    public int sizeNonResident() {
        int x = 0;
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            x += s.queue2Size;
            ++n2;
        }
        return x;
    }

    public int sizeMapArray() {
        int x = 0;
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            x += s.entries.length;
            ++n2;
        }
        return x;
    }

    public int sizeHot() {
        int x = 0;
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            x += s.mapSize - s.queueSize - s.queue2Size;
            ++n2;
        }
        return x;
    }

    public long getHits() {
        long x = 0L;
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            x += s.hits;
            ++n2;
        }
        return x;
    }

    public long getMisses() {
        int x = 0;
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            x = (int)((long)x + s.misses);
            ++n2;
        }
        return x;
    }

    public int size() {
        int x = 0;
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            x += s.mapSize - s.queue2Size;
            ++n2;
        }
        return x;
    }

    public List<Long> keys(boolean cold, boolean nonResident) {
        ArrayList<Long> keys = new ArrayList<Long>();
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s = segmentArray[n2];
            keys.addAll(s.keys(cold, nonResident));
            ++n2;
        }
        return keys;
    }

    public List<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        for (long k : this.keySet()) {
            V value = this.peek(k);
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(V value) {
        return this.getMap().containsValue(value);
    }

    public Map<Long, V> getMap() {
        HashMap<Long, V> map = new HashMap<Long, V>();
        for (long k : this.keySet()) {
            V x = this.peek(k);
            if (x == null) continue;
            map.put(k, x);
        }
        return map;
    }

    public void putAll(Map<Long, ? extends V> m) {
        for (Map.Entry<Long, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimNonResidentQueue() {
        Segment<V>[] segmentArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            Segment<V> s;
            Segment<V> segment = s = segmentArray[n2];
            synchronized (segment) {
                s.trimNonResidentQueue();
            }
            ++n2;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Config {
        public long maxMemory = 1L;
        public int segmentCount = 16;
        public int stackMoveDistance = 32;
        public final int nonResidentQueueSize = 3;
        public final int nonResidentQueueSizeHigh = 12;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class Entry<V> {
        static final int TOTAL_MEMORY_OVERHEAD = 112;
        final long key;
        V value;
        WeakReference<V> reference;
        final long memory;
        int topMove;
        Entry<V> stackNext;
        Entry<V> stackPrev;
        Entry<V> queueNext;
        Entry<V> queuePrev;
        Entry<V> mapNext;

        Entry() {
            this(0L, null, 0L);
        }

        Entry(long key, V value, long memory) {
            this.key = key;
            this.memory = memory + 112L;
            this.value = value;
        }

        Entry(Entry<V> old) {
            this.key = old.key;
            this.memory = old.memory;
            this.value = old.value;
            this.reference = old.reference;
            this.topMove = old.topMove;
        }

        boolean isHot() {
            return this.queueNext == null;
        }

        V getValue() {
            return (V)(this.value == null ? this.reference.get() : this.value);
        }

        long getMemory() {
            return this.value == null ? 0L : this.memory;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Segment<V> {
        int mapSize;
        int queueSize;
        int queue2Size;
        long hits;
        long misses;
        final Entry<V>[] entries;
        long usedMemory;
        private final int stackMoveDistance;
        private long maxMemory;
        private final int mask;
        private final int nonResidentQueueSize;
        private final int nonResidentQueueSizeHigh;
        private final Entry<V> stack;
        private int stackSize;
        private final Entry<V> queue;
        private final Entry<V> queue2;
        private int stackMoveCounter;

        Segment(long maxMemory, int stackMoveDistance, int len, int nonResidentQueueSize, int nonResidentQueueSizeHigh) {
            this.setMaxMemory(maxMemory);
            this.stackMoveDistance = stackMoveDistance;
            this.nonResidentQueueSize = nonResidentQueueSize;
            this.nonResidentQueueSizeHigh = nonResidentQueueSizeHigh;
            this.mask = len - 1;
            this.stack = new Entry();
            this.stack.stackNext = this.stack;
            this.stack.stackPrev = this.stack.stackNext;
            this.queue = new Entry();
            this.queue.queueNext = this.queue;
            this.queue.queuePrev = this.queue.queueNext;
            this.queue2 = new Entry();
            this.queue2.queueNext = this.queue2;
            this.queue2.queuePrev = this.queue2.queueNext;
            Entry[] e = new Entry[len];
            this.entries = e;
        }

        Segment(Segment<V> old, int len) {
            this(old.maxMemory, old.stackMoveDistance, len, old.nonResidentQueueSize, old.nonResidentQueueSizeHigh);
            Entry e;
            this.hits = old.hits;
            this.misses = old.misses;
            Entry s = old.stack.stackPrev;
            while (s != old.stack) {
                e = new Entry(s);
                this.addToMap(e);
                this.addToStack(e);
                s = s.stackPrev;
            }
            s = old.queue.queuePrev;
            while (s != old.queue) {
                e = this.find(s.key, CacheLongKeyLIRS.getHash(s.key));
                if (e == null) {
                    e = new Entry(s);
                    this.addToMap(e);
                }
                this.addToQueue(this.queue, e);
                s = s.queuePrev;
            }
            s = old.queue2.queuePrev;
            while (s != old.queue2) {
                e = this.find(s.key, CacheLongKeyLIRS.getHash(s.key));
                if (e == null) {
                    e = new Entry(s);
                    this.addToMap(e);
                }
                this.addToQueue(this.queue2, e);
                s = s.queuePrev;
            }
        }

        int getNewMapLen() {
            int len = this.mask + 1;
            if (len * 3 < this.mapSize * 4 && len < 0x10000000) {
                return len * 2;
            }
            if (len > 32 && len / 8 > this.mapSize) {
                return len / 2;
            }
            return 0;
        }

        private void addToMap(Entry<V> e) {
            int index = CacheLongKeyLIRS.getHash(e.key) & this.mask;
            e.mapNext = this.entries[index];
            this.entries[index] = e;
            this.usedMemory += e.getMemory();
            ++this.mapSize;
        }

        synchronized V get(Entry<V> e) {
            V value;
            V v = value = e == null ? null : (V)e.getValue();
            if (value == null) {
                ++this.misses;
            } else {
                this.access(e);
                ++this.hits;
            }
            return value;
        }

        private void access(Entry<V> e) {
            if (e.isHot()) {
                if (e != this.stack.stackNext && e.stackNext != null && this.stackMoveCounter - e.topMove > this.stackMoveDistance) {
                    boolean wasEnd = e == this.stack.stackPrev;
                    this.removeFromStack(e);
                    if (wasEnd) {
                        this.pruneStack();
                    }
                    this.addToStack(e);
                }
            } else {
                V v = e.getValue();
                if (v != null) {
                    this.removeFromQueue(e);
                    if (e.reference != null) {
                        e.value = v;
                        e.reference = null;
                        this.usedMemory += e.memory;
                    }
                    if (e.stackNext != null) {
                        this.removeFromStack(e);
                        this.convertOldestHotToCold();
                    } else {
                        this.addToQueue(this.queue, e);
                    }
                    this.addToStack(e);
                    this.pruneStack();
                }
            }
        }

        synchronized V put(long key, int hash, V value, long memory) {
            Entry<V> e = this.find(key, hash);
            boolean existed = e != null;
            V old = null;
            if (existed) {
                old = e.getValue();
                this.remove(key, hash);
            }
            if (memory + 112L > this.maxMemory) {
                return old;
            }
            e = new Entry<V>(key, value, memory);
            int index = hash & this.mask;
            e.mapNext = this.entries[index];
            this.entries[index] = e;
            this.usedMemory += e.memory;
            if (this.usedMemory > this.maxMemory) {
                this.evict();
                if (this.stackSize > 0) {
                    this.addToQueue(this.queue, e);
                }
            }
            ++this.mapSize;
            this.addToStack(e);
            if (existed) {
                this.access(e);
            }
            return old;
        }

        synchronized V remove(long key, int hash) {
            int index = hash & this.mask;
            Entry<V> e = this.entries[index];
            if (e == null) {
                return null;
            }
            if (e.key == key) {
                this.entries[index] = e.mapNext;
            } else {
                do {
                    Entry<V> last = e;
                    e = e.mapNext;
                    if (e != null) continue;
                    return null;
                } while (e.key != key);
                last.mapNext = e.mapNext;
            }
            V old = e.getValue();
            --this.mapSize;
            this.usedMemory -= e.getMemory();
            if (e.stackNext != null) {
                this.removeFromStack(e);
            }
            if (e.isHot()) {
                e = this.queue.queueNext;
                if (e != this.queue) {
                    this.removeFromQueue(e);
                    if (e.stackNext == null) {
                        this.addToStackBottom(e);
                    }
                }
                this.pruneStack();
            } else {
                this.removeFromQueue(e);
            }
            return old;
        }

        private void evict() {
            do {
                this.evictBlock();
            } while (this.usedMemory > this.maxMemory);
        }

        private void evictBlock() {
            while (this.queueSize <= this.mapSize - this.queue2Size >>> 5 && this.stackSize > 0) {
                this.convertOldestHotToCold();
            }
            while (this.usedMemory > this.maxMemory && this.queueSize > 0) {
                Entry e = this.queue.queuePrev;
                this.usedMemory -= e.memory;
                this.removeFromQueue(e);
                e.reference = new WeakReference(e.value);
                e.value = null;
                this.addToQueue(this.queue2, e);
                this.trimNonResidentQueue();
            }
        }

        void trimNonResidentQueue() {
            int residentCount = this.mapSize - this.queue2Size;
            int maxQueue2SizeHigh = this.nonResidentQueueSizeHigh * residentCount;
            int maxQueue2Size = this.nonResidentQueueSize * residentCount;
            while (this.queue2Size > maxQueue2Size) {
                WeakReference reference;
                Entry e = this.queue2.queuePrev;
                if (this.queue2Size <= maxQueue2SizeHigh && (reference = e.reference) != null && reference.get() != null) break;
                int hash = CacheLongKeyLIRS.getHash(e.key);
                this.remove(e.key, hash);
            }
        }

        private void convertOldestHotToCold() {
            Entry last = this.stack.stackPrev;
            if (last == this.stack) {
                throw new IllegalStateException();
            }
            this.removeFromStack(last);
            this.addToQueue(this.queue, last);
            this.pruneStack();
        }

        private void pruneStack() {
            Entry last;
            while (!(last = this.stack.stackPrev).isHot()) {
                this.removeFromStack(last);
            }
        }

        Entry<V> find(long key, int hash) {
            int index = hash & this.mask;
            Entry<V> e = this.entries[index];
            while (e != null && e.key != key) {
                e = e.mapNext;
            }
            return e;
        }

        private void addToStack(Entry<V> e) {
            e.stackPrev = this.stack;
            e.stackNext = this.stack.stackNext;
            e.stackNext.stackPrev = e;
            this.stack.stackNext = e;
            ++this.stackSize;
            e.topMove = this.stackMoveCounter++;
        }

        private void addToStackBottom(Entry<V> e) {
            e.stackNext = this.stack;
            e.stackPrev = this.stack.stackPrev;
            e.stackPrev.stackNext = e;
            this.stack.stackPrev = e;
            ++this.stackSize;
        }

        private void removeFromStack(Entry<V> e) {
            e.stackPrev.stackNext = e.stackNext;
            e.stackNext.stackPrev = e.stackPrev;
            e.stackNext = null;
            e.stackPrev = null;
            --this.stackSize;
        }

        private void addToQueue(Entry<V> q, Entry<V> e) {
            e.queuePrev = q;
            e.queueNext = q.queueNext;
            e.queueNext.queuePrev = e;
            q.queueNext = e;
            if (e.value != null) {
                ++this.queueSize;
            } else {
                ++this.queue2Size;
            }
        }

        private void removeFromQueue(Entry<V> e) {
            e.queuePrev.queueNext = e.queueNext;
            e.queueNext.queuePrev = e.queuePrev;
            e.queueNext = null;
            e.queuePrev = null;
            if (e.value != null) {
                --this.queueSize;
            } else {
                --this.queue2Size;
            }
        }

        synchronized List<Long> keys(boolean cold, boolean nonResident) {
            ArrayList<Long> keys = new ArrayList<Long>();
            if (cold) {
                Entry<V> start = nonResident ? this.queue2 : this.queue;
                Entry e = start.queueNext;
                while (e != start) {
                    keys.add(e.key);
                    e = e.queueNext;
                }
            } else {
                Entry e = this.stack.stackNext;
                while (e != this.stack) {
                    keys.add(e.key);
                    e = e.stackNext;
                }
            }
            return keys;
        }

        synchronized Set<Long> keySet() {
            HashSet<Long> set = new HashSet<Long>();
            Entry e = this.stack.stackNext;
            while (e != this.stack) {
                set.add(e.key);
                e = e.stackNext;
            }
            e = this.queue.queueNext;
            while (e != this.queue) {
                set.add(e.key);
                e = e.queueNext;
            }
            return set;
        }

        void setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
        }
    }
}

