/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.mvstore.cache.CacheLongKeyLIRS;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FilePathWrapper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class FilePathCache
extends FilePathWrapper {
    public static final FilePathCache INSTANCE = new FilePathCache();

    static {
        FilePath.register(INSTANCE);
    }

    public static FileChannel wrap(FileChannel f) {
        return new FileCache(f);
    }

    @Override
    public FileChannel open(String mode) throws IOException {
        return new FileCache(this.getBase().open(mode));
    }

    @Override
    public String getScheme() {
        return "cache";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class FileCache
    extends FileBase {
        private static final int CACHE_BLOCK_SIZE = 4096;
        private final FileChannel base;
        private final CacheLongKeyLIRS<ByteBuffer> cache;

        FileCache(FileChannel base) {
            CacheLongKeyLIRS.Config cc = new CacheLongKeyLIRS.Config();
            cc.maxMemory = 0x100000L;
            this.cache = new CacheLongKeyLIRS(cc);
            this.base = base;
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.base.close();
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            this.base.position(newPosition);
            return this;
        }

        @Override
        public long position() throws IOException {
            return this.base.position();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return this.base.read(dst);
        }

        @Override
        public synchronized int read(ByteBuffer dst, long position) throws IOException {
            long cachePos = FileCache.getCachePos(position);
            int off = (int)(position - cachePos);
            int len = 4096 - off;
            len = Math.min(len, dst.remaining());
            ByteBuffer buff = this.cache.get(cachePos);
            if (buff == null) {
                int read;
                buff = ByteBuffer.allocate(4096);
                long pos = cachePos;
                while ((read = this.base.read(buff, pos)) > 0 && buff.remaining() != 0) {
                    pos += (long)read;
                }
                read = buff.position();
                if (read == 4096) {
                    this.cache.put(cachePos, buff, 4176L);
                } else {
                    if (read <= 0) {
                        return -1;
                    }
                    len = Math.min(len, read - off);
                }
            }
            dst.put(buff.array(), off, len);
            return len == 0 ? -1 : len;
        }

        private static long getCachePos(long pos) {
            return pos / 4096L * 4096L;
        }

        @Override
        public long size() throws IOException {
            return this.base.size();
        }

        @Override
        public synchronized FileChannel truncate(long newSize) throws IOException {
            this.cache.clear();
            this.base.truncate(newSize);
            return this;
        }

        @Override
        public synchronized int write(ByteBuffer src, long position) throws IOException {
            this.clearCache(src, position);
            return this.base.write(src, position);
        }

        @Override
        public synchronized int write(ByteBuffer src) throws IOException {
            this.clearCache(src, this.position());
            return this.base.write(src);
        }

        private void clearCache(ByteBuffer src, long position) {
            if (this.cache.size() > 0) {
                int len = src.remaining();
                long p = FileCache.getCachePos(position);
                while (len > 0) {
                    this.cache.remove(p);
                    p += 4096L;
                    len -= 4096;
                }
            }
        }

        @Override
        public void force(boolean metaData) throws IOException {
            this.base.force(metaData);
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return this.base.tryLock(position, size, shared);
        }

        public String toString() {
            return "cache:" + this.base.toString();
        }
    }
}

