/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.h2.engine.Database;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.StreamStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.db.NullValueDataType;
import org.h2.mvstore.db.Store;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.ByteArrayDataType;
import org.h2.mvstore.type.LongDataType;
import org.h2.store.CountingReaderInputStream;
import org.h2.store.LobStorageInterface;
import org.h2.store.RangeInputStream;
import org.h2.util.IOUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueBlob;
import org.h2.value.ValueClob;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class LobStorageMap
implements LobStorageInterface {
    private static final boolean TRACE = false;
    private final Database database;
    final MVStore mvStore;
    private final AtomicLong nextLobId = new AtomicLong(0L);
    private final ThreadPoolExecutor cleanupExecutor;
    private final MVMap<Long, BlobMeta> lobMap;
    private final MVMap<Long, byte[]> tempLobMap;
    private final MVMap<BlobReference, Value> refMap;
    private final StreamStore streamStore;
    private final Queue<LobRemovalInfo> pendingLobRemovals = new ConcurrentLinkedQueue<LobRemovalInfo>();

    public static MVMap<Long, BlobMeta> openLobMap(TransactionStore txStore) {
        return txStore.openMap("lobMap", LongDataType.INSTANCE, BlobMeta.Type.INSTANCE);
    }

    public static MVMap<Long, byte[]> openLobDataMap(TransactionStore txStore) {
        return txStore.openMap("lobData", LongDataType.INSTANCE, ByteArrayDataType.INSTANCE);
    }

    public LobStorageMap(Database database) {
        this.database = database;
        Store s = database.getStore();
        TransactionStore txStore = s.getTransactionStore();
        this.mvStore = s.getMvStore();
        if (this.mvStore.isVersioningRequired()) {
            this.cleanupExecutor = Utils.createSingleThreadExecutor("H2-lob-cleaner", new SynchronousQueue<Runnable>());
            this.mvStore.setOldestVersionTracker(oldestVersionToKeep -> {
                if (this.needCleanup()) {
                    try {
                        this.cleanupExecutor.execute(() -> {
                            try {
                                this.cleanup(oldestVersionToKeep);
                            }
                            catch (MVStoreException e) {
                                this.mvStore.panic(e);
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            });
        } else {
            this.cleanupExecutor = null;
        }
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            this.lobMap = LobStorageMap.openLobMap(txStore);
            this.tempLobMap = txStore.openMap("tempLobMap", LongDataType.INSTANCE, ByteArrayDataType.INSTANCE);
            this.refMap = txStore.openMap("lobRef", BlobReference.Type.INSTANCE, NullValueDataType.INSTANCE);
            MVMap<Long, byte[]> dataMap = LobStorageMap.openLobDataMap(txStore);
            this.streamStore = new StreamStore(dataMap);
            if (!database.isReadOnly()) {
                Long last = dataMap.lastKey();
                if (last != null) {
                    this.streamStore.setNextKey(last + 1L);
                }
                Long id1 = this.lobMap.lastKey();
                Long id2 = this.tempLobMap.lastKey();
                long next = 1L;
                if (id1 != null) {
                    next = id1 + 1L;
                }
                if (id2 != null) {
                    next = Math.max(next, id2 + 1L);
                }
                this.nextLobId.set(next);
            }
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public ValueBlob createBlob(InputStream in, long maxLength) {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            if (maxLength != -1L && maxLength <= (long)this.database.getMaxLengthInplaceLob()) {
                byte[] small = new byte[(int)maxLength];
                int len = IOUtils.readFully(in, small, (int)maxLength);
                if ((long)len > maxLength) {
                    throw new IllegalStateException("len > blobLength, " + len + " > " + maxLength);
                }
                if (len < small.length) {
                    small = Arrays.copyOf(small, len);
                }
                ValueBlob valueBlob = ValueBlob.createSmall(small);
                return valueBlob;
            }
            if (maxLength != -1L) {
                in = new RangeInputStream(in, 0L, maxLength);
            }
            ValueBlob valueBlob = this.createBlob(in);
            return valueBlob;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public ValueClob createClob(Reader reader, long maxLength) {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            if (maxLength != -1L && maxLength * 3L <= (long)this.database.getMaxLengthInplaceLob()) {
                char[] small = new char[(int)maxLength];
                int len = IOUtils.readFully(reader, small, (int)maxLength);
                if ((long)len > maxLength) {
                    throw new IllegalStateException("len > blobLength, " + len + " > " + maxLength);
                }
                byte[] utf8 = new String(small, 0, len).getBytes(StandardCharsets.UTF_8);
                if (utf8.length > this.database.getMaxLengthInplaceLob()) {
                    throw new IllegalStateException("len > maxinplace, " + utf8.length + " > " + this.database.getMaxLengthInplaceLob());
                }
                ValueClob valueClob = ValueClob.createSmall(utf8, len);
                return valueClob;
            }
            if (maxLength < 0L) {
                maxLength = Long.MAX_VALUE;
            }
            CountingReaderInputStream in = new CountingReaderInputStream(reader, maxLength);
            ValueBlob blob = this.createBlob(in);
            LobData lobData = blob.getLobData();
            ValueClob valueClob = new ValueClob(lobData, blob.octetLength(), in.getLength());
            return valueClob;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    private ValueBlob createBlob(InputStream in) throws IOException {
        byte[] streamStoreId;
        try {
            streamStoreId = this.streamStore.put(in);
        }
        catch (Exception e) {
            throw DataUtils.convertToIOException(e);
        }
        long lobId = this.generateLobId();
        long length = this.streamStore.length(streamStoreId);
        int tableId = -2;
        this.tempLobMap.put(lobId, streamStoreId);
        BlobReference key = new BlobReference(streamStoreId, lobId);
        this.refMap.put(key, ValueNull.INSTANCE);
        ValueBlob lob = new ValueBlob(new LobDataDatabase(this.database, -2, lobId), length);
        return lob;
    }

    private long generateLobId() {
        return this.nextLobId.getAndIncrement();
    }

    @Override
    public boolean isReadOnly() {
        return this.database.isReadOnly();
    }

    @Override
    public ValueLob copyLob(ValueLob old, int tableId) {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            ValueLob lob;
            byte[] streamStoreId;
            LobDataDatabase lobData = (LobDataDatabase)old.getLobData();
            int type = old.getValueType();
            long oldLobId = lobData.getLobId();
            long octetLength = old.octetLength();
            if (LobStorageMap.isTemporaryLob(lobData.getTableId())) {
                streamStoreId = this.tempLobMap.get(oldLobId);
            } else {
                BlobMeta value = this.lobMap.get(oldLobId);
                streamStoreId = value.streamStoreId;
            }
            long newLobId = this.generateLobId();
            if (LobStorageMap.isTemporaryLob(tableId)) {
                this.tempLobMap.put(newLobId, streamStoreId);
            } else {
                BlobMeta value = new BlobMeta(streamStoreId, tableId, type == 3 ? old.charLength() : octetLength, 0L);
                this.lobMap.put(newLobId, value);
            }
            BlobReference refMapKey = new BlobReference(streamStoreId, newLobId);
            this.refMap.put(refMapKey, ValueNull.INSTANCE);
            LobDataDatabase newLobData = new LobDataDatabase(this.database, tableId, newLobId);
            ValueLob valueLob = lob = type == 7 ? new ValueBlob(newLobData, octetLength) : new ValueClob(newLobData, octetLength, old.charLength());
            return valueLob;
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public InputStream getInputStream(long lobId, long byteCount) throws IOException {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            byte[] streamStoreId = this.tempLobMap.get(lobId);
            if (streamStoreId == null) {
                BlobMeta value = this.lobMap.get(lobId);
                streamStoreId = value.streamStoreId;
            }
            if (streamStoreId == null) {
                throw DbException.get(90039, "" + lobId);
            }
            InputStream inputStream = this.streamStore.get(streamStoreId);
            LobInputStream lobInputStream = new LobInputStream(inputStream);
            return lobInputStream;
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public InputStream getInputStream(long lobId, int tableId, long byteCount) throws IOException {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            byte[] streamStoreId;
            if (LobStorageMap.isTemporaryLob(tableId)) {
                streamStoreId = this.tempLobMap.get(lobId);
            } else {
                BlobMeta value = this.lobMap.get(lobId);
                streamStoreId = value.streamStoreId;
            }
            if (streamStoreId == null) {
                throw DbException.get(90039, "" + lobId);
            }
            InputStream inputStream = this.streamStore.get(streamStoreId);
            LobInputStream lobInputStream = new LobInputStream(inputStream);
            return lobInputStream;
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public void removeAllForTable(int tableId) {
        if (this.mvStore.isClosed()) {
            return;
        }
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            if (LobStorageMap.isTemporaryLob(tableId)) {
                Iterator<Long> iter = this.tempLobMap.keyIterator(0L);
                while (iter.hasNext()) {
                    long lobId = iter.next();
                    this.doRemoveLob(tableId, lobId);
                }
                this.tempLobMap.clear();
            } else {
                ArrayList<Long> list = new ArrayList<Long>();
                for (Map.Entry<Long, BlobMeta> e : this.lobMap.entrySet()) {
                    BlobMeta value = e.getValue();
                    if (value.tableId != tableId) continue;
                    list.add(e.getKey());
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    long lobId = (Long)iterator.next();
                    this.doRemoveLob(tableId, lobId);
                }
            }
        }
        finally {
            this.mvStore.deregisterVersionUsage(txCounter);
        }
    }

    @Override
    public void removeLob(ValueLob lob) {
        LobDataDatabase lobData = (LobDataDatabase)lob.getLobData();
        int tableId = lobData.getTableId();
        long lobId = lobData.getLobId();
        this.requestLobRemoval(tableId, lobId);
    }

    private void requestLobRemoval(int tableId, long lobId) {
        this.pendingLobRemovals.offer(new LobRemovalInfo(this.mvStore.getCurrentVersion(), lobId, tableId));
    }

    private boolean needCleanup() {
        return !this.pendingLobRemovals.isEmpty();
    }

    @Override
    public void close() {
        this.mvStore.setOldestVersionTracker(null);
        Utils.shutdownExecutor(this.cleanupExecutor);
        if (!this.mvStore.isClosed() && this.mvStore.isVersioningRequired()) {
            this.removeAllForTable(-1);
            this.cleanup(this.mvStore.getCurrentVersion() + 1L);
        }
    }

    private void cleanup(long oldestVersionToKeep) {
        MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
        try {
            LobRemovalInfo lobRemovalInfo;
            while ((lobRemovalInfo = this.pendingLobRemovals.poll()) != null && lobRemovalInfo.version < oldestVersionToKeep) {
                this.doRemoveLob(lobRemovalInfo.mapId, lobRemovalInfo.lobId);
            }
            if (lobRemovalInfo != null) {
                this.pendingLobRemovals.offer(lobRemovalInfo);
            }
        }
        finally {
            this.mvStore.decrementVersionUsageCounter(txCounter);
        }
    }

    private void doRemoveLob(int tableId, long lobId) {
        byte[] s2;
        byte[] streamStoreId;
        if (LobStorageMap.isTemporaryLob(tableId)) {
            streamStoreId = this.tempLobMap.remove(lobId);
            if (streamStoreId == null) {
                return;
            }
        } else {
            BlobMeta value = this.lobMap.remove(lobId);
            if (value == null) {
                return;
            }
            streamStoreId = value.streamStoreId;
        }
        BlobReference key = new BlobReference(streamStoreId, lobId);
        Value existing = this.refMap.remove(key);
        assert (existing != null);
        key = new BlobReference(streamStoreId, 0L);
        BlobReference value = this.refMap.ceilingKey(key);
        boolean hasMoreEntries = false;
        if (value != null && Arrays.equals(streamStoreId, s2 = value.streamStoreId)) {
            hasMoreEntries = true;
        }
        if (!hasMoreEntries) {
            this.streamStore.remove(streamStoreId);
        }
    }

    private static boolean isTemporaryLob(int tableId) {
        return tableId == -1 || tableId == -2 || tableId == -3;
    }

    private static void trace(String op) {
        System.out.println("[" + Thread.currentThread().getName() + "] LOB " + op);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class BlobMeta {
        public final byte[] streamStoreId;
        final int tableId;
        final long byteCount;
        final long hash;

        public BlobMeta(byte[] streamStoreId, int tableId, long byteCount, long hash) {
            this.streamStoreId = streamStoreId;
            this.tableId = tableId;
            this.byteCount = byteCount;
            this.hash = hash;
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static final class Type
        extends BasicDataType<BlobMeta> {
            public static final Type INSTANCE = new Type();

            private Type() {
            }

            @Override
            public int getMemory(BlobMeta blobMeta) {
                return blobMeta.streamStoreId.length + 20;
            }

            @Override
            public void write(WriteBuffer buff, BlobMeta blobMeta) {
                buff.putVarInt(blobMeta.streamStoreId.length);
                buff.put(blobMeta.streamStoreId);
                buff.putVarInt(blobMeta.tableId);
                buff.putVarLong(blobMeta.byteCount);
                buff.putLong(blobMeta.hash);
            }

            @Override
            public BlobMeta read(ByteBuffer buff) {
                int len = DataUtils.readVarInt(buff);
                byte[] streamStoreId = new byte[len];
                buff.get(streamStoreId);
                int tableId = DataUtils.readVarInt(buff);
                long byteCount = DataUtils.readVarLong(buff);
                long hash = buff.getLong();
                return new BlobMeta(streamStoreId, tableId, byteCount, hash);
            }

            public BlobMeta[] createStorage(int size) {
                return new BlobMeta[size];
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class BlobReference
    implements Comparable<BlobReference> {
        public final byte[] streamStoreId;
        public final long lobId;

        public BlobReference(byte[] streamStoreId, long lobId) {
            this.streamStoreId = streamStoreId;
            this.lobId = lobId;
        }

        @Override
        public int compareTo(BlobReference other) {
            int res = Integer.compare(this.streamStoreId.length, other.streamStoreId.length);
            if (res == 0) {
                int i = 0;
                while (res == 0 && i < this.streamStoreId.length) {
                    res = Byte.compare(this.streamStoreId[i], other.streamStoreId[i]);
                    ++i;
                }
                if (res == 0) {
                    res = Long.compare(this.lobId, other.lobId);
                }
            }
            return res;
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static final class Type
        extends BasicDataType<BlobReference> {
            public static final Type INSTANCE = new Type();

            private Type() {
            }

            @Override
            public int getMemory(BlobReference blobReference) {
                return blobReference.streamStoreId.length + 8;
            }

            @Override
            public int compare(BlobReference one, BlobReference two) {
                return one == two ? 0 : (one == null ? 1 : (two == null ? -1 : one.compareTo(two)));
            }

            @Override
            public void write(WriteBuffer buff, BlobReference blobReference) {
                buff.putVarInt(blobReference.streamStoreId.length);
                buff.put(blobReference.streamStoreId);
                buff.putVarLong(blobReference.lobId);
            }

            @Override
            public BlobReference read(ByteBuffer buff) {
                int len = DataUtils.readVarInt(buff);
                byte[] streamStoreId = new byte[len];
                buff.get(streamStoreId);
                long blobId = DataUtils.readVarLong(buff);
                return new BlobReference(streamStoreId, blobId);
            }

            public BlobReference[] createStorage(int size) {
                return new BlobReference[size];
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class LobInputStream
    extends FilterInputStream {
        public LobInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            MVStore.TxCounter txCounter = LobStorageMap.this.mvStore.registerVersionUsage();
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                LobStorageMap.this.mvStore.deregisterVersionUsage(txCounter);
            }
        }

        @Override
        public int read() throws IOException {
            MVStore.TxCounter txCounter = LobStorageMap.this.mvStore.registerVersionUsage();
            try {
                int n = super.read();
                return n;
            }
            finally {
                LobStorageMap.this.mvStore.deregisterVersionUsage(txCounter);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class LobRemovalInfo {
        final long version;
        final long lobId;
        final int mapId;

        LobRemovalInfo(long version, long lobId, int mapId) {
            this.version = version;
            this.lobId = lobId;
            this.mapId = mapId;
        }
    }
}

