/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.h2.engine.IsolationLevel;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.RootReference;
import org.h2.mvstore.tx.Record;
import org.h2.mvstore.tx.Snapshot;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.tx.TxDecisionMaker;
import org.h2.mvstore.tx.VersionedValueCommitted;
import org.h2.mvstore.tx.VersionedValueUncommitted;
import org.h2.mvstore.type.DataType;
import org.h2.value.VersionedValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TransactionMap<K, V>
extends AbstractMap<K, V> {
    public final MVMap<K, VersionedValue<V>> map;
    private final Transaction transaction;
    private Snapshot<K, VersionedValue<V>> snapshot;
    private Snapshot<K, VersionedValue<V>> statementSnapshot;
    private boolean hasChanges;
    private final TxDecisionMaker<K, V> txDecisionMaker;
    private final TxDecisionMaker<K, V> ifAbsentDecisionMaker;
    private final TxDecisionMaker<K, V> lockDecisionMaker;

    TransactionMap(Transaction transaction, MVMap<K, VersionedValue<V>> map) {
        this.transaction = transaction;
        this.map = map;
        this.txDecisionMaker = new TxDecisionMaker(map.getId(), transaction);
        this.ifAbsentDecisionMaker = new TxDecisionMaker.PutIfAbsentDecisionMaker<Object, Object>(map.getId(), transaction, this::getFromSnapshot);
        this.lockDecisionMaker = transaction.allowNonRepeatableRead() ? new TxDecisionMaker.LockDecisionMaker(map.getId(), transaction) : new TxDecisionMaker.RepeatableReadLockDecisionMaker<Object, Object>(map.getId(), transaction, map.getValueType(), this::getFromSnapshot);
    }

    public TransactionMap<K, V> getInstance(Transaction transaction) {
        return transaction.openMapX(this.map);
    }

    @Override
    public int size() {
        long size = this.sizeAsLong();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public long sizeAsLongMax() {
        return this.map.sizeAsLong();
    }

    public long sizeAsLong() {
        long undoLogsTotalSize;
        RootReference<Long, Record<?, ?>>[] undoLogRootReferences;
        Snapshot<K, VersionedValue<V>> snapshot;
        IsolationLevel isolationLevel = this.transaction.getIsolationLevel();
        if (!isolationLevel.allowNonRepeatableRead() && this.hasChanges) {
            return this.sizeAsLongRepeatableReadWithChanges();
        }
        do {
            snapshot = this.getSnapshot();
            undoLogRootReferences = this.getTransaction().getUndoLogRootReferences();
        } while (!snapshot.equals(this.getSnapshot()));
        RootReference mapRootReference = snapshot.root;
        long size = mapRootReference.getTotalCount();
        long l = undoLogsTotalSize = undoLogRootReferences == null ? size : TransactionStore.calculateUndoLogsTotalSize(undoLogRootReferences);
        if (undoLogsTotalSize == 0L) {
            return size;
        }
        return this.adjustSize(undoLogRootReferences, mapRootReference, isolationLevel == IsolationLevel.READ_UNCOMMITTED ? null : snapshot.committingTransactions, size, undoLogsTotalSize);
    }

    private long adjustSize(RootReference<Long, Record<?, ?>>[] undoLogRootReferences, RootReference<K, VersionedValue<V>> mapRootReference, BitSet committingTransactions, long size, long undoLogsTotalSize) {
        if (2L * undoLogsTotalSize > size) {
            Cursor<Object, VersionedValue<V>> cursor = this.map.cursor(mapRootReference, null, null, false);
            while (cursor.hasNext()) {
                cursor.next();
                VersionedValue<V> currentValue = cursor.getValue();
                assert (currentValue != null);
                long operationId = currentValue.getOperationId();
                if (operationId == 0L || !this.isIrrelevant(operationId, currentValue, committingTransactions)) continue;
                --size;
            }
        } else {
            assert (undoLogRootReferences != null);
            RootReference<Long, Record<?, ?>>[] rootReferenceArray = undoLogRootReferences;
            int n = undoLogRootReferences.length;
            int n2 = 0;
            while (n2 < n) {
                RootReference<Long, Record<?, ?>> undoLogRootReference = rootReferenceArray[n2];
                if (undoLogRootReference != null) {
                    Cursor<Object, Record<?, ?>> cursor = undoLogRootReference.root.map.cursor(undoLogRootReference, null, null, false);
                    while (cursor.hasNext()) {
                        VersionedValue<V> currentValue;
                        cursor.next();
                        Record<?, ?> op = cursor.getValue();
                        if (op.mapId != this.map.getId() || (currentValue = this.map.get(mapRootReference.root, op.key)) == null) continue;
                        long operationId = cursor.getKey();
                        assert (operationId != 0L);
                        if (currentValue.getOperationId() != operationId || !this.isIrrelevant(operationId, currentValue, committingTransactions)) continue;
                        --size;
                    }
                }
                ++n2;
            }
        }
        return size;
    }

    private boolean isIrrelevant(long operationId, VersionedValue<?> currentValue, BitSet committingTransactions) {
        Object v;
        if (committingTransactions == null) {
            v = currentValue.getCurrentValue();
        } else {
            int txId = TransactionStore.getTransactionId(operationId);
            Object obj = v = txId == this.transaction.transactionId || committingTransactions.get(txId) ? currentValue.getCurrentValue() : currentValue.getCommittedValue();
        }
        return v == null;
    }

    private long sizeAsLongRepeatableReadWithChanges() {
        long count = 0L;
        RepeatableIterator iterator = new RepeatableIterator(this, null, null, false, false);
        while (iterator.fetchNext() != null) {
            ++count;
        }
        return count;
    }

    @Override
    public V remove(Object key) {
        return this.set(key, null);
    }

    @Override
    public V put(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        return this.set(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        this.ifAbsentDecisionMaker.initialize(key, value);
        V result = this.set(key, this.ifAbsentDecisionMaker, -1);
        if (this.ifAbsentDecisionMaker.getDecision() == MVMap.Decision.ABORT) {
            result = this.ifAbsentDecisionMaker.getLastValue();
        }
        return result;
    }

    public void append(K key, V value) {
        this.map.append(key, VersionedValueUncommitted.getInstance(this.transaction.log(new Record(this.map.getId(), key, null)), value, null));
        this.hasChanges = true;
    }

    public V lock(K key) {
        return this.lock(key, -1);
    }

    public V lock(K key, int timeoutMillis) {
        this.lockDecisionMaker.initialize(key, null);
        return this.set(key, this.lockDecisionMaker, timeoutMillis);
    }

    public V putCommitted(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        VersionedValue<V> newValue = VersionedValueCommitted.getInstance(value);
        VersionedValue<V> oldValue = this.map.put(key, newValue);
        V result = oldValue == null ? null : (V)oldValue.getCurrentValue();
        return result;
    }

    private V set(K key, V value) {
        this.txDecisionMaker.initialize(key, value);
        return this.set(key, this.txDecisionMaker, -1);
    }

    private V set(Object key, TxDecisionMaker<K, V> decisionMaker, int timeoutMillis) {
        VersionedValue result;
        Transaction blockingTransaction;
        String mapName = null;
        do {
            assert (this.transaction.getBlockerId() == 0);
            Object k = key;
            result = this.map.operate(k, null, decisionMaker);
            MVMap.Decision decision = decisionMaker.getDecision();
            assert (decision != null);
            assert (decision != MVMap.Decision.REPEAT);
            blockingTransaction = decisionMaker.getBlockingTransaction();
            if (decision != MVMap.Decision.ABORT || blockingTransaction == null) {
                this.hasChanges |= decision != MVMap.Decision.ABORT;
                V res = result == null ? null : (V)result.getCurrentValue();
                return res;
            }
            decisionMaker.reset();
            if (timeoutMillis == -2) {
                return null;
            }
            if (mapName != null) continue;
            mapName = this.map.getName();
        } while (timeoutMillis != 0 && this.transaction.waitFor(blockingTransaction, mapName, key, timeoutMillis));
        throw DataUtils.newMVStoreException(101, "Map entry <{0}> with key <{1}> and value {2} is locked by tx {3} and can not be updated by tx {4} within allocated time interval {5} ms.", mapName, key, result, blockingTransaction.transactionId, this.transaction.transactionId, timeoutMillis == -1 ? this.transaction.timeoutMillis : timeoutMillis);
    }

    public boolean tryRemove(K key) {
        return this.trySet(key, null);
    }

    public boolean tryPut(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        return this.trySet(key, value);
    }

    public boolean trySet(K key, V value) {
        try {
            this.set(key, value);
            return true;
        }
        catch (MVStoreException e) {
            return false;
        }
    }

    @Override
    public V get(Object key) {
        return this.getImmediate(key);
    }

    public V getFromSnapshot(K key) {
        Snapshot<K, VersionedValue<V>> snapshot;
        switch (this.transaction.isolationLevel) {
            case READ_UNCOMMITTED: {
                Snapshot<K, VersionedValue<V>> snapshot2 = this.getStatementSnapshot();
                VersionedValue<V> data = this.map.get(snapshot2.root.root, key);
                if (data != null) {
                    return data.getCurrentValue();
                }
                return null;
            }
            case REPEATABLE_READ: 
            case SNAPSHOT: 
            case SERIALIZABLE: {
                long id;
                if (!this.transaction.hasChanges()) break;
                snapshot = this.getStatementSnapshot();
                VersionedValue<V> data = this.map.get(snapshot.root.root, key);
                if (data == null || (id = data.getOperationId()) == 0L || this.transaction.transactionId != TransactionStore.getTransactionId(id)) break;
                return data.getCurrentValue();
            }
        }
        snapshot = this.getSnapshot();
        return this.getFromSnapshot(snapshot.root, snapshot.committingTransactions, key);
    }

    private V getFromSnapshot(RootReference<K, VersionedValue<V>> rootRef, BitSet committingTransactions, K key) {
        int tx;
        VersionedValue<V> data = this.map.get(rootRef.root, key);
        if (data == null) {
            return null;
        }
        long id = data.getOperationId();
        if (id != 0L && (tx = TransactionStore.getTransactionId(id)) != this.transaction.transactionId && !committingTransactions.get(tx)) {
            return data.getCommittedValue();
        }
        return data.getCurrentValue();
    }

    public V getImmediate(K key) {
        return (V)this.useSnapshot((rootReference, committedTransactions) -> this.getFromSnapshot((RootReference<K, VersionedValue<V>>)rootReference, (BitSet)committedTransactions, key));
    }

    Snapshot<K, VersionedValue<V>> getSnapshot() {
        return this.snapshot == null ? this.createSnapshot() : this.snapshot;
    }

    Snapshot<K, VersionedValue<V>> getStatementSnapshot() {
        return this.statementSnapshot == null ? this.createSnapshot() : this.statementSnapshot;
    }

    void setStatementSnapshot(Snapshot<K, VersionedValue<V>> snapshot) {
        this.statementSnapshot = snapshot;
    }

    void promoteSnapshot() {
        if (this.snapshot == null) {
            this.snapshot = this.statementSnapshot;
        }
    }

    Snapshot<K, VersionedValue<V>> createSnapshot() {
        return this.useSnapshot(Snapshot::new);
    }

    <R> R useSnapshot(BiFunction<RootReference<K, VersionedValue<V>>, BitSet, R> snapshotConsumer) {
        RootReference<K, VersionedValue<V>> root;
        BitSet prevCommittingTransactions;
        AtomicReference<BitSet> holder = this.transaction.store.committingTransactions;
        BitSet committingTransactions = holder.get();
        do {
            prevCommittingTransactions = committingTransactions;
            root = this.map.getRoot();
        } while ((committingTransactions = holder.get()) != prevCommittingTransactions);
        return snapshotConsumer.apply(root, committingTransactions);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getImmediate(key) != null;
    }

    public boolean isDeletedByCurrentTransaction(K key) {
        VersionedValue<V> data = this.map.get(key);
        if (data != null) {
            long id = data.getOperationId();
            return id != 0L && TransactionStore.getTransactionId(id) == this.transaction.transactionId && data.getCurrentValue() == null;
        }
        return false;
    }

    public boolean isSameTransaction(K key) {
        VersionedValue<V> data = this.map.get(key);
        if (data == null) {
            return false;
        }
        int tx = TransactionStore.getTransactionId(data.getOperationId());
        return tx == this.transaction.transactionId;
    }

    public boolean isClosed() {
        return this.map.isClosed();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.hasChanges = true;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return TransactionMap.this.entryIterator(null, null);
            }

            @Override
            public int size() {
                return TransactionMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return TransactionMap.this.containsKey(o);
            }
        };
    }

    public Map.Entry<K, V> firstEntry() {
        return (Map.Entry)this.chooseIterator(null, null, false, true).fetchNext();
    }

    public K firstKey() {
        return (K)this.chooseIterator(null, null, false, false).fetchNext();
    }

    public Map.Entry<K, V> lastEntry() {
        return (Map.Entry)this.chooseIterator(null, null, true, true).fetchNext();
    }

    public K lastKey() {
        return (K)this.chooseIterator(null, null, true, false).fetchNext();
    }

    public Map.Entry<K, V> higherEntry(K key) {
        return this.higherLowerEntry(key, false);
    }

    public K higherKey(K key) {
        return this.higherLowerKey(key, false);
    }

    public Map.Entry<K, V> ceilingEntry(K key) {
        return (Map.Entry)this.chooseIterator(key, null, false, true).fetchNext();
    }

    public K ceilingKey(K key) {
        return (K)this.chooseIterator(key, null, false, false).fetchNext();
    }

    public Map.Entry<K, V> floorEntry(K key) {
        return (Map.Entry)this.chooseIterator(key, null, true, true).fetchNext();
    }

    public K floorKey(K key) {
        return (K)this.chooseIterator(key, null, true, false).fetchNext();
    }

    public Map.Entry<K, V> lowerEntry(K key) {
        return this.higherLowerEntry(key, true);
    }

    public K lowerKey(K key) {
        return this.higherLowerKey(key, true);
    }

    private Map.Entry<K, V> higherLowerEntry(K key, boolean lower) {
        TMIterator it = this.chooseIterator(key, null, lower, true);
        Map.Entry result = (Map.Entry)it.fetchNext();
        if (result != null && this.map.getKeyType().compare(key, result.getKey()) == 0) {
            result = (Map.Entry)it.fetchNext();
        }
        return result;
    }

    private K higherLowerKey(K key, boolean lower) {
        TMIterator it = this.chooseIterator(key, null, lower, false);
        Object result = it.fetchNext();
        if (result != null && this.map.getKeyType().compare(key, result) == 0) {
            result = it.fetchNext();
        }
        return (K)result;
    }

    public Iterator<K> keyIterator(K from) {
        return this.chooseIterator(from, null, false, false);
    }

    public TMIterator<K, V, K> keyIterator(K from, boolean reverse) {
        return this.chooseIterator(from, null, reverse, false);
    }

    public TMIterator<K, V, K> keyIterator(K from, K to) {
        return this.chooseIterator(from, to, false, false);
    }

    public TMIterator<K, V, K> keyIterator(K from, K to, boolean reverse) {
        return this.chooseIterator(from, to, reverse, false);
    }

    public TMIterator<K, V, K> keyIteratorUncommitted(K from, K to) {
        return new ValidationIterator(this, from, to);
    }

    public TMIterator<K, V, Map.Entry<K, V>> entryIterator(K from, K to) {
        return this.chooseIterator(from, to, false, true);
    }

    public TMIterator<K, V, Map.Entry<K, V>> entryIterator(K from, K to, boolean reverse) {
        return this.chooseIterator(from, to, reverse, true);
    }

    private <X> TMIterator<K, V, X> chooseIterator(K from, K to, boolean reverse, boolean forEntries) {
        switch (this.transaction.isolationLevel) {
            case READ_UNCOMMITTED: {
                return new UncommittedIterator(this, from, to, reverse, forEntries);
            }
            case REPEATABLE_READ: 
            case SNAPSHOT: 
            case SERIALIZABLE: {
                if (!this.hasChanges) break;
                return new RepeatableIterator(this, from, to, reverse, forEntries);
            }
        }
        return new CommittedIterator(this, from, to, reverse, forEntries);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public DataType<K> getKeyType() {
        return this.map.getKeyType();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class CommittedIterator<K, V, X>
    extends TMIterator<K, V, X> {
        CommittedIterator(TransactionMap<K, V> transactionMap, K from, K to, boolean reverse, boolean forEntries) {
            super(transactionMap, from, to, transactionMap.getSnapshot(), reverse, forEntries);
        }

        @Override
        public X fetchNext() {
            while (this.cursor.hasNext()) {
                int tx;
                Object key = this.cursor.next();
                VersionedValue data = (VersionedValue)this.cursor.getValue();
                if (data == null) continue;
                long id = data.getOperationId();
                if (id != 0L && (tx = TransactionStore.getTransactionId(id)) != this.transactionId && !this.committingTransactions.get(tx)) {
                    Object committedValue = data.getCommittedValue();
                    if (committedValue == null) continue;
                    return this.toElement(key, committedValue);
                }
                Object currentValue = data.getCurrentValue();
                if (currentValue == null) continue;
                return this.toElement(key, currentValue);
            }
            return null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class RepeatableIterator<K, V, X>
    extends TMIterator<K, V, X> {
        private final DataType<K> keyType;
        private K snapshotKey;
        private Object snapshotValue;
        private final Cursor<K, VersionedValue<V>> uncommittedCursor;
        private K uncommittedKey;
        private V uncommittedValue;

        RepeatableIterator(TransactionMap<K, V> transactionMap, K from, K to, boolean reverse, boolean forEntries) {
            super(transactionMap, from, to, transactionMap.getSnapshot(), reverse, forEntries);
            this.keyType = transactionMap.map.getKeyType();
            Snapshot<K, VersionedValue<V>> snapshot = transactionMap.getStatementSnapshot();
            this.uncommittedCursor = transactionMap.map.cursor(snapshot.root, from, to, reverse);
        }

        @Override
        public X fetchNext() {
            X next = null;
            do {
                int cmp;
                if (this.snapshotKey == null) {
                    this.fetchSnapshot();
                }
                if (this.uncommittedKey == null) {
                    this.fetchUncommitted();
                }
                if (this.snapshotKey == null && this.uncommittedKey == null) break;
                int n = this.snapshotKey == null ? 1 : (cmp = this.uncommittedKey == null ? -1 : this.keyType.compare(this.snapshotKey, this.uncommittedKey));
                if (cmp < 0) {
                    next = this.toElement(this.snapshotKey, this.snapshotValue);
                    this.snapshotKey = null;
                    break;
                }
                if (this.uncommittedValue != null) {
                    next = this.toElement(this.uncommittedKey, this.uncommittedValue);
                }
                if (cmp == 0) {
                    this.snapshotKey = null;
                }
                this.uncommittedKey = null;
            } while (next == null);
            return next;
        }

        private void fetchSnapshot() {
            while (this.cursor.hasNext()) {
                int tx;
                Object key = this.cursor.next();
                VersionedValue data = (VersionedValue)this.cursor.getValue();
                if (data == null) continue;
                Object value = data.getCommittedValue();
                long id = data.getOperationId();
                if (id != 0L && ((tx = TransactionStore.getTransactionId(id)) == this.transactionId || this.committingTransactions.get(tx))) {
                    value = data.getCurrentValue();
                }
                if (value == null) continue;
                this.snapshotKey = key;
                this.snapshotValue = value;
                return;
            }
        }

        private void fetchUncommitted() {
            while (this.uncommittedCursor.hasNext()) {
                long id;
                K key = this.uncommittedCursor.next();
                VersionedValue<V> data = this.uncommittedCursor.getValue();
                if (data == null || (id = data.getOperationId()) == 0L || this.transactionId != TransactionStore.getTransactionId(id)) continue;
                this.uncommittedKey = key;
                this.uncommittedValue = data.getCurrentValue();
                return;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static abstract class TMIterator<K, V, X>
    implements Iterator<X> {
        final int transactionId;
        final BitSet committingTransactions;
        protected final Cursor<K, VersionedValue<V>> cursor;
        private final boolean forEntries;
        X current;

        TMIterator(TransactionMap<K, V> transactionMap, K from, K to, Snapshot<K, VersionedValue<V>> snapshot, boolean reverse, boolean forEntries) {
            Transaction transaction = transactionMap.getTransaction();
            this.transactionId = transaction.transactionId;
            this.forEntries = forEntries;
            this.cursor = transactionMap.map.cursor(snapshot.root, from, to, reverse);
            this.committingTransactions = snapshot.committingTransactions;
        }

        final X toElement(K key, Object value) {
            return (X)(this.forEntries ? new AbstractMap.SimpleImmutableEntry<K, Object>(key, value) : key);
        }

        public abstract X fetchNext();

        @Override
        public final boolean hasNext() {
            return this.current != null || (this.current = this.fetchNext()) != null;
        }

        @Override
        public final X next() {
            X result = this.current;
            if (result == null) {
                result = this.fetchNext();
                if (result == null) {
                    throw new NoSuchElementException();
                }
            } else {
                this.current = null;
            }
            return result;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class UncommittedIterator<K, V, X>
    extends TMIterator<K, V, X> {
        UncommittedIterator(TransactionMap<K, V> transactionMap, K from, K to, boolean reverse, boolean forEntries) {
            super(transactionMap, from, to, transactionMap.createSnapshot(), reverse, forEntries);
        }

        UncommittedIterator(TransactionMap<K, V> transactionMap, K from, K to, Snapshot<K, VersionedValue<V>> snapshot, boolean reverse, boolean forEntries) {
            super(transactionMap, from, to, snapshot, reverse, forEntries);
        }

        @Override
        public final X fetchNext() {
            while (this.cursor.hasNext()) {
                Object currentValue;
                Object key = this.cursor.next();
                VersionedValue data = (VersionedValue)this.cursor.getValue();
                if (data == null || (currentValue = data.getCurrentValue()) == null && !this.shouldIgnoreRemoval(data)) continue;
                return this.toElement(key, currentValue);
            }
            return null;
        }

        boolean shouldIgnoreRemoval(VersionedValue<?> data) {
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class ValidationIterator<K, V, X>
    extends UncommittedIterator<K, V, X> {
        ValidationIterator(TransactionMap<K, V> transactionMap, K from, K to) {
            super(transactionMap, from, to, transactionMap.createSnapshot(), false, false);
        }

        @Override
        boolean shouldIgnoreRemoval(VersionedValue<?> data) {
            assert (data.getCurrentValue() == null);
            long id = data.getOperationId();
            if (id != 0L) {
                int tx = TransactionStore.getTransactionId(id);
                return this.transactionId != tx && !this.committingTransactions.get(tx);
            }
            return false;
        }
    }
}

