/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.tx.VersionedValueCommitted;
import org.h2.value.VersionedValue;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class VersionedValueUncommitted<T>
extends VersionedValueCommitted<T> {
    private final long operationId;
    private final T committedValue;

    private VersionedValueUncommitted(long operationId, T value, T committedValue) {
        super(value);
        assert (operationId != 0L);
        this.operationId = operationId;
        this.committedValue = committedValue;
    }

    static <X> VersionedValue<X> getInstance(long operationId, X value, X committedValue) {
        return new VersionedValueUncommitted<X>(operationId, value, committedValue);
    }

    @Override
    public boolean isCommitted() {
        return false;
    }

    @Override
    public long getOperationId() {
        return this.operationId;
    }

    @Override
    public T getCommittedValue() {
        return this.committedValue;
    }

    @Override
    public String toString() {
        return super.toString() + " " + TransactionStore.getTransactionId(this.operationId) + "/" + TransactionStore.getLogId(this.operationId) + " " + String.valueOf(this.committedValue);
    }
}

