/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.util.Utils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ObjectDataType
extends BasicDataType<Object> {
    static final int TYPE_NULL = 0;
    static final int TYPE_BOOLEAN = 1;
    static final int TYPE_BYTE = 2;
    static final int TYPE_SHORT = 3;
    static final int TYPE_INT = 4;
    static final int TYPE_LONG = 5;
    static final int TYPE_BIG_INTEGER = 6;
    static final int TYPE_FLOAT = 7;
    static final int TYPE_DOUBLE = 8;
    static final int TYPE_BIG_DECIMAL = 9;
    static final int TYPE_CHAR = 10;
    static final int TYPE_STRING = 11;
    static final int TYPE_UUID = 12;
    static final int TYPE_DATE = 13;
    static final int TYPE_ARRAY = 14;
    static final int TYPE_SERIALIZED_OBJECT = 19;
    static final int TAG_BOOLEAN_TRUE = 32;
    static final int TAG_INTEGER_NEGATIVE = 33;
    static final int TAG_INTEGER_FIXED = 34;
    static final int TAG_LONG_NEGATIVE = 35;
    static final int TAG_LONG_FIXED = 36;
    static final int TAG_BIG_INTEGER_0 = 37;
    static final int TAG_BIG_INTEGER_1 = 38;
    static final int TAG_BIG_INTEGER_SMALL = 39;
    static final int TAG_FLOAT_0 = 40;
    static final int TAG_FLOAT_1 = 41;
    static final int TAG_FLOAT_FIXED = 42;
    static final int TAG_DOUBLE_0 = 43;
    static final int TAG_DOUBLE_1 = 44;
    static final int TAG_DOUBLE_FIXED = 45;
    static final int TAG_BIG_DECIMAL_0 = 46;
    static final int TAG_BIG_DECIMAL_1 = 47;
    static final int TAG_BIG_DECIMAL_SMALL = 48;
    static final int TAG_BIG_DECIMAL_SMALL_SCALED = 49;
    static final int TAG_INTEGER_0_15 = 64;
    static final int TAG_LONG_0_7 = 80;
    static final int TAG_STRING_0_15 = 88;
    static final int TAG_BYTE_ARRAY_0_15 = 104;
    static final int FLOAT_ZERO_BITS = Float.floatToIntBits(0.0f);
    static final int FLOAT_ONE_BITS = Float.floatToIntBits(1.0f);
    static final long DOUBLE_ZERO_BITS = Double.doubleToLongBits(0.0);
    static final long DOUBLE_ONE_BITS = Double.doubleToLongBits(1.0);
    static final Class<?>[] COMMON_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Object.class, Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, BigInteger.class, Float.class, Double.class, BigDecimal.class, String.class, UUID.class, Date.class};
    private AutoDetectDataType<Object> last = this.selectDataType(0);

    @Override
    public Object[] createStorage(int size) {
        return new Object[size];
    }

    @Override
    public int compare(Object a, Object b) {
        int typeId = ObjectDataType.getTypeId(a);
        int typeDiff = typeId - ObjectDataType.getTypeId(b);
        if (typeDiff == 0) {
            return this.newType(typeId).compare(a, b);
        }
        return Integer.signum(typeDiff);
    }

    @Override
    public int getMemory(Object obj) {
        return this.switchType(obj).getMemory(obj);
    }

    @Override
    public void write(WriteBuffer buff, Object obj) {
        this.switchType(obj).write(buff, obj);
    }

    private AutoDetectDataType<Object> newType(int typeId) {
        if (typeId == this.last.typeId) {
            return this.last;
        }
        return this.selectDataType(typeId);
    }

    private AutoDetectDataType selectDataType(int typeId) {
        switch (typeId) {
            case 0: {
                return NullType.INSTANCE;
            }
            case 1: {
                return BooleanType.INSTANCE;
            }
            case 2: {
                return ByteType.INSTANCE;
            }
            case 3: {
                return ShortType.INSTANCE;
            }
            case 10: {
                return CharacterType.INSTANCE;
            }
            case 4: {
                return IntegerType.INSTANCE;
            }
            case 5: {
                return LongType.INSTANCE;
            }
            case 7: {
                return FloatType.INSTANCE;
            }
            case 8: {
                return DoubleType.INSTANCE;
            }
            case 6: {
                return BigIntegerType.INSTANCE;
            }
            case 9: {
                return BigDecimalType.INSTANCE;
            }
            case 11: {
                return StringType.INSTANCE;
            }
            case 12: {
                return UUIDType.INSTANCE;
            }
            case 13: {
                return DateType.INSTANCE;
            }
            case 14: {
                return new ObjectArrayType();
            }
            case 19: {
                return new SerializedObjectType(this);
            }
        }
        throw DataUtils.newMVStoreException(3, "Unsupported type {0}", typeId);
    }

    @Override
    public Object read(ByteBuffer buff) {
        int typeId;
        int tag = buff.get();
        if (tag <= 19) {
            typeId = tag;
        } else {
            switch (tag) {
                case 32: {
                    typeId = 1;
                    break;
                }
                case 33: 
                case 34: {
                    typeId = 4;
                    break;
                }
                case 35: 
                case 36: {
                    typeId = 5;
                    break;
                }
                case 37: 
                case 38: 
                case 39: {
                    typeId = 6;
                    break;
                }
                case 40: 
                case 41: 
                case 42: {
                    typeId = 7;
                    break;
                }
                case 43: 
                case 44: 
                case 45: {
                    typeId = 8;
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: {
                    typeId = 9;
                    break;
                }
                default: {
                    if (tag >= 64 && tag <= 79) {
                        typeId = 4;
                        break;
                    }
                    if (tag >= 88 && tag <= 103) {
                        typeId = 11;
                        break;
                    }
                    if (tag >= 80 && tag <= 87) {
                        typeId = 5;
                        break;
                    }
                    if (tag >= 104 && tag <= 119) {
                        typeId = 14;
                        break;
                    }
                    throw DataUtils.newMVStoreException(6, "Unknown tag {0}", tag);
                }
            }
        }
        AutoDetectDataType<Object> t = this.last;
        if (typeId != t.typeId) {
            this.last = t = this.newType(typeId);
        }
        return t.read(buff, tag);
    }

    private static int getTypeId(Object obj) {
        if (obj instanceof Integer) {
            return 4;
        }
        if (obj instanceof String) {
            return 11;
        }
        if (obj instanceof Long) {
            return 5;
        }
        if (obj instanceof Double) {
            return 8;
        }
        if (obj instanceof Float) {
            return 7;
        }
        if (obj instanceof Boolean) {
            return 1;
        }
        if (obj instanceof UUID) {
            return 12;
        }
        if (obj instanceof Byte) {
            return 2;
        }
        if (obj instanceof Short) {
            return 3;
        }
        if (obj instanceof Character) {
            return 10;
        }
        if (obj == null) {
            return 0;
        }
        if (ObjectDataType.isDate(obj)) {
            return 13;
        }
        if (ObjectDataType.isBigInteger(obj)) {
            return 6;
        }
        if (ObjectDataType.isBigDecimal(obj)) {
            return 9;
        }
        if (obj.getClass().isArray()) {
            return 14;
        }
        return 19;
    }

    AutoDetectDataType<Object> switchType(Object obj) {
        int typeId = ObjectDataType.getTypeId(obj);
        AutoDetectDataType<Object> l = this.last;
        if (typeId != l.typeId) {
            this.last = l = this.newType(typeId);
        }
        return l;
    }

    static boolean isBigInteger(Object obj) {
        return obj != null && obj.getClass() == BigInteger.class;
    }

    static boolean isBigDecimal(Object obj) {
        return obj != null && obj.getClass() == BigDecimal.class;
    }

    static boolean isDate(Object obj) {
        return obj != null && obj.getClass() == Date.class;
    }

    static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static byte[] serialize(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw DataUtils.newIllegalArgumentException("Could not serialize {0}", obj, e);
        }
    }

    public static Object deserialize(byte[] data) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Throwable e) {
            throw DataUtils.newIllegalArgumentException("Could not deserialize {0}", Arrays.toString(data), e);
        }
    }

    public static int compareNotNull(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return 0;
        }
        int len = Math.min(data1.length, data2.length);
        int i = 0;
        while (i < len) {
            int b = data1[i] & 0xFF;
            int b2 = data2[i] & 0xFF;
            if (b != b2) {
                return b > b2 ? 1 : -1;
            }
            ++i;
        }
        return Integer.signum(data1.length - data2.length);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static abstract class AutoDetectDataType<T>
    extends BasicDataType<T> {
        private final ObjectDataType base;
        final int typeId;

        AutoDetectDataType(int typeId) {
            this.base = null;
            this.typeId = typeId;
        }

        AutoDetectDataType(ObjectDataType base, int typeId) {
            this.base = base;
            this.typeId = typeId;
        }

        @Override
        public int getMemory(T o) {
            return this.getType(o).getMemory(o);
        }

        @Override
        public void write(WriteBuffer buff, T o) {
            this.getType(o).write(buff, o);
        }

        DataType<Object> getType(Object o) {
            return this.base.switchType(o);
        }

        abstract Object read(ByteBuffer var1, int var2);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class BigDecimalType
    extends AutoDetectDataType<BigDecimal> {
        static final BigDecimalType INSTANCE = new BigDecimalType();

        private BigDecimalType() {
            super(9);
        }

        public BigDecimal[] createStorage(int size) {
            return new BigDecimal[size];
        }

        @Override
        public int compare(BigDecimal a, BigDecimal b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(BigDecimal obj) {
            return 150;
        }

        @Override
        public void write(WriteBuffer buff, BigDecimal x) {
            if (BigDecimal.ZERO.equals(x)) {
                buff.put((byte)46);
            } else if (BigDecimal.ONE.equals(x)) {
                buff.put((byte)47);
            } else {
                int scale = x.scale();
                BigInteger b = x.unscaledValue();
                int bits = b.bitLength();
                if (bits < 64) {
                    if (scale == 0) {
                        buff.put((byte)48);
                    } else {
                        buff.put((byte)49).putVarInt(scale);
                    }
                    buff.putVarLong(b.longValue());
                } else {
                    byte[] bytes = b.toByteArray();
                    buff.put((byte)9).putVarInt(scale).putVarInt(bytes.length).put(bytes);
                }
            }
        }

        @Override
        public BigDecimal read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public BigDecimal read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 46: {
                    return BigDecimal.ZERO;
                }
                case 47: {
                    return BigDecimal.ONE;
                }
                case 48: {
                    return BigDecimal.valueOf(DataUtils.readVarLong(buff));
                }
                case 49: {
                    int scale = DataUtils.readVarInt(buff);
                    return BigDecimal.valueOf(DataUtils.readVarLong(buff), scale);
                }
            }
            int scale = DataUtils.readVarInt(buff);
            int len = DataUtils.readVarInt(buff);
            byte[] bytes = Utils.newBytes(len);
            buff.get(bytes);
            BigInteger b = new BigInteger(bytes);
            return new BigDecimal(b, scale);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class BigIntegerType
    extends AutoDetectDataType<BigInteger> {
        static final BigIntegerType INSTANCE = new BigIntegerType();

        private BigIntegerType() {
            super(6);
        }

        public BigInteger[] createStorage(int size) {
            return new BigInteger[size];
        }

        @Override
        public int compare(BigInteger a, BigInteger b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(BigInteger obj) {
            return 100;
        }

        @Override
        public void write(WriteBuffer buff, BigInteger x) {
            if (BigInteger.ZERO.equals(x)) {
                buff.put((byte)37);
            } else if (BigInteger.ONE.equals(x)) {
                buff.put((byte)38);
            } else {
                int bits = x.bitLength();
                if (bits <= 63) {
                    buff.put((byte)39).putVarLong(x.longValue());
                } else {
                    byte[] bytes = x.toByteArray();
                    buff.put((byte)6).putVarInt(bytes.length).put(bytes);
                }
            }
        }

        @Override
        public BigInteger read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public BigInteger read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 37: {
                    return BigInteger.ZERO;
                }
                case 38: {
                    return BigInteger.ONE;
                }
                case 39: {
                    return BigInteger.valueOf(DataUtils.readVarLong(buff));
                }
            }
            int len = DataUtils.readVarInt(buff);
            byte[] bytes = Utils.newBytes(len);
            buff.get(bytes);
            return new BigInteger(bytes);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class BooleanType
    extends AutoDetectDataType<Boolean> {
        static final BooleanType INSTANCE = new BooleanType();

        private BooleanType() {
            super(1);
        }

        public Boolean[] createStorage(int size) {
            return new Boolean[size];
        }

        @Override
        public int compare(Boolean a, Boolean b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(Boolean obj) {
            return 0;
        }

        @Override
        public void write(WriteBuffer buff, Boolean obj) {
            int tag = obj != false ? 32 : 1;
            buff.put((byte)tag);
        }

        @Override
        public Boolean read(ByteBuffer buff) {
            return buff.get() == 32 ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public Boolean read(ByteBuffer buff, int tag) {
            return tag == 1 ? Boolean.FALSE : Boolean.TRUE;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ByteType
    extends AutoDetectDataType<Byte> {
        static final ByteType INSTANCE = new ByteType();

        private ByteType() {
            super(2);
        }

        public Byte[] createStorage(int size) {
            return new Byte[size];
        }

        @Override
        public int compare(Byte a, Byte b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(Byte obj) {
            return 1;
        }

        @Override
        public void write(WriteBuffer buff, Byte obj) {
            buff.put((byte)2);
            buff.put(obj);
        }

        @Override
        public Byte read(ByteBuffer buff) {
            return buff.get();
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            return buff.get();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class CharacterType
    extends AutoDetectDataType<Character> {
        static final CharacterType INSTANCE = new CharacterType();

        private CharacterType() {
            super(10);
        }

        public Character[] createStorage(int size) {
            return new Character[size];
        }

        @Override
        public int compare(Character a, Character b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(Character obj) {
            return 24;
        }

        @Override
        public void write(WriteBuffer buff, Character obj) {
            buff.put((byte)10);
            buff.putChar(obj.charValue());
        }

        @Override
        public Character read(ByteBuffer buff) {
            return Character.valueOf(buff.getChar());
        }

        @Override
        public Character read(ByteBuffer buff, int tag) {
            return Character.valueOf(buff.getChar());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class DateType
    extends AutoDetectDataType<Date> {
        static final DateType INSTANCE = new DateType();

        private DateType() {
            super(13);
        }

        public Date[] createStorage(int size) {
            return new Date[size];
        }

        @Override
        public int getMemory(Date obj) {
            return 40;
        }

        @Override
        public int compare(Date a, Date b) {
            return a.compareTo(b);
        }

        @Override
        public void write(WriteBuffer buff, Date a) {
            buff.put((byte)13);
            buff.putLong(a.getTime());
        }

        @Override
        public Date read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public Date read(ByteBuffer buff, int tag) {
            long a = buff.getLong();
            return new Date(a);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class DoubleType
    extends AutoDetectDataType<Double> {
        static final DoubleType INSTANCE = new DoubleType();

        private DoubleType() {
            super(8);
        }

        public Double[] createStorage(int size) {
            return new Double[size];
        }

        @Override
        public int compare(Double a, Double b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(Double obj) {
            return 30;
        }

        @Override
        public void write(WriteBuffer buff, Double obj) {
            double x = obj;
            long d = Double.doubleToLongBits(x);
            if (d == DOUBLE_ZERO_BITS) {
                buff.put((byte)43);
            } else if (d == DOUBLE_ONE_BITS) {
                buff.put((byte)44);
            } else {
                long value = Long.reverse(d);
                if (value >= 0L && value <= 0x1FFFFFFFFFFFFL) {
                    buff.put((byte)8);
                    buff.putVarLong(value);
                } else {
                    buff.put((byte)45);
                    buff.putDouble(x);
                }
            }
        }

        @Override
        public Double read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public Double read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 43: {
                    return 0.0;
                }
                case 44: {
                    return 1.0;
                }
                case 45: {
                    return buff.getDouble();
                }
            }
            return Double.longBitsToDouble(Long.reverse(DataUtils.readVarLong(buff)));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class FloatType
    extends AutoDetectDataType<Float> {
        static final FloatType INSTANCE = new FloatType();

        private FloatType() {
            super(7);
        }

        public Float[] createStorage(int size) {
            return new Float[size];
        }

        @Override
        public int compare(Float a, Float b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(Float obj) {
            return 24;
        }

        @Override
        public void write(WriteBuffer buff, Float obj) {
            float x = obj.floatValue();
            int f = Float.floatToIntBits(x);
            if (f == FLOAT_ZERO_BITS) {
                buff.put((byte)40);
            } else if (f == FLOAT_ONE_BITS) {
                buff.put((byte)41);
            } else {
                int value = Integer.reverse(f);
                if (value >= 0 && value <= 0x1FFFFF) {
                    buff.put((byte)7).putVarInt(value);
                } else {
                    buff.put((byte)42).putFloat(x);
                }
            }
        }

        @Override
        public Float read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public Float read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 40: {
                    return Float.valueOf(0.0f);
                }
                case 41: {
                    return Float.valueOf(1.0f);
                }
                case 42: {
                    return Float.valueOf(buff.getFloat());
                }
            }
            return Float.valueOf(Float.intBitsToFloat(Integer.reverse(DataUtils.readVarInt(buff))));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class Holder {
        private static final HashMap<Class<?>, Integer> COMMON_CLASSES_MAP = new HashMap(32);

        static {
            int i = 0;
            int size = COMMON_CLASSES.length;
            while (i < size) {
                COMMON_CLASSES_MAP.put(COMMON_CLASSES[i], i);
                ++i;
            }
        }

        private Holder() {
        }

        static Integer getCommonClassId(Class<?> clazz) {
            return COMMON_CLASSES_MAP.get(clazz);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class IntegerType
    extends AutoDetectDataType<Integer> {
        static final IntegerType INSTANCE = new IntegerType();

        private IntegerType() {
            super(4);
        }

        public Integer[] createStorage(int size) {
            return new Integer[size];
        }

        @Override
        public int compare(Integer a, Integer b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(Integer obj) {
            return 24;
        }

        @Override
        public void write(WriteBuffer buff, Integer obj) {
            int x = obj;
            if (x < 0) {
                if (-x < 0 || -x > 0x1FFFFF) {
                    buff.put((byte)34).putInt(x);
                } else {
                    buff.put((byte)33).putVarInt(-x);
                }
            } else if (x <= 15) {
                buff.put((byte)(64 + x));
            } else if (x <= 0x1FFFFF) {
                buff.put((byte)4).putVarInt(x);
            } else {
                buff.put((byte)34).putInt(x);
            }
        }

        @Override
        public Integer read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public Integer read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 4: {
                    return DataUtils.readVarInt(buff);
                }
                case 33: {
                    return -DataUtils.readVarInt(buff);
                }
                case 34: {
                    return buff.getInt();
                }
            }
            return tag - 64;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class LongType
    extends AutoDetectDataType<Long> {
        static final LongType INSTANCE = new LongType();

        private LongType() {
            super(5);
        }

        public Long[] createStorage(int size) {
            return new Long[size];
        }

        @Override
        public int compare(Long a, Long b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(Long obj) {
            return 30;
        }

        @Override
        public void write(WriteBuffer buff, Long obj) {
            long x = obj;
            if (x < 0L) {
                if (-x < 0L || -x > 0x1FFFFFFFFFFFFL) {
                    buff.put((byte)36);
                    buff.putLong(x);
                } else {
                    buff.put((byte)35);
                    buff.putVarLong(-x);
                }
            } else if (x <= 7L) {
                buff.put((byte)(80L + x));
            } else if (x <= 0x1FFFFFFFFFFFFL) {
                buff.put((byte)5);
                buff.putVarLong(x);
            } else {
                buff.put((byte)36);
                buff.putLong(x);
            }
        }

        @Override
        public Long read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public Long read(ByteBuffer buff, int tag) {
            switch (tag) {
                case 5: {
                    return DataUtils.readVarLong(buff);
                }
                case 35: {
                    return -DataUtils.readVarLong(buff);
                }
                case 36: {
                    return buff.getLong();
                }
            }
            return tag - 80;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class NullType
    extends AutoDetectDataType<Object> {
        static final NullType INSTANCE = new NullType();

        private NullType() {
            super(0);
        }

        @Override
        public Object[] createStorage(int size) {
            return null;
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            return 0;
        }

        @Override
        public int getMemory(Object obj) {
            return 0;
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            buff.put((byte)0);
        }

        @Override
        public Object read(ByteBuffer buff) {
            return null;
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            return null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ObjectArrayType
    extends AutoDetectDataType<Object> {
        private final ObjectDataType elementType = new ObjectDataType();

        ObjectArrayType() {
            super(14);
        }

        @Override
        public Object[] createStorage(int size) {
            return new Object[size];
        }

        @Override
        public int getMemory(Object obj) {
            int size;
            block5: {
                block3: {
                    int len;
                    Class<?> type;
                    block7: {
                        block6: {
                            block4: {
                                if (!ObjectDataType.isArray(obj)) {
                                    return super.getMemory(obj);
                                }
                                size = 64;
                                type = obj.getClass().getComponentType();
                                if (!type.isPrimitive()) break block3;
                                len = Array.getLength(obj);
                                if (type != Boolean.TYPE && type != Byte.TYPE) break block4;
                                size += len;
                                break block5;
                            }
                            if (type != Character.TYPE && type != Short.TYPE) break block6;
                            size += len * 2;
                            break block5;
                        }
                        if (type != Integer.TYPE && type != Float.TYPE) break block7;
                        size += len * 4;
                        break block5;
                    }
                    if (type != Double.TYPE && type != Long.TYPE) break block5;
                    size += len * 8;
                    break block5;
                }
                Object[] objectArray = (Object[])obj;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object x = objectArray[n2];
                    if (x != null) {
                        size += this.elementType.getMemory(x);
                    }
                    ++n2;
                }
            }
            return size * 2;
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            Class<?> bType;
            if (!ObjectDataType.isArray(aObj) || !ObjectDataType.isArray(bObj)) {
                return super.compare(aObj, bObj);
            }
            if (aObj == bObj) {
                return 0;
            }
            Class<?> type = aObj.getClass().getComponentType();
            if (type != (bType = bObj.getClass().getComponentType())) {
                Integer classA = Holder.getCommonClassId(type);
                Integer classB = Holder.getCommonClassId(bType);
                if (classA != null) {
                    if (classB != null) {
                        return classA.compareTo(classB);
                    }
                    return -1;
                }
                if (classB != null) {
                    return 1;
                }
                return type.getName().compareTo(bType.getName());
            }
            int aLen = Array.getLength(aObj);
            int bLen = Array.getLength(bObj);
            int len = Math.min(aLen, bLen);
            if (type.isPrimitive()) {
                if (type == Byte.TYPE) {
                    byte[] a = (byte[])aObj;
                    byte[] b = (byte[])bObj;
                    return ObjectDataType.compareNotNull(a, b);
                }
                int i = 0;
                while (i < len) {
                    int x;
                    if (type == Boolean.TYPE) {
                        x = Integer.signum((((boolean[])aObj)[i] ? 1 : 0) - (((boolean[])bObj)[i] ? 1 : 0));
                    } else if (type == Character.TYPE) {
                        x = Integer.signum(((char[])aObj)[i] - ((char[])bObj)[i]);
                    } else if (type == Short.TYPE) {
                        x = Integer.signum(((short[])aObj)[i] - ((short[])bObj)[i]);
                    } else if (type == Integer.TYPE) {
                        int a = ((int[])aObj)[i];
                        int b = ((int[])bObj)[i];
                        x = Integer.compare(a, b);
                    } else if (type == Float.TYPE) {
                        x = Float.compare(((float[])aObj)[i], ((float[])bObj)[i]);
                    } else if (type == Double.TYPE) {
                        x = Double.compare(((double[])aObj)[i], ((double[])bObj)[i]);
                    } else {
                        long a = ((long[])aObj)[i];
                        long b = ((long[])bObj)[i];
                        x = Long.compare(a, b);
                    }
                    if (x != 0) {
                        return x;
                    }
                    ++i;
                }
            } else {
                Object[] a = (Object[])aObj;
                Object[] b = (Object[])bObj;
                int i = 0;
                while (i < len) {
                    int comp = this.elementType.compare(a[i], b[i]);
                    if (comp != 0) {
                        return comp;
                    }
                    ++i;
                }
            }
            return Integer.compare(aLen, bLen);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            if (!ObjectDataType.isArray(obj)) {
                super.write(buff, obj);
                return;
            }
            Class<?> type = obj.getClass().getComponentType();
            Integer classId = Holder.getCommonClassId(type);
            if (classId != null) {
                if (type.isPrimitive()) {
                    if (type == Byte.TYPE) {
                        byte[] data = (byte[])obj;
                        int len = data.length;
                        if (len <= 15) {
                            buff.put((byte)(104 + len));
                        } else {
                            buff.put((byte)14).put((byte)classId.intValue()).putVarInt(len);
                        }
                        buff.put(data);
                        return;
                    }
                    int len = Array.getLength(obj);
                    buff.put((byte)14).put((byte)classId.intValue()).putVarInt(len);
                    int i = 0;
                    while (i < len) {
                        if (type == Boolean.TYPE) {
                            buff.put((byte)(((boolean[])obj)[i] ? 1 : 0));
                        } else if (type == Character.TYPE) {
                            buff.putChar(((char[])obj)[i]);
                        } else if (type == Short.TYPE) {
                            buff.putShort(((short[])obj)[i]);
                        } else if (type == Integer.TYPE) {
                            buff.putInt(((int[])obj)[i]);
                        } else if (type == Float.TYPE) {
                            buff.putFloat(((float[])obj)[i]);
                        } else if (type == Double.TYPE) {
                            buff.putDouble(((double[])obj)[i]);
                        } else {
                            buff.putLong(((long[])obj)[i]);
                        }
                        ++i;
                    }
                    return;
                }
                buff.put((byte)14).put((byte)classId.intValue());
            } else {
                buff.put((byte)14).put((byte)-1);
                String c = type.getName();
                StringDataType.INSTANCE.write(buff, c);
            }
            Object[] array = (Object[])obj;
            int len = array.length;
            buff.putVarInt(len);
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object x = objectArray[n2];
                this.elementType.write(buff, x);
                ++n2;
            }
        }

        @Override
        public Object read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            Object obj;
            Class<?> clazz;
            if (tag != 14) {
                int len = tag - 104;
                byte[] data = Utils.newBytes(len);
                buff.get(data);
                return data;
            }
            byte ct = buff.get();
            if (ct == -1) {
                String componentType = StringDataType.INSTANCE.read(buff);
                try {
                    clazz = Class.forName(componentType);
                }
                catch (Exception e) {
                    throw DataUtils.newMVStoreException(8, "Could not get class {0}", componentType, e);
                }
            } else {
                clazz = COMMON_CLASSES[ct];
            }
            int len = DataUtils.readVarInt(buff);
            try {
                obj = Array.newInstance(clazz, len);
            }
            catch (Exception e) {
                throw DataUtils.newMVStoreException(8, "Could not create array of type {0} length {1}", clazz, len, e);
            }
            if (clazz.isPrimitive()) {
                int i = 0;
                while (i < len) {
                    if (clazz == Boolean.TYPE) {
                        ((boolean[])obj)[i] = buff.get() == 1;
                    } else if (clazz == Byte.TYPE) {
                        ((byte[])obj)[i] = buff.get();
                    } else if (clazz == Character.TYPE) {
                        ((char[])obj)[i] = buff.getChar();
                    } else if (clazz == Short.TYPE) {
                        ((short[])obj)[i] = buff.getShort();
                    } else if (clazz == Integer.TYPE) {
                        ((int[])obj)[i] = buff.getInt();
                    } else if (clazz == Float.TYPE) {
                        ((float[])obj)[i] = buff.getFloat();
                    } else if (clazz == Double.TYPE) {
                        ((double[])obj)[i] = buff.getDouble();
                    } else {
                        ((long[])obj)[i] = buff.getLong();
                    }
                    ++i;
                }
            } else {
                Object[] array = (Object[])obj;
                int i = 0;
                while (i < len) {
                    array[i] = this.elementType.read(buff);
                    ++i;
                }
            }
            return obj;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class SerializedObjectType
    extends AutoDetectDataType<Object> {
        private int averageSize = 10000;

        SerializedObjectType(ObjectDataType base) {
            super(base, 19);
        }

        @Override
        public Object[] createStorage(int size) {
            return new Object[size];
        }

        @Override
        public int compare(Object aObj, Object bObj) {
            if (aObj == bObj) {
                return 0;
            }
            DataType<Object> ta = this.getType(aObj);
            DataType<Object> tb = this.getType(bObj);
            if (ta != this || tb != this) {
                if (ta == tb) {
                    return ta.compare(aObj, bObj);
                }
                return super.compare(aObj, bObj);
            }
            if (aObj instanceof Comparable && aObj.getClass().isAssignableFrom(bObj.getClass())) {
                return ((Comparable)aObj).compareTo(bObj);
            }
            if (bObj instanceof Comparable && bObj.getClass().isAssignableFrom(aObj.getClass())) {
                return -((Comparable)bObj).compareTo(aObj);
            }
            byte[] a = ObjectDataType.serialize(aObj);
            byte[] b = ObjectDataType.serialize(bObj);
            return ObjectDataType.compareNotNull(a, b);
        }

        @Override
        public int getMemory(Object obj) {
            DataType<Object> t = this.getType(obj);
            if (t == this) {
                return this.averageSize;
            }
            return t.getMemory(obj);
        }

        @Override
        public void write(WriteBuffer buff, Object obj) {
            DataType<Object> t = this.getType(obj);
            if (t != this) {
                t.write(buff, obj);
                return;
            }
            byte[] data = ObjectDataType.serialize(obj);
            int size = data.length * 2;
            this.averageSize = (int)(((long)size + 15L * (long)this.averageSize) / 16L);
            buff.put((byte)19).putVarInt(data.length).put(data);
        }

        @Override
        public Object read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public Object read(ByteBuffer buff, int tag) {
            int len = DataUtils.readVarInt(buff);
            byte[] data = Utils.newBytes(len);
            int size = data.length * 2;
            this.averageSize = (int)(((long)size + 15L * (long)this.averageSize) / 16L);
            buff.get(data);
            return ObjectDataType.deserialize(data);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class ShortType
    extends AutoDetectDataType<Short> {
        static final ShortType INSTANCE = new ShortType();

        private ShortType() {
            super(3);
        }

        public Short[] createStorage(int size) {
            return new Short[size];
        }

        @Override
        public int compare(Short a, Short b) {
            return a.compareTo(b);
        }

        @Override
        public int getMemory(Short obj) {
            return 24;
        }

        @Override
        public void write(WriteBuffer buff, Short obj) {
            buff.put((byte)3);
            buff.putShort(obj);
        }

        @Override
        public Short read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public Short read(ByteBuffer buff, int tag) {
            return buff.getShort();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class StringType
    extends AutoDetectDataType<String> {
        static final StringType INSTANCE = new StringType();

        private StringType() {
            super(11);
        }

        public String[] createStorage(int size) {
            return new String[size];
        }

        @Override
        public int getMemory(String obj) {
            return 24 + 2 * obj.length();
        }

        @Override
        public int compare(String aObj, String bObj) {
            return aObj.compareTo(bObj);
        }

        @Override
        public void write(WriteBuffer buff, String s) {
            int len = s.length();
            if (len <= 15) {
                buff.put((byte)(88 + len));
            } else {
                buff.put((byte)11).putVarInt(len);
            }
            buff.putStringData(s, len);
        }

        @Override
        public String read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public String read(ByteBuffer buff, int tag) {
            int len = tag == 11 ? DataUtils.readVarInt(buff) : tag - 88;
            return DataUtils.readString(buff, len);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class UUIDType
    extends AutoDetectDataType<UUID> {
        static final UUIDType INSTANCE = new UUIDType();

        private UUIDType() {
            super(12);
        }

        public UUID[] createStorage(int size) {
            return new UUID[size];
        }

        @Override
        public int getMemory(UUID obj) {
            return 40;
        }

        @Override
        public int compare(UUID a, UUID b) {
            return a.compareTo(b);
        }

        @Override
        public void write(WriteBuffer buff, UUID a) {
            buff.put((byte)12);
            buff.putLong(a.getMostSignificantBits());
            buff.putLong(a.getLeastSignificantBits());
        }

        @Override
        public UUID read(ByteBuffer buff) {
            return this.read(buff, buff.get());
        }

        @Override
        public UUID read(ByteBuffer buff, int tag) {
            long a = buff.getLong();
            long b = buff.getLong();
            return new UUID(a, b);
        }
    }
}

