/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.io.IOException;
import java.util.ArrayList;
import org.h2.engine.SessionRemote;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.FetchedResult;
import org.h2.result.ResultColumn;
import org.h2.value.Transfer;
import org.h2.value.TypeInfo;
import org.h2.value.Value;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ResultRemote
extends FetchedResult {
    private int fetchSize;
    private SessionRemote session;
    private Transfer transfer;
    private int id;
    private final ResultColumn[] columns;
    private long rowCount;
    private long rowOffset;
    private ArrayList<Value[]> result;
    private final Trace trace;

    public ResultRemote(SessionRemote session, Transfer transfer, int id, int columnCount, int fetchSize) throws IOException {
        this.session = session;
        this.trace = session.getTrace();
        this.transfer = transfer;
        this.id = id;
        this.columns = new ResultColumn[columnCount];
        this.rowCount = transfer.readRowCount();
        int i = 0;
        while (i < columnCount) {
            this.columns[i] = new ResultColumn(transfer);
            ++i;
        }
        this.rowId = -1L;
        this.fetchSize = fetchSize;
        if (this.rowCount >= 0L) {
            fetchSize = (int)Math.min(this.rowCount, (long)fetchSize);
            this.result = new ArrayList(fetchSize);
        } else {
            this.result = new ArrayList();
        }
        session.lock();
        try {
            try {
                if (this.fetchRows(fetchSize)) {
                    this.rowCount = this.result.size();
                }
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
        finally {
            session.unlock();
        }
    }

    @Override
    public boolean isLazy() {
        return this.rowCount < 0L;
    }

    @Override
    public String getAlias(int i) {
        return this.columns[i].alias;
    }

    @Override
    public String getSchemaName(int i) {
        return this.columns[i].schemaName;
    }

    @Override
    public String getTableName(int i) {
        return this.columns[i].tableName;
    }

    @Override
    public String getColumnName(int i) {
        return this.columns[i].columnName;
    }

    @Override
    public TypeInfo getColumnType(int i) {
        return this.columns[i].columnType;
    }

    @Override
    public boolean isIdentity(int i) {
        return this.columns[i].identity;
    }

    @Override
    public int getNullable(int i) {
        return this.columns[i].nullable;
    }

    @Override
    public void reset() {
        if (this.rowCount < 0L || this.rowOffset > 0L) {
            throw DbException.get(90128);
        }
        this.rowId = -1L;
        this.currentRow = null;
        this.nextRow = null;
        this.afterLast = false;
        SessionRemote session = this.session;
        if (session == null) {
            return;
        }
        session.lock();
        try {
            session.checkClosed();
            try {
                session.traceOperation("RESULT_RESET", this.id);
                this.transfer.writeInt(6).writeInt(this.id).flush();
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
        finally {
            session.unlock();
        }
    }

    @Override
    public int getVisibleColumnCount() {
        return this.columns.length;
    }

    @Override
    public long getRowCount() {
        if (this.rowCount < 0L) {
            throw DbException.getUnsupportedException("Row count is unknown for lazy result.");
        }
        return this.rowCount;
    }

    @Override
    public boolean hasNext() {
        if (this.afterLast) {
            return false;
        }
        if (this.nextRow == null && (this.rowCount < 0L || this.rowId < this.rowCount - 1L)) {
            int index;
            long nextRowId = this.rowId + 1L;
            if (this.session != null) {
                this.remapIfOld();
                if (nextRowId - this.rowOffset >= (long)this.result.size()) {
                    this.fetchAdditionalRows();
                }
            }
            Value[] valueArray = this.nextRow = (index = (int)(nextRowId - this.rowOffset)) < this.result.size() ? this.result.get(index) : null;
        }
        return this.nextRow != null;
    }

    private void sendClose() {
        SessionRemote session = this.session;
        if (session == null) {
            return;
        }
        session.lock();
        try {
            try {
                session.traceOperation("RESULT_CLOSE", this.id);
                this.transfer.writeInt(7).writeInt(this.id);
            }
            catch (IOException e) {
                this.trace.error(e, "close");
                session.unlock();
                this.transfer = null;
                this.session = null;
            }
        }
        finally {
            session.unlock();
            this.transfer = null;
            this.session = null;
        }
    }

    @Override
    public void close() {
        this.result = null;
        this.sendClose();
    }

    private void remapIfOld() {
        try {
            if (this.id <= this.session.getCurrentId() - SysProperties.SERVER_CACHED_OBJECTS / 2) {
                int newId = this.session.getNextId();
                this.session.traceOperation("CHANGE_ID", this.id);
                this.transfer.writeInt(9).writeInt(this.id).writeInt(newId);
                this.id = newId;
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, null);
        }
    }

    private void fetchAdditionalRows() {
        SessionRemote session = this.session;
        session.lock();
        try {
            session.checkClosed();
            try {
                this.rowOffset += (long)this.result.size();
                this.result.clear();
                int fetch = this.fetchSize;
                if (this.rowCount >= 0L) {
                    fetch = (int)Math.min((long)fetch, this.rowCount - this.rowOffset);
                } else if (fetch == Integer.MAX_VALUE) {
                    fetch = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
                }
                session.traceOperation("RESULT_FETCH_ROWS", this.id);
                this.transfer.writeInt(5).writeInt(this.id).writeInt(fetch);
                session.done(this.transfer);
                this.fetchRows(fetch);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
        finally {
            session.unlock();
        }
    }

    private boolean fetchRows(int fetch) throws IOException {
        int len = this.columns.length;
        int r = 0;
        while (r < fetch) {
            switch (this.transfer.readByte()) {
                case 1: {
                    Value[] values = new Value[len];
                    int i = 0;
                    while (i < len) {
                        values[i] = this.transfer.readValue(this.columns[i].columnType);
                        ++i;
                    }
                    this.result.add(values);
                    break;
                }
                case 0: {
                    this.sendClose();
                    return true;
                }
                case -1: {
                    throw SessionRemote.readException(this.transfer);
                }
                default: {
                    throw DbException.getInternalError();
                }
            }
            ++r;
        }
        if (this.rowCount >= 0L && this.rowOffset + (long)this.result.size() >= this.rowCount) {
            this.sendClose();
        }
        return false;
    }

    public String toString() {
        return "columns: " + this.columns.length + (String)(this.rowCount < 0L ? " lazy" : " rows: " + this.rowCount) + " pos: " + this.rowId;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public boolean isClosed() {
        return this.result == null;
    }
}

